/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.util;

import com.google.common.base.Preconditions;
import com.google.common.util.concurrent.AsyncCallable;
import com.google.common.util.concurrent.FutureCallback;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.ListeningScheduledExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import com.google.common.util.concurrent.SettableFuture;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.Random;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryUtils {
    private static final Logger log = LoggerFactory.getLogger(RetryUtils.class);
    private static final Random rand = new Random();

    public static <T> ListenableFuture<T> retryWithJitter(AsyncCallable<T> asyncCallable, int intervalMs) {
        ListeningScheduledExecutorService exec = MoreExecutors.listeningDecorator((ScheduledExecutorService)Executors.newSingleThreadScheduledExecutor(new ThreadFactoryBuilder().setThreadFactory(Executors.defaultThreadFactory()).setNameFormat("retry-utils-%d").setDaemon(true).build()));
        ListenableFuture<T> listenableFuture = RetryUtils.retryWithJitter(exec, asyncCallable, intervalMs);
        listenableFuture.addListener(() -> MoreExecutors.shutdownAndAwaitTermination((ExecutorService)exec, (long)5L, (TimeUnit)TimeUnit.SECONDS), MoreExecutors.directExecutor());
        return listenableFuture;
    }

    public static <T> ListenableFuture<T> retryWithJitter(final ListeningScheduledExecutorService exec, final AsyncCallable<T> asyncCallable, final int intervalMs) {
        final SettableFuture result = SettableFuture.create();
        Runnable task = new Runnable(){

            @Override
            public void run() {
                final 1 outerThis = this;
                try {
                    Futures.addCallback((ListenableFuture)asyncCallable.call(), (FutureCallback)new FutureCallback<T>(){

                        public void onSuccess(T value) {
                            result.set(value);
                        }

                        public void onFailure(Throwable t) {
                            int jitter = (rand.nextInt(intervalMs * 2) - intervalMs) / 5;
                            exec.schedule(outerThis, (long)(intervalMs + jitter), TimeUnit.MILLISECONDS);
                        }
                    }, (Executor)exec);
                }
                catch (Exception e) {
                    result.setException((Throwable)e);
                }
            }
        };
        exec.submit(task);
        return result;
    }

    public static <T> T execute(Callable<T> action, int retries) throws Exception {
        Preconditions.checkNotNull(action);
        Preconditions.checkArgument((retries >= 0 ? 1 : 0) != 0, (String)"retries argument is negative: %s", (int)retries);
        int counter = 0;
        while (true) {
            try {
                return action.call();
            }
            catch (Exception ex) {
                log.warn("Failed retry attempt {} {}", (Object)counter, (Object)ex);
                if (counter++ >= retries) {
                    log.warn("Failed all retry attempt");
                    throw ex;
                }
                log.info("Retry attempt {}", (Object)counter);
                continue;
            }
            break;
        }
    }
}

