/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.util;

import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.collect.Maps;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.kafka.clients.admin.Config;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.clients.admin.NewTopic;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TopicInfo {
    public final String name;
    public final int partitions;
    public final short replication;
    public final Map<String, ConfigEntry> configEntries;
    public final boolean validateConfig;
    public final Config config;
    public final boolean isMrcCluster;
    public final boolean shouldRespectMrc;

    public TopicInfo(String name, int partitions, short replication, Map<String, ConfigEntry> configs, boolean validateConfig, boolean isMrcCluster, boolean shouldRespectMrc) {
        this.name = name;
        this.partitions = partitions;
        this.replication = replication;
        this.configEntries = configs;
        this.validateConfig = validateConfig;
        this.config = new Config(this.configEntries.values());
        this.isMrcCluster = isMrcCluster;
        this.shouldRespectMrc = shouldRespectMrc;
    }

    public NewTopic toNewTopic() {
        Map transformedValues = Maps.transformValues(this.configEntries, ConfigEntry::value);
        if (this.isMrcCluster && this.shouldRespectMrc) {
            return new NewTopic(this.name, Optional.of(this.partitions), Optional.empty()).configs(transformedValues);
        }
        return new NewTopic(this.name, this.partitions, this.replication).configs(transformedValues);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("name", (Object)this.name).add("partitions", this.partitions).add("replication", (int)this.replication).toString();
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private static final Logger log = LoggerFactory.getLogger(Builder.class);
        private String name;
        private int partitions;
        private short replication;
        private Map<String, ConfigEntry> configs = Maps.newHashMap();
        private boolean validateConfig = true;
        private boolean isMrcCluster = false;
        private boolean shouldRespectMrc;

        public Builder setName(String name) {
            this.name = name;
            return this;
        }

        public Builder setPartitions(int partitions) {
            this.partitions = partitions;
            return this;
        }

        public Builder setReplication(short replication) {
            this.replication = replication;
            this.addConfigEntry("min.insync.replicas", Math.min(2, replication < 3 ? 1 : replication - 1));
            return this;
        }

        public Builder setValidateConfig(boolean validateConfig) {
            this.validateConfig = validateConfig;
            return this;
        }

        public Builder setRetentionMs(long retentionMs) {
            return this.addConfigEntry("retention.ms", retentionMs);
        }

        public Builder setDeleteRetentionMs(long retentionMs) {
            return this.addConfigEntry("delete.retention.ms", retentionMs);
        }

        public Builder setRetentionBytes(long retentionBytes) {
            return this.addConfigEntry("retention.bytes", retentionBytes);
        }

        public Builder setDelete() {
            return this.addConfigEntry("cleanup.policy", "delete");
        }

        public Builder setCompact() {
            return this.addConfigEntry("cleanup.policy", "compact");
        }

        public Builder setCompactDelete() {
            return this.addConfigEntry("cleanup.policy", Joiner.on((char)',').join((Object)"compact", (Object)"delete", new Object[0]));
        }

        public Builder setSegmentBytes(long segmentBytes) {
            return this.addConfigEntry("segment.bytes", segmentBytes);
        }

        public Builder addConfigEntry(String name, Object value) {
            return this.addConfigEntry(new ConfigEntry(name, Objects.toString(value)));
        }

        public Builder addConfigEntry(ConfigEntry configEntry) {
            this.configs.put(configEntry.name(), configEntry);
            return this;
        }

        public Builder setIsMrcCluster(boolean isMrcCluster) {
            this.isMrcCluster = isMrcCluster;
            return this;
        }

        public Builder setShouldRespectMrc(boolean shouldRespectMrc) {
            this.shouldRespectMrc = shouldRespectMrc;
            return this;
        }

        public TopicInfo build() {
            return new TopicInfo(this.name, this.partitions, this.replication, this.configs, this.validateConfig, this.isMrcCluster, this.shouldRespectMrc);
        }
    }
}

