/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.controlcenter.validation;

import com.google.inject.Inject;
import com.google.inject.Singleton;
import io.confluent.controlcenter.client.ClusterRegistryFeatures;
import io.confluent.controlcenter.errors.UpdateException;
import io.confluent.controlcenter.validation.Validator;
import io.confluent.rbacapi.entities.ClusterInfo;
import io.confluent.rbacapi.validation.v1.V1ValidationUtil;
import javax.annotation.Nullable;
import javax.validation.ConstraintViolationException;
import org.apache.commons.lang3.StringUtils;

@Singleton
public class ClusterInfoValidator
implements Validator<ClusterInfo> {
    private final ClusterRegistryFeatures clusterRegistryFeatures;

    @Inject
    public ClusterInfoValidator(@Nullable ClusterRegistryFeatures clusterRegistryFeatures) {
        this.clusterRegistryFeatures = clusterRegistryFeatures;
    }

    @Override
    public void validate(ClusterInfo clusterInfo) {
        this.getValidator().validate(clusterInfo);
    }

    Validator<ClusterInfo> getValidator() {
        if (this.clusterRegistryFeatures != null && this.clusterRegistryFeatures.unicodeInNameEnabled()) {
            return new V1Validator();
        }
        return new V0Validator();
    }

    public static class V1Validator
    implements Validator<ClusterInfo> {
        private final V1ValidationUtil validator = new V1ValidationUtil();

        @Override
        public void validate(ClusterInfo clusterInfo) {
            try {
                this.validator.verifyClusterInfo(clusterInfo);
            }
            catch (ConstraintViolationException ex) {
                throw new UpdateException((Exception)((Object)ex));
            }
        }
    }

    public static class V0Validator
    implements Validator<ClusterInfo> {
        @Override
        public void validate(ClusterInfo clusterInfo) {
            if (!StringUtils.containsOnly((CharSequence)clusterInfo.getClusterName(), (String)"0123456789_-abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ")) {
                throw new UpdateException("Cluster name should not contain characters other than alphanumeric, '-', and '_'\"");
            }
        }
    }
}

