/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.audit.kafka;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.IntNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.NullNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ShortNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.Struct;
import com.google.protobuf.util.JsonFormat;
import io.confluent.protobuf.events.auditlog.v2.AuditLog;
import io.confluent.protobuf.events.auditlog.v2.Result;
import io.confluent.protobuf.events.auditlog.v2.TypedCloudResourceRef;
import io.confluent.security.audit.AuditLogUtils;
import io.confluent.security.audit.kafka.AuditExtractorOptions;
import io.confluent.security.authorizer.ResourcePattern;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.message.FetchRequestData;
import org.apache.kafka.common.message.FetchRequestDataJsonConverter;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.message.FetchResponseDataJsonConverter;
import org.apache.kafka.common.network.ProduceConsumeAuditLogTracker;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.RequestContext;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.server.audit.KafkaRequestEvent;

public class FetchRequestAuditExtractor {
    public static List<AuditLog> extract(KafkaRequestEvent requestEvent, AuditExtractorOptions extractorOptions) throws Exception {
        ArrayList<AuditLog> extractedAuditLogs = new ArrayList<AuditLog>();
        RequestContext requestContext = (RequestContext)requestEvent.requestContext();
        FetchRequestData fetchRequestData = FetchRequestDataJsonConverter.read((JsonNode)requestEvent.requestPayload(), (short)((short)requestEvent.requestContext().requestVersion()));
        for (FetchRequestData.FetchTopic fetchTopic : fetchRequestData.topics()) {
            String topicName = fetchTopic.topic();
            String transformedTopicName = (requestContext.tenantPrefix().isPresent() ? (String)requestContext.tenantPrefix().get() : "") + topicName;
            Uuid topicId = fetchTopic.topicId();
            boolean useTopicName = requestEvent.requestContext().requestVersion() <= 12;
            ArrayList<FetchResponseData.PartitionData> partitionDataList = new ArrayList<FetchResponseData.PartitionData>();
            requestEvent.responsePayload().get("responses").forEach(response -> response.get("partitions").forEach(partition -> {
                if (useTopicName && response.get("topic").asText().equals(transformedTopicName) || !useTopicName && response.get("topicId").asText().equals(topicId.toString())) {
                    ObjectNode o = (ObjectNode)partition.deepCopy();
                    o.putIfAbsent("records", null);
                    partitionDataList.add(FetchResponseDataJsonConverter.PartitionDataJsonConverter.read((JsonNode)o, (short)((short)requestEvent.requestContext().requestVersion())));
                }
            }));
            partitionDataList.sort(Comparator.comparingInt(FetchResponseData.PartitionData::partitionIndex));
            fetchTopic.partitions().sort(Comparator.comparingInt(FetchRequestData.FetchPartition::partition));
            Iterator requestDataIterator = fetchTopic.partitions().iterator();
            Iterator responseDataIterator = partitionDataList.iterator();
            while (requestDataIterator.hasNext() && responseDataIterator.hasNext()) {
                Boolean cacheHasSuccessEntry;
                FetchResponseData.PartitionData responsePartitionData = (FetchResponseData.PartitionData)responseDataIterator.next();
                ProduceConsumeAuditLogTracker.TopicDetails transformedTopicDetails = new ProduceConsumeAuditLogTracker.TopicDetails(topicId, transformedTopicName);
                Boolean isSuccess = Errors.forCode((short)responsePartitionData.errorCode()).equals((Object)Errors.NONE);
                if (requestContext.produceConsumeAuditLogTracker.hasConsumeTopic(transformedTopicDetails).booleanValue() && ((cacheHasSuccessEntry = requestContext.produceConsumeAuditLogTracker.hasConsumeTopicWithSuccess(transformedTopicDetails)).booleanValue() || !isSuccess.booleanValue())) continue;
                requestContext.produceConsumeAuditLogTracker.addConsumeTopic(transformedTopicDetails, isSuccess != false ? ProduceConsumeAuditLogTracker.LoggedAuditStatus.SUCCESS : ProduceConsumeAuditLogTracker.LoggedAuditStatus.FAILURE);
                boolean hasAuthorizationFailure = AuditLogUtils.hasAuthorizationFailure(responsePartitionData.errorCode());
                Struct requestData = FetchRequestAuditExtractor.requestData(fetchRequestData);
                Struct resultData = FetchRequestAuditExtractor.resultData(responsePartitionData);
                Result.Status status = FetchRequestAuditExtractor.status(responsePartitionData);
                List<TypedCloudResourceRef> typedCloudResourceRefList = FetchRequestAuditExtractor.typedCloudResourceRefList(requestEvent, useTopicName ? topicName : topicId.toString());
                ResourcePattern resourcePattern = new ResourcePattern("Topic", useTopicName ? topicName : topicId.toString(), PatternType.LITERAL);
                String resourceCrn = AuditLogUtils.requestResourceCrn(extractorOptions.crnAuthority(), requestEvent, resourcePattern);
                AuditLog auditLog = AuditLogUtils.auditLog(requestEvent, extractorOptions, hasAuthorizationFailure, false, requestData, status, resultData, typedCloudResourceRefList, resourceCrn);
                extractedAuditLogs.add(auditLog);
            }
        }
        return extractedAuditLogs;
    }

    private static List<TypedCloudResourceRef> typedCloudResourceRefList(KafkaRequestEvent requestEvent, String topicName) {
        List<TypedCloudResourceRef> typedCloudResourceRefList = AuditLogUtils.typedCloudResourceRefList(requestEvent);
        typedCloudResourceRefList.add(TypedCloudResourceRef.newBuilder().setType(TypedCloudResourceRef.ResourceType.TOPIC).setResourceId(topicName).build());
        return typedCloudResourceRefList;
    }

    private static Struct requestData(FetchRequestData fetchRequestData) throws InvalidProtocolBufferException {
        Struct.Builder builder = Struct.newBuilder();
        ObjectNode jsonNode = new ObjectNode(JsonNodeFactory.instance);
        jsonNode.set("partition", (JsonNode)NullNode.getInstance());
        jsonNode.set("offset", (JsonNode)NullNode.getInstance());
        jsonNode.set("isolationLevel", (JsonNode)new IntNode((int)fetchRequestData.isolationLevel()));
        jsonNode.set("sessionId", (JsonNode)new IntNode(fetchRequestData.sessionId()));
        jsonNode.set("sessionEpoch", (JsonNode)new IntNode(fetchRequestData.sessionEpoch()));
        JsonFormat.parser().merge(jsonNode.toString(), (Message.Builder)builder);
        return builder.build();
    }

    private static Result.Status status(FetchResponseData.PartitionData partitionData) {
        if (partitionData.errorCode() == Errors.NONE.code()) {
            return Result.Status.SUCCESS;
        }
        return Result.Status.FAILURE;
    }

    private static Struct resultData(FetchResponseData.PartitionData partitionData) throws InvalidProtocolBufferException {
        Struct.Builder builder = Struct.newBuilder();
        ObjectNode jsonNode = new ObjectNode(JsonNodeFactory.instance);
        jsonNode.set("message", (JsonNode)new TextNode(Errors.forCode((short)partitionData.errorCode()).message()));
        jsonNode.set("errorCode", (JsonNode)new ShortNode(partitionData.errorCode()));
        jsonNode.set("errorType", (JsonNode)new TextNode(Errors.forCode((short)partitionData.errorCode()).name()));
        JsonFormat.parser().merge(jsonNode.toString(), (Message.Builder)builder);
        return builder.build();
    }
}

