/*
 * Decompiled with CFR 0.152.
 */
package io.spiffe.provider;

import io.spiffe.bundle.BundleSource;
import io.spiffe.bundle.x509bundle.X509Bundle;
import io.spiffe.provider.SpiffeKeyManagerFactory;
import io.spiffe.provider.SpiffeTrustManagerFactory;
import io.spiffe.spiffeid.SpiffeId;
import io.spiffe.svid.x509svid.X509SvidSource;
import io.spiffe.workloadapi.X509Source;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import java.util.Set;
import java.util.function.Supplier;
import javax.net.ssl.KeyManager;
import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import lombok.Generated;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public final class SpiffeSslContextFactory {
    private static final String DEFAULT_SSL_PROTOCOL = "TLSv1.2";

    private SpiffeSslContextFactory() {
    }

    public static SSLContext getSslContext(@NonNull SslContextOptions options) throws NoSuchAlgorithmException, KeyManagementException {
        if (options == null) {
            throw new NullPointerException("options is marked non-null but is null");
        }
        if (options.x509Source == null) {
            throw new IllegalArgumentException("x509Source option cannot be null, an X.509 Source must be provided");
        }
        if (!options.acceptAnySpiffeId && options.acceptedSpiffeIdsSupplier == null) {
            throw new IllegalArgumentException("SSL context should be configured either with a Supplier of accepted SPIFFE IDs or with acceptAnySpiffeId=true");
        }
        SSLContext sslContext = SpiffeSslContextFactory.newSslContext(options);
        TrustManager[] trustManagers = SpiffeSslContextFactory.newTrustManager(options);
        KeyManager[] keyManagers = new SpiffeKeyManagerFactory().engineGetKeyManagers((X509SvidSource)options.x509Source);
        sslContext.init(keyManagers, trustManagers, null);
        return sslContext;
    }

    private static TrustManager[] newTrustManager(SslContextOptions options) {
        if (options.acceptAnySpiffeId) {
            return new SpiffeTrustManagerFactory().engineGetTrustManagersAcceptAnySpiffeId((BundleSource<X509Bundle>)options.x509Source);
        }
        TrustManager[] trustManager = options.acceptedSpiffeIdsSupplier != null ? new SpiffeTrustManagerFactory().engineGetTrustManagers((BundleSource<X509Bundle>)options.x509Source, options.acceptedSpiffeIdsSupplier) : new SpiffeTrustManagerFactory().engineGetTrustManagers((BundleSource<X509Bundle>)options.x509Source);
        return trustManager;
    }

    private static SSLContext newSslContext(SslContextOptions options) throws NoSuchAlgorithmException {
        if (StringUtils.isBlank((CharSequence)options.sslProtocol)) {
            options.sslProtocol = DEFAULT_SSL_PROTOCOL;
        }
        return SSLContext.getInstance(options.sslProtocol);
    }

    public static class SslContextOptions {
        private String sslProtocol;
        private X509Source x509Source;
        private Supplier<Set<SpiffeId>> acceptedSpiffeIdsSupplier;
        private boolean acceptAnySpiffeId;

        public SslContextOptions(String sslProtocol, X509Source x509Source, Supplier<Set<SpiffeId>> acceptedSpiffeIdsSupplier, boolean acceptAnySpiffeId) {
            this.x509Source = x509Source;
            this.acceptedSpiffeIdsSupplier = acceptedSpiffeIdsSupplier;
            this.sslProtocol = sslProtocol;
            this.acceptAnySpiffeId = acceptAnySpiffeId;
        }

        public static SslContextOptionsBuilder builder() {
            return new SslContextOptionsBuilder();
        }

        @Generated
        public String getSslProtocol() {
            return this.sslProtocol;
        }

        @Generated
        public X509Source getX509Source() {
            return this.x509Source;
        }

        @Generated
        public Supplier<Set<SpiffeId>> getAcceptedSpiffeIdsSupplier() {
            return this.acceptedSpiffeIdsSupplier;
        }

        @Generated
        public boolean isAcceptAnySpiffeId() {
            return this.acceptAnySpiffeId;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SslContextOptions)) {
                return false;
            }
            SslContextOptions other = (SslContextOptions)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isAcceptAnySpiffeId() != other.isAcceptAnySpiffeId()) {
                return false;
            }
            String this$sslProtocol = this.getSslProtocol();
            String other$sslProtocol = other.getSslProtocol();
            if (this$sslProtocol == null ? other$sslProtocol != null : !this$sslProtocol.equals(other$sslProtocol)) {
                return false;
            }
            X509Source this$x509Source = this.getX509Source();
            X509Source other$x509Source = other.getX509Source();
            if (this$x509Source == null ? other$x509Source != null : !this$x509Source.equals(other$x509Source)) {
                return false;
            }
            Supplier<Set<SpiffeId>> this$acceptedSpiffeIdsSupplier = this.getAcceptedSpiffeIdsSupplier();
            Supplier<Set<SpiffeId>> other$acceptedSpiffeIdsSupplier = other.getAcceptedSpiffeIdsSupplier();
            return !(this$acceptedSpiffeIdsSupplier == null ? other$acceptedSpiffeIdsSupplier != null : !this$acceptedSpiffeIdsSupplier.equals(other$acceptedSpiffeIdsSupplier));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof SslContextOptions;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isAcceptAnySpiffeId() ? 79 : 97);
            String $sslProtocol = this.getSslProtocol();
            result = result * 59 + ($sslProtocol == null ? 43 : $sslProtocol.hashCode());
            X509Source $x509Source = this.getX509Source();
            result = result * 59 + ($x509Source == null ? 43 : $x509Source.hashCode());
            Supplier<Set<SpiffeId>> $acceptedSpiffeIdsSupplier = this.getAcceptedSpiffeIdsSupplier();
            result = result * 59 + ($acceptedSpiffeIdsSupplier == null ? 43 : $acceptedSpiffeIdsSupplier.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "SpiffeSslContextFactory.SslContextOptions(sslProtocol=" + this.getSslProtocol() + ", x509Source=" + this.getX509Source() + ", acceptedSpiffeIdsSupplier=" + this.getAcceptedSpiffeIdsSupplier() + ", acceptAnySpiffeId=" + this.isAcceptAnySpiffeId() + ")";
        }

        public static class SslContextOptionsBuilder {
            private String sslProtocol;
            private X509Source x509Source;
            private Supplier<Set<SpiffeId>> acceptedSpiffeIdsSupplier;
            private boolean acceptAnySpiffeId;

            SslContextOptionsBuilder() {
            }

            public SslContextOptionsBuilder sslProtocol(String sslProtocol) {
                this.sslProtocol = sslProtocol;
                return this;
            }

            public SslContextOptionsBuilder x509Source(X509Source x509Source) {
                this.x509Source = x509Source;
                return this;
            }

            public SslContextOptionsBuilder acceptedSpiffeIdsSupplier(Supplier<Set<SpiffeId>> acceptedSpiffeIdsSupplier) {
                this.acceptedSpiffeIdsSupplier = acceptedSpiffeIdsSupplier;
                return this;
            }

            public SslContextOptionsBuilder acceptAnySpiffeId() {
                this.acceptAnySpiffeId = true;
                return this;
            }

            public SslContextOptions build() {
                return new SslContextOptions(this.sslProtocol, this.x509Source, this.acceptedSpiffeIdsSupplier, this.acceptAnySpiffeId);
            }
        }
    }
}

