/*
 * Decompiled with CFR 0.152.
 */
package kafka.coordinator.transaction;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import kafka.coordinator.transaction.ProducerIdManager;
import kafka.coordinator.transaction.ProducerIdManager$;
import kafka.server.ControllerRequestCompletionHandler;
import kafka.server.NodeToControllerChannelManager;
import kafka.utils.Logging;
import org.apache.kafka.clients.ClientResponse;
import org.apache.kafka.common.message.AllocateProducerIdsRequestData;
import org.apache.kafka.common.message.AllocateProducerIdsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.AbstractRequest;
import org.apache.kafka.common.requests.AllocateProducerIdsRequest;
import org.apache.kafka.common.requests.AllocateProducerIdsResponse;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.common.ProducerIdsBlock;
import scala.Function0;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Failure;
import scala.util.Success;
import scala.util.Try;

@ScalaSignature(bytes="\u0006\u0005\u0005Eb\u0001B\u000b\u0017\u0001uA\u0001B\f\u0001\u0003\u0002\u0003\u0006Ia\f\u0005\te\u0001\u0011\t\u0011)A\u0005g!Aq\b\u0001B\u0001B\u0003%\u0001\t\u0003\u0005G\u0001\t\u0005\t\u0015!\u0003H\u0011\u0015i\u0005\u0001\"\u0001O\u0011!!\u0006\u00011A\u0005\u0002Y)\u0006\u0002\u00035\u0001\u0001\u0004%\tAF5\t\r=\u0004\u0001\u0015)\u0003W\u0011!\u0001\bA1A\u0005\u0002Y)\u0006BB9\u0001A\u0003%a\u000bC\u0004s\u0001\t\u0007I\u0011B:\t\r]\u0004\u0001\u0015!\u0003u\u0011\u001dA\bA1A\u0005\neDa! \u0001!\u0002\u0013Q\b\"\u0002@\u0001\t\u0003z\bbBA\u0004\u0001\u0011\u0005\u0013\u0011\u0002\u0005\t\u0003+\u0001A\u0011\u0001\f\u0002\u0018!A\u0011\u0011\u0004\u0001\u0005\u0002Y\t9\u0002\u0003\u0005\u0002\u001c\u0001!\tAFA\u000f\u0011\u001d\ty\u0003\u0001C\u0005\u0003/\u0011AC\u0015)D!J|G-^2fe&#W*\u00198bO\u0016\u0014(BA\f\u0019\u0003-!(/\u00198tC\u000e$\u0018n\u001c8\u000b\u0005eQ\u0012aC2p_J$\u0017N\\1u_JT\u0011aG\u0001\u0006W\u000647.Y\u0002\u0001'\u0011\u0001a\u0004\n\u0015\u0011\u0005}\u0011S\"\u0001\u0011\u000b\u0003\u0005\nQa]2bY\u0006L!a\t\u0011\u0003\r\u0005s\u0017PU3g!\t)c%D\u0001\u0017\u0013\t9cCA\tQe>$WoY3s\u0013\u0012l\u0015M\\1hKJ\u0004\"!\u000b\u0017\u000e\u0003)R!a\u000b\u000e\u0002\u000bU$\u0018\u000e\\:\n\u00055R#a\u0002'pO\u001eLgnZ\u0001\tEJ|7.\u001a:JIB\u0011q\u0004M\u0005\u0003c\u0001\u00121!\u00138u\u0003\u0011!\u0018.\\3\u0011\u0005QjT\"A\u001b\u000b\u0005-2$BA\u001c9\u0003\u0019\u0019w.\\7p]*\u00111$\u000f\u0006\u0003um\na!\u00199bG\",'\"\u0001\u001f\u0002\u0007=\u0014x-\u0003\u0002?k\t!A+[7f\u0003M\u0011'o\\6fe\u0016\u0003xn\u00195TkB\u0004H.[3s!\ry\u0012iQ\u0005\u0003\u0005\u0002\u0012\u0011BR;oGRLwN\u001c\u0019\u0011\u0005}!\u0015BA#!\u0005\u0011auN\\4\u0002#\r|g\u000e\u001e:pY2,'o\u00115b]:,G\u000e\u0005\u0002I\u00176\t\u0011J\u0003\u0002K5\u000511/\u001a:wKJL!\u0001T%\u0003=9{G-\u001a+p\u0007>tGO]8mY\u0016\u00148\t[1o]\u0016dW*\u00198bO\u0016\u0014\u0018A\u0002\u001fj]&$h\bF\u0003P!F\u00136\u000b\u0005\u0002&\u0001!)a&\u0002a\u0001_!)!'\u0002a\u0001g!)q(\u0002a\u0001\u0001\")a)\u0002a\u0001\u000f\u0006\u0019b.\u001a=u!J|G-^2fe&#'\t\\8dWV\ta\u000bE\u0002XA\nl\u0011\u0001\u0017\u0006\u00033j\u000ba!\u0019;p[&\u001c'BA.]\u0003)\u0019wN\\2veJ,g\u000e\u001e\u0006\u0003;z\u000bA!\u001e;jY*\tq,\u0001\u0003kCZ\f\u0017BA1Y\u0005=\tEo\\7jGJ+g-\u001a:f]\u000e,\u0007CA2g\u001b\u0005!'BA\u001cf\u0015\tQ\u0005(\u0003\u0002hI\n\u0001\u0002K]8ek\u000e,'/\u00133t\u00052|7m[\u0001\u0018]\u0016DH\u000f\u0015:pIV\u001cWM]%e\u00052|7m[0%KF$\"A[7\u0011\u0005}Y\u0017B\u00017!\u0005\u0011)f.\u001b;\t\u000f9<\u0011\u0011!a\u0001-\u0006\u0019\u0001\u0010J\u0019\u0002)9,\u0007\u0010\u001e)s_\u0012,8-\u001a:JI\ncwnY6!\u0003Y\u0019WO\u001d:f]R\u0004&o\u001c3vG\u0016\u0014\u0018\n\u001a\"m_\u000e\\\u0017aF2veJ,g\u000e\u001e)s_\u0012,8-\u001a:JI\ncwnY6!\u0003=\u0011X-];fgRLeN\u00127jO\"$X#\u0001;\u0011\u0005]+\u0018B\u0001<Y\u00055\tEo\\7jG\n{w\u000e\\3b]\u0006\u0001\"/Z9vKN$\u0018J\u001c$mS\u001eDG\u000fI\u0001\u0012E\u0006\u001c7n\u001c4g\t\u0016\fG\r\\5oK6\u001bX#\u0001>\u0011\u0005][\u0018B\u0001?Y\u0005)\tEo\\7jG2{gnZ\u0001\u0013E\u0006\u001c7n\u001c4g\t\u0016\fG\r\\5oK6\u001b\b%A\u0007iCN4\u0016\r\\5e\u00052|7m[\u000b\u0003\u0003\u0003\u00012aHA\u0002\u0013\r\t)\u0001\t\u0002\b\u0005>|G.Z1o\u0003I9WM\\3sCR,\u0007K]8ek\u000e,'/\u00133\u0015\u0005\u0005-\u0001#BA\u0007\u0003#\u0019UBAA\b\u0015\ti\u0006%\u0003\u0003\u0002\u0014\u0005=!a\u0001+ss\u0006)R.Y=cKJ+\u0017/^3ti:+\u0007\u0010\u001e\"m_\u000e\\G#\u00016\u0002\u0017M,g\u000e\u001a*fcV,7\u000f^\u0001\"Q\u0006tG\r\\3BY2|7-\u0019;f!J|G-^2fe&#7OU3ta>t7/\u001a\u000b\u0004U\u0006}\u0001bBA\u0011'\u0001\u0007\u00111E\u0001\te\u0016\u001c\bo\u001c8tKB!\u0011QEA\u0016\u001b\t\t9CC\u0002\u0002*Y\n\u0001B]3rk\u0016\u001cHo]\u0005\u0005\u0003[\t9CA\u000eBY2|7-\u0019;f!J|G-^2fe&#7OU3ta>t7/Z\u0001\u000eQ\u0006tG\r\\3US6,w.\u001e;")
public class RPCProducerIdManager
implements ProducerIdManager,
Logging {
    private final int brokerId;
    private final Time time;
    private final Function0<Object> brokerEpochSupplier;
    private final NodeToControllerChannelManager controllerChannel;
    private AtomicReference<ProducerIdsBlock> nextProducerIdBlock;
    private final AtomicReference<ProducerIdsBlock> currentProducerIdBlock;
    private final AtomicBoolean requestInFlight;
    private final AtomicLong backoffDeadlineMs;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public void shutdown() {
        ProducerIdManager.shutdown$(this);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public AtomicReference<ProducerIdsBlock> nextProducerIdBlock() {
        return this.nextProducerIdBlock;
    }

    public void nextProducerIdBlock_$eq(AtomicReference<ProducerIdsBlock> x$1) {
        this.nextProducerIdBlock = x$1;
    }

    public AtomicReference<ProducerIdsBlock> currentProducerIdBlock() {
        return this.currentProducerIdBlock;
    }

    private AtomicBoolean requestInFlight() {
        return this.requestInFlight;
    }

    private AtomicLong backoffDeadlineMs() {
        return this.backoffDeadlineMs;
    }

    @Override
    public boolean hasValidBlock() {
        return this.nextProducerIdBlock().get() != null;
    }

    @Override
    public Try<Object> generateProducerId() {
        Failure result = null;
        int iteration = 0;
        while (result == null) {
            Option option = OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(this.currentProducerIdBlock().get().claimNextId()));
            if (None$.MODULE$.equals(option)) {
                ProducerIdsBlock block = this.nextProducerIdBlock().getAndSet(null);
                if (block == null) {
                    this.maybeRequestNextBlock();
                    result = new Failure((Throwable)Errors.COORDINATOR_LOAD_IN_PROGRESS.exception("Producer ID block is full. Waiting for next block"));
                } else {
                    this.currentProducerIdBlock().set(block);
                    this.requestInFlight().set(false);
                    ++iteration;
                }
            } else if (option instanceof Some) {
                long prefetchTarget;
                Long nextProducerId = (Long)((Some)option).value();
                if (BoxesRunTime.equalsNumObject((Number)nextProducerId, (Object)BoxesRunTime.boxToLong((long)(prefetchTarget = this.currentProducerIdBlock().get().firstProducerId() + (long)((double)this.currentProducerIdBlock().get().size() * ProducerIdManager$.MODULE$.PidPrefetchThreshold()))))) {
                    this.maybeRequestNextBlock();
                }
                result = new Success((Object)BoxesRunTime.boxToLong((long)Predef$.MODULE$.Long2long(nextProducerId)));
            } else {
                throw new MatchError((Object)option);
            }
            if (iteration != ProducerIdManager$.MODULE$.IterationLimit()) continue;
            result = new Failure((Throwable)Errors.COORDINATOR_LOAD_IN_PROGRESS.exception("Producer ID block is full. Waiting for next block"));
        }
        return result;
    }

    public void maybeRequestNextBlock() {
        long retryTimestamp = this.backoffDeadlineMs().get();
        if (retryTimestamp == ProducerIdManager$.MODULE$.NoRetry() || this.time.milliseconds() >= retryTimestamp) {
            if (this.nextProducerIdBlock().get() == null && this.requestInFlight().compareAndSet(false, true)) {
                this.sendRequest();
                this.backoffDeadlineMs().set(ProducerIdManager$.MODULE$.NoRetry());
                return;
            }
            return;
        }
    }

    public void sendRequest() {
        AllocateProducerIdsRequestData message = new AllocateProducerIdsRequestData().setBrokerEpoch(this.brokerEpochSupplier.apply$mcJ$sp()).setBrokerId(this.brokerId);
        AllocateProducerIdsRequest.Builder request = new AllocateProducerIdsRequest.Builder(message);
        this.debug((Function0<String>)(Function0 & Serializable)() -> "Requesting next Producer ID block");
        this.controllerChannel.sendRequest((AbstractRequest.Builder<? extends AbstractRequest>)request, new ControllerRequestCompletionHandler(this){
            private final /* synthetic */ RPCProducerIdManager $outer;

            public void onComplete(ClientResponse response) {
                AllocateProducerIdsResponse message = (AllocateProducerIdsResponse)response.responseBody();
                this.$outer.handleAllocateProducerIdsResponse(message);
            }

            public void onTimeout() {
                this.$outer.kafka$coordinator$transaction$RPCProducerIdManager$$handleTimeout();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
    }

    public void handleAllocateProducerIdsResponse(AllocateProducerIdsResponse response) {
        AllocateProducerIdsResponseData data = response.data();
        boolean successfulResponse = false;
        Errors errors = Errors.forCode((short)data.errorCode());
        if (Errors.NONE.equals(errors)) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(43).append("Got next producer ID block from controller ").append(data).toString());
            if (data.producerIdStart() < this.currentProducerIdBlock().get().lastProducerId()) {
                this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(73).append("Producer ID block is not monotonic with current block: current=").append(this.currentProducerIdBlock()).append(" response=").append(data).toString());
            } else if (data.producerIdStart() < 0L || data.producerIdLen() < 0 || data.producerIdStart() > Long.MAX_VALUE - (long)data.producerIdLen()) {
                this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(45).append("Producer ID block includes invalid ID range: ").append(data).toString());
            } else {
                this.nextProducerIdBlock().set(new ProducerIdsBlock(this.brokerId, data.producerIdStart(), data.producerIdLen()));
                successfulResponse = true;
            }
        } else if (Errors.STALE_BROKER_EPOCH.equals(errors)) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> "Our broker currentBlockCount was stale, trying again.");
        } else if (Errors.BROKER_ID_NOT_REGISTERED.equals(errors)) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> "Our broker ID is not yet known by the controller, trying again.");
        } else if (errors != null) {
            this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(55).append("Received an unexpected error code from the controller: ").append(errors).toString());
        } else {
            throw new MatchError(null);
        }
        if (!successfulResponse) {
            this.backoffDeadlineMs().set(this.time.milliseconds() + (long)ProducerIdManager$.MODULE$.RetryBackoffMs());
            this.requestInFlight().set(false);
            return;
        }
    }

    public void kafka$coordinator$transaction$RPCProducerIdManager$$handleTimeout() {
        this.warn((Function0<String>)(Function0 & Serializable)() -> "Timed out when requesting AllocateProducerIds from the controller.");
        this.requestInFlight().set(false);
    }

    public RPCProducerIdManager(int brokerId, Time time, Function0<Object> brokerEpochSupplier, NodeToControllerChannelManager controllerChannel) {
        this.brokerId = brokerId;
        this.time = time;
        this.brokerEpochSupplier = brokerEpochSupplier;
        this.controllerChannel = controllerChannel;
        this.logIdent_$eq(new StringBuilder(27).append("[RPC ProducerId Manager ").append(brokerId).append("]: ").toString());
        this.nextProducerIdBlock = new AtomicReference<Object>(null);
        this.currentProducerIdBlock = new AtomicReference<ProducerIdsBlock>(ProducerIdsBlock.EMPTY);
        this.requestInFlight = new AtomicBoolean(false);
        this.backoffDeadlineMs = new AtomicLong(ProducerIdManager$.MODULE$.NoRetry());
    }
}

