/*
 * Decompiled with CFR 0.152.
 */
package kafka.network;

import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiFunction;
import java.util.function.Function;
import java.util.function.Supplier;
import kafka.network.BrokerQuotaEntity;
import kafka.network.ConnectionQuotaEntity;
import kafka.network.ListenerConnectionQuotaEntity;
import kafka.network.SocketServer;
import kafka.network.TooManyConnectionsException;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.network.ListenerName;

public class ConnectionQuota<Entity> {
    private final Metrics metrics;
    private final Map<Entity, Integer> counts;
    private volatile Map<Entity, Integer> maxConnectionsOverride;
    private volatile int defaultMaxConnections;
    private final Map<Entity, Double> maxConnectionRateOverride;
    private volatile double defaultMaxConnectionRate;
    private final Function<Entity, ConnectionQuotaEntity> createQuotaEntity;
    private final BiFunction<Entity, ListenerName, ListenerConnectionQuotaEntity> createListenerConnectionQuotaEntity;
    private final Supplier<Double> calculateDefaultMaxConnectionRate;
    private final String entityMetricTag;
    private final Function<String, Entity> metricValueToEntity;

    private ConnectionQuota(Metrics metrics, Map<Entity, Integer> maxConnectionsOverride, int defaultMaxConnections, Function<Entity, ConnectionQuotaEntity> createQuotaEntity, BiFunction<Entity, ListenerName, ListenerConnectionQuotaEntity> createListenerConnectionQuotaEntity, Supplier<Double> calculateDefaultMaxConnectionRate, String entityMetricTag, Function<String, Entity> metricValueToEntity) {
        this.metrics = Objects.requireNonNull(metrics);
        this.counts = new HashMap<Entity, Integer>();
        this.maxConnectionsOverride = Objects.requireNonNull(maxConnectionsOverride);
        this.defaultMaxConnections = defaultMaxConnections;
        this.maxConnectionRateOverride = new ConcurrentHashMap<Entity, Double>();
        this.defaultMaxConnectionRate = calculateDefaultMaxConnectionRate.get();
        this.createQuotaEntity = Objects.requireNonNull(createQuotaEntity);
        this.createListenerConnectionQuotaEntity = Objects.requireNonNull(createListenerConnectionQuotaEntity);
        this.calculateDefaultMaxConnectionRate = Objects.requireNonNull(calculateDefaultMaxConnectionRate);
        this.entityMetricTag = Objects.requireNonNull(entityMetricTag);
        this.metricValueToEntity = Objects.requireNonNull(metricValueToEntity);
    }

    public double maxConnectionRate(Entity entity) {
        return this.maxConnectionRateOverride.getOrDefault(entity, this.defaultMaxConnectionRate);
    }

    void incrementConnectionCount(Entity entity) {
        this.counts.put(entity, this.counts.getOrDefault(entity, 0) + 1);
    }

    void decrementConnectionCount(Entity entity) {
        int count = this.counts.getOrDefault(entity, 0);
        if (count <= 1) {
            this.counts.remove(entity);
        } else {
            this.counts.put(entity, count - 1);
        }
    }

    boolean containsEntity(Entity entity) {
        return this.counts.containsKey(entity);
    }

    Integer connectionCountOrDefault(Entity entity, Integer defaultCount) {
        return this.counts.getOrDefault(entity, defaultCount);
    }

    boolean isConnectionCountsEmpty() {
        return this.counts.isEmpty();
    }

    int connectionCount(Entity entity) {
        return this.connectionCountOrDefault(entity, 0);
    }

    void updateDefaultMaxConnections(int defaultMaxConnections) {
        this.defaultMaxConnections = defaultMaxConnections;
    }

    void updateMaxConnectionsOverride(Map<Entity, Integer> maxConnectionsOverride) {
        this.maxConnectionsOverride = maxConnectionsOverride;
    }

    int maxConnections(Entity entity) {
        return this.maxConnectionsOverride.getOrDefault(entity, this.defaultMaxConnections);
    }

    void enforceMaxConnectionLimit(Entity entity) {
        int max;
        int count = this.counts.getOrDefault(entity, 0);
        if (count > (max = this.maxConnections(entity))) {
            throw new TooManyConnectionsException(entity.toString(), max);
        }
    }

    void updateDefaultMaxConnectionRate(Optional<Double> defaultMaxConnectionRate) {
        this.defaultMaxConnectionRate = defaultMaxConnectionRate.orElse(this.calculateDefaultMaxConnectionRate.get());
    }

    void updateMaxConnectionRate(Entity entity, double rate) {
        this.maxConnectionRateOverride.put(entity, rate);
    }

    void removeMaxConnectionRate(Entity entity) {
        this.maxConnectionRateOverride.remove(entity);
    }

    boolean containsConnectionRateOverride(Entity entity) {
        return this.maxConnectionRateOverride.containsKey(entity);
    }

    double defaultMaxConnectionRate() {
        return this.defaultMaxConnectionRate;
    }

    boolean isQuotaEnabled(double quotaValue) {
        return Double.MAX_VALUE != quotaValue;
    }

    boolean isEntityConnectionQuotaMetric(MetricName metricName) {
        return BrokerQuotaEntity.ConnectionQuotaMetricName().equals(metricName.name()) && SocketServer.MetricsGroup().equals(metricName.group()) && metricName.tags().containsKey(this.entityMetricTag);
    }

    ConnectionQuotaEntity createConnectionQuotaEntity(Entity entity) {
        return this.createQuotaEntity.apply(entity);
    }

    ListenerConnectionQuotaEntity createListenerConnectionQuotaEntity(Entity entity, ListenerName listenerName) {
        return this.createListenerConnectionQuotaEntity.apply(entity, listenerName);
    }

    Entity entityFromMetricName(MetricName metricName) {
        return this.metricValueToEntity.apply((String)metricName.tags().get(this.entityMetricTag));
    }

    Sensor getOrCreateConnectionRateThrottleSensor(Entity entity) {
        ConnectionQuotaEntity quotaEntity = this.createQuotaEntity.apply(entity);
        String sensorName = String.format("ConnectionRateThrottleTime-%s", quotaEntity.entityName());
        Sensor sensor = this.metrics.getSensor(sensorName);
        if (sensor == null) {
            sensor = this.metrics.sensor(sensorName, null, BrokerQuotaEntity.InactiveSensorExpirationTimeSeconds(), new Sensor[0]);
            MetricName metricName = this.metrics.metricName(String.format("%s-connection-accept-throttle-time", quotaEntity.domain()), SocketServer.MetricsGroup(), String.format("Tracking average throttle-time, out of non-zero throttle times, per %s", quotaEntity.domain()), quotaEntity.metricTags());
            sensor.add(metricName, (MeasurableStat)new Avg());
        }
        return sensor;
    }

    public static class Builder<Entity> {
        private final Metrics metrics;
        private Map<Entity, Integer> maxConnectionsOverride = null;
        private int defaultMaxConnections = -1;
        private Function<Entity, ConnectionQuotaEntity> createQuotaEntity = null;
        private BiFunction<Entity, ListenerName, ListenerConnectionQuotaEntity> createListenerConnectionQuotaEntity = null;
        private Supplier<Double> calculateDefaultMaxConnectionRate = null;
        private String entityMetricTag = null;
        private Function<String, Entity> metricValueToEntity = null;

        public Builder(Metrics metrics) {
            this.metrics = metrics;
        }

        public Builder<Entity> setMaxConnectionsOverride(Map<Entity, Integer> maxConnectionsOverride) {
            this.maxConnectionsOverride = maxConnectionsOverride;
            return this;
        }

        public Builder<Entity> setDefaultMaxConnections(int defaultMaxConnections) {
            this.defaultMaxConnections = defaultMaxConnections;
            return this;
        }

        public Builder<Entity> setCreateQuotaEntity(Function<Entity, ConnectionQuotaEntity> createQuotaEntity) {
            this.createQuotaEntity = createQuotaEntity;
            return this;
        }

        public Builder<Entity> setCreateListenerConnectionQuotaEntity(BiFunction<Entity, ListenerName, ListenerConnectionQuotaEntity> createListenerConnectionQuotaEntity) {
            this.createListenerConnectionQuotaEntity = createListenerConnectionQuotaEntity;
            return this;
        }

        public Builder<Entity> setCalculateDefaultMaxConnectionRate(Supplier<Double> calculateDefaultMaxConnectionRate) {
            this.calculateDefaultMaxConnectionRate = calculateDefaultMaxConnectionRate;
            return this;
        }

        public Builder<Entity> setEntityMetricTag(String entityMetricTag) {
            this.entityMetricTag = entityMetricTag;
            return this;
        }

        public Builder<Entity> setMetricValueToEntity(Function<String, Entity> metricValueToEntity) {
            this.metricValueToEntity = metricValueToEntity;
            return this;
        }

        public ConnectionQuota<Entity> build() {
            if (this.maxConnectionsOverride == null) {
                throw new IllegalStateException("You must specify a maxConnectionsOverride");
            }
            if (this.defaultMaxConnections <= -1) {
                throw new IllegalStateException("You must specify a defaultMaxConnections");
            }
            if (this.createQuotaEntity == null) {
                throw new IllegalStateException("You must specify a createQuotaEntity");
            }
            if (this.createListenerConnectionQuotaEntity == null) {
                throw new IllegalStateException("You must specify a createListenerConnectionQuotaEntity");
            }
            if (this.calculateDefaultMaxConnectionRate == null) {
                throw new IllegalStateException("You must specify a calculateDefaultMaxConnectionRate");
            }
            if (this.entityMetricTag == null) {
                throw new IllegalStateException("You must specify a entityMetricTag");
            }
            if (this.metricValueToEntity == null) {
                throw new IllegalStateException("You must specify a metricValueToEntity");
            }
            return new ConnectionQuota(this.metrics, this.maxConnectionsOverride, this.defaultMaxConnections, this.createQuotaEntity, this.createListenerConnectionQuotaEntity, this.calculateDefaultMaxConnectionRate, this.entityMetricTag, this.metricValueToEntity);
        }
    }
}

