/*
 * Decompiled with CFR 0.152.
 */
package kafka.raft;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Histogram;
import io.confluent.kafka.availability.FilesWrapper;
import io.confluent.kafka.storage.checksum.E2EChecksumStore;
import java.io.File;
import java.io.Serializable;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.util.Map;
import java.util.Optional;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import kafka.log.AbstractLog;
import kafka.log.MergedLog;
import kafka.log.MergedLog$;
import kafka.log.TierLogComponents;
import kafka.log.TierLogComponents$;
import kafka.raft.KafkaMetadataLog;
import kafka.raft.MetadataLogConfig;
import kafka.server.BrokerTopicStats;
import kafka.server.KafkaConfig$;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.raft.OffsetAndEpoch;
import org.apache.kafka.server.util.Scheduler;
import org.apache.kafka.snapshot.FileRawSnapshotReader;
import org.apache.kafka.snapshot.SnapshotPath;
import org.apache.kafka.snapshot.Snapshots;
import org.apache.kafka.storage.internals.log.LogConfig;
import org.apache.kafka.storage.internals.log.LogDirFailureChannel;
import org.apache.kafka.storage.internals.log.LogOffsetsListener;
import org.apache.kafka.storage.internals.log.ProducerIdQuotaRecorder;
import org.apache.kafka.storage.internals.log.ProducerStateManagerConfig;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.collection.mutable.TreeMap;
import scala.collection.mutable.TreeMap$;
import scala.math.Ordering$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

public final class KafkaMetadataLog$
implements Logging {
    public static final KafkaMetadataLog$ MODULE$ = new KafkaMetadataLog$();
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public KafkaMetadataLog apply(TopicPartition topicPartition, Uuid topicId, File dataDir, Time time, Metrics metrics, Scheduler scheduler, MetadataLogConfig config, Consumer<Long> logStartOffsetChangeCallback, Consumer<OffsetAndEpoch> logSnapshotGeneratedCallback) {
        Properties props = new Properties();
        props.setProperty("max.message.bytes", Integer.toString(config.maxBatchSizeInBytes()));
        props.setProperty("segment.bytes", Integer.toString(config.logSegmentBytes()));
        props.setProperty("segment.ms", Long.toString(config.logSegmentMillis()));
        props.setProperty("file.delete.delay.ms", Long.toString(60000L));
        props.setProperty("retention.ms", "-1");
        props.setProperty("retention.bytes", "-1");
        LogConfig.validate((Properties)props);
        LogConfig defaultLogConfig = new LogConfig((Map)props);
        if (config.logSegmentBytes() < config.logSegmentMinBytes()) {
            throw new InvalidConfigurationException(new StringBuilder(20).append("Cannot set ").append(KafkaConfig$.MODULE$.MetadataLogSegmentBytesProp()).append(" below ").append(config.logSegmentMinBytes()).append(": ").append(config.logSegmentBytes()).toString());
        }
        if (defaultLogConfig.retentionMs >= 0L) {
            throw new InvalidConfigurationException(new StringBuilder(35).append("Cannot set ").append("retention.ms").append(" above -1: ").append(defaultLogConfig.retentionMs).append(".").toString());
        }
        if (defaultLogConfig.retentionSize >= 0L) {
            throw new InvalidConfigurationException(new StringBuilder(38).append("Cannot set ").append("retention.bytes").append(" above -1: ").append(defaultLogConfig.retentionSize).append(".").toString());
        }
        BrokerTopicStats x$6 = new BrokerTopicStats();
        ProducerStateManagerConfig x$10 = new ProducerStateManagerConfig(Integer.MAX_VALUE, false);
        LogDirFailureChannel x$12 = new LogDirFailureChannel(5);
        TierLogComponents x$13 = TierLogComponents$.MODULE$.EMPTY();
        Some x$15 = new Some((Object)topicId);
        None$ x$17 = None$.MODULE$;
        Optional<E2EChecksumStore> x$18 = Optional.empty();
        None$ x$19 = None$.MODULE$;
        LogOffsetsListener x$20 = LogOffsetsListener.NO_OP_OFFSETS_LISTENER;
        ConcurrentHashMap<String, Object> x$21 = new ConcurrentHashMap<String, Object>();
        MergedLog log = MergedLog$.MODULE$.apply(dataDir, defaultLogConfig, 0L, 0L, scheduler, x$6, metrics, time, Integer.MAX_VALUE, x$10, Integer.MAX_VALUE, (Option<ProducerIdQuotaRecorder>)x$19, x$12, x$13, false, (Option<Uuid>)x$15, true, x$20, (Option<Histogram>)x$17, x$21, x$18);
        KafkaMetadataLog metadataLog = new KafkaMetadataLog(log, time, scheduler, this.recoverSnapshots(log, true), topicPartition, config, logStartOffsetChangeCallback, logSnapshotGeneratedCallback);
        if (config.logSegmentMinBytes() != 0x800000 && metadataLog.logger().underlying().isErrorEnabled()) {
            String msgWithLogIdent_msg = KafkaMetadataLog$.$anonfun$apply$1();
            Object var24_24 = null;
            metadataLog.logger().underlying().error(Logging.msgWithLogIdent$(metadataLog, msgWithLogIdent_msg));
        }
        metadataLog.truncateToLatestSnapshot();
        return metadataLog;
    }

    public Consumer<Long> apply$default$8() {
        return x$4 -> {};
    }

    public Consumer<OffsetAndEpoch> apply$default$9() {
        return x$5 -> {};
    }

    public KafkaMetadataLog createWithoutRecovery(TopicPartition topicPartition, Uuid topicId, File dataDir, Time time, Metrics metrics, Scheduler scheduler, MetadataLogConfig config, Consumer<Long> logStartOffsetChangeCallback, Consumer<OffsetAndEpoch> logSnapshotGeneratedCallback) {
        Properties props = new Properties();
        props.setProperty("max.message.bytes", Integer.toString(config.maxBatchSizeInBytes()));
        props.setProperty("segment.bytes", Integer.toString(config.logSegmentBytes()));
        props.setProperty("segment.ms", Long.toString(config.logSegmentMillis()));
        props.setProperty("file.delete.delay.ms", Long.toString(60000L));
        props.setProperty("retention.ms", "-1");
        props.setProperty("retention.bytes", "-1");
        LogConfig.validate((Properties)props);
        LogConfig defaultLogConfig = new LogConfig((Map)props);
        if (config.logSegmentBytes() < config.logSegmentMinBytes()) {
            throw new InvalidConfigurationException(new StringBuilder(20).append("Cannot set ").append(KafkaConfig$.MODULE$.MetadataLogSegmentBytesProp()).append(" below ").append(config.logSegmentMinBytes()).append(": ").append(config.logSegmentBytes()).toString());
        }
        if (defaultLogConfig.retentionMs >= 0L) {
            throw new InvalidConfigurationException(new StringBuilder(35).append("Cannot set ").append("retention.ms").append(" above -1: ").append(defaultLogConfig.retentionMs).append(".").toString());
        }
        if (defaultLogConfig.retentionSize >= 0L) {
            throw new InvalidConfigurationException(new StringBuilder(38).append("Cannot set ").append("retention.bytes").append(" above -1: ").append(defaultLogConfig.retentionSize).append(".").toString());
        }
        BrokerTopicStats x$6 = new BrokerTopicStats();
        ProducerStateManagerConfig x$10 = new ProducerStateManagerConfig(Integer.MAX_VALUE, false);
        LogDirFailureChannel x$12 = new LogDirFailureChannel(5);
        TierLogComponents x$13 = TierLogComponents$.MODULE$.EMPTY();
        Some x$15 = new Some((Object)topicId);
        Optional<E2EChecksumStore> x$17 = Optional.empty();
        None$ x$18 = None$.MODULE$;
        LogOffsetsListener x$19 = LogOffsetsListener.NO_OP_OFFSETS_LISTENER;
        None$ x$20 = None$.MODULE$;
        ConcurrentHashMap<String, Object> x$21 = new ConcurrentHashMap<String, Object>();
        MergedLog log = MergedLog$.MODULE$.apply(dataDir, defaultLogConfig, 0L, 0L, scheduler, x$6, metrics, time, Integer.MAX_VALUE, x$10, Integer.MAX_VALUE, (Option<ProducerIdQuotaRecorder>)x$18, x$12, x$13, false, (Option<Uuid>)x$15, true, x$19, (Option<Histogram>)x$20, x$21, x$17);
        KafkaMetadataLog metadataLog = new KafkaMetadataLog(log, time, scheduler, this.recoverSnapshots(log, false), topicPartition, config, logStartOffsetChangeCallback, logSnapshotGeneratedCallback);
        if (config.logSegmentMinBytes() != 0x800000 && metadataLog.logger().underlying().isErrorEnabled()) {
            String msgWithLogIdent_msg = KafkaMetadataLog$.$anonfun$createWithoutRecovery$1();
            Object var24_24 = null;
            metadataLog.logger().underlying().error(Logging.msgWithLogIdent$(metadataLog, msgWithLogIdent_msg));
        }
        return metadataLog;
    }

    public Consumer<Long> createWithoutRecovery$default$8() {
        return x$6 -> {};
    }

    public Consumer<OffsetAndEpoch> createWithoutRecovery$default$9() {
        return x$7 -> {};
    }

    private TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> recoverSnapshots(AbstractLog log, boolean allowDelete) {
        TreeMap snapshotsToRetain = TreeMap$.MODULE$.empty(Ordering$.MODULE$.ordered(Predef$.MODULE$.$conforms()));
        Buffer snapshotsToDelete = (Buffer)Buffer$.MODULE$.empty();
        try (DirectoryStream filesInDir = FilesWrapper.newDirectoryStream((Path)log.dir().toPath());){
            Option latestSnapshotId;
            filesInDir.forEach(path -> Snapshots.parse((Path)path).ifPresent(snapshotPath -> {
                if (snapshotPath.partial || snapshotPath.deleted || snapshotPath.snapshotId.offset() < log.logStartOffset()) {
                    snapshotsToDelete.append(snapshotPath);
                    return;
                }
                snapshotsToRetain.put((Object)snapshotPath.snapshotId, (Object)None$.MODULE$);
            }));
            if (log.logStartOffset() > 0L && !(latestSnapshotId = snapshotsToRetain.lastOption().map((Function1 & Serializable)x$8 -> (OffsetAndEpoch)x$8._1())).exists((Function1 & Serializable)snapshotId -> BoxesRunTime.boxToBoolean((boolean)KafkaMetadataLog$.$anonfun$recoverSnapshots$4(log, snapshotId)))) {
                throw new IllegalStateException(new StringBuilder(137).append("Inconsistent snapshot state: there must be a snapshot ").append("at an offset larger then the current log start offset ").append(log.logStartOffset()).append(", but the ").append("latest snapshot is ").append(latestSnapshotId).toString());
            }
            if (allowDelete) {
                snapshotsToDelete.foreach((Function1 & Serializable)snapshotPath -> {
                    KafkaMetadataLog$.$anonfun$recoverSnapshots$5(snapshotPath);
                    return BoxedUnit.UNIT;
                });
            } else if (snapshotsToDelete.nonEmpty() && this.logger().underlying().isInfoEnabled()) {
                String msgWithLogIdent_msg = KafkaMetadataLog$.$anonfun$recoverSnapshots$7(snapshotsToDelete);
                Object var8_7 = null;
                this.logger().underlying().info(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
            }
        }
        if (this.logger().underlying().isInfoEnabled()) {
            String msgWithLogIdent_msg = KafkaMetadataLog$.$anonfun$recoverSnapshots$8(snapshotsToRetain, log);
            Object var9_9 = null;
            this.logger().underlying().info(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
        }
        return snapshotsToRetain;
    }

    private boolean recoverSnapshots$default$2() {
        return true;
    }

    public void kafka$raft$KafkaMetadataLog$$deleteSnapshotFiles(Path logDir, TreeMap<OffsetAndEpoch, Option<FileRawSnapshotReader>> expiredSnapshots, Logging logging) {
        expiredSnapshots.foreach((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)KafkaMetadataLog$.$anonfun$deleteSnapshotFiles$1(logging, logDir, x0$1)));
    }

    public static final /* synthetic */ String $anonfun$apply$1() {
        return new StringBuilder(132).append("Overriding ").append(KafkaConfig$.MODULE$.MetadataLogSegmentMinBytesProp()).append(" is only supported for testing. Setting ").append("this value too low may lead to an inability to write batches of metadata records.").toString();
    }

    public static final /* synthetic */ String $anonfun$createWithoutRecovery$1() {
        return new StringBuilder(132).append("Overriding ").append(KafkaConfig$.MODULE$.MetadataLogSegmentMinBytesProp()).append(" is only supported for testing. Setting ").append("this value too low may lead to an inability to write batches of metadata records.").toString();
    }

    public static final /* synthetic */ boolean $anonfun$recoverSnapshots$4(AbstractLog log$1, OffsetAndEpoch snapshotId) {
        return snapshotId.offset() >= log$1.logStartOffset();
    }

    public static final /* synthetic */ String $anonfun$recoverSnapshots$6(SnapshotPath snapshotPath$1) {
        return new StringBuilder(41).append("Deleted unneeded snapshot file with path ").append(snapshotPath$1).toString();
    }

    public static final /* synthetic */ void $anonfun$recoverSnapshots$5(SnapshotPath snapshotPath) {
        Files.deleteIfExists(snapshotPath.path);
        KafkaMetadataLog$ info_this = MODULE$;
        if (info_this.logger().underlying().isInfoEnabled()) {
            String msgWithLogIdent_msg = KafkaMetadataLog$.$anonfun$recoverSnapshots$6(snapshotPath);
            Object var2_2 = null;
            info_this.logger().underlying().info(Logging.msgWithLogIdent$(info_this, msgWithLogIdent_msg));
            return;
        }
    }

    public static final /* synthetic */ String $anonfun$recoverSnapshots$7(Buffer snapshotsToDelete$1) {
        return new StringBuilder(63).append("Skipping deletion of eligible snapshots found during recovery: ").append(snapshotsToDelete$1).toString();
    }

    public static final /* synthetic */ String $anonfun$recoverSnapshots$8(TreeMap snapshotsToRetain$1, AbstractLog log$1) {
        return new StringBuilder(37).append("Initialized snapshots with IDs ").append(snapshotsToRetain$1.keys()).append(" from ").append(log$1.dir()).toString();
    }

    public static final /* synthetic */ boolean $anonfun$deleteSnapshotFiles$1(Logging logging$1, Path logDir$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            OffsetAndEpoch snapshotId = (OffsetAndEpoch)x0$1._1();
            ((Option)x0$1._2()).foreach((Function1 & Serializable)reader -> {
                CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> reader.close(), logging$1, Level.WARN);
                return BoxedUnit.UNIT;
            });
            return Snapshots.deleteIfExists((Path)logDir$1, (OffsetAndEpoch)snapshotId);
        }
        throw new MatchError(null);
    }

    private KafkaMetadataLog$() {
    }
}

