/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import kafka.server.FetchContext;
import kafka.server.FetchSessionCache;
import kafka.server.FullFetchContext$;
import kafka.server.IncrementalPartitionFetchMetadata;
import kafka.server.PartitionFetchMetadata;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicIdPartition;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.FetchResponse;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.Option;
import scala.Option$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005s!\u0002\f\u0018\u0011\u0003ab!\u0002\u0010\u0018\u0011\u0003y\u0002\"\u0002\u0014\u0002\t\u00039\u0003b\u0002\u0015\u0002\u0005\u0004%i!\u000b\u0005\u0007i\u0005\u0001\u000bQ\u0002\u0016\u0007\ty9\u0002!\u000e\u0005\ts\u0015\u0011)\u0019!C\u0005u!A\u0001*\u0002B\u0001B\u0003%1\b\u0003\u0005J\u000b\t\u0015\r\u0011\"\u0003K\u0011!qUA!A!\u0002\u0013Y\u0005\u0002C(\u0006\u0005\u000b\u0007I\u0011\u0002)\t\u0011\u0001,!\u0011!Q\u0001\nEC\u0001\"Y\u0003\u0003\u0006\u0004%IA\u0019\u0005\tM\u0016\u0011\t\u0011)A\u0005G\"Aq-\u0002BC\u0002\u0013%!\r\u0003\u0005i\u000b\t\u0005\t\u0015!\u0003d\u0011\u00151S\u0001\"\u0001j\u0011!AS\u0001#b\u0001\n\u0003J\u0003\"\u00029\u0006\t\u0003\n\b\"\u0002>\u0006\t\u0003Z\bbBA\u0005\u000b\u0011\u0005\u00131\u0002\u0005\b\u0003_)A\u0011IA\u0019\u0003A1U\u000f\u001c7GKR\u001c\u0007nQ8oi\u0016DHO\u0003\u0002\u00193\u000511/\u001a:wKJT\u0011AG\u0001\u0006W\u000647.Y\u0002\u0001!\ti\u0012!D\u0001\u0018\u0005A1U\u000f\u001c7GKR\u001c\u0007nQ8oi\u0016DHo\u0005\u0002\u0002AA\u0011\u0011\u0005J\u0007\u0002E)\t1%A\u0003tG\u0006d\u0017-\u0003\u0002&E\t1\u0011I\\=SK\u001a\fa\u0001P5oSRtD#\u0001\u000f\u0002\r1|wmZ3s+\u0005Q\u0003CA\u00163\u001b\u0005a#BA\u0017/\u00031\u00198-\u00197bY><w-\u001b8h\u0015\ty\u0003'\u0001\u0005usB,7/\u00194f\u0015\u0005\t\u0014aA2p[&\u00111\u0007\f\u0002\u0007\u0019><w-\u001a:\u0002\u000f1|wmZ3sAM\u0019Q\u0001\t\u001c\u0011\u0005u9\u0014B\u0001\u001d\u0018\u000511U\r^2i\u0007>tG/\u001a=u\u0003\u0011!\u0018.\\3\u0016\u0003m\u0002\"\u0001\u0010$\u000e\u0003uR!AP \u0002\u000bU$\u0018\u000e\\:\u000b\u0005\u0001\u000b\u0015AB2p[6|gN\u0003\u0002\u001b\u0005*\u00111\tR\u0001\u0007CB\f7\r[3\u000b\u0003\u0015\u000b1a\u001c:h\u0013\t9UH\u0001\u0003US6,\u0017!\u0002;j[\u0016\u0004\u0013!B2bG\",W#A&\u0011\u0005ua\u0015BA'\u0018\u0005E1U\r^2i'\u0016\u001c8/[8o\u0007\u0006\u001c\u0007.Z\u0001\u0007G\u0006\u001c\u0007.\u001a\u0011\u0002\u0013\u0019,Go\u00195ECR\fW#A)\u0011\tI;\u0016,X\u0007\u0002'*\u0011A+V\u0001\u0005kRLGNC\u0001W\u0003\u0011Q\u0017M^1\n\u0005a\u001b&aA'baB\u0011!lW\u0007\u0002\u007f%\u0011Al\u0010\u0002\u0011)>\u0004\u0018nY%e!\u0006\u0014H/\u001b;j_:\u0004\"!\b0\n\u0005};\"A\u0006)beRLG/[8o\r\u0016$8\r['fi\u0006$\u0017\r^1\u0002\u0015\u0019,Go\u00195ECR\f\u0007%\u0001\u0007vg\u0016\u001cHk\u001c9jG&#7/F\u0001d!\t\tC-\u0003\u0002fE\t9!i\\8mK\u0006t\u0017!D;tKN$v\u000e]5d\u0013\u0012\u001c\b%\u0001\bjg\u001a\u0013x.\u001c$pY2|w/\u001a:\u0002\u001f%\u001chI]8n\r>dGn\\<fe\u0002\"bA[6m[:|\u0007CA\u000f\u0006\u0011\u0015I\u0004\u00031\u0001<\u0011\u0015I\u0005\u00031\u0001L\u0011\u0015y\u0005\u00031\u0001R\u0011\u0015\t\u0007\u00031\u0001d\u0011\u00159\u0007\u00031\u0001d\u000399W\r\u001e$fi\u000eDwJ\u001a4tKR$\"A\u001d=\u0011\u0007\u0005\u001aX/\u0003\u0002uE\t1q\n\u001d;j_:\u0004\"!\t<\n\u0005]\u0014#\u0001\u0002'p]\u001eDQ!\u001f\nA\u0002e\u000bA\u0001]1si\u0006\u0001bm\u001c:fC\u000eD\u0007+\u0019:uSRLwN\u001c\u000b\u0003y~\u0004\"!I?\n\u0005y\u0014#\u0001B+oSRDq!!\u0001\u0014\u0001\u0004\t\u0019!A\u0002gk:\u0004b!IA\u00033vc\u0018bAA\u0004E\tIa)\u001e8di&|gNM\u0001\u0010O\u0016$(+Z:q_:\u001cXmU5{KR1\u0011QBA\n\u0003K\u00012!IA\b\u0013\r\t\tB\t\u0002\u0004\u0013:$\bbBA\u000b)\u0001\u0007\u0011qC\u0001\bkB$\u0017\r^3t!\u0011\tI\"a\b\u000f\u0007u\tY\"C\u0002\u0002\u001e]\tABR3uG\"\u001cVm]:j_:LA!!\t\u0002$\tA!+R*Q?6\u000b\u0005KC\u0002\u0002\u001e]Aq!a\n\u0015\u0001\u0004\tI#A\u0005wKJ\u001c\u0018n\u001c8JIB\u0019\u0011%a\u000b\n\u0007\u00055\"EA\u0003TQ>\u0014H/A\u000fva\u0012\fG/Z!oI\u001e+g.\u001a:bi\u0016\u0014Vm\u001d9p]N,G)\u0019;b)\u0011\t\u0019$a\u0010\u0011\t\u0005U\u00121H\u0007\u0003\u0003oQ1!!\u000f@\u0003!\u0011X-];fgR\u001c\u0018\u0002BA\u001f\u0003o\u0011QBR3uG\"\u0014Vm\u001d9p]N,\u0007bBA\u000b+\u0001\u0007\u0011q\u0003")
public class FullFetchContext
implements FetchContext {
    private Logger logger;
    private final Time time;
    private final FetchSessionCache cache;
    private final Map<TopicIdPartition, PartitionFetchMetadata> fetchData;
    private final boolean usesTopicIds;
    private final boolean isFromFollower;
    private String logIdent;
    private volatile boolean bitmap$0;

    @Override
    public String partitionsToLogString(Collection<TopicIdPartition> partitions) {
        return FetchContext.partitionsToLogString$(this, partitions);
    }

    @Override
    public FetchResponse getThrottledResponse(int throttleTimeMs) {
        return FetchContext.getThrottledResponse$(this, throttleTimeMs);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private Time time() {
        return this.time;
    }

    private FetchSessionCache cache() {
        return this.cache;
    }

    private Map<TopicIdPartition, PartitionFetchMetadata> fetchData() {
        return this.fetchData;
    }

    private boolean usesTopicIds() {
        return this.usesTopicIds;
    }

    private boolean isFromFollower() {
        return this.isFromFollower;
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = FullFetchContext$.MODULE$.kafka$server$FullFetchContext$$logger();
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public Option<Object> getFetchOffset(TopicIdPartition part) {
        return Option$.MODULE$.apply((Object)this.fetchData().get(part)).map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToLong((long)x$3.fetchOffset()));
    }

    @Override
    public void foreachPartition(Function2<TopicIdPartition, PartitionFetchMetadata, BoxedUnit> fun) {
        this.fetchData().forEach((topicPartition, partition) -> fun.apply(topicPartition, partition));
    }

    @Override
    public int getResponseSize(LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> updates, short versionId) {
        return FetchResponse.sizeOf((short)versionId, updates.entrySet().iterator());
    }

    @Override
    public FetchResponse updateAndGenerateResponseData(LinkedHashMap<TopicIdPartition, FetchResponseData.PartitionData> updates) {
        int responseSessionId = this.cache().maybeCreateSession(this.time().milliseconds(), this.isFromFollower(), updates.size(), this.usesTopicIds(), (Function0<ImplicitLinkedHashCollection<IncrementalPartitionFetchMetadata>>)(Function0 & Serializable)() -> this.createNewSession$1(updates));
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(46).append("Full fetch context with session id ").append(responseSessionId).append(" returning ").append(this.partitionsToLogString(updates.keySet())).toString());
        return FetchResponse.of((Errors)Errors.NONE, (int)0, (int)responseSessionId, updates);
    }

    private final ImplicitLinkedHashCollection createNewSession$1(LinkedHashMap updates$2) {
        ImplicitLinkedHashCollection cachedPartitions = new ImplicitLinkedHashCollection(updates$2.size());
        updates$2.forEach((part, respData) -> {
            PartitionFetchMetadata reqData = this.fetchData().get(part);
            IncrementalPartitionFetchMetadata cachedPartition = new IncrementalPartitionFetchMetadata((TopicIdPartition)part, reqData);
            cachedPartition.maybeUpdateResponseData((FetchResponseData.PartitionData)respData, true);
            cachedPartitions.mustAdd((ImplicitLinkedHashCollection.Element)cachedPartition);
        });
        return cachedPartitions;
    }

    public FullFetchContext(Time time, FetchSessionCache cache, Map<TopicIdPartition, PartitionFetchMetadata> fetchData, boolean usesTopicIds, boolean isFromFollower) {
        this.time = time;
        this.cache = cache;
        this.fetchData = fetchData;
        this.usesTopicIds = usesTopicIds;
        this.isFromFollower = isFromFollower;
    }
}

