/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Meter;
import io.confluent.kafka.availability.ThreadCountersManager;
import io.confluent.kafka.availability.ThreadLocalCounters;
import java.io.Serializable;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.atomic.AtomicInteger;
import kafka.network.RequestChannel;
import kafka.network.RequestChannel$ShutdownRequest$;
import kafka.network.RequestChannel$WakeupRequest$;
import kafka.server.ApiRequestHandler;
import kafka.server.DefaultRequestLogger;
import kafka.server.KafkaConfig;
import kafka.server.KafkaRequestHandler$;
import kafka.server.RequestLocal;
import kafka.server.RequestLocal$;
import kafka.server.RequestLogger;
import kafka.utils.Exit$;
import kafka.utils.Logging;
import org.apache.kafka.common.internals.FatalExitError;
import org.apache.kafka.common.utils.Time;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.StringOps$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t5r!\u0002\u0017.\u0011\u0003\u0011d!\u0002\u001b.\u0011\u0003)\u0004\"\u0002\u001f\u0002\t\u0003i\u0004b\u0002 \u0002\u0005\u0004%Ia\u0010\u0005\u0007\u001d\u0006\u0001\u000b\u0011\u0002!\t\u000f=\u000b!\u0019!C\u0005!\"1\u0011,\u0001Q\u0001\nECqAW\u0001A\u0002\u0013%1\fC\u0004`\u0003\u0001\u0007I\u0011\u00021\t\r\u0019\f\u0001\u0015)\u0003]\u0011\u0015Y\u0017\u0001\"\u0001m\u0011\u0015y\u0017\u0001\"\u0001q\u0011\u0015\t\u0018\u0001\"\u0001s\u0011%\tI\"AI\u0001\n\u0003\tYBB\u00035[\u0001\t9\u0005\u0003\u0006\u0002b9\u0011\t\u0011)A\u0005\u0003GB!\"!\u001b\u000f\u0005\u0003\u0005\u000b\u0011BA6\u0011)\t\tH\u0004B\u0001B\u0003%\u0011q\u0004\u0005\u000b\u0003gr!\u0011!Q\u0001\n\u0005\r\u0004BCA;\u001d\t\u0015\r\u0011\"\u0001\u0002x!Q\u0011\u0011\u0013\b\u0003\u0002\u0003\u0006I!!\u001f\t\u0015\u0005MeB!b\u0001\n\u0003\t)\n\u0003\u0006\u0002,:\u0011\t\u0011)A\u0005\u0003/C!\"!,\u000f\u0005\u000b\u0007I\u0011AAX\u0011%\t\tL\u0004B\u0001B\u0003%\u0001\n\u0003\u0006\u00024:\u0011\t\u0011)A\u0005\u0003kC!\"a/\u000f\u0005\u0003\u0005\u000b\u0011BA_\u0011)\t)N\u0004B\u0001B\u0003%\u0011q\u0004\u0005\u0007y9!\t!a6\t\u0013\u0005=hB1A\u0005\n\u0005E\b\u0002CA~\u001d\u0001\u0006I!a=\t\u0013\u0005]aB1A\u0005\n\u0005u\b\u0002CA\u0000\u001d\u0001\u0006I!a\u0004\t\u0013\t\u0005aB1A\u0005\n\t\r\u0001\u0002\u0003B\u0006\u001d\u0001\u0006IA!\u0002\t\u0011\t5a\u00021A\u0005\nmC\u0011Ba\u0004\u000f\u0001\u0004%IA!\u0005\t\u000f\tUa\u0002)Q\u00059\"9!\u0011\u0004\b\u0005\u0002\tm\u0001\u0002\u0003B\u000f\u001d\u0011\u0005QFa\b\t\u000f\t\u0015b\u0002\"\u0003\u0003\u001c!9!q\u0005\b\u0005\u0002\tm\u0001b\u0002B\u0015\u001d\u0011\u0005!1\u0004\u0005\b\u0005WqA\u0011\u0001B\u000e\u0003MY\u0015MZ6b%\u0016\fX/Z:u\u0011\u0006tG\r\\3s\u0015\tqs&\u0001\u0004tKJ4XM\u001d\u0006\u0002a\u0005)1.\u00194lC\u000e\u0001\u0001CA\u001a\u0002\u001b\u0005i#aE&bM.\f'+Z9vKN$\b*\u00198eY\u0016\u00148CA\u00017!\t9$(D\u00019\u0015\u0005I\u0014!B:dC2\f\u0017BA\u001e9\u0005\u0019\te.\u001f*fM\u00061A(\u001b8jiz\"\u0012AM\u0001\u0015i\"\u0014X-\u00193SKF,Xm\u001d;DQ\u0006tg.\u001a7\u0016\u0003\u0001\u00032!\u0011$I\u001b\u0005\u0011%BA\"E\u0003\u0011a\u0017M\\4\u000b\u0003\u0015\u000bAA[1wC&\u0011qI\u0011\u0002\f)\"\u0014X-\u00193M_\u000e\fG\u000e\u0005\u0002J\u00196\t!J\u0003\u0002L_\u00059a.\u001a;x_J\\\u0017BA'K\u00059\u0011V-];fgR\u001c\u0005.\u00198oK2\fQ\u0003\u001e5sK\u0006$'+Z9vKN$8\t[1o]\u0016d\u0007%\u0001\u000buQJ,\u0017\rZ\"veJ,g\u000e\u001e*fcV,7\u000f^\u000b\u0002#B\u0019\u0011I\u0012*\u0011\u0005M3fBA%U\u0013\t)&*\u0001\bSKF,Xm\u001d;DQ\u0006tg.\u001a7\n\u0005]C&a\u0002*fcV,7\u000f\u001e\u0006\u0003+*\u000bQ\u0003\u001e5sK\u0006$7)\u001e:sK:$(+Z9vKN$\b%A\tcsB\f7o\u001d+ie\u0016\fGm\u00115fG.,\u0012\u0001\u0018\t\u0003ouK!A\u0018\u001d\u0003\u000f\t{w\u000e\\3b]\u0006)\"-\u001f9bgN$\u0006N]3bI\u000eCWmY6`I\u0015\fHCA1e!\t9$-\u0003\u0002dq\t!QK\\5u\u0011\u001d)\u0007\"!AA\u0002q\u000b1\u0001\u001f\u00132\u0003I\u0011\u0017\u0010]1tgRC'/Z1e\u0007\",7m\u001b\u0011)\u0005%A\u0007CA\u001cj\u0013\tQ\u0007H\u0001\u0005w_2\fG/\u001b7f\u0003Q\u0019X\r\u001e\"za\u0006\u001c8\u000f\u00165sK\u0006$7\t[3dWR\u0011\u0011-\u001c\u0005\u0006]*\u0001\r\u0001X\u0001\fEf\u0004\u0018m]:DQ\u0016\u001c7.\u0001\fdkJ\u0014XM\u001c;SKF,Xm\u001d;P]RC'/Z1e)\u0005\u0011\u0016!E<sCB\f5/\u001f8d\u0007\u0006dGNY1dWV\u00111/\u001f\u000b\u0006i\u0006\u0015\u0011Q\u0003\t\u0005oU<\u0018-\u0003\u0002wq\tIa)\u001e8di&|g.\r\t\u0003qfd\u0001\u0001B\u0003{\u0019\t\u00071PA\u0001U#\tax\u0010\u0005\u00028{&\u0011a\u0010\u000f\u0002\b\u001d>$\b.\u001b8h!\r9\u0014\u0011A\u0005\u0004\u0003\u0007A$aA!os\"9\u0011q\u0001\u0007A\u0002\u0005%\u0011aF1ts:\u001c7i\\7qY\u0016$\u0018n\u001c8DC2d'-Y2l!\u001d9\u00141BA\bo\u0006L1!!\u00049\u0005%1UO\\2uS>t'\u0007E\u00024\u0003#I1!a\u0005.\u00051\u0011V-];fgRdunY1m\u0011\u001d\t9\u0002\u0004a\u0001\u0003\u001f\tAB]3rk\u0016\u001cH\u000fT8dC2\fA\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\n\u0004'\u0006\u0002\u0002\u001e)\"\u0011qDA\u001b!\u0011\t\t#a\f\u000f\t\u0005\r\u00121\u0006\t\u0004\u0003KATBAA\u0014\u0015\r\tI#M\u0001\u0007yI|w\u000e\u001e \n\u0007\u00055\u0002(\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003c\t\u0019D\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003[A4FAA\u001c!\u0011\tI$a\u0011\u000e\u0005\u0005m\"\u0002BA\u001f\u0003\u007f\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\u0005\u0005\u0003(\u0001\u0006b]:|G/\u0019;j_:LA!!\u0012\u0002<\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0014\u000f9\tI%a\u0014\u0002VA\u0019\u0011)a\u0013\n\u0007\u00055#I\u0001\u0004PE*,7\r\u001e\t\u0004\u0003\u0006E\u0013bAA*\u0005\nA!+\u001e8oC\ndW\r\u0005\u0003\u0002X\u0005uSBAA-\u0015\r\tYfL\u0001\u0006kRLGn]\u0005\u0005\u0003?\nIFA\u0004M_\u001e<\u0017N\\4\u0002\u0005%$\u0007cA\u001c\u0002f%\u0019\u0011q\r\u001d\u0003\u0007%sG/\u0001\u0004d_:4\u0017n\u001a\t\u0004g\u00055\u0014bAA8[\tY1*\u00194lC\u000e{gNZ5h\u0003%\u0019G.^:uKJLE-\u0001\u0005ce>\\WM]%e\u0003I\twm\u001a:fO\u0006$X-\u00133mK6+G/\u001a:\u0016\u0005\u0005e\u0004\u0003BA>\u0003\u001bk!!! \u000b\t\u0005}\u0014\u0011Q\u0001\u0005G>\u0014XM\u0003\u0003\u0002\u0004\u0006\u0015\u0015aB7fiJL7m\u001d\u0006\u0005\u0003\u000f\u000bI)\u0001\u0004zC6lWM\u001d\u0006\u0003\u0003\u0017\u000b1aY8n\u0013\u0011\ty)! \u0003\u000b5+G/\u001a:\u0002'\u0005<wM]3hCR,\u0017\n\u001a7f\u001b\u0016$XM\u001d\u0011\u0002'Q|G/\u00197IC:$G.\u001a:UQJ,\u0017\rZ:\u0016\u0005\u0005]\u0005\u0003BAM\u0003Ok!!a'\u000b\t\u0005u\u0015qT\u0001\u0007CR|W.[2\u000b\t\u0005\u0005\u00161U\u0001\u000bG>t7-\u001e:sK:$(bAAS\t\u0006!Q\u000f^5m\u0013\u0011\tI+a'\u0003\u001b\u0005#x.\\5d\u0013:$XmZ3s\u0003Q!x\u000e^1m\u0011\u0006tG\r\\3s)\"\u0014X-\u00193tA\u0005q!/Z9vKN$8\t[1o]\u0016dW#\u0001%\u0002\u001fI,\u0017/^3ti\u000eC\u0017M\u001c8fY\u0002\nA!\u00199jgB\u00191'a.\n\u0007\u0005eVFA\tBa&\u0014V-];fgRD\u0015M\u001c3mKJ\fA\u0001^5nKB!\u0011qXAi\u001b\t\t\tM\u0003\u0003\u0002\\\u0005\r'\u0002BAc\u0003\u000f\faaY8n[>t'b\u0001\u0019\u0002J*!\u00111ZAg\u0003\u0019\t\u0007/Y2iK*\u0011\u0011qZ\u0001\u0004_J<\u0017\u0002BAj\u0003\u0003\u0014A\u0001V5nK\u0006Aan\u001c3f\u001d\u0006lW\r\u0006\f\u0002Z\u0006m\u0017Q\\Ap\u0003C\f\u0019/!:\u0002h\u0006%\u00181^Aw!\t\u0019d\u0002C\u0004\u0002bq\u0001\r!a\u0019\t\u000f\u0005%D\u00041\u0001\u0002l!9\u0011\u0011\u000f\u000fA\u0002\u0005}\u0001bBA:9\u0001\u0007\u00111\r\u0005\b\u0003kb\u0002\u0019AA=\u0011\u001d\t\u0019\n\ba\u0001\u0003/Ca!!,\u001d\u0001\u0004A\u0005bBAZ9\u0001\u0007\u0011Q\u0017\u0005\b\u0003wc\u0002\u0019AA_\u0011%\t)\u000e\bI\u0001\u0002\u0004\ty\"\u0001\ttQV$Hm\\<o\u0007>l\u0007\u000f\\3uKV\u0011\u00111\u001f\t\u0005\u0003k\f90\u0004\u0002\u0002 &!\u0011\u0011`AP\u00059\u0019u.\u001e8u\t><h\u000eT1uG\"\f\u0011c\u001d5vi\u0012|wO\\\"p[BdW\r^3!+\t\ty!A\u0007sKF,Xm\u001d;M_\u000e\fG\u000eI\u0001\u000ee\u0016\fX/Z:u\u0019><w-\u001a:\u0016\u0005\t\u0015\u0001cA\u001a\u0003\b%\u0019!\u0011B\u0017\u0003\u001bI+\u0017/^3ti2{wmZ3s\u00039\u0011X-];fgRdunZ4fe\u0002\nqa\u001d;paB,G-A\u0006ti>\u0004\b/\u001a3`I\u0015\fHcA1\u0003\u0014!9Q\rJA\u0001\u0002\u0004a\u0016\u0001C:u_B\u0004X\r\u001a\u0011)\u0005\u0015B\u0017a\u0001:v]R\t\u0011-\u0001\u0003q_2dGcA1\u0003\"!9!1E\u0014A\u0002\u0005\r\u0014!\u0003;j[\u0016|W\u000f^'t\u0003A\u0019w.\u001c9mKR,7\u000b[;uI><h.\u0001\u0003ti>\u0004\u0018\u0001E5oSRL\u0017\r^3TQV$Hm\\<o\u00035\tw/Y5u'\",H\u000fZ8x]\u0002")
public class KafkaRequestHandler
implements Runnable,
Logging {
    private final int id;
    private final int brokerId;
    private final Meter aggregateIdleMeter;
    private final AtomicInteger totalHandlerThreads;
    private final RequestChannel requestChannel;
    private final ApiRequestHandler apis;
    private final Time time;
    private final CountDownLatch shutdownComplete;
    private final RequestLocal requestLocal;
    private final RequestLogger requestLogger;
    private volatile boolean stopped;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static String $lessinit$greater$default$10() {
        return "broker";
    }

    public static <T> Function1<T, BoxedUnit> wrapAsyncCallback(Function2<RequestLocal, T, BoxedUnit> asyncCompletionCallback, RequestLocal requestLocal) {
        return KafkaRequestHandler$.MODULE$.wrapAsyncCallback(asyncCompletionCallback, requestLocal);
    }

    public static RequestChannel.Request currentRequestOnThread() {
        return KafkaRequestHandler$.MODULE$.currentRequestOnThread();
    }

    public static void setBypassThreadCheck(boolean bypassCheck) {
        KafkaRequestHandler$.MODULE$.setBypassThreadCheck(bypassCheck);
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public Meter aggregateIdleMeter() {
        return this.aggregateIdleMeter;
    }

    public AtomicInteger totalHandlerThreads() {
        return this.totalHandlerThreads;
    }

    public RequestChannel requestChannel() {
        return this.requestChannel;
    }

    private CountDownLatch shutdownComplete() {
        return this.shutdownComplete;
    }

    private RequestLocal requestLocal() {
        return this.requestLocal;
    }

    private RequestLogger requestLogger() {
        return this.requestLogger;
    }

    private boolean stopped() {
        return this.stopped;
    }

    private void stopped_$eq(boolean x$1) {
        this.stopped = x$1;
    }

    @Override
    public void run() {
        try {
            ThreadCountersManager.LocalCounters.setThreadType((ThreadLocalCounters.ThreadGroupType)ThreadLocalCounters.ThreadGroupType.REQUEST_HANDLER_THREAD);
            KafkaRequestHandler$.MODULE$.kafka$server$KafkaRequestHandler$$threadRequestChannel().set(this.requestChannel());
            while (!this.stopped()) {
                this.poll(300);
            }
        }
        finally {
            this.completeShutdown();
        }
    }

    public void poll(int timeoutMs) {
        long startSelectTime = this.time.nanoseconds();
        RequestChannel.BaseRequest req = this.requestChannel().receiveRequest(timeoutMs);
        long endTime = this.time.nanoseconds();
        long idleTime = endTime - startSelectTime;
        this.aggregateIdleMeter().mark(idleTime / (long)this.totalHandlerThreads().get());
        if (RequestChannel$ShutdownRequest$.MODULE$.equals(req)) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(60).append("Kafka request handler ").append($this.id).append(" on broker ").append($this.brokerId).append(" received shut down command").toString());
            this.stop();
            return;
        }
        if (req instanceof RequestChannel.CallbackRequest) {
            RequestChannel.CallbackRequest callbackRequest = (RequestChannel.CallbackRequest)req;
            RequestChannel.Request originalRequest = callbackRequest.originalRequest();
            try {
                try {
                    if (originalRequest.callbackRequestDequeueTimeNanos().isDefined()) {
                        long prevCallbacksTimeNanos = BoxesRunTime.unboxToLong((Object)originalRequest.callbackRequestCompleteTimeNanos().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L)) - BoxesRunTime.unboxToLong((Object)originalRequest.callbackRequestDequeueTimeNanos().getOrElse((Function0)(JFunction0.mcJ.sp & Serializable)() -> 0L));
                        originalRequest.callbackRequestCompleteTimeNanos_$eq((Option<Object>)None$.MODULE$);
                        originalRequest.callbackRequestDequeueTimeNanos_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)(this.time.nanoseconds() - prevCallbacksTimeNanos))));
                    } else {
                        originalRequest.callbackRequestDequeueTimeNanos_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)this.time.nanoseconds())));
                    }
                    KafkaRequestHandler$.MODULE$.kafka$server$KafkaRequestHandler$$threadCurrentRequest().set(originalRequest);
                    BoxedUnit cfr_ignored_0 = (BoxedUnit)ThreadCountersManager.wrapEngine(() -> {
                        KafkaRequestHandler.$anonfun$poll$4(this, callbackRequest);
                        return BoxedUnit.UNIT;
                    });
                }
                catch (FatalExitError e) {
                    this.shutdownComplete().countDown();
                    throw Exit$.MODULE$.exit(e.statusCode(), (Option<String>)None$.MODULE$);
                }
                catch (Throwable e) {
                    this.error((Function0<String>)(Function0 & Serializable)() -> "Exception when handling request", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                }
            }
            finally {
                this.requestChannel().tryCompleteActions();
                if (originalRequest.callbackRequestCompleteTimeNanos().isEmpty()) {
                    originalRequest.callbackRequestCompleteTimeNanos_$eq((Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)this.time.nanoseconds())));
                }
                KafkaRequestHandler$.MODULE$.kafka$server$KafkaRequestHandler$$threadCurrentRequest().remove();
            }
            return;
        }
        if (req instanceof RequestChannel.Request) {
            RequestChannel.Request request = (RequestChannel.Request)req;
            try {
                try {
                    request.requestDequeueTimeNanos_$eq(endTime);
                    this.trace((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(51).append("Kafka request handler ").append($this.id).append(" on broker ").append($this.brokerId).append(" handling request ").append(request).toString());
                    KafkaRequestHandler$.MODULE$.kafka$server$KafkaRequestHandler$$threadCurrentRequest().set(request);
                    BoxedUnit cfr_ignored_1 = (BoxedUnit)ThreadCountersManager.wrapEngine(() -> {
                        this.apis.handle(request, this.requestLogger(), this.requestLocal());
                        return BoxedUnit.UNIT;
                    });
                }
                catch (FatalExitError e) {
                    this.shutdownComplete().countDown();
                    throw Exit$.MODULE$.exit(e.statusCode(), (Option<String>)None$.MODULE$);
                }
                catch (Throwable e) {
                    this.error((Function0<String>)(Function0 & Serializable)() -> "Exception when handling request", (Function0<Throwable>)(Function0 & Serializable)() -> e);
                }
            }
            finally {
                KafkaRequestHandler$.MODULE$.kafka$server$KafkaRequestHandler$$threadCurrentRequest().remove();
                request.releaseBuffer();
            }
            return;
        }
        if (RequestChannel$WakeupRequest$.MODULE$.equals(req)) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> "Received a wakeup request outside of typical usage.");
            return;
        }
        if (req == null) {
            return;
        }
        throw new MatchError((Object)req);
    }

    private void completeShutdown() {
        this.requestLocal().close();
        KafkaRequestHandler$.MODULE$.kafka$server$KafkaRequestHandler$$threadRequestChannel().remove();
        this.shutdownComplete().countDown();
    }

    public void stop() {
        this.stopped_$eq(true);
    }

    public void initiateShutdown() {
        this.requestChannel().sendShutdownRequest();
    }

    public void awaitShutdown() {
        this.shutdownComplete().await();
    }

    public static final /* synthetic */ void $anonfun$poll$4(KafkaRequestHandler $this, RequestChannel.CallbackRequest x3$1) {
        x3$1.fun().apply((Object)$this.requestLocal());
    }

    public KafkaRequestHandler(int id, KafkaConfig config, String clusterId, int brokerId, Meter aggregateIdleMeter, AtomicInteger totalHandlerThreads, RequestChannel requestChannel, ApiRequestHandler apis, Time time, String nodeName) {
        this.id = id;
        this.brokerId = brokerId;
        this.aggregateIdleMeter = aggregateIdleMeter;
        this.totalHandlerThreads = totalHandlerThreads;
        this.requestChannel = requestChannel;
        this.apis = apis;
        this.time = time;
        this.logIdent_$eq(new StringBuilder(31).append("[Kafka Request Handler ").append(id).append(" on ").append(StringOps$.MODULE$.capitalize$extension(Predef$.MODULE$.augmentString(nodeName))).append(" ").append(brokerId).append("], ").toString());
        this.shutdownComplete = new CountDownLatch(1);
        this.requestLocal = RequestLocal$.MODULE$.withThreadConfinedCaching();
        this.requestLogger = new DefaultRequestLogger(config, clusterId);
        this.stopped = false;
    }
}

