/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.Collection;
import java.util.Collections;
import java.util.concurrent.ExecutionException;
import kafka.server.ClusterLinkRequestQuota;
import kafka.server.link.ClusterLinkClearLinkReference$;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkMetadataManagerWithKRaftSupport;
import kafka.server.link.ClusterLinkMetadataManagerWithZkSupport;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.ClusterLinkUtils$;
import kafka.server.link.TaskErrorCodeAndMsg;
import org.apache.kafka.clients.admin.AlterMirrorOp;
import org.apache.kafka.clients.admin.AlterMirrorsOptions;
import org.apache.kafka.clients.admin.AlterMirrorsResult;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.CreateAclsResult;
import org.apache.kafka.clients.admin.DeleteAclsResult;
import org.apache.kafka.clients.admin.DeleteClusterLinksOptions;
import org.apache.kafka.clients.admin.DeleteClusterLinksResult;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AccessControlEntry;
import org.apache.kafka.common.acl.AccessControlEntryFilter;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.acl.AclPermissionType;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.resource.ResourcePatternFilter;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.authorizer.Authorizer;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.immutable.List;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.Nothing$;

@ScalaSignature(bytes="\u0006\u0005\t\u0015d\u0001\u0002\u00180\u0001YB\u0001b\u0010\u0001\u0003\u0002\u0003\u0006I\u0001\u0011\u0005\t\u0017\u0002\u0011\t\u0011)A\u0005\u0019\"I\u0011\f\u0001B\u0001B\u0003%!,\u0018\u0005\t=\u0002\u0011\t\u0011)A\u0005?\"A!\r\u0001B\u0001B\u0003%1\r\u0003\u0005n\u0001\t\u0005\t\u0015!\u0003o\u0011!1\bA!A!\u0002\u00139\bBC?\u0001\u0005\u0003\u0005\u000b\u0011\u0002@\u0002\n!a\u00111\u0002\u0001\u0003\u0002\u0003\u0006I!!\u0004\u0002\u0016!Q\u0011q\u0003\u0001\u0003\u0002\u0003\u0006I!!\u0007\t\u0019\u0005}\u0001A!A!\u0002\u0013\tI\"!\t\t\u0015\u0005\u0015\u0002A!A!\u0002\u0013\tI\u0002C\u0004\u0002(\u0001!\t!!\u000b\t\u0013\u0005\u0015\u0003A1A\u0005\n\u0005\u001d\u0003\u0002CA+\u0001\u0001\u0006I!!\u0013\t\u0013\u0005]\u0003\u00011A\u0005\n\u0005e\u0003\"CA1\u0001\u0001\u0007I\u0011BA2\u0011!\tI\u0007\u0001Q!\n\u0005m\u0003\"CA6\u0001\u0001\u0007I\u0011BA-\u0011%\ti\u0007\u0001a\u0001\n\u0013\ty\u0007\u0003\u0005\u0002t\u0001\u0001\u000b\u0015BA.\u0011-\t)\b\u0001a\u0001\u0002\u0004%I!a\u001e\t\u0017\u0005E\u0005\u00011AA\u0002\u0013%\u00111\u0013\u0005\f\u0003/\u0003\u0001\u0019!A!B\u0013\tI\bC\u0004\u0002\u001a\u0002!\t&a'\t\u000f\u0005E\u0006\u0001\"\u0003\u0002\u001c\"9\u00111\u0017\u0001\u0005\n\u0005U\u0006bBAZ\u0001\u0011%\u0011\u0011\u0019\u0005\b\u0003\u001b\u0004A\u0011BAN\u0011\u001d\ty\r\u0001C\u0005\u00037Cq!!5\u0001\t\u0013\t\u0019\u000eC\u0004\u0002Z\u0002!I!a7\t\u000f\t\r\u0001\u0001\"\u0003\u0002\u001c\"9!Q\u0001\u0001\u0005\n\u0005m\u0005b\u0002B\u0003\u0001\u0011E#q\u0001\u0005\b\u0005'\u0001A\u0011AA-\u000f\u001d\u0011)b\fE\u0001\u0005/1aAL\u0018\t\u0002\te\u0001bBA\u0014M\u0011\u0005!1\u0006\u0005\t\u0005[1C\u0011A\u0018\u00030!A!q\u0007\u0014\u0005\u0002=\u0012I\u0004\u0003\u0005\u0003>\u0019\"\ta\fB \u0011%\u0011IEJI\u0001\n\u0003\u0011Y\u0005C\u0005\u0003b\u0019\n\n\u0011\"\u0001\u0003L!I!1\r\u0014\u0012\u0002\u0013\u0005!1\n\u0002\u001e\u00072,8\u000f^3s\u0019&t7n\u00117fCJd\u0015N\\6SK\u001a,'/\u001a8dK*\u0011\u0001'M\u0001\u0005Y&t7N\u0003\u00023g\u000511/\u001a:wKJT\u0011\u0001N\u0001\u0006W\u000647.Y\u0002\u0001'\t\u0001q\u0007\u0005\u00029y9\u0011\u0011HO\u0007\u0002_%\u00111hL\u0001\u0015\u00072,8\u000f^3s\u0019&t7nU2iK\u0012,H.\u001a:\n\u0005ur$\u0001\u0004)fe&|G-[2UCN\\'BA\u001e0\u0003\u0019a\u0017N\\6JIB\u0011\u0011)S\u0007\u0002\u0005*\u00111\tR\u0001\u0007G>lWn\u001c8\u000b\u0005Q*%B\u0001$H\u0003\u0019\t\u0007/Y2iK*\t\u0001*A\u0002pe\u001eL!A\u0013\"\u0003\tU+\u0018\u000eZ\u0001\tY&t7NT1nKB\u0011QJ\u0016\b\u0003\u001dR\u0003\"a\u0014*\u000e\u0003AS!!U\u001b\u0002\rq\u0012xn\u001c;?\u0015\u0005\u0019\u0016!B:dC2\f\u0017BA+S\u0003\u0019\u0001&/\u001a3fM&\u0011q\u000b\u0017\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005U\u0013\u0016!C:dQ\u0016$W\u000f\\3s!\tI4,\u0003\u0002]_\t!2\t\\;ti\u0016\u0014H*\u001b8l'\u000eDW\rZ;mKJL!!\u0017\u001f\u0002\u001f5,G/\u00193bi\u0006l\u0015M\\1hKJ\u0004\"!\u000f1\n\u0005\u0005|#AG\"mkN$XM\u001d'j].lU\r^1eCR\fW*\u00198bO\u0016\u0014\u0018AC1vi\"|'/\u001b>feB\u0019A-Z4\u000e\u0003IK!A\u001a*\u0003\r=\u0003H/[8o!\tA7.D\u0001j\u0015\t\u0011'N\u0003\u00023\t&\u0011A.\u001b\u0002\u000b\u0003V$\bn\u001c:ju\u0016\u0014\u0018A\u00037pG\u0006d\u0017\tZ7j]B\u0011q\u000e^\u0007\u0002a*\u0011\u0011O]\u0001\u0006C\u0012l\u0017N\u001c\u0006\u0003g\u0012\u000bqa\u00197jK:$8/\u0003\u0002va\nq1i\u001c8gYV,g\u000e^!e[&t\u0017AE2p[BdW\r^5p]\u000e\u000bG\u000e\u001c2bG.\u00042\u0001\u001a={\u0013\tI(KA\u0005Gk:\u001cG/[8oaA\u0011Am_\u0005\u0003yJ\u0013A!\u00168ji\u0006!A/[7f!\ry\u0018QA\u0007\u0003\u0003\u0003Q1!a\u0001C\u0003\u0015)H/\u001b7t\u0013\u0011\t9!!\u0001\u0003\tQKW.Z\u0005\u0003{r\nQ!];pi\u0006\u0004B!a\u0004\u0002\u00125\t\u0011'C\u0002\u0002\u0014E\u0012qc\u00117vgR,'\u000fT5oWJ+\u0017/^3tiF+x\u000e^1\n\u0007\u0005-A(\u0001\bu_BL7m\u0012:pkB\u001c\u0016N_3\u0011\u0007\u0011\fY\"C\u0002\u0002\u001eI\u00131!\u00138u\u0003)Ig\u000e^3sm\u0006dWj]\u0005\u0004\u0003Ga\u0014!\u0005:fg\u000eDW\rZ;mK\u0012+G.Y=Ng\u0006a!/\u001a;ss\u0012+G.Y=Ng\u00061A(\u001b8jiz\"\"$a\u000b\u0002.\u0005=\u0012\u0011GA\u001a\u0003k\t9$!\u000f\u0002<\u0005u\u0012qHA!\u0003\u0007\u0002\"!\u000f\u0001\t\u000b}j\u0001\u0019\u0001!\t\u000b-k\u0001\u0019\u0001'\t\u000bek\u0001\u0019\u0001.\t\u000byk\u0001\u0019A0\t\u000b\tl\u0001\u0019A2\t\u000b5l\u0001\u0019\u00018\t\u000bYl\u0001\u0019A<\t\u000bul\u0001\u0019\u0001@\t\u000f\u0005-Q\u00021\u0001\u0002\u000e!I\u0011qC\u0007\u0011\u0002\u0003\u0007\u0011\u0011\u0004\u0005\n\u0003?i\u0001\u0013!a\u0001\u00033A\u0011\"!\n\u000e!\u0003\u0005\r!!\u0007\u0002\u00151Lgn\u001b$jYR,'/\u0006\u0002\u0002JA!\u00111JA)\u001b\t\tiEC\u0002\u0002P\t\u000b1!Y2m\u0013\u0011\t\u0019&!\u0014\u00031\u0005\u001b7-Z:t\u0007>tGO]8m\u000b:$(/\u001f$jYR,'/A\u0006mS:\\g)\u001b7uKJ\u0004\u0013aC;qI\u0006$X\rZ!dYN,\"!a\u0017\u0011\u0007\u0011\fi&C\u0002\u0002`I\u0013qAQ8pY\u0016\fg.A\bva\u0012\fG/\u001a3BG2\u001cx\fJ3r)\rQ\u0018Q\r\u0005\n\u0003O\n\u0012\u0011!a\u0001\u00037\n1\u0001\u001f\u00132\u00031)\b\u000fZ1uK\u0012\f5\r\\:!\u00035)\b\u000fZ1uK\u0012$v\u000e]5dg\u0006\tR\u000f\u001d3bi\u0016$Gk\u001c9jGN|F%Z9\u0015\u0007i\f\t\bC\u0005\u0002hQ\t\t\u00111\u0001\u0002\\\u0005qQ\u000f\u001d3bi\u0016$Gk\u001c9jGN\u0004\u0013a\u0003;pa&\u001cwI]8vaN,\"!!\u001f\u0011\r\u0005m\u0014QQAF\u001d\u0011\ti(!!\u000f\u0007=\u000by(C\u0001T\u0013\r\t\u0019IU\u0001\ba\u0006\u001c7.Y4f\u0013\u0011\t9)!#\u0003\t1K7\u000f\u001e\u0006\u0004\u0003\u0007\u0013\u0006\u0003B'\u0002\u000e2K1!a$Y\u0005\r\u0019V\r^\u0001\u0010i>\u0004\u0018nY$s_V\u00048o\u0018\u0013fcR\u0019!0!&\t\u0013\u0005\u001dt#!AA\u0002\u0005e\u0014\u0001\u0004;pa&\u001cwI]8vaN\u0004\u0013a\u0001:v]R\u0011\u0011Q\u0014\t\u0005\u0003?\u000biKD\u0002\u0002\"jrA!a)\u0002,:!\u0011QUAU\u001d\ry\u0015qU\u0005\u0002i%\u0011!gM\u0005\u0003aEJ1!a,?\u0005)!\u0016m]6SKN,H\u000e^\u0001\faJ|7-Z:t\u0003\u000ed7/A\u000bdY\u0016\f'\u000fT5oW\u0006\u001bGn]\"p[BdW\r^3\u0015\t\u0005u\u0015q\u0017\u0005\b\u0003s[\u0002\u0019AA^\u0003A\u0019'/Z1uK\u0006\u001bGn\u001d*fgVdG\u000fE\u0002p\u0003{K1!a0q\u0005A\u0019%/Z1uK\u0006\u001bGn\u001d*fgVdG\u000f\u0006\u0003\u0002\u001e\u0006\r\u0007bBAc9\u0001\u0007\u0011qY\u0001\u0011I\u0016dW\r^3BG2\u001c(+Z:vYR\u00042a\\Ae\u0013\r\tY\r\u001d\u0002\u0011\t\u0016dW\r^3BG2\u001c(+Z:vYR\fQ\u0002\u001d:pG\u0016\u001c8\u000fV8qS\u000e\u001c\u0018!\u00059s_\u000e,7o\u001d+pa&\u001c7o\u00148dK\u0006\t2\r\\3be6K'O]8s)>\u0004\u0018nY:\u0015\t\u0005u\u0015Q\u001b\u0005\b\u0003/|\u0002\u0019AAF\u0003\u0019!x\u000e]5dg\u0006I2\r\\3be6K'O]8s)>\u0004\u0018nY:D_6\u0004H.\u001a;f)\u0011\ti*!8\t\u000f\u0005}\u0007\u00051\u0001\u0002b\u00069!/Z:vYR\u001c\bcBAr\u0003[d\u0015\u0011_\u0007\u0003\u0003KTA!a:\u0002j\u0006!Q\u000f^5m\u0015\t\tY/\u0001\u0003kCZ\f\u0017\u0002BAx\u0003K\u00141!T1q!\u0015\t\u00151_A|\u0013\r\t)P\u0011\u0002\f\u0017\u000647.\u0019$viV\u0014X\r\u0005\u0003\u0002z\u0006}XBAA~\u0015\u0011\ti0!;\u0002\t1\fgnZ\u0005\u0005\u0005\u0003\tYP\u0001\u0003W_&$\u0017!\u00073fY\u0016$Xm\u00117vgR,'\u000fT5oW6+G/\u00193bi\u0006\fAb\u001c8D_6\u0004H.\u001a;j_:$2A\u001fB\u0005\u0011\u001d\u0011Ya\ta\u0001\u0005\u001b\taA]3tk2$\bc\u0001\u001d\u0003\u0010%\u0019!\u0011\u0003 \u0003'\r{W\u000e\u001d7fi\u0016$G+Y:l%\u0016\u001cX\u000f\u001c;\u0002\u001d\u001d,G/\u00169eCR,G-Q2mg\u0006i2\t\\;ti\u0016\u0014H*\u001b8l\u00072,\u0017M\u001d'j].\u0014VMZ3sK:\u001cW\r\u0005\u0002:MM)aEa\u0007\u0003\"A\u0019AM!\b\n\u0007\t}!K\u0001\u0004B]f\u0014VM\u001a\t\u0005\u0005G\u00119#\u0004\u0002\u0003&)\u0019\u00111A\u001a\n\t\t%\"Q\u0005\u0002\b\u0019><w-\u001b8h)\t\u00119\"\u0001\rtQ>,H\u000eZ\"mK\u0006\u0014H*\u001b8l%\u00164WM]3oG\u0016$b!a\u0017\u00032\tM\u0002\"B )\u0001\u0004\u0001\u0005B\u0002B\u001bQ\u0001\u0007q,A\u0004nC:\fw-\u001a:\u0002-!\fg\u000e\u001a7f\t\u0016dW\r^3BG2\u001c(+Z:vYR$B!a\u0017\u0003<!9\u0011QY\u0015A\u0002\u0005\u001d\u0017A\u00065b]\u0012dWm\u0011:fCR,\u0017i\u00197t%\u0016\u001cX\u000f\u001c;\u0015\t\t\u0005#q\t\t\bI\n\r\u00131LA\r\u0013\r\u0011)E\u0015\u0002\u0007)V\u0004H.\u001a\u001a\t\u000f\u0005e&\u00061\u0001\u0002<\u0006aB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uIE\u0002TC\u0001B'U\u0011\tIBa\u0014,\u0005\tE\u0003\u0003\u0002B*\u0005;j!A!\u0016\u000b\t\t]#\u0011L\u0001\nk:\u001c\u0007.Z2lK\u0012T1Aa\u0017S\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005?\u0012)FA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fA\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u0012\n\u0014'\u0001\u000f%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%\r\u001a")
public class ClusterLinkClearLinkReference
extends ClusterLinkScheduler.PeriodicTask {
    private final Uuid linkId;
    private final String linkName;
    private final ClusterLinkMetadataManager metadataManager;
    private final Option<Authorizer> authorizer;
    private final ConfluentAdmin localAdmin;
    private final Function0<BoxedUnit> completionCallback;
    private final int topicGroupSize;
    private final int retryDelayMs;
    private final AccessControlEntryFilter linkFilter;
    private boolean updatedAcls;
    private boolean updatedTopics;
    private List<Set<String>> topicGroups;

    public static int $lessinit$greater$default$12() {
        return 1000;
    }

    public static int $lessinit$greater$default$11() {
        return 5000;
    }

    public static int $lessinit$greater$default$10() {
        return 100;
    }

    private AccessControlEntryFilter linkFilter() {
        return this.linkFilter;
    }

    private boolean updatedAcls() {
        return this.updatedAcls;
    }

    private void updatedAcls_$eq(boolean x$1) {
        this.updatedAcls = x$1;
    }

    private boolean updatedTopics() {
        return this.updatedTopics;
    }

    private void updatedTopics_$eq(boolean x$1) {
        this.updatedTopics = x$1;
    }

    private List<Set<String>> topicGroups() {
        return this.topicGroups;
    }

    private void topicGroups_$eq(List<Set<String>> x$1) {
        this.topicGroups = x$1;
    }

    @Override
    public ClusterLinkScheduler.TaskResult run() {
        if (!ClusterLinkClearLinkReference$.MODULE$.shouldClearLinkReference(this.linkId, this.metadataManager)) {
            return this.onCompletion();
        }
        if (!this.updatedAcls() && this.authorizer.nonEmpty()) {
            return this.processAcls();
        }
        if (!this.updatedTopics()) {
            return this.processTopics();
        }
        ClusterLinkMetadataManager clusterLinkMetadataManager = this.metadataManager;
        if (clusterLinkMetadataManager instanceof ClusterLinkMetadataManagerWithZkSupport) {
            return this.deleteClusterLinkMetadata();
        }
        if (clusterLinkMetadataManager instanceof ClusterLinkMetadataManagerWithKRaftSupport) {
            return this.onCompletion();
        }
        if (clusterLinkMetadataManager != null) {
            throw new IllegalStateException("Unsupported type of ClusterLinkMetadataManager");
        }
        throw new MatchError(null);
    }

    private ClusterLinkScheduler.TaskResult processAcls() {
        this.authorizer.foreach((Function1 & Serializable)authz -> {
            Iterable linkAcls = CollectionConverters$.MODULE$.IterableHasAsScala(authz.acls(new AclBindingFilter(ResourcePatternFilter.ANY, this.linkFilter()))).asScala();
            Iterable aclsToAdd = (Iterable)linkAcls.filterNot((Function1 & Serializable)acl -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkClearLinkReference.$anonfun$processAcls$2(acl)));
            if (linkAcls.isEmpty()) {
                this.updatedAcls_$eq(true);
                return this.processTopics();
            }
            if (aclsToAdd.nonEmpty()) {
                java.util.List localAcls = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)aclsToAdd.map((Function1 & Serializable)acl -> {
                    AccessControlEntry ace = new AccessControlEntry(acl.entry().principal(), acl.entry().host(), acl.entry().operation(), acl.entry().permissionType());
                    return new AclBinding(acl.pattern(), ace);
                })).toList()).asJava();
                CreateAclsResult createAclResult = $this.localAdmin.createAcls((Collection)localAcls);
                Iterable createAclsFuture = CollectionConverters$.MODULE$.MapHasAsScala(createAclResult.values()).asScala().values();
                this.scheduleWhenComplete(KafkaFuture.allOf((KafkaFuture[])((KafkaFuture[])createAclsFuture.toSeq().toArray(ClassTag$.MODULE$.apply(KafkaFuture.class)))), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable)x$2 -> this.clearLinkAclsComplete(createAclResult), new ClusterLinkScheduler.TaskContext((scala.collection.immutable.Seq<TaskErrorCodeAndMsg>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()))));
                return BoxedUnit.UNIT;
            }
            java.util.List aclsToRemove = CollectionConverters$.MODULE$.SeqHasAsJava((Seq)((IterableOnceOps)linkAcls.map((Function1 & Serializable)acl -> SecurityUtils.aclWithClusterLinkIds((AclBinding)acl, (Collection)this.linkFilter().clusterLinkIds()).toFilter())).toList()).asJava();
            DeleteAclsResult deleteAclsResult = $this.localAdmin.deleteAcls((Collection)aclsToRemove);
            Iterable deleteAclsResultFutures = CollectionConverters$.MODULE$.MapHasAsScala(deleteAclsResult.values()).asScala().values();
            this.scheduleWhenComplete(KafkaFuture.allOf((KafkaFuture[])((KafkaFuture[])deleteAclsResultFutures.toSeq().toArray(ClassTag$.MODULE$.apply(KafkaFuture.class)))), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable)x$3 -> this.clearLinkAclsComplete(deleteAclsResult), new ClusterLinkScheduler.TaskContext((scala.collection.immutable.Seq<TaskErrorCodeAndMsg>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()))));
            return BoxedUnit.UNIT;
        });
        if (this.updatedAcls()) {
            scala.collection.immutable.Seq completedTask_errs = (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
            return new ClusterLinkScheduler.TaskResult(true, (scala.collection.immutable.Seq<TaskErrorCodeAndMsg>)completedTask_errs);
        }
        scala.collection.immutable.Seq inProgressTask_errs = (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
        return new ClusterLinkScheduler.TaskResult(false, (scala.collection.immutable.Seq<TaskErrorCodeAndMsg>)inProgressTask_errs);
    }

    private ClusterLinkScheduler.TaskResult clearLinkAclsComplete(CreateAclsResult createAclsResult) {
        boolean success = ClusterLinkClearLinkReference$.MODULE$.handleCreateAclsResult(createAclsResult)._1$mcZ$sp();
        this.scheduleOnce(new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable)x$4 -> this.processAcls(), new ClusterLinkScheduler.TaskContext((scala.collection.immutable.Seq<TaskErrorCodeAndMsg>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()))), success ? 0L : (long)this.retryDelayMs);
        scala.collection.immutable.Seq inProgressTask_errs = (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
        return new ClusterLinkScheduler.TaskResult(false, (scala.collection.immutable.Seq<TaskErrorCodeAndMsg>)inProgressTask_errs);
    }

    private ClusterLinkScheduler.TaskResult clearLinkAclsComplete(DeleteAclsResult deleteAclsResult) {
        boolean success = ClusterLinkClearLinkReference$.MODULE$.handleDeleteAclsResult(deleteAclsResult);
        this.scheduleOnce(new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable)x$5 -> this.processAcls(), new ClusterLinkScheduler.TaskContext((scala.collection.immutable.Seq<TaskErrorCodeAndMsg>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()))), success ? 0L : (long)this.retryDelayMs);
        scala.collection.immutable.Seq inProgressTask_errs = (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
        return new ClusterLinkScheduler.TaskResult(false, (scala.collection.immutable.Seq<TaskErrorCodeAndMsg>)inProgressTask_errs);
    }

    private ClusterLinkScheduler.TaskResult processTopics() {
        Set<String> topicSet = this.metadataManager.getAllTopicsInCluster();
        this.topicGroups_$eq((List<Set<String>>)topicSet.grouped(this.topicGroupSize).toList());
        Map<String, ClusterLinkTopicState> mirrorTopics = this.metadataManager.mirrorTopicStatesFromMetadataCache(this.linkId);
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(70).append("Processing ").append(mirrorTopics.size()).append(" topics for mirror topic state removal for cluster link id ").append($this.linkId).toString());
        return this.processTopicsOnce();
    }

    private ClusterLinkScheduler.TaskResult processTopicsOnce() {
        if (this.topicGroups().isEmpty()) {
            this.updatedTopics_$eq(true);
            return this.deleteClusterLinkMetadata();
        }
        Map mirrorTopics = (Map)this.metadataManager.mirrorTopicStatesFromMetadataStore((Set<String>)((Set)this.topicGroups().head())).filter((Function1 & Serializable)entry -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkClearLinkReference.$anonfun$processTopicsOnce$1(this, entry)));
        if (mirrorTopics.nonEmpty()) {
            return this.clearMirrorTopics((Set<String>)mirrorTopics.keys().toSet());
        }
        this.topicGroups_$eq((List<Set<String>>)((List)this.topicGroups().drop(1)));
        this.scheduleOnce(new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable)x$6 -> this.processTopicsOnce(), new ClusterLinkScheduler.TaskContext((scala.collection.immutable.Seq<TaskErrorCodeAndMsg>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()))), this.scheduleOnce$default$2());
        scala.collection.immutable.Seq inProgressTask_errs = (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
        return new ClusterLinkScheduler.TaskResult(false, (scala.collection.immutable.Seq<TaskErrorCodeAndMsg>)inProgressTask_errs);
    }

    private ClusterLinkScheduler.TaskResult clearMirrorTopics(Set<String> topics) {
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(57).append("Clearing mirror topics for topics '").append(topics).append("' for cluster link id ").append($this.linkId).toString());
        try {
            scala.collection.immutable.Map ops = ((IterableOnceOps)topics.map((Function1 & Serializable)t -> Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(t), (Object)AlterMirrorOp.CLEAR))).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
            AlterMirrorsOptions options = new AlterMirrorsOptions();
            AlterMirrorsResult result = this.localAdmin.alterMirrors(CollectionConverters$.MODULE$.MapHasAsJava((Map)ops).asJava(), options);
            this.scheduleWhenComplete(result.all(), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable)x$7 -> this.clearMirrorTopicsComplete(result.values()), new ClusterLinkScheduler.TaskContext((scala.collection.immutable.Seq<TaskErrorCodeAndMsg>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()))));
        }
        catch (Throwable e) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(69).append("Encountered error while clearing mirror topics. Will try again in ").append($this.retryDelayMs).append(" ms").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
            this.scheduleOnce(new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable)x$8 -> this.processTopicsOnce(), new ClusterLinkScheduler.TaskContext((scala.collection.immutable.Seq<TaskErrorCodeAndMsg>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()))), this.retryDelayMs);
        }
        scala.collection.immutable.Seq inProgressTask_errs = (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
        return new ClusterLinkScheduler.TaskResult(false, (scala.collection.immutable.Seq<TaskErrorCodeAndMsg>)inProgressTask_errs);
    }

    private ClusterLinkScheduler.TaskResult clearMirrorTopicsComplete(java.util.Map<String, KafkaFuture<Void>> results) {
        if (CollectionConverters$.MODULE$.MapHasAsScala(results).asScala().forall((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkClearLinkReference.$anonfun$clearMirrorTopicsComplete$1(this, x0$1)))) {
            this.topicGroups_$eq((List<Set<String>>)((List)this.topicGroups().drop(1)));
            this.scheduleOnce(new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable)x$9 -> this.processTopicsOnce(), new ClusterLinkScheduler.TaskContext((scala.collection.immutable.Seq<TaskErrorCodeAndMsg>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()))), this.scheduleOnce$default$2());
        } else {
            this.scheduleOnce(new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable)x$10 -> this.processTopicsOnce(), new ClusterLinkScheduler.TaskContext((scala.collection.immutable.Seq<TaskErrorCodeAndMsg>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()))), this.retryDelayMs);
        }
        scala.collection.immutable.Seq inProgressTask_errs = (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
        return new ClusterLinkScheduler.TaskResult(false, (scala.collection.immutable.Seq<TaskErrorCodeAndMsg>)inProgressTask_errs);
    }

    private ClusterLinkScheduler.TaskResult deleteClusterLinkMetadata() {
        ClusterLinkScheduler.TaskResult taskResult;
        try {
            if (this.metadataManager.isLinkCoordinatorEnabled()) {
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(31).append("Deleting the metadata for link ").append($this.linkName).toString());
                DeleteClusterLinksResult result = this.localAdmin.deleteClusterLinks(Collections.singletonList(this.linkName), new DeleteClusterLinksOptions().deleteMetadata(true));
                this.scheduleWhenComplete(result.all(), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable)x$11 -> {
                    try {
                        result.all().get();
                        return this.onCompletion();
                    }
                    catch (Throwable ex) {
                        throw this.handleException$1(ex);
                    }
                }, new ClusterLinkScheduler.TaskContext((scala.collection.immutable.Seq<TaskErrorCodeAndMsg>)((scala.collection.immutable.Seq)package$.MODULE$.Seq().empty()))));
                scala.collection.immutable.Seq inProgressTask_errs = (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
                return new ClusterLinkScheduler.TaskResult(false, (scala.collection.immutable.Seq<TaskErrorCodeAndMsg>)inProgressTask_errs);
            }
            taskResult = this.onCompletion();
        }
        catch (Throwable ex) {
            throw this.handleException$1(ex);
        }
        return taskResult;
    }

    private ClusterLinkScheduler.TaskResult onCompletion() {
        this.shutdown();
        super.scheduler().scheduleOnce("ClearLinkReferenceCompleted", () -> $this.completionCallback.apply$mcV$sp());
        scala.collection.immutable.Seq completedTask_errs = (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty();
        return new ClusterLinkScheduler.TaskResult(true, (scala.collection.immutable.Seq<TaskErrorCodeAndMsg>)completedTask_errs);
    }

    @Override
    public void onCompletion(ClusterLinkScheduler.CompletedTaskResult result) {
    }

    public boolean getUpdatedAcls() {
        return this.updatedAcls();
    }

    public static final /* synthetic */ boolean $anonfun$processAcls$2(AclBinding acl) {
        return acl.entry().clusterLinkIds().contains(Uuid.ZERO_UUID);
    }

    public static final /* synthetic */ boolean $anonfun$processTopicsOnce$1(ClusterLinkClearLinkReference $this, Tuple2 entry) {
        Uuid uuid = ((ClusterLinkTopicState)entry._2()).linkId();
        Uuid uuid2 = $this.linkId;
        return !(uuid != null ? !uuid.equals(uuid2) : uuid2 != null);
    }

    public static final /* synthetic */ boolean $anonfun$clearMirrorTopicsComplete$1(ClusterLinkClearLinkReference $this, Tuple2 x0$1) {
        if (x0$1 != null) {
            String topic = (String)x0$1._1();
            try {
                ((KafkaFuture)x0$1._2()).get();
                return true;
            }
            catch (ExecutionException executionException) {
                Throwable throwable = executionException.getCause();
                if (throwable instanceof UnknownTopicOrPartitionException) {
                    $this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(103).append("Encountered UnknownTopicOrPartitionException while clearing mirror topic '").append(topic).append("'.").append(" Mirror topic may not exist").toString());
                    return true;
                }
                if (throwable != null) {
                    $this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(48).append("Encountered error while clearing mirror topic '").append(topic).append("'").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> throwable);
                    return false;
                }
                throw new MatchError(null);
            }
            catch (Throwable e) {
                $this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(48).append("Encountered error while clearing mirror topic '").append(topic).append("'").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> e);
                return false;
            }
        }
        throw new MatchError(null);
    }

    private final Nothing$ handleException$1(Throwable ex) {
        ApiException e = ClusterLinkUtils$.MODULE$.apiException(ex, new StringBuilder(43).append("Failed to remove metadata for deleted link ").append(this.linkName).toString());
        this.warn((Function0<String>)(Function0 & Serializable)() -> "Failed to remove metadata for deleted link", (Function0<Throwable>)(Function0 & Serializable)() -> e);
        throw e;
    }

    public ClusterLinkClearLinkReference(Uuid linkId, String linkName, ClusterLinkScheduler scheduler, ClusterLinkMetadataManager metadataManager, Option<Authorizer> authorizer, ConfluentAdmin localAdmin, Function0<BoxedUnit> completionCallback, Time time, ClusterLinkRequestQuota quota, int topicGroupSize, int intervalMs, int retryDelayMs) {
        this.linkId = linkId;
        this.linkName = linkName;
        this.metadataManager = metadataManager;
        this.authorizer = authorizer;
        this.localAdmin = localAdmin;
        this.completionCallback = completionCallback;
        this.topicGroupSize = topicGroupSize;
        this.retryDelayMs = retryDelayMs;
        super(scheduler, "ClearLinkReference", intervalMs, time, quota);
        this.linkFilter = new AccessControlEntryFilter(null, null, AclOperation.ANY, AclPermissionType.ANY, Collections.singleton(linkId));
        this.updatedAcls = false;
        this.updatedTopics = false;
    }
}

