/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import kafka.server.ClusterLinkRequestQuota;
import kafka.server.link.ClusterLinkConvertToMirrorTopicTaskType$;
import kafka.server.link.ClusterLinkDestClientManager;
import kafka.server.link.ClusterLinkLocalAdmin;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkTask$;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.InternalTaskErrorCode$;
import kafka.server.link.TaskDescription;
import kafka.server.link.TaskErrorCodeAndMsg;
import org.apache.kafka.clients.admin.AlterMirrorOp;
import org.apache.kafka.clients.admin.AlterMirrorsOptions;
import org.apache.kafka.clients.admin.AlterMirrorsResult;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.DescribeMirrorsOptions;
import org.apache.kafka.clients.admin.DescribeTopicsOptions;
import org.apache.kafka.clients.admin.MirrorTopicDescription;
import org.apache.kafka.clients.admin.TopicDescription;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.MirrorTopicError;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.errors.ClusterLinkNotFoundException;
import org.apache.kafka.common.errors.UnknownTopicOrPartitionException;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.MirrorTopic;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\t\u0005e\u0001B\u00193\u0001eB\u0001B\u0011\u0001\u0003\u0002\u0003\u0006Ia\u0011\u0005\t!\u0002\u0011\t\u0011)A\u0005#\"AA\u000b\u0001B\u0001B\u0003%Q\u000bC\u0005]\u0001\t\u0005\t\u0015!\u0003^U\"I1\u000e\u0001B\u0001B\u0003%A\u000e\u001d\u0005\nc\u0002\u0011\t\u0011)A\u0005eVDQa\u001e\u0001\u0005\u0002aD\u0011\"!\u0001\u0001\u0001\u0004%I!a\u0001\t\u0013\u0005-\u0001\u00011A\u0005\n\u00055\u0001\u0002CA\r\u0001\u0001\u0006K!!\u0002\t\u0013\u0005m\u0001\u00011A\u0005\n\u0005\r\u0001\"CA\u000f\u0001\u0001\u0007I\u0011BA\u0010\u0011!\t\u0019\u0003\u0001Q!\n\u0005\u0015\u0001\"CA\u0013\u0001\t\u0007I\u0011BA\u0014\u0011!\ty\u0003\u0001Q\u0001\n\u0005%\u0002\"CA\u0019\u0001\t\u0007I\u0011BA\u001a\u0011!\t)\u0005\u0001Q\u0001\n\u0005U\u0002bCA$\u0001\u0001\u0007\t\u0019!C\u0005\u0003\u0013B1\"!\u0017\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002\\!Y\u0011q\f\u0001A\u0002\u0003\u0005\u000b\u0015BA&\u0011%\t\t\u0007\u0001a\u0001\n\u0013\t\u0019\u0007C\u0005\u0002f\u0001\u0001\r\u0011\"\u0003\u0002h!9\u00111\u000e\u0001!B\u0013\u0011\b\"CA7\u0001\u0001\u0007I\u0011BA2\u0011%\ty\u0007\u0001a\u0001\n\u0013\t\t\bC\u0004\u0002v\u0001\u0001\u000b\u0015\u0002:\t\u0013\u0005]\u0004\u00011A\u0005\n\u0005e\u0004\"CAD\u0001\u0001\u0007I\u0011BAE\u0011!\ti\t\u0001Q!\n\u0005m\u0004bBAL\u0001\u0011E\u0013\u0011\u0014\u0005\b\u0003_\u0003A\u0011BAY\u0011\u001d\ti\f\u0001C\u0005\u0003\u007fCq!a9\u0001\t\u0013\t)\u000fC\u0004\u0002\u0000\u0002!IA!\u0001\t\u000f\t\u0015\u0001\u0001\"\u0003\u0003\b!9!\u0011\u0004\u0001\u0005\n\tm\u0001b\u0002B\u0011\u0001\u0011%!1\u0005\u0005\b\u0005O\u0001A\u0011\u0002B\u0015\u0011\u001d\u00119\u0004\u0001C\u0005\u0005sAqAa\u0010\u0001\t\u0013\u0011\t\u0005C\u0004\u0003F\u0001!IAa\u0012\t\u000f\t\u0015\u0003\u0001\"\u0015\u0003L!9!Q\u000b\u0001\u0005\u0002\t]\u0003\"\u0004B-\u0001A\u0005\u0019\u0011!A\u0005\n\u0005\rToB\u0005\u0003\\I\n\t\u0011#\u0001\u0003^\u0019A\u0011GMA\u0001\u0012\u0003\u0011y\u0006\u0003\u0004x]\u0011\u0005!q\r\u0005\n\u0005Sr\u0013\u0013!C\u0001\u0005W\u0012qd\u00117vgR,'\u000fT5oW\u000e{gN^3siR{W*\u001b:s_J$v\u000e]5d\u0015\t\u0019D'\u0001\u0003mS:\\'BA\u001b7\u0003\u0019\u0019XM\u001d<fe*\tq'A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0005\u0001Q\u0004CA\u001e@\u001d\taT(D\u00013\u0013\tq$'\u0001\u000bDYV\u001cH/\u001a:MS:\\7k\u00195fIVdWM]\u0005\u0003\u0001\u0006\u0013A\u0002U3sS>$\u0017n\u0019+bg.T!A\u0010\u001a\u0002\u000bQ|\u0007/[2\u0011\u0005\u0011keBA#L!\t1\u0015*D\u0001H\u0015\tA\u0005(\u0001\u0004=e>|GO\u0010\u0006\u0002\u0015\u0006)1oY1mC&\u0011A*S\u0001\u0007!J,G-\u001a4\n\u00059{%AB*ue&twM\u0003\u0002M\u0013\u0006i1\r\\5f]Rl\u0015M\\1hKJ\u0004\"\u0001\u0010*\n\u0005M\u0013$\u0001H\"mkN$XM\u001d'j].$Um\u001d;DY&,g\u000e^'b]\u0006<WM]\u0001\u0012Y>\u001c\u0017\r\\!e[&tg)Y2u_JL\bc\u0001,X36\t\u0011*\u0003\u0002Y\u0013\nIa)\u001e8di&|g\u000e\r\t\u0003yiK!a\u0017\u001a\u0003+\rcWo\u001d;fe2Kgn\u001b'pG\u0006d\u0017\tZ7j]\u0006!A/[7f!\tq\u0006.D\u0001`\u0015\t\u0001\u0017-A\u0003vi&d7O\u0003\u0002cG\u000611m\\7n_:T!a\u000e3\u000b\u0005\u00154\u0017AB1qC\u000eDWMC\u0001h\u0003\ry'oZ\u0005\u0003S~\u0013A\u0001V5nK&\u0011AlP\u0001\u0006cV|G/\u0019\t\u0003[:l\u0011\u0001N\u0005\u0003_R\u0012qc\u00117vgR,'\u000fT5oWJ+\u0017/^3tiF+x\u000e^1\n\u0005-|\u0014AC5oi\u0016\u0014h/\u00197NgB\u0011ak]\u0005\u0003i&\u00131!\u00138u\u0013\t1x(A\tsKN\u001c\u0007.\u001a3vY\u0016$U\r\\1z\u001bN\fa\u0001P5oSRtDcB={wrlhp \t\u0003y\u0001AQAQ\u0004A\u0002\rCQ\u0001U\u0004A\u0002ECQ\u0001V\u0004A\u0002UCQ\u0001X\u0004A\u0002uCQa[\u0004A\u00021Dq!]\u0004\u0011\u0002\u0003\u0007!/A\ttQ>,H\u000eZ*uCJ$X*\u001b:s_J,\"!!\u0002\u0011\u0007Y\u000b9!C\u0002\u0002\n%\u0013qAQ8pY\u0016\fg.A\u000btQ>,H\u000eZ*uCJ$X*\u001b:s_J|F%Z9\u0015\t\u0005=\u0011Q\u0003\t\u0004-\u0006E\u0011bAA\n\u0013\n!QK\\5u\u0011%\t9\"CA\u0001\u0002\u0004\t)!A\u0002yIE\n!c\u001d5pk2$7\u000b^1si6K'O]8sA\u0005I!-Z4j]R\u000b7o[\u0001\u000eE\u0016<\u0017N\u001c+bg.|F%Z9\u0015\t\u0005=\u0011\u0011\u0005\u0005\n\u0003/a\u0011\u0011!a\u0001\u0003\u000b\t!BY3hS:$\u0016m]6!\u0003=iW\r^1eCR\fW*\u00198bO\u0016\u0014XCAA\u0015!\ra\u00141F\u0005\u0004\u0003[\u0011$AG\"mkN$XM\u001d'j].lU\r^1eCR\fW*\u00198bO\u0016\u0014\u0018\u0001E7fi\u0006$\u0017\r^1NC:\fw-\u001a:!\u0003-\u0011X-\\8uK\u0006#W.\u001b8\u0016\u0005\u0005U\u0002\u0003BA\u001c\u0003\u0003j!!!\u000f\u000b\t\u0005m\u0012QH\u0001\u0006C\u0012l\u0017N\u001c\u0006\u0004\u0003\u007f\u0019\u0017aB2mS\u0016tGo]\u0005\u0005\u0003\u0007\nID\u0001\bD_:4G.^3oi\u0006#W.\u001b8\u0002\u0019I,Wn\u001c;f\u0003\u0012l\u0017N\u001c\u0011\u0002\u0015A\f'\u000f^5uS>t7/\u0006\u0002\u0002LA)A)!\u0014\u0002R%\u0019\u0011qJ(\u0003\u0007M+G\u000f\u0005\u0003\u0002T\u0005US\"A1\n\u0007\u0005]\u0013M\u0001\bU_BL7\rU1si&$\u0018n\u001c8\u0002\u001dA\f'\u000f^5uS>t7o\u0018\u0013fcR!\u0011qBA/\u0011%\t9bEA\u0001\u0002\u0004\tY%A\u0006qCJ$\u0018\u000e^5p]N\u0004\u0013\u0001\t8v[\u0012+7o\u0019:jE\u0016\u001cv.\u001e:dKR{\u0007/[2Fq\u000e,\u0007\u000f^5p]N,\u0012A]\u0001%]VlG)Z:de&\u0014WmU8ve\u000e,Gk\u001c9jG\u0016C8-\u001a9uS>t7o\u0018\u0013fcR!\u0011qBA5\u0011!\t9BFA\u0001\u0002\u0004\u0011\u0018!\t8v[\u0012+7o\u0019:jE\u0016\u001cv.\u001e:dKR{\u0007/[2Fq\u000e,\u0007\u000f^5p]N\u0004\u0013\u0001\n8v[N{WO]2f)>\u0004\u0018nY'jeJ|'o\u0015;biV\u001cX\t_2faRLwN\\:\u0002Q9,XnU8ve\u000e,Gk\u001c9jG6K'O]8s'R\fG/^:Fq\u000e,\u0007\u000f^5p]N|F%Z9\u0015\t\u0005=\u00111\u000f\u0005\t\u0003/I\u0012\u0011!a\u0001e\u0006)c.^7T_V\u00148-\u001a+pa&\u001cW*\u001b:s_J\u001cF/\u0019;vg\u0016C8-\u001a9uS>t7\u000fI\u0001\ti\u0006\u001c8\u000eR3tGV\u0011\u00111\u0010\t\u0006-\u0006u\u0014\u0011Q\u0005\u0004\u0003\u007fJ%AB(qi&|g\u000eE\u0002=\u0003\u0007K1!!\"3\u0005=!\u0016m]6EKN\u001c'/\u001b9uS>t\u0017\u0001\u0004;bg.$Um]2`I\u0015\fH\u0003BA\b\u0003\u0017C\u0011\"a\u0006\u001d\u0003\u0003\u0005\r!a\u001f\u0002\u0013Q\f7o\u001b#fg\u000e\u0004\u0003fA\u000f\u0002\u0012B\u0019a+a%\n\u0007\u0005U\u0015J\u0001\u0005w_2\fG/\u001b7f\u0003\r\u0011XO\u001c\u000b\u0003\u00037\u0003B!!(\u0002,:\u0019\u0011qT\u001f\u000f\t\u0005\u0005\u0016\u0011\u0016\b\u0005\u0003G\u000b9KD\u0002G\u0003KK\u0011aN\u0005\u0003kYJ!a\r\u001b\n\u0007\u00055\u0016I\u0001\u0006UCN\\'+Z:vYR\fac\u00195fG.\u001cv.\u001e:dKR{\u0007/[2Ti\u0006$Xo\u001d\u000b\u0005\u00037\u000b\u0019\fC\u0004\u00026~\u0001\r!a.\u0002\u0017Q\f7o[\"p]R,\u0007\u0010\u001e\t\u0005\u0003;\u000bI,C\u0002\u0002<\u0006\u00131\u0002V1tW\u000e{g\u000e^3yi\u0006y\u0002.\u00198eY\u0016$Um]2sS\n,7k\\;sG\u0016$v\u000e]5d%\u0016\u001cX\u000f\u001c;\u0015\r\u0005m\u0015\u0011YAb\u0011\u001d\t)\f\ta\u0001\u0003oCq!!2!\u0001\u0004\t9-\u0001\ft_V\u00148-\u001a+pa&\u001cG)Z:de&\u0004H/[8o!\u0019\t\u0019&!3\u0002N&\u0019\u00111Z1\u0003\u0017-\u000bgm[1GkR,(/\u001a\t\b\u0003\u001f\fInQAo\u001b\t\t\tN\u0003\u0003\u0002T\u0006U\u0017\u0001B;uS2T!!a6\u0002\t)\fg/Y\u0005\u0005\u00037\f\tNA\u0002NCB\u0004B!a\u000e\u0002`&!\u0011\u0011]A\u001d\u0005A!v\u000e]5d\t\u0016\u001c8M]5qi&|g.\u0001\u0012iC:$G.\u001a#fg\u000e\u0014\u0018NY3T_V\u00148-\u001a+pa&\u001cW\t_2faRLwN\u001c\u000b\u0007\u00037\u000b9/!;\t\u000f\u0005U\u0016\u00051\u0001\u00028\"9\u00111^\u0011A\u0002\u00055\u0018!A3\u0011\t\u0005=\u0018\u0011 \b\u0005\u0003c\f)PD\u0002G\u0003gL\u0011AS\u0005\u0004\u0003oL\u0015a\u00029bG.\fw-Z\u0005\u0005\u0003w\fiPA\u0005UQJ|w/\u00192mK*\u0019\u0011q_%\u00029\rDWmY6T_V\u00148-\u001a+pa&\u001cW*\u001b:s_J\u001cF/\u0019;vgR!\u00111\u0014B\u0002\u0011\u001d\t)L\ta\u0001\u0003o\u000b1\u0005[1oI2,7k\\;sG\u0016$v\u000e]5d\u001b&\u0014(o\u001c:Ti\u0006$Xo\u001d*fgVdG\u000f\u0006\u0004\u0002\u001c\n%!1\u0002\u0005\b\u0003k\u001b\u0003\u0019AA\\\u0011\u001d\u0011ia\ta\u0001\u0005\u001f\tAd]8ve\u000e,W*\u001b:s_J$v\u000e]5d\t\u0016\u001c8M]5qi&|g\u000e\u0005\u0004\u0002T\u0005%'\u0011\u0003\t\b\u0003\u001f\fIn\u0011B\n!\u0011\t9D!\u0006\n\t\t]\u0011\u0011\b\u0002\u0017\u001b&\u0014(o\u001c:U_BL7\rR3tGJL\u0007\u000f^5p]\u00061\u0003.\u00198eY\u0016\u001cv.\u001e:dKR{\u0007/[2NSJ\u0014xN]*uCR,8/\u0012=dKB$\u0018n\u001c8\u0015\r\u0005m%Q\u0004B\u0010\u0011\u001d\t)\f\na\u0001\u0003oCq!a;%\u0001\u0004\ti/A\rti\u0006\u0014Ho\u0014:QCV\u001cX\rU3oI&tw-T5se>\u0014H\u0003BAN\u0005KAq!!.&\u0001\u0004\t9,A\u0013iC:$G.Z*uCJ$xJ\u001d)bkN,\u0007+\u001a8eS:<W*\u001b:s_J\u0014Vm];miR1\u00111\u0014B\u0016\u0005[Aq!!.'\u0001\u0004\t9\fC\u0004\u00030\u0019\u0002\rA!\r\u0002\rI,7/\u001e7u!\u0011\t9Da\r\n\t\tU\u0012\u0011\b\u0002\u0013\u00032$XM]'jeJ|'o\u001d*fgVdG/\u0001\u0015iC:$G.Z*uCJ$xJ\u001d)bkN,\u0007+\u001a8eS:<W*\u001b:s_J,\u0005pY3qi&|g\u000e\u0006\u0004\u0002\u001c\nm\"Q\b\u0005\b\u0003k;\u0003\u0019AA\\\u0011\u001d\tYo\na\u0001\u0003[\fqBZ1jY6K'O]8s)>\u0004\u0018n\u0019\u000b\u0005\u00037\u0013\u0019\u0005C\u0004\u00026\"\u0002\r!a.\u0002\u0019=t7i\\7qY\u0016$\u0018n\u001c8\u0015\t\u0005m%\u0011\n\u0005\b\u0003kK\u0003\u0019AA\\)\u0011\tyA!\u0014\t\u000f\t=\"\u00061\u0001\u0003PA\u00191H!\u0015\n\u0007\tM\u0013IA\nD_6\u0004H.\u001a;fIR\u000b7o\u001b*fgVdG/A\buCN\\G)Z:de&\u0004H/[8o)\t\tY(A\ftkB,'\u000f\n:fg\u000eDW\rZ;mK\u0012+G.Y=Ng\u0006y2\t\\;ti\u0016\u0014H*\u001b8l\u0007>tg/\u001a:u)>l\u0015N\u001d:peR{\u0007/[2\u0011\u0005qr3c\u0001\u0018\u0003bA\u0019aKa\u0019\n\u0007\t\u0015\u0014J\u0001\u0004B]f\u0014VM\u001a\u000b\u0003\u0005;\n1\u0004\n7fgNLg.\u001b;%OJ,\u0017\r^3sI\u0011,g-Y;mi\u00122TC\u0001B7U\r\u0011(qN\u0016\u0003\u0005c\u0002BAa\u001d\u0003~5\u0011!Q\u000f\u0006\u0005\u0005o\u0012I(A\u0005v]\u000eDWmY6fI*\u0019!1P%\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003\u0000\tU$!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public class ClusterLinkConvertToMirrorTopic
extends ClusterLinkScheduler.PeriodicTask {
    private final String topic;
    private final ClusterLinkDestClientManager clientManager;
    private final Function0<ClusterLinkLocalAdmin> localAdminFactory;
    private boolean shouldStartMirror;
    private boolean beginTask;
    private final ClusterLinkMetadataManager metadataManager;
    private final ConfluentAdmin remoteAdmin;
    private Set<TopicPartition> partitions;
    private int numDescribeSourceTopicExceptions;
    private int numSourceTopicMirrorStatusExceptions;
    private volatile Option<TaskDescription> taskDesc;

    public static int $lessinit$greater$default$6() {
        return 5000;
    }

    private /* synthetic */ int super$rescheduleDelayMs() {
        return super.rescheduleDelayMs();
    }

    private boolean shouldStartMirror() {
        return this.shouldStartMirror;
    }

    private void shouldStartMirror_$eq(boolean x$1) {
        this.shouldStartMirror = x$1;
    }

    private boolean beginTask() {
        return this.beginTask;
    }

    private void beginTask_$eq(boolean x$1) {
        this.beginTask = x$1;
    }

    private ClusterLinkMetadataManager metadataManager() {
        return this.metadataManager;
    }

    private ConfluentAdmin remoteAdmin() {
        return this.remoteAdmin;
    }

    private Set<TopicPartition> partitions() {
        return this.partitions;
    }

    private void partitions_$eq(Set<TopicPartition> x$1) {
        this.partitions = x$1;
    }

    private int numDescribeSourceTopicExceptions() {
        return this.numDescribeSourceTopicExceptions;
    }

    private void numDescribeSourceTopicExceptions_$eq(int x$1) {
        this.numDescribeSourceTopicExceptions = x$1;
    }

    private int numSourceTopicMirrorStatusExceptions() {
        return this.numSourceTopicMirrorStatusExceptions;
    }

    private void numSourceTopicMirrorStatusExceptions_$eq(int x$1) {
        this.numSourceTopicMirrorStatusExceptions = x$1;
    }

    private Option<TaskDescription> taskDesc() {
        return this.taskDesc;
    }

    private void taskDesc_$eq(Option<TaskDescription> x$1) {
        this.taskDesc = x$1;
    }

    @Override
    public ClusterLinkScheduler.TaskResult run() {
        this.partitions_$eq(this.metadataManager().topicPartitions(this.topic));
        ClusterLinkScheduler.TaskContext taskContext = new ClusterLinkScheduler.TaskContext((Seq<TaskErrorCodeAndMsg>)((Seq)package$.MODULE$.Seq().empty()));
        if (this.partitions().isEmpty()) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(110).append("Cannot promote and swap mirror topic for deleted topic '").append($this.topic).append("'. ").append("Shutting down ClusterLinkConvertToMirrorTopic task.").toString());
            return this.onCompletion(taskContext);
        }
        Option mirrorState = this.metadataManager().mirrorTopicStatesFromMetadataStore((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic})))).get((Object)this.topic);
        boolean bl = false;
        Some some = null;
        if (mirrorState instanceof Some) {
            bl = true;
            some = (Some)mirrorState;
            ClusterLinkTopicState state = (ClusterLinkTopicState)some.value();
            if (state instanceof ClusterLinkTopicState.PendingMirror) {
                ClusterLinkTopicState.PendingMirror pendingMirror = (ClusterLinkTopicState.PendingMirror)state;
                if (pendingMirror.nextState().equals(MirrorTopic.State.PAUSED.stateName())) {
                    this.shouldStartMirror_$eq(false);
                } else if (pendingMirror.nextState().equals(MirrorTopic.State.MIRROR.stateName())) {
                    this.shouldStartMirror_$eq(true);
                } else {
                    this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(115).append("See unsupported mirror '").append(pendingMirror).append("' for the next state for mirror topic ").append($this.topic).append(", will").append(" shut down ClusterLinkConvertToMirrorTopic task").toString());
                    this.beginTask_$eq(false);
                }
                if (this.beginTask()) {
                    this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(69).append("Starting task to convert PendingMirror topic ").append($this.topic).append(" with shouldStartMirror=").append(this.shouldStartMirror()).toString());
                    return this.checkSourceTopicStatus(taskContext);
                }
                return this.onCompletion(taskContext);
            }
        }
        if (bl) {
            ClusterLinkTopicState state = (ClusterLinkTopicState)some.value();
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(86).append("See mirror '").append(state).append("' for mirror topic '").append($this.topic).append("', not performing ClusterLinkConvertToMirrorTopic task").toString());
            return this.onCompletion(taskContext);
        }
        if (None$.MODULE$.equals(mirrorState)) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(88).append("No mirror state for mirror topic '").append($this.topic).append("', not performing ClusterLinkConvertToMirrorTopic task").toString());
            return this.onCompletion(taskContext);
        }
        throw new MatchError((Object)mirrorState);
    }

    private ClusterLinkScheduler.TaskResult checkSourceTopicStatus(ClusterLinkScheduler.TaskContext taskContext) {
        try {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(43).append("Describing source topic ").append($this.topic).append(" to check existence").toString());
            this.numDescribeSourceTopicExceptions_$eq(0);
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(65).append("Attempting to verify that remote topic ").append($this.topic).append(" exists on remote cluster.").toString());
            KafkaFuture sourceTopicDescription = this.remoteAdmin().describeTopics(Collections.singleton(this.topic), new DescribeTopicsOptions()).allTopicNames();
            this.scheduleWhenComplete(sourceTopicDescription, new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable)tc -> this.handleDescribeSourceTopicResult((ClusterLinkScheduler.TaskContext)tc, (KafkaFuture<Map<String, TopicDescription>>)sourceTopicDescription), taskContext));
            Seq<TaskErrorCodeAndMsg> inProgressTask_errs = taskContext.errs();
            return new ClusterLinkScheduler.TaskResult(false, inProgressTask_errs);
        }
        catch (Throwable e) {
            return this.handleDescribeSourceTopicException(taskContext, e);
        }
    }

    private ClusterLinkScheduler.TaskResult handleDescribeSourceTopicResult(ClusterLinkScheduler.TaskContext taskContext, KafkaFuture<Map<String, TopicDescription>> sourceTopicDescription) {
        ClusterLinkScheduler.TaskResult taskResult;
        try {
            this.numDescribeSourceTopicExceptions_$eq(0);
            TopicDescription topicDescription = (TopicDescription)((Map)sourceTopicDescription.get()).get(this.topic);
            if (topicDescription != null) {
                Uuid sourceTopicId = ((ClusterLinkTopicState)((Tuple2)this.metadataManager().mirrorTopicStatesFromMetadataStore((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic})))).head())._2()).sourceTopicId();
                Uuid remoteTopicId = topicDescription.topicId();
                if (!remoteTopicId.equals((Object)sourceTopicId)) {
                    this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(166).append("Remote topic id ").append(remoteTopicId).append(" is not the same as the source topic id of the local mirror topic").append(" ").append(sourceTopicId).append(". Failing local mirror topic and shutting down ClusterLinkConvertToMirrorTopic task.").toString());
                    return this.failMirrorTopic(taskContext);
                }
                if (topicDescription.partitions().size() != this.partitions().size()) {
                    this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(136).append("Remote topic ").append($this.topic).append(" does not have the same number of partitions as the local mirror topic.").append(" Will retry ClusterLinkConvertToMirrorTopic task in ").append(this.super$rescheduleDelayMs()).toString());
                    Seq<TaskErrorCodeAndMsg> completedTask_errs = taskContext.errs();
                    return new ClusterLinkScheduler.TaskResult(true, completedTask_errs);
                }
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(210).append("Verified source topic ").append($this.topic).append(" exists on remote cluster with same number of partitions as local").append(" mirror topic ").append($this.topic).append(" and same topic id as source topic id of local mirror topic. Will now check for source").append(" topic's mirror status.").toString());
                return this.checkSourceTopicMirrorStatus(taskContext);
            }
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(101).append("Source topic ").append($this.topic).append(" metadata is null on remote cluster. Will retry ClusterLinkConvertToMirrorTopic task in ").append(this.super$rescheduleDelayMs()).toString());
            Seq<TaskErrorCodeAndMsg> completedTask_errs = taskContext.errs();
            taskResult = new ClusterLinkScheduler.TaskResult(true, completedTask_errs);
            Object var7_4 = null;
        }
        catch (Throwable e) {
            taskResult = this.handleDescribeSourceTopicException(taskContext, e);
        }
        return taskResult;
    }

    private ClusterLinkScheduler.TaskResult handleDescribeSourceTopicException(ClusterLinkScheduler.TaskContext taskContext, Throwable e) {
        if (this.numDescribeSourceTopicExceptions() == 0) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(62).append("Encountered exception while trying to describe source topic ").append($this.topic).append(": ").append(e).toString());
        } else {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(103).append("Encountered exception while trying to describe source topic ").append($this.topic).append(". Source topic describe has").append(" failed ").append(this.numDescribeSourceTopicExceptions()).append(" times: ").append(e).toString());
        }
        this.numDescribeSourceTopicExceptions_$eq(this.numDescribeSourceTopicExceptions() + 1);
        if (e instanceof UnknownTopicOrPartitionException) {
            String errMsg = new StringBuilder(103).append("Source topic ").append(this.topic).append(" metadata does not exist on remote cluster, might be due to stale metadata.").append(" Will retry in ").append(super.rescheduleDelayMs()).toString();
            this.warn((Function0<String>)(Function0 & Serializable)() -> errMsg);
            Seq completedTask_errs = (Seq)taskContext.errs().$plus$plus((IterableOnce)new .colon.colon((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg), (List)Nil$.MODULE$));
            return new ClusterLinkScheduler.TaskResult(true, (Seq<TaskErrorCodeAndMsg>)completedTask_errs);
        }
        if (e != null) {
            if (ClusterLinkTask$.MODULE$.isRetriableException(e)) {
                String errMsg = new StringBuilder(47).append("Encountered retriable exception, will retry in ").append(super.rescheduleDelayMs()).toString();
                this.debug((Function0<String>)(Function0 & Serializable)() -> errMsg);
                Seq completedTask_errs = (Seq)taskContext.errs().$plus$plus((IterableOnce)new .colon.colon((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg), (List)Nil$.MODULE$));
                return new ClusterLinkScheduler.TaskResult(true, (Seq<TaskErrorCodeAndMsg>)completedTask_errs);
            }
            throw e;
        }
        throw new MatchError(null);
    }

    private ClusterLinkScheduler.TaskResult checkSourceTopicMirrorStatus(ClusterLinkScheduler.TaskContext taskContext) {
        try {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(58).append("Checking mirror status of source topic ").append($this.topic).append(" on remote cluster.").toString());
            this.numSourceTopicMirrorStatusExceptions_$eq(0);
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(69).append("Attempting to check mirror status of source topic ").append($this.topic).append(" on remote cluster.").toString());
            KafkaFuture sourceTopicMirrorDescription = this.remoteAdmin().describeMirrors(Collections.singleton(this.topic), new DescribeMirrorsOptions()).all();
            this.scheduleWhenComplete(sourceTopicMirrorDescription, new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable)tc -> this.handleSourceTopicMirrorStatusResult((ClusterLinkScheduler.TaskContext)tc, (KafkaFuture<Map<String, MirrorTopicDescription>>)sourceTopicMirrorDescription), taskContext));
            Seq<TaskErrorCodeAndMsg> inProgressTask_errs = taskContext.errs();
            return new ClusterLinkScheduler.TaskResult(false, inProgressTask_errs);
        }
        catch (Throwable e) {
            return this.handleSourceTopicMirrorStatusException(taskContext, e);
        }
    }

    private ClusterLinkScheduler.TaskResult handleSourceTopicMirrorStatusResult(ClusterLinkScheduler.TaskContext taskContext, KafkaFuture<Map<String, MirrorTopicDescription>> sourceMirrorTopicDescription) {
        ClusterLinkScheduler.TaskResult taskResult;
        block8: {
            try {
                this.numSourceTopicMirrorStatusExceptions_$eq(0);
                if ((Map)sourceMirrorTopicDescription.get() == null) {
                    String errMsg = new StringBuilder(82).append("Source mirror topic description map is null, may be stale metadata. Will retry in ").append(super.rescheduleDelayMs()).toString();
                    this.warn((Function0<String>)(Function0 & Serializable)() -> errMsg);
                    Seq completedTask_errs = (Seq)taskContext.errs().$plus$plus((IterableOnce)new .colon.colon((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg), (List)Nil$.MODULE$));
                    return new ClusterLinkScheduler.TaskResult(true, (Seq<TaskErrorCodeAndMsg>)completedTask_errs);
                }
                MirrorTopicDescription topicDescription = (MirrorTopicDescription)((Map)sourceMirrorTopicDescription.get()).get(this.topic);
                if (topicDescription == null) {
                    String errMsg = new StringBuilder(78).append("Source mirror topic description is null, may be stale metadata. Will retry in ").append(super.rescheduleDelayMs()).toString();
                    this.warn((Function0<String>)(Function0 & Serializable)() -> errMsg);
                    Seq completedTask_errs = (Seq)taskContext.errs().$plus$plus((IterableOnce)new .colon.colon((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg), (List)Nil$.MODULE$));
                    return new ClusterLinkScheduler.TaskResult(true, (Seq<TaskErrorCodeAndMsg>)completedTask_errs);
                }
                MirrorTopicDescription.State state = topicDescription.state();
                if (MirrorTopicDescription.State.STOPPED.equals(state)) {
                    String action = this.shouldStartMirror() ? "start" : "pause";
                    this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(92).append("Source topic mirror status is in a STOPPED mirror state. Will proceed to ").append(action).append(" the local mirror ").append($this.topic).append(".").toString());
                    taskResult = this.startOrPausePendingMirror(taskContext);
                    break block8;
                }
                if (MirrorTopicDescription.State.PENDING_SYNCHRONIZE.equals(state) ? true : (MirrorTopicDescription.State.PENDING_STOPPED.equals(state) ? true : MirrorTopicDescription.State.PAUSED.equals(state))) {
                    String errMsg = new StringBuilder(72).append("Source topic is not yet in STOPPED mirror state. Will retry task in ").append(super.rescheduleDelayMs()).append(" ms.").toString();
                    this.debug((Function0<String>)(Function0 & Serializable)() -> errMsg);
                    Seq completedTask_errs = (Seq)taskContext.errs().$plus$plus((IterableOnce)new .colon.colon((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg), (List)Nil$.MODULE$));
                    taskResult = new ClusterLinkScheduler.TaskResult(true, (Seq<TaskErrorCodeAndMsg>)completedTask_errs);
                    Object var14_11 = null;
                    break block8;
                }
                if (MirrorTopicDescription.State.LINK_PAUSED.equals(state) ? true : (MirrorTopicDescription.State.LINK_FAILED.equals(state) ? true : (MirrorTopicDescription.State.SOURCE_UNAVAILABLE.equals(state) ? true : MirrorTopicDescription.State.UNKNOWN.equals(state)))) {
                    String errMsg = new StringBuilder(86).append("Source topic may have some issues with its link configuration. Will retry task in ").append(super.rescheduleDelayMs()).append(" ms.").toString();
                    this.debug((Function0<String>)(Function0 & Serializable)() -> errMsg);
                    Seq completedTask_errs = (Seq)taskContext.errs().$plus$plus((IterableOnce)new .colon.colon((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg), (List)Nil$.MODULE$));
                    taskResult = new ClusterLinkScheduler.TaskResult(true, (Seq<TaskErrorCodeAndMsg>)completedTask_errs);
                    Object var15_13 = null;
                    break block8;
                }
                if (MirrorTopicDescription.State.ACTIVE.equals(state) ? true : (MirrorTopicDescription.State.FAILED.equals(state) ? true : (MirrorTopicDescription.State.PENDING_REPAIR.equals(state) ? true : MirrorTopicDescription.State.PENDING_MIRROR.equals(state)))) {
                    String errMsg = new StringBuilder(99).append("Source topic is in unexpected state of ").append(state.toString()).append(". This may be due to stale metadata, ").append("will retry task in ").append(super.rescheduleDelayMs()).append(" ms.").toString();
                    this.warn((Function0<String>)(Function0 & Serializable)() -> errMsg);
                    Seq completedTask_errs = (Seq)taskContext.errs().$plus$plus((IterableOnce)new .colon.colon((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg), (List)Nil$.MODULE$));
                    taskResult = new ClusterLinkScheduler.TaskResult(true, (Seq<TaskErrorCodeAndMsg>)completedTask_errs);
                    Object var16_15 = null;
                    break block8;
                }
                throw new MatchError((Object)state);
            }
            catch (Throwable e) {
                taskResult = this.handleSourceTopicMirrorStatusException(taskContext, e);
            }
        }
        return taskResult;
    }

    private ClusterLinkScheduler.TaskResult handleSourceTopicMirrorStatusException(ClusterLinkScheduler.TaskContext taskContext, Throwable e) {
        if (this.numSourceTopicMirrorStatusExceptions() == 0) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(76).append("Encountered exception while trying to check mirror status of source topic ").append($this.topic).append(": ").append(e).toString());
        } else {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(128).append("Encountered exception while trying to check mirror status of source topic ").append($this.topic).append(". Source topic").append(" mirror status check has failed ").append(this.numSourceTopicMirrorStatusExceptions()).append(" times: ").append(e).toString());
        }
        this.numSourceTopicMirrorStatusExceptions_$eq(this.numSourceTopicMirrorStatusExceptions() + 1);
        if (e instanceof ClusterLinkNotFoundException) {
            String errMsg = new StringBuilder(109).append("Source topic ").append(this.topic).append(" is not a mirror topic on the remote cluster. Shutting down ClusterLinkConvertToMirrorTopic task").toString();
            this.warn((Function0<String>)(Function0 & Serializable)() -> errMsg);
            return this.onCompletion(new ClusterLinkScheduler.TaskContext((Seq<TaskErrorCodeAndMsg>)((Seq)taskContext.errs().$plus$plus((IterableOnce)new .colon.colon((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg), (List)Nil$.MODULE$)))));
        }
        if (e != null) {
            if (ClusterLinkTask$.MODULE$.isRetriableException(e)) {
                String errMsg = new StringBuilder(47).append("Encountered retriable exception, will retry in ").append(super.rescheduleDelayMs()).toString();
                this.debug((Function0<String>)(Function0 & Serializable)() -> errMsg);
                Seq completedTask_errs = (Seq)taskContext.errs().$plus$plus((IterableOnce)new .colon.colon((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg), (List)Nil$.MODULE$));
                return new ClusterLinkScheduler.TaskResult(true, (Seq<TaskErrorCodeAndMsg>)completedTask_errs);
            }
            throw e;
        }
        throw new MatchError(null);
    }

    private ClusterLinkScheduler.TaskResult startOrPausePendingMirror(ClusterLinkScheduler.TaskContext taskContext) {
        try {
            String action = this.shouldStartMirror() ? "start" : "pause";
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(30).append("Going to ").append(action).append(" local mirror topic ").append($this.topic).append(".").toString());
            AlterMirrorsResult startOrPausePendingMirrorResult = this.shouldStartMirror() ? ((ClusterLinkLocalAdmin)this.localAdminFactory.apply()).alterMirrors(Collections.singletonMap(this.topic, AlterMirrorOp.START_PENDING_MIRROR), new AlterMirrorsOptions()) : ((ClusterLinkLocalAdmin)this.localAdminFactory.apply()).alterMirrors(Collections.singletonMap(this.topic, AlterMirrorOp.PAUSE_PENDING_MIRROR), new AlterMirrorsOptions());
            this.scheduleWhenComplete(startOrPausePendingMirrorResult.all(), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable)tc -> this.handleStartOrPausePendingMirrorResult((ClusterLinkScheduler.TaskContext)tc, startOrPausePendingMirrorResult), taskContext));
            Seq<TaskErrorCodeAndMsg> inProgressTask_errs = taskContext.errs();
            return new ClusterLinkScheduler.TaskResult(false, inProgressTask_errs);
        }
        catch (Throwable e) {
            return this.handleStartOrPausePendingMirrorException(taskContext, e);
        }
    }

    private ClusterLinkScheduler.TaskResult handleStartOrPausePendingMirrorResult(ClusterLinkScheduler.TaskContext taskContext, AlterMirrorsResult result) {
        try {
            result.all().get();
            String action = this.shouldStartMirror() ? "started" : "paused";
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(54).append("Successfully ").append(action).append(" local mirror topic ").append($this.topic).append(". Shutting down task.").toString());
            return this.onCompletion(taskContext);
        }
        catch (Throwable e) {
            return this.handleStartOrPausePendingMirrorException(taskContext, e);
        }
    }

    private ClusterLinkScheduler.TaskResult handleStartOrPausePendingMirrorException(ClusterLinkScheduler.TaskContext taskContext, Throwable e) {
        String action = this.shouldStartMirror() ? "start" : "pause";
        String errMsg = new StringBuilder(60).append("Encountered exception while trying to ").append(action).append(" local mirror topic ").append(this.topic).append(": ").append(e).toString();
        this.warn((Function0<String>)(Function0 & Serializable)() -> errMsg);
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(46).append("Unable to ").append(action).append(" local mirror topic, will retry in ").append(this.super$rescheduleDelayMs()).append(".").toString());
        Seq completedTask_errs = (Seq)taskContext.errs().$plus$plus((IterableOnce)new .colon.colon((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg), (List)Nil$.MODULE$));
        return new ClusterLinkScheduler.TaskResult(true, (Seq<TaskErrorCodeAndMsg>)completedTask_errs);
    }

    private ClusterLinkScheduler.TaskResult failMirrorTopic(ClusterLinkScheduler.TaskContext taskContext) {
        try {
            String action = this.shouldStartMirror() ? "start" : "pause";
            String errMsg = new StringBuilder(75).append("Failing local mirror topic ").append(this.topic).append(" due to issues encountered when trying to ").append(action).append(" topic").toString();
            this.warn((Function0<String>)(Function0 & Serializable)() -> errMsg);
            ((ClusterLinkLocalAdmin)this.localAdminFactory.apply()).failMirror(this.topic, MirrorTopicError.SOURCE_TOPIC_ID_CHANGED).all().get();
            return this.onCompletion(new ClusterLinkScheduler.TaskContext((Seq<TaskErrorCodeAndMsg>)((Seq)taskContext.errs().$plus$plus((IterableOnce)new .colon.colon((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg), (List)Nil$.MODULE$)))));
        }
        catch (Throwable throwable) {
            String errMsg = new StringBuilder(144).append("Unable to fail local mirror topic ").append(this.topic).append(", shutting down task. Please execute the failover command").append(" on the local mirror topic to make the topic writable").toString();
            this.warn((Function0<String>)(Function0 & Serializable)() -> errMsg);
            return this.onCompletion(new ClusterLinkScheduler.TaskContext((Seq<TaskErrorCodeAndMsg>)((Seq)taskContext.errs().$plus$plus((IterableOnce)new .colon.colon((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg), (List)Nil$.MODULE$)))));
        }
    }

    private ClusterLinkScheduler.TaskResult onCompletion(ClusterLinkScheduler.TaskContext taskContext) {
        this.info((Function0<String>)(Function0 & Serializable)() -> "Shutting down ClusterLinkConvertToMirrorTopic task.");
        this.shutdown();
        Seq<TaskErrorCodeAndMsg> completedTask_errs = taskContext.errs();
        return new ClusterLinkScheduler.TaskResult(true, completedTask_errs);
    }

    @Override
    public void onCompletion(ClusterLinkScheduler.CompletedTaskResult result) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(27).append("Completed with task result ").append(result).toString());
        this.taskDesc_$eq(ClusterLinkTask$.MODULE$.handleResult(result, this.clientManager.metrics(), ClusterLinkConvertToMirrorTopicTaskType$.MODULE$, "transition the topic to a mirror"));
    }

    public Option<TaskDescription> taskDescription() {
        return this.taskDesc();
    }

    public ClusterLinkConvertToMirrorTopic(String topic, ClusterLinkDestClientManager clientManager, Function0<ClusterLinkLocalAdmin> localAdminFactory, Time time, ClusterLinkRequestQuota quota, int intervalMs) {
        this.topic = topic;
        this.clientManager = clientManager;
        this.localAdminFactory = localAdminFactory;
        super(clientManager.scheduler(), new StringBuilder(38).append("ClusterLinkConvertToMirrorTopic-topic-").append(topic).toString(), intervalMs, time, quota);
        this.shouldStartMirror = true;
        this.beginTask = true;
        this.metadataManager = clientManager.metadataManager();
        this.remoteAdmin = clientManager.getAdmin();
        this.numDescribeSourceTopicExceptions = 0;
        this.numSourceTopicMirrorStatusExceptions = 0;
        this.taskDesc = None$.MODULE$;
    }
}

