/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import io.confluent.kafka.link.ClusterLinkConfig;
import java.util.Collections;
import kafka.server.link.ConnectionMode;
import kafka.server.link.ConnectionMode$Inbound$;
import kafka.server.link.ConnectionMode$Outbound$;
import kafka.server.link.LinkType;
import org.apache.kafka.common.MetricName;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.runtime.ScalaRunTime$;

public final class ClusterLinkMetrics$ {
    public static final ClusterLinkMetrics$ MODULE$ = new ClusterLinkMetrics$();
    private static final String metricsGroup = "cluster-link-metrics";

    public String metricsGroup() {
        return metricsGroup;
    }

    public String activeClientConnectionsCountSensorName() {
        return "link-client-connections-sensor";
    }

    public MetricName activeClientConnectionsCountMetricName() {
        return new MetricName("link-client-connections-total", "cluster-link-metrics", "", Collections.emptyMap());
    }

    public String clientConnectionsThrottleSensorName() {
        return "link-client-connections-throttle-sensor";
    }

    public MetricName clientConnectionsThrottleRateMetricName() {
        return new MetricName("link-client-connections-throttle-rate", "cluster-link-metrics", "", Collections.emptyMap());
    }

    public String throttleTimeSensorName(String linkName) {
        return new StringBuilder(29).append("linked-fetcher-throttle-time-").append(linkName).toString();
    }

    public String unavailabilitySensorName(String linkName) {
        return new StringBuilder(17).append("link-unavailable-").append(linkName).toString();
    }

    public String kafka$server$link$ClusterLinkMetrics$$linkCountDescription(ClusterLinkConfig.LinkMode linkMode) {
        if (ClusterLinkConfig.LinkMode.DESTINATION.equals(linkMode)) {
            return "Number of destination links for this cluster.";
        }
        if (ClusterLinkConfig.LinkMode.SOURCE.equals(linkMode)) {
            return "Number of source links for this cluster.";
        }
        if (ClusterLinkConfig.LinkMode.BIDIRECTIONAL.equals(linkMode)) {
            return "Number of bidirectional links for this cluster.";
        }
        throw new IllegalArgumentException(new StringBuilder(30).append("Unsupported cluster link mode ").append(linkMode).toString());
    }

    public String kafka$server$link$ClusterLinkMetrics$$controllerReverseConnectionDescription(ConnectionMode connectionMode) {
        if (ConnectionMode$Inbound$.MODULE$.equals(connectionMode)) {
            return "Number of persistent reverse connections for this link from the remote cluster to this broker.";
        }
        if (ConnectionMode$Outbound$.MODULE$.equals(connectionMode)) {
            return "Number of persistent reverse connections for this link from this broker to the remote link coordinator.";
        }
        throw new IllegalArgumentException(new StringBuilder(41).append("Unsupported cluster link connection mode ").append(connectionMode).toString());
    }

    public String kafka$server$link$ClusterLinkMetrics$$reverseConnectionDescription(ConnectionMode connectionMode) {
        if (ConnectionMode$Inbound$.MODULE$.equals(connectionMode)) {
            return "Total number of reverse connections for this link from remote brokers to this broker.";
        }
        if (ConnectionMode$Outbound$.MODULE$.equals(connectionMode)) {
            return "Total number of reverse connections for this link from this broker to remote brokers.";
        }
        throw new IllegalArgumentException(new StringBuilder(28).append("Unsupported connection mode ").append(connectionMode).toString());
    }

    public Map<String, String> linkModeTag(ClusterLinkConfig.LinkMode linkMode) {
        return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"mode"), (Object)linkMode.lowerCaseName())}));
    }

    public Map<String, String> linkTypeTag(LinkType linkType) {
        return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"deployed-link-type"), (Object)linkType.lowerCaseName())}));
    }

    public Map<String, String> connectionModeTag(ConnectionMode connectionMode) {
        return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"connection-mode"), (Object)connectionMode.lowerCaseName())}));
    }

    public Map<String, String> remoteLinkConnectionModeTag(ConnectionMode connectionMode) {
        return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"remote-link-connection-mode"), (Object)connectionMode.lowerCaseName())}));
    }

    public Map<String, String> stateTag(String state) {
        return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"state"), (Object)state)}));
    }

    public Map<String, String> reasonTag(String reason) {
        return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"reason"), (Object)reason)}));
    }

    public Map<String, String> taskNameTag(String taskName) {
        return (Map)Predef$.MODULE$.Map().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"task-name"), (Object)taskName)}));
    }

    private ClusterLinkMetrics$() {
    }
}

