/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.tasks.delete;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import com.yammer.metrics.core.Meter;
import java.io.Serializable;
import java.util.concurrent.TimeUnit;
import kafka.cluster.Partition;
import kafka.log.AbstractLog;
import kafka.server.ReplicaManager;
import kafka.tier.TopicIdPartition;
import kafka.tier.fetcher.CancellationContext;
import kafka.tier.store.TierObjectStore;
import kafka.tier.tasks.TierTaskWorkingSet;
import kafka.tier.tasks.config.TierTasksConfig;
import kafka.tier.tasks.delete.DeletionMetrics;
import kafka.tier.tasks.delete.DeletionTask;
import kafka.tier.tasks.delete.DeletionTask$CollectDeletableObjects$;
import kafka.tier.tasks.delete.DeletionTaskQueue;
import kafka.tier.topic.TierTopicAppender;
import kafka.utils.Logging;
import kafka.utils.Throttler;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.SeqOps;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.List;
import scala.collection.immutable.Seq;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.LongRef;

@ScalaSignature(bytes="\u0006\u0005\t\rb\u0001B\u0013'\u0005=B\u0001\u0002\u0010\u0001\u0003\u0002\u0003\u0006I!\u0010\u0005\t\u0007\u0002\u0011\t\u0011)A\u0005\t\"A!\n\u0001B\u0001B\u0003%1\n\u0003\u0005R\u0001\t\u0005\t\u0015!\u0003S\u0011!A\u0006A!A!\u0002\u0013I\u0006\u0002\u0003/\u0001\u0005\u0003\u0005\u000b\u0011B/\t\u0011\t\u0004!\u0011!Q\u0001\n\rD\u0001b\u001c\u0001\u0003\u0002\u0003\u0006Y\u0001\u001d\u0005\u0006m\u0002!\ta\u001e\u0005\b\u0003\u000f\u0001A\u0011KA\u0005\u0011%\t\t\u0003\u0001b\u0001\n\u0013\t\u0019\u0003\u0003\u0005\u00024\u0001\u0001\u000b\u0011BA\u0013\u0011%\t)\u0004\u0001b\u0001\n\u0013\t9\u0004\u0003\u0005\u0002P\u0001\u0001\u000b\u0011BA\u001d\u0011%\t\t\u0006\u0001b\u0001\n\u0013\t9\u0004\u0003\u0005\u0002T\u0001\u0001\u000b\u0011BA\u001d\u0011%\t)\u0006\u0001b\u0001\n\u0013\t9\u0004\u0003\u0005\u0002X\u0001\u0001\u000b\u0011BA\u001d\u0011)\tI\u0006\u0001a\u0001\n\u00031\u00131\f\u0005\u000b\u0003G\u0002\u0001\u0019!C\u0001M\u0005\u0015\u0004\u0002CA9\u0001\u0001\u0006K!!\u0018\t\u0013\u0005m\u0004A1A\u0005\n\u0005u\u0004\u0002CAC\u0001\u0001\u0006I!a \t\u0015\u0005\u001d\u0005A1A\u0005\u0002!\nI\t\u0003\u0005\u0002\u0012\u0002\u0001\u000b\u0011BAF\u0011%\t\u0019\n\u0001b\u0001\n\u0013\t)\n\u0003\u0005\u0002&\u0002\u0001\u000b\u0011BAL\u0011!\t9\u000b\u0001C\u0001M\u0005%\u0006\u0002CAi\u0001\u0011\u0005a%a5\t\u000f\u00055\b\u0001\"\u0001\u0002p\"9\u0011\u0011\u001f\u0001\u0005\u0002\u0005M\bb\u0002B\u0001\u0001\u0011\u0005\u0011q^\u0004\n\u0005\u00071\u0013\u0011!E\u0001\u0005\u000b1\u0001\"\n\u0014\u0002\u0002#\u0005!q\u0001\u0005\u0007m\n\"\tA!\u0003\t\u0013\t-!%%A\u0005\u0002\t5!a\u0005+jKJ$U\r\\3uS>tW*\u00198bO\u0016\u0014(BA\u0014)\u0003\u0019!W\r\\3uK*\u0011\u0011FK\u0001\u0006i\u0006\u001c8n\u001d\u0006\u0003W1\nA\u0001^5fe*\tQ&A\u0003lC\u001a\\\u0017m\u0001\u0001\u0014\u0007\u0001\u0001d\u0007\u0005\u00022i5\t!GC\u00014\u0003\u0015\u00198-\u00197b\u0013\t)$G\u0001\u0004B]f\u0014VM\u001a\t\u0003oij\u0011\u0001\u000f\u0006\u0003s1\nQ!\u001e;jYNL!a\u000f\u001d\u0003\u000f1{wmZ5oO\u0006q!/\u001a9mS\u000e\fW*\u00198bO\u0016\u0014\bC\u0001 B\u001b\u0005y$B\u0001!-\u0003\u0019\u0019XM\u001d<fe&\u0011!i\u0010\u0002\u000f%\u0016\u0004H.[2b\u001b\u0006t\u0017mZ3s\u0003E!\u0018.\u001a:U_BL7-\u00119qK:$WM\u001d\t\u0003\u000b\"k\u0011A\u0012\u0006\u0003\u000f*\nQ\u0001^8qS\u000eL!!\u0013$\u0003#QKWM\u001d+pa&\u001c\u0017\t\u001d9f]\u0012,'/A\buS\u0016\u0014xJ\u00196fGR\u001cFo\u001c:f!\tau*D\u0001N\u0015\tq%&A\u0003ti>\u0014X-\u0003\u0002Q\u001b\nyA+[3s\u001f\nTWm\u0019;Ti>\u0014X-A\u0002dib\u0004\"a\u0015,\u000e\u0003QS!!\u0016\u0016\u0002\u000f\u0019,Go\u00195fe&\u0011q\u000b\u0016\u0002\u0014\u0007\u0006t7-\u001a7mCRLwN\\\"p]R,\u0007\u0010^\u0001\t[\u0006DH+Y:lgB\u0011\u0011GW\u0005\u00037J\u00121!\u00138u\u0003\u0019\u0019wN\u001c4jOB\u0011a\fY\u0007\u0002?*\u0011A\fK\u0005\u0003C~\u0013q\u0002V5feR\u000b7o[:D_:4\u0017nZ\u0001\u0005i&lW\r\u0005\u0002e[6\tQM\u0003\u0002:M*\u0011q\r[\u0001\u0007G>lWn\u001c8\u000b\u00055J'B\u00016l\u0003\u0019\t\u0007/Y2iK*\tA.A\u0002pe\u001eL!A\\3\u0003\tQKW.Z\u0001\u0003K\u000e\u0004\"!\u001d;\u000e\u0003IT!a\u001d\u001a\u0002\u0015\r|gnY;se\u0016tG/\u0003\u0002ve\n\u0001R\t_3dkRLwN\\\"p]R,\u0007\u0010^\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0017adXP`@\u0002\u0002\u0005\r\u0011Q\u0001\u000b\u0003sn\u0004\"A\u001f\u0001\u000e\u0003\u0019BQa\\\u0005A\u0004ADQ\u0001P\u0005A\u0002uBQaQ\u0005A\u0002\u0011CQAS\u0005A\u0002-CQ!U\u0005A\u0002ICQ\u0001W\u0005A\u0002eCQ\u0001X\u0005A\u0002uCqAY\u0005\u0011\u0002\u0003\u00071-\u0001\u0006m_\u001e<WM\u001d(b[\u0016,\"!a\u0003\u0011\t\u00055\u00111\u0004\b\u0005\u0003\u001f\t9\u0002E\u0002\u0002\u0012Ij!!a\u0005\u000b\u0007\u0005Ua&\u0001\u0004=e>|GOP\u0005\u0004\u00033\u0011\u0014A\u0002)sK\u0012,g-\u0003\u0003\u0002\u001e\u0005}!AB*ue&twMC\u0002\u0002\u001aI\nA\"\\3ue&\u001c7o\u0012:pkB,\"!!\n\u0011\t\u0005\u001d\u0012qF\u0007\u0003\u0003SQA!a\u000b\u0002.\u00059Q.\u001a;sS\u000e\u001c(B\u0001!i\u0013\u0011\t\t$!\u000b\u0003#-\u000bgm[1NKR\u0014\u0018nY:He>,\b/A\u0007nKR\u0014\u0018nY:He>,\b\u000fI\u0001\ne\u0016$(/\u001f*bi\u0016,\"!!\u000f\u0011\t\u0005m\u00121J\u0007\u0003\u0003{QA!a\u0010\u0002B\u0005!1m\u001c:f\u0015\u0011\tY#a\u0011\u000b\t\u0005\u0015\u0013qI\u0001\u0007s\u0006lW.\u001a:\u000b\u0005\u0005%\u0013aA2p[&!\u0011QJA\u001f\u0005\u0015iU\r^3s\u0003)\u0011X\r\u001e:z%\u0006$X\rI\u0001\u000fKb\u001cW\r\u001d;j_:\u001c(+\u0019;f\u0003=)\u0007pY3qi&|gn\u001d*bi\u0016\u0004\u0013a\u0006;jKJ\u001cVmZ7f]R$U\r\\3uS>t'+\u0019;f\u0003a!\u0018.\u001a:TK\u001elWM\u001c;EK2,G/[8o%\u0006$X\rI\u0001\u001di&,'oU3h[\u0016tG\u000fR3mKRLwN\\)vKV,7+\u001b>f+\t\ti\u0006E\u00022\u0003?J1!!\u00193\u0005\u0011auN\\4\u0002AQLWM]*fO6,g\u000e\u001e#fY\u0016$\u0018n\u001c8Rk\u0016,XmU5{K~#S-\u001d\u000b\u0005\u0003O\ni\u0007E\u00022\u0003SJ1!a\u001b3\u0005\u0011)f.\u001b;\t\u0013\u0005=D#!AA\u0002\u0005u\u0013a\u0001=%c\u0005iB/[3s'\u0016<W.\u001a8u\t\u0016dW\r^5p]F+X-^3TSj,\u0007\u0005K\u0002\u0016\u0003k\u00022!MA<\u0013\r\tIH\r\u0002\tm>d\u0017\r^5mK\u0006YB/[3s'\u0016<W.\u001a8u\t\u0016dW\r^5p]N\u0004VM\u001c3j]\u001e,\"!a \u0011\r\u0005m\u0012\u0011QA/\u0013\u0011\t\u0019)!\u0010\u0003\u000b\u001d\u000bWoZ3\u00029QLWM]*fO6,g\u000e\u001e#fY\u0016$\u0018n\u001c8t!\u0016tG-\u001b8hA\u0005IA/Y:l#V,W/Z\u000b\u0003\u0003\u0017\u00032A_AG\u0013\r\tyI\n\u0002\u0012\t\u0016dW\r^5p]R\u000b7o[)vKV,\u0017A\u0003;bg.\fV/Z;fA\u0005Qqo\u001c:lS:<7+\u001a;\u0016\u0005\u0005]\u0005CBAM\u00037\u000by*D\u0001)\u0013\r\ti\n\u000b\u0002\u0013)&,'\u000fV1tW^{'o[5oON+G\u000fE\u0002{\u0003CK1!a)'\u00051!U\r\\3uS>tG+Y:l\u0003-9xN]6j]\u001e\u001cV\r\u001e\u0011\u0002M\r|G\u000e\\3di\u0006cGnQ1oI&$\u0017\r^3TK\u001elWM\u001c;t\r>\u0014H)\u001a7fi&|g\u000e\u0006\u0002\u0002,B1\u0011QVA\\\u0003{sA!a,\u00024:!\u0011\u0011CAY\u0013\u0005\u0019\u0014bAA[e\u00059\u0001/Y2lC\u001e,\u0017\u0002BA]\u0003w\u00131aU3r\u0015\r\t)L\r\t\u0007\u0003[\u000by,a1\n\t\u0005\u0005\u00171\u0018\u0002\t\u0013R,'/\u00192mKB!\u0011QYAf\u001d\ra\u0015qY\u0005\u0004\u0003\u0013l\u0015a\u0004+jKJ|%M[3diN#xN]3\n\t\u00055\u0017q\u001a\u0002\u000f\u001f\nTWm\u0019;NKR\fG-\u0019;b\u0015\r\tI-T\u0001\u0015i>\u0004H*Y4hS:<\u0007+\u0019:uSRLwN\\:\u0015\r\u0005U\u0017Q]Au!\u0019\ti+a.\u0002XB1\u0011'!7\u0002^fK1!a73\u0005\u0019!V\u000f\u001d7feA!\u0011q\\Aq\u001b\u0005Q\u0013bAArU\t\u0001Bk\u001c9jG&#\u0007+\u0019:uSRLwN\u001c\u0005\b\u0003Ol\u0002\u0019AAV\u0003)\u0001\u0018M\u001d;ji&|gn\u001d\u0005\u0007\u0003Wl\u0002\u0019A-\u0002\u00079,X.\u0001\u000fsK\u000e|'\u000f\u001a#fY\u0016$\u0018n\u001c8t!\u0016tG-\u001b8h\u001b\u0016$(/[2\u0015\u0005\u0005\u001d\u0014A\u00023p/>\u00148\u000e\u0006\u0002\u0002vB1\u0011QVA|\u0003wLA!!?\u0002<\n!A*[:u!\u0015\t\u0018Q`AP\u0013\r\tyP\u001d\u0002\u0007\rV$XO]3\u0002\u0011MDW\u000f\u001e3po:\f1\u0003V5fe\u0012+G.\u001a;j_:l\u0015M\\1hKJ\u0004\"A\u001f\u0012\u0014\u0005\t\u0002DC\u0001B\u0003\u0003m!C.Z:tS:LG\u000fJ4sK\u0006$XM\u001d\u0013eK\u001a\fW\u000f\u001c;%oU\u0011!q\u0002\u0016\u0004G\nE1F\u0001B\n!\u0011\u0011)Ba\b\u000e\u0005\t]!\u0002\u0002B\r\u00057\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\tu!'\u0001\u0006b]:|G/\u0019;j_:LAA!\t\u0003\u0018\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3")
public final class TierDeletionManager
implements Logging {
    private final ReplicaManager replicaManager;
    private final CancellationContext ctx;
    private final TierTasksConfig config;
    private final KafkaMetricsGroup metricsGroup;
    private final Meter retryRate;
    private final Meter exceptionsRate;
    private final Meter tierSegmentDeletionRate;
    private volatile long tierSegmentDeletionQueueSize;
    private final Gauge<Object> tierSegmentDeletionsPending;
    private final DeletionTaskQueue taskQueue;
    private final TierTaskWorkingSet<DeletionTask> workingSet;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static Time $lessinit$greater$default$7() {
        return Time.SYSTEM;
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    @Override
    public String loggerName() {
        return TierDeletionManager.class.getName();
    }

    private KafkaMetricsGroup metricsGroup() {
        return this.metricsGroup;
    }

    private Meter retryRate() {
        return this.retryRate;
    }

    private Meter exceptionsRate() {
        return this.exceptionsRate;
    }

    private Meter tierSegmentDeletionRate() {
        return this.tierSegmentDeletionRate;
    }

    public long tierSegmentDeletionQueueSize() {
        return this.tierSegmentDeletionQueueSize;
    }

    public void tierSegmentDeletionQueueSize_$eq(long x$1) {
        this.tierSegmentDeletionQueueSize = x$1;
    }

    private Gauge<Object> tierSegmentDeletionsPending() {
        return this.tierSegmentDeletionsPending;
    }

    public DeletionTaskQueue taskQueue() {
        return this.taskQueue;
    }

    private TierTaskWorkingSet<DeletionTask> workingSet() {
        return this.workingSet;
    }

    public Seq<Iterable<TierObjectStore.ObjectMetadata>> collectAllCandidateSegmentsForDeletion() {
        LongRef queueSize = LongRef.create((long)0L);
        IndexedSeq out = this.replicaManager.leaderPartitionsIterator().filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)TierDeletionManager.$anonfun$collectAllCandidateSegmentsForDeletion$1(x$1))).flatMap((Function1 & Serializable)x$2 -> x$2.log()).filter((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)TierDeletionManager.$anonfun$collectAllCandidateSegmentsForDeletion$3(x$3))).filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)TierDeletionManager.$anonfun$collectAllCandidateSegmentsForDeletion$4(x$4))).filter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)TierDeletionManager.$anonfun$collectAllCandidateSegmentsForDeletion$5(x$5))).map((Function1 & Serializable)log -> {
            Iterable<TierObjectStore.ObjectMetadata> segments = DeletionTask$CollectDeletableObjects$.MODULE$.collectDeletableSegments((AbstractLog)log);
            queueSize$1.elem += (long)segments.size();
            return segments;
        }).toIndexedSeq();
        this.tierSegmentDeletionQueueSize_$eq(queueSize.elem);
        return out;
    }

    public Seq<Tuple2<TopicIdPartition, Object>> topLaggingPartitions(Seq<Iterable<TierObjectStore.ObjectMetadata>> partitions, int num) {
        return (Seq)((IterableOps)((IterableOps)((SeqOps)partitions.filter((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.nonEmpty()))).sortWith((Function2 & Serializable)(x$7, x$8) -> BoxesRunTime.boxToBoolean((boolean)TierDeletionManager.$anonfun$topLaggingPartitions$2(x$7, x$8)))).take(num)).map((Function1 & Serializable)tierObjects -> new Tuple2((Object)((TierObjectStore.ObjectMetadata)tierObjects.head()).topicIdPartition(), (Object)BoxesRunTime.boxToInteger((int)tierObjects.size())));
    }

    public void recordDeletionsPendingMetric() {
        Seq<Iterable<TierObjectStore.ObjectMetadata>> candidateSegmentsForDeletion = this.collectAllCandidateSegmentsForDeletion();
        Seq<Tuple2<TopicIdPartition, Object>> topTpids = this.topLaggingPartitions(candidateSegmentsForDeletion, 5);
        String logOutput = ((IterableOnceOps)((IterableOps)topTpids.zipWithIndex()).map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                Tuple2 id = (Tuple2)x0$1._1();
                int index = x0$1._2$mcI$sp();
                return new StringBuilder(17).append(index + 1).append(". (topic=").append(id._1()).append(", size=").append(id._2$mcI$sp()).append(")").toString();
            }
            throw new MatchError(null);
        })).mkString(", ");
        if (this.logger().underlying().isInfoEnabled()) {
            String msgWithLogIdent_msg = TierDeletionManager.$anonfun$recordDeletionsPendingMetric$2(topTpids, logOutput);
            Object var4_4 = null;
            this.logger().underlying().info(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
            return;
        }
    }

    public List<Future<DeletionTask>> doWork() {
        return this.workingSet().doWork(this.config, (Option<Throttler>)None$.MODULE$);
    }

    public void shutdown() {
        this.ctx.cancel();
        this.taskQueue().close();
    }

    public static final /* synthetic */ boolean $anonfun$collectAllCandidateSegmentsForDeletion$1(Partition x$1) {
        return !x$1.isUncleanLeader();
    }

    public static final /* synthetic */ boolean $anonfun$collectAllCandidateSegmentsForDeletion$3(AbstractLog x$3) {
        return x$3.tierPartitionState().isTieringEnabled();
    }

    public static final /* synthetic */ boolean $anonfun$collectAllCandidateSegmentsForDeletion$4(AbstractLog x$4) {
        return !x$4.isTierMetadataStateRecovering();
    }

    public static final /* synthetic */ boolean $anonfun$collectAllCandidateSegmentsForDeletion$5(AbstractLog x$5) {
        return !x$5.isFrozenLogStartOffsetState();
    }

    public static final /* synthetic */ boolean $anonfun$topLaggingPartitions$2(Iterable x$7, Iterable x$8) {
        return x$7.size() > x$8.size();
    }

    public static final /* synthetic */ String $anonfun$recordDeletionsPendingMetric$2(Seq topTpids$1, String logOutput$1) {
        return new StringBuilder(62).append("The top ").append(topTpids$1.size()).append(" lagging topic-partitions in TierDeletionManager are: ").append(logOutput$1).toString();
    }

    public TierDeletionManager(ReplicaManager replicaManager, TierTopicAppender tierTopicAppender, TierObjectStore tierObjectStore, CancellationContext ctx, int maxTasks, TierTasksConfig config, Time time, ExecutionContext ec) {
        this.replicaManager = replicaManager;
        this.ctx = ctx;
        this.config = config;
        this.metricsGroup = new KafkaMetricsGroup(this.getClass());
        this.metricsGroup().removeMetric("RetriesPerSec");
        this.retryRate = this.metricsGroup().newMeter("RetriesPerSec", "number of retries per second", TimeUnit.SECONDS);
        this.metricsGroup().removeMetric("ObjectStoreRetriableExceptionsPerSec");
        this.exceptionsRate = this.metricsGroup().newMeter("ObjectStoreRetriableExceptionsPerSec", "number of times TierObjectStoreRetriableException was invoked per second", TimeUnit.SECONDS);
        this.metricsGroup().removeMetric("TierSegmentDeletionsPerMinute");
        this.tierSegmentDeletionRate = this.metricsGroup().newMeter("TierSegmentDeletionsPerMinute", "number of transitions into InitiateDelete state in any DeletionTask per minute", TimeUnit.MINUTES);
        this.tierSegmentDeletionQueueSize = 0L;
        this.metricsGroup().removeMetric("TierSegmentDeletionsPending");
        this.tierSegmentDeletionsPending = this.metricsGroup().newGauge("TierSegmentDeletionsPending", (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ TierDeletionManager $outer;

            public long value() {
                return this.$outer.tierSegmentDeletionQueueSize();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        });
        this.taskQueue = new DeletionTaskQueue(ctx.subContext(), maxTasks, time, replicaManager, new DeletionMetrics((Option<Meter>)new Some((Object)this.retryRate()), (Option<Meter>)new Some((Object)this.exceptionsRate()), (Option<Meter>)new Some((Object)this.tierSegmentDeletionRate()), (Option<Gauge<Object>>)new Some(this.tierSegmentDeletionsPending())));
        this.workingSet = new TierTaskWorkingSet<DeletionTask>(this.taskQueue(), replicaManager, tierTopicAppender, tierObjectStore, time, ec);
    }
}

