/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.security.authorizer.rbac;

import io.confluent.common.security.auth.JwtPrincipal;
import io.confluent.common.security.util.JwtUtils;
import io.confluent.kafka.schemaregistry.rest.SchemaRegistryConfig;
import io.confluent.kafka.schemaregistry.security.SchemaRegistrySecurityResourceExtension;
import io.confluent.kafka.schemaregistry.security.authorizer.AbstractSchemaRegistryAuthorizer;
import io.confluent.kafka.schemaregistry.security.authorizer.AuthorizeRequest;
import io.confluent.kafka.schemaregistry.security.authorizer.AuthorizerException;
import io.confluent.kafka.schemaregistry.security.authorizer.SchemaRegistryResourceOperation;
import io.confluent.kafka.schemaregistry.security.authorizer.rbac.MdsBasicAuthProvider;
import io.confluent.kafka.schemaregistry.security.authorizer.rbac.SchemaRegistryActions;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistry;
import io.confluent.kafka.schemaregistry.utils.QualifiedSubject;
import io.confluent.security.auth.client.RestAuthorizer;
import io.confluent.security.auth.client.RestClientConfig;
import io.confluent.security.auth.client.provider.BuiltInAuthProviders;
import io.confluent.security.authorizer.Action;
import io.confluent.security.authorizer.AuthorizeResult;
import io.confluent.security.authorizer.Scope;
import java.io.IOException;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kafka.common.security.auth.ConfluentPrincipal;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RbacAuthorizer
extends AbstractSchemaRegistryAuthorizer {
    private static final Logger log = LoggerFactory.getLogger(RbacAuthorizer.class);
    private MdsBasicAuthProvider authProvider;
    private RestAuthorizer restAuthorizer;
    private SchemaRegistryActions schemaRegistryActions;

    public RbacAuthorizer() {
    }

    RbacAuthorizer(SchemaRegistry schemaRegistry, MdsBasicAuthProvider authProvider, RestAuthorizer restAuthorizer, SchemaRegistryActions schemaRegistryActions) throws AuthorizerException {
        super.configure(null, schemaRegistry);
        this.authProvider = authProvider;
        this.restAuthorizer = restAuthorizer;
        this.schemaRegistryActions = schemaRegistryActions;
    }

    @Override
    public void configure(SchemaRegistryConfig config, SchemaRegistry kafkaSchemaRegistry) throws AuthorizerException {
        super.configure(config, kafkaSchemaRegistry);
        RestClientConfig restClientConfig = new RestClientConfig(config.originals());
        if (BuiltInAuthProviders.HttpCredentialProviders.BASIC.name().equalsIgnoreCase(restClientConfig.getString("confluent.metadata.http.auth.credentials.provider"))) {
            this.authProvider = new MdsBasicAuthProvider();
            this.authProvider.configure(config.originals());
        }
        this.restAuthorizer = new RestAuthorizer();
        this.restAuthorizer.configure(config.originals());
        Scope scope = SchemaRegistrySecurityResourceExtension.determineScope(kafkaSchemaRegistry);
        this.schemaRegistryActions = new SchemaRegistryActions(scope);
        log.info("Initialized RBAC authorizer on cluster with scope of '{}'", (Object)scope);
    }

    @Override
    public boolean authorizeGlobalOperation(String user, SchemaRegistryResourceOperation schemaRegistryResourceOperation, AuthorizeRequest originalAuthorizeRequest) {
        if (SchemaRegistryResourceOperation.GLOBAL_READ.equals((Object)schemaRegistryResourceOperation)) {
            return true;
        }
        return this.authorizeRequest(originalAuthorizeRequest.getUser(), this.schemaRegistryActions.globalAction(schemaRegistryResourceOperation));
    }

    @Override
    public boolean authorizeSubjectOperation(String user, String subject, SchemaRegistryResourceOperation schemaRegistryResourceOperation, AuthorizeRequest originalAuthorizeRequest) {
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.add(this.schemaRegistryActions.subjectAction(schemaRegistryResourceOperation, subject));
        QualifiedSubject qs = QualifiedSubject.create((String)this.schemaRegistry().tenant(), (String)subject);
        String context = qs.getContext();
        if (!".".equals(context)) {
            String normalizedContext = QualifiedSubject.normalizeContext((String)context);
            actions.add(this.schemaRegistryActions.subjectAction(schemaRegistryResourceOperation, normalizedContext));
        }
        return this.authorizeActions(originalAuthorizeRequest.getUser(), actions).stream().anyMatch(b -> b);
    }

    @Override
    public boolean authorizeKekOperation(String user, String kekName, SchemaRegistryResourceOperation schemaRegistryResourceOperation, AuthorizeRequest originalAuthorizeRequest) {
        ArrayList<Action> actions = new ArrayList<Action>();
        actions.add(this.schemaRegistryActions.kekAction(schemaRegistryResourceOperation, kekName));
        return this.authorizeActions(originalAuthorizeRequest.getUser(), actions).stream().anyMatch(b -> b);
    }

    @Override
    public List<Boolean> bulkAuthorize(Principal principal, List<AuthorizeRequest> authorizeRequests) {
        if (authorizeRequests.isEmpty()) {
            return Collections.singletonList(false);
        }
        List<Action> actions = authorizeRequests.stream().map(this.schemaRegistryActions::action).collect(Collectors.toList());
        return this.authorizeActions(principal, actions);
    }

    @Override
    public void shutdown() {
        if (this.restAuthorizer != null) {
            try {
                this.restAuthorizer.close();
            }
            catch (IOException e) {
                log.error("Error while closing REST authorizer", (Throwable)e);
            }
            finally {
                this.restAuthorizer = null;
            }
        }
        if (this.authProvider != null) {
            this.authProvider.close();
            this.authProvider = null;
        }
    }

    protected boolean authorizeRequest(Principal principal, Action action) {
        return this.authorizeActions(principal, Collections.singletonList(action)).stream().allMatch(b -> b);
    }

    protected List<Boolean> authorizeActions(Principal principal, List<Action> actions) {
        log.info("Authorizing actions {} with principal {}", actions, (Object)principal);
        if (this.authProvider != null) {
            return this.restAuthorizer.authorize(this.authProvider.getCredentialProvider(), RbacAuthorizer.kafkaPrincipalFor(principal), null, actions).stream().map(arg_0 -> AuthorizeResult.ALLOWED.equals(arg_0)).collect(Collectors.toList());
        }
        return this.restAuthorizer.authorize(RbacAuthorizer.kafkaPrincipalFor(principal), null, actions).stream().map(arg_0 -> AuthorizeResult.ALLOWED.equals(arg_0)).collect(Collectors.toList());
    }

    public static KafkaPrincipal kafkaPrincipalFor(Principal userPrincipal) {
        Set groups;
        if (userPrincipal instanceof JwtPrincipal && !(groups = JwtUtils.getGroupsFromJwtPrincipal((JwtPrincipal)((JwtPrincipal)userPrincipal))).isEmpty()) {
            return new ConfluentPrincipal("User", userPrincipal.getName(), userPrincipal.getName(), Optional.empty(), false, groups);
        }
        return new KafkaPrincipal("User", userPrincipal.getName());
    }
}

