/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.security.authorizer.schemaregistryacl;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.confluent.kafka.schemaregistry.security.authorizer.schemaregistryacl.GlobalAclKey;
import io.confluent.kafka.schemaregistry.security.authorizer.schemaregistryacl.GlobalAclValue;
import io.confluent.kafka.schemaregistry.security.authorizer.schemaregistryacl.NoopKey;
import io.confluent.kafka.schemaregistry.security.authorizer.schemaregistryacl.SchemaRegistryAclKey;
import io.confluent.kafka.schemaregistry.security.authorizer.schemaregistryacl.SchemaRegistryAclValue;
import io.confluent.kafka.schemaregistry.security.authorizer.schemaregistryacl.SubjectAclKey;
import io.confluent.kafka.schemaregistry.security.authorizer.schemaregistryacl.SubjectAclValue;
import io.confluent.kafka.schemaregistry.storage.exceptions.SerializationException;
import java.io.IOException;
import java.util.Map;
import java.util.Set;
import javax.validation.ConstraintViolationException;
import javax.validation.Validation;
import javax.validation.ValidatorFactory;

public class AclMessageSerializer {
    private final ObjectMapper objectMapper;
    private ValidatorFactory factory = Validation.buildDefaultValidatorFactory();

    public AclMessageSerializer() {
        this.objectMapper = new ObjectMapper();
    }

    public byte[] serializeSchemaRegistryAclKey(Object key) throws SerializationException {
        try {
            return this.objectMapper.writeValueAsBytes(key);
        }
        catch (JsonProcessingException e) {
            throw new SerializationException("Error while serializing SchemaRegistryAclKey " + key.toString(), (Throwable)e);
        }
    }

    public SchemaRegistryAclKey deserializeSchemaRegistryAclKey(byte[] key) throws SerializationException {
        SchemaRegistryAclKey deserializedKey = null;
        try {
            Map keyObj = (Map)this.objectMapper.readValue(key, (TypeReference)new TypeReference<Map<Object, Object>>(){});
            SchemaRegistryAclKey.SchemaRegistryAclKeyType keyType = SchemaRegistryAclKey.SchemaRegistryAclKeyType.valueOf((String)keyObj.get("keytype"));
            switch (keyType) {
                case NOOP: {
                    deserializedKey = (SchemaRegistryAclKey)this.objectMapper.readValue(key, NoopKey.class);
                    break;
                }
                case SUBJECT_ACL: {
                    deserializedKey = (SchemaRegistryAclKey)this.objectMapper.readValue(key, SubjectAclKey.class);
                    break;
                }
                case GLOBAL_ACL: {
                    deserializedKey = (SchemaRegistryAclKey)this.objectMapper.readValue(key, GlobalAclKey.class);
                    break;
                }
                default: {
                    throw new SerializationException("Unknown schema registry ACL key type encountered " + (Object)((Object)keyType));
                }
            }
        }
        catch (IOException e) {
            throw new SerializationException("Error while deserializing SchemaRegistryAclKey", (Throwable)e);
        }
        return deserializedKey;
    }

    public byte[] serializeSchemaRegistryAclValue(SchemaRegistryAclValue schemaRegistryAclValue) throws SerializationException {
        if (schemaRegistryAclValue == null) {
            return null;
        }
        this.validateConstraints(schemaRegistryAclValue);
        try {
            return this.objectMapper.writeValueAsBytes((Object)schemaRegistryAclValue);
        }
        catch (JsonProcessingException e) {
            throw new SerializationException("Error while serializing SchemaRegistryAclValue" + schemaRegistryAclValue.toString(), (Throwable)e);
        }
    }

    private void validateConstraints(SchemaRegistryAclValue schemaRegistryAclValue) throws SerializationException {
        Set violations = this.factory.getValidator().validate((Object)schemaRegistryAclValue, new Class[0]);
        if (!violations.isEmpty()) {
            throw new SerializationException((Throwable)new ConstraintViolationException("Operation Failed", violations));
        }
    }

    public SchemaRegistryAclValue deserializeSchemaRegistryAclValue(SchemaRegistryAclKey.SchemaRegistryAclKeyType keyType, byte[] value) throws SerializationException {
        if (value == null) {
            return null;
        }
        SchemaRegistryAclValue deserializedValue = null;
        try {
            switch (keyType) {
                case SUBJECT_ACL: {
                    deserializedValue = (SchemaRegistryAclValue)this.objectMapper.readValue(value, SubjectAclValue.class);
                    break;
                }
                case GLOBAL_ACL: {
                    deserializedValue = (SchemaRegistryAclValue)this.objectMapper.readValue(value, GlobalAclValue.class);
                    break;
                }
                default: {
                    throw new SerializationException("Unknown schema registry ACL key type encountered " + (Object)((Object)keyType));
                }
            }
        }
        catch (IOException e) {
            throw new SerializationException("Error while deserializing SchemaRegistryAclValue", (Throwable)e);
        }
        this.validateConstraints(deserializedValue);
        return deserializedValue;
    }
}

