/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.security.permissions;

import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryException;
import io.confluent.kafka.schemaregistry.security.authorizer.AuthorizeRequest;
import io.confluent.kafka.schemaregistry.security.authorizer.AuthorizerException;
import io.confluent.kafka.schemaregistry.security.authorizer.SchemaRegistryAuthorizer;
import io.confluent.kafka.schemaregistry.security.authorizer.SchemaRegistryResourceOperation;
import io.confluent.kafka.schemaregistry.security.authorizer.rbac.SchemaRegistryOperations;
import io.confluent.kafka.schemaregistry.security.permissions.PermissionsBuilder;
import io.confluent.kafka.schemaregistry.security.permissions.entities.Permissions;
import io.confluent.kafka.schemaregistry.storage.LookupFilter;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistry;
import io.confluent.security.authorizer.Scope;
import java.security.Principal;
import java.util.EnumSet;
import java.util.Set;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.container.ContainerRequestContext;
import javax.ws.rs.core.Context;

@Path(value="/permissions")
@Produces(value={"application/json"})
public class PermissionsResource {
    private static final EnumSet<SchemaRegistryResourceOperation> GLOBAL_COMPATIBILITY_RESOURCE_OPERATIONS = EnumSet.of(SchemaRegistryResourceOperation.GLOBAL_COMPATIBILITY_READ, SchemaRegistryResourceOperation.GLOBAL_COMPATIBILITY_WRITE);
    private final Scope scope;
    private final SchemaRegistry schemaRegistry;
    private final SchemaRegistryAuthorizer authorizer;
    @Context
    HttpServletRequest httpServletRequest;

    public PermissionsResource(Scope scope, SchemaRegistry schemaRegistry, SchemaRegistryAuthorizer authorizer) {
        this.scope = scope;
        this.schemaRegistry = schemaRegistry;
        this.authorizer = authorizer;
    }

    @GET
    public Permissions getPermissions(@Context ContainerRequestContext requestContext) throws SchemaRegistryException, AuthorizerException {
        Principal principal = requestContext.getSecurityContext().getUserPrincipal();
        PermissionsBuilder permissionsBuilder = new PermissionsBuilder(principal).withAuthorizer(this.authorizer).withScope(this.scope);
        AuthorizeRequestUtils authorizeRequestUtils = new AuthorizeRequestUtils(principal, requestContext, this.httpServletRequest);
        Set subjects = this.schemaRegistry.listSubjects(LookupFilter.DEFAULT);
        subjects.forEach(subject -> permissionsBuilder.withRequests(SchemaRegistryOperations.SUBJECT_RESOURCE, (String)subject, SchemaRegistryResourceOperation.SUBJECT_RESOURCE_OPERATIONS.stream().map(op -> authorizeRequestUtils.subjectRequest((String)subject, (SchemaRegistryResourceOperation)((Object)((Object)op)))).collect(Collectors.toList())));
        permissionsBuilder.withRequests(SchemaRegistryOperations.SUBJECT_RESOURCE, "__GLOBAL", GLOBAL_COMPATIBILITY_RESOURCE_OPERATIONS.stream().map(authorizeRequestUtils::globalRequest).collect(Collectors.toList()));
        return permissionsBuilder.build();
    }

    private static class AuthorizeRequestUtils {
        private final Principal principal;
        private final ContainerRequestContext requestContext;
        private final HttpServletRequest httpServletRequest;

        public AuthorizeRequestUtils(Principal principal, ContainerRequestContext requestContext, HttpServletRequest httpServletRequest) {
            this.principal = principal;
            this.requestContext = requestContext;
            this.httpServletRequest = httpServletRequest;
        }

        public AuthorizeRequest subjectRequest(String subject, SchemaRegistryResourceOperation op) {
            return new AuthorizeRequest(this.principal, subject, op, this.requestContext, this.httpServletRequest);
        }

        public AuthorizeRequest globalRequest(SchemaRegistryResourceOperation op) {
            return new AuthorizeRequest(this.principal, null, op, this.requestContext, this.httpServletRequest);
        }
    }
}

