/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.dekregistry.storage;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import io.confluent.dekregistry.client.rest.entities.KeyType;
import io.confluent.dekregistry.storage.DataEncryptionKey;
import io.confluent.dekregistry.storage.EncryptionKeyId;
import io.confluent.dekregistry.storage.KeyEncryptionKey;
import java.util.Objects;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, include=JsonTypeInfo.As.EXISTING_PROPERTY, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=DataEncryptionKey.class, name="DEK"), @JsonSubTypes.Type(value=KeyEncryptionKey.class, name="KEK")})
public abstract class EncryptionKey {
    protected final KeyType type;
    protected final boolean deleted;
    protected Long offset;
    protected Long timestamp;

    @JsonCreator
    public EncryptionKey(@JsonProperty(value="type") KeyType type, @JsonProperty(value="deleted") boolean deleted) {
        this.type = type;
        this.deleted = deleted;
    }

    @JsonProperty(value="type")
    public KeyType getType() {
        return this.type;
    }

    @JsonProperty(value="deleted")
    public boolean isDeleted() {
        return this.deleted;
    }

    @JsonProperty(value="offset")
    public Long getOffset() {
        return this.offset;
    }

    @JsonProperty(value="offset")
    public void setOffset(Long offset) {
        this.offset = offset;
    }

    @JsonProperty(value="ts")
    public Long getTimestamp() {
        return this.timestamp;
    }

    @JsonProperty(value="ts")
    public void setTimestamp(Long timestamp) {
        this.timestamp = timestamp;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EncryptionKey that = (EncryptionKey)o;
        return this.deleted == that.deleted && this.type == that.type;
    }

    public int hashCode() {
        return Objects.hash(this.type, this.deleted);
    }

    public abstract EncryptionKeyId toKey(String var1);
}

