/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.dekregistry.web.rest.resources;

import com.google.common.base.CharMatcher;
import io.confluent.dekregistry.client.rest.entities.CreateDekRequest;
import io.confluent.dekregistry.client.rest.entities.CreateKekRequest;
import io.confluent.dekregistry.client.rest.entities.Dek;
import io.confluent.dekregistry.client.rest.entities.Kek;
import io.confluent.dekregistry.client.rest.entities.UpdateKekRequest;
import io.confluent.dekregistry.storage.DataEncryptionKey;
import io.confluent.dekregistry.storage.DekRegistry;
import io.confluent.dekregistry.storage.KeyEncryptionKey;
import io.confluent.dekregistry.storage.exceptions.AlreadyExistsException;
import io.confluent.dekregistry.storage.exceptions.DekGenerationException;
import io.confluent.dekregistry.storage.exceptions.InvalidKeyException;
import io.confluent.dekregistry.storage.exceptions.KeyNotSoftDeletedException;
import io.confluent.dekregistry.storage.exceptions.KeyReferenceExistsException;
import io.confluent.dekregistry.storage.exceptions.KeySoftDeletedException;
import io.confluent.dekregistry.storage.exceptions.TooManyKeysException;
import io.confluent.dekregistry.web.rest.exceptions.DekRegistryErrors;
import io.confluent.dekregistry.web.rest.resources.SchemaRegistryResource;
import io.confluent.kafka.schemaregistry.encryption.tink.DekFormat;
import io.confluent.kafka.schemaregistry.exceptions.InvalidVersionException;
import io.confluent.kafka.schemaregistry.exceptions.SchemaRegistryException;
import io.confluent.kafka.schemaregistry.rest.VersionId;
import io.confluent.kafka.schemaregistry.rest.exceptions.Errors;
import io.confluent.kafka.schemaregistry.rest.resources.DocumentedName;
import io.confluent.kafka.schemaregistry.rest.resources.RequestHeaderBuilder;
import io.confluent.kafka.schemaregistry.storage.SchemaRegistry;
import io.confluent.rest.annotations.PerformanceMetric;
import io.swagger.v3.oas.annotations.Operation;
import io.swagger.v3.oas.annotations.Parameter;
import io.swagger.v3.oas.annotations.media.ArraySchema;
import io.swagger.v3.oas.annotations.media.Content;
import io.swagger.v3.oas.annotations.media.Schema;
import io.swagger.v3.oas.annotations.responses.ApiResponse;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import javax.validation.constraints.NotNull;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.HttpHeaders;
import javax.ws.rs.core.Response;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="/dek-registry/v1/keks")
@Singleton
@Produces(value={"application/vnd.schemaregistry.v1+json", "application/vnd.schemaregistry+json; qs=0.9", "application/json; qs=0.5"})
@Consumes(value={"application/vnd.schemaregistry.v1+json", "application/vnd.schemaregistry+json", "application/json", "application/octet-stream"})
public class DekRegistryResource
extends SchemaRegistryResource {
    private static final Logger log = LoggerFactory.getLogger(DekRegistryResource.class);
    public static final int NAME_MAX_LENGTH = 256;
    private final DekRegistry dekRegistry;
    private final RequestHeaderBuilder requestHeaderBuilder = new RequestHeaderBuilder();

    @Inject
    public DekRegistryResource(SchemaRegistry schemaRegistry, DekRegistry dekRegistry) {
        super(schemaRegistry);
        this.dekRegistry = dekRegistry;
    }

    @GET
    @Operation(summary="Get a list of kek names.", responses={@ApiResponse(responseCode="200", description="List of kek names", content={@Content(array=@ArraySchema(schema=@Schema(example="mykek")))})})
    @PerformanceMetric(value="keks.list")
    @DocumentedName(value="getKekNames")
    public List<String> getKekNames(@Parameter(description="Subject name prefix") @QueryParam(value="subjectPrefix") List<String> subjectPrefix, @Parameter(description="Whether to include deleted keys") @QueryParam(value="deleted") boolean lookupDeleted) {
        return this.dekRegistry.getKekNames(subjectPrefix, lookupDeleted);
    }

    @GET
    @Path(value="/{name}")
    @Operation(summary="Get a kek by name.", responses={@ApiResponse(responseCode="200", description="The kek info", content={@Content(schema=@Schema(implementation=Kek.class))}), @ApiResponse(responseCode="404", description="Error code 40470 -- Key not found"), @ApiResponse(responseCode="422", description="Error code 42271 -- Invalid key")})
    @PerformanceMetric(value="keks.get")
    @DocumentedName(value="getKek")
    public Kek getKek(@Parameter(description="Name of the kek", required=true) @PathParam(value="name") String name, @Parameter(description="Whether to include deleted keys") @QueryParam(value="deleted") boolean lookupDeleted) {
        DekRegistryResource.checkName(name);
        KeyEncryptionKey key = this.dekRegistry.getKek(name, lookupDeleted);
        if (key == null) {
            throw DekRegistryErrors.keyNotFoundException(name);
        }
        return this.dekRegistry.toKekEntity(key);
    }

    @GET
    @Path(value="/{name}/deks")
    @Operation(summary="Get a list of dek subjects.", responses={@ApiResponse(responseCode="200", description="List of dek subjects", content={@Content(array=@ArraySchema(schema=@Schema(example="User")))}), @ApiResponse(responseCode="404", description="Error code 40470 -- Key not found"), @ApiResponse(responseCode="422", description="Error code 42271 -- Invalid key")})
    @PerformanceMetric(value="deks.list")
    @DocumentedName(value="getDekSubjects")
    public List<String> getDekSubjects(@Parameter(description="Name of the kek", required=true) @PathParam(value="name") String kekName, @Parameter(description="Whether to include deleted keys") @QueryParam(value="deleted") boolean lookupDeleted) {
        DekRegistryResource.checkName(kekName);
        KeyEncryptionKey key = this.dekRegistry.getKek(kekName, lookupDeleted);
        if (key == null) {
            throw DekRegistryErrors.keyNotFoundException(kekName);
        }
        return this.dekRegistry.getDekSubjects(kekName, lookupDeleted);
    }

    @GET
    @Path(value="/{name}/deks/{subject}")
    @Operation(summary="Get a dek by subject.", responses={@ApiResponse(responseCode="200", description="The dek info", content={@Content(schema=@Schema(implementation=Dek.class))}), @ApiResponse(responseCode="404", description="Error code 40470 -- Key not found"), @ApiResponse(responseCode="422", description="Error code 42271 -- Invalid key"), @ApiResponse(responseCode="500", description="Error code 50070 -- Dek generation error")})
    @PerformanceMetric(value="deks.get")
    @DocumentedName(value="getDek")
    public Dek getDek(@Parameter(description="Name of the kek", required=true) @PathParam(value="name") String kekName, @Parameter(description="Subject of the dek", required=true) @PathParam(value="subject") String subject, @Parameter(description="Algorithm of the dek") @QueryParam(value="algorithm") DekFormat algorithm, @Parameter(description="Whether to include deleted keys") @QueryParam(value="deleted") boolean lookupDeleted) {
        DekRegistryResource.checkName(kekName);
        DekRegistryResource.checkSubject(subject);
        try {
            KeyEncryptionKey kek = this.dekRegistry.getKek(kekName, lookupDeleted);
            if (kek == null) {
                throw DekRegistryErrors.keyNotFoundException(kekName);
            }
            DataEncryptionKey key = this.dekRegistry.getDek(kekName, subject, 1, algorithm, lookupDeleted);
            if (key == null) {
                throw DekRegistryErrors.keyNotFoundException(subject);
            }
            return key.toDekEntity();
        }
        catch (DekGenerationException e) {
            throw DekRegistryErrors.dekGenerationException(e.getMessage());
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException((String)"Error while retrieving key", (Throwable)e);
        }
    }

    @GET
    @Path(value="/{name}/deks/{subject}/versions")
    @Operation(summary="List versions of dek.", responses={@ApiResponse(responseCode="200", description="List of version numbers for dek", content={@Content(array=@ArraySchema(schema=@Schema(type="integer", format="int32", example="1")))}), @ApiResponse(responseCode="404", description="Error code 40470 -- Key not found"), @ApiResponse(responseCode="422", description="Error code 42271 -- Invalid key")})
    @PerformanceMetric(value="deks.versions.list")
    @DocumentedName(value="getAllDekVersions")
    public List<Integer> getDekVersions(@Parameter(description="Name of the kek", required=true) @PathParam(value="name") String kekName, @Parameter(description="Subject of the dek", required=true) @PathParam(value="subject") String subject, @Parameter(description="Algorithm of the dek") @QueryParam(value="algorithm") DekFormat algorithm, @Parameter(description="Whether to include deleted keys") @QueryParam(value="deleted") boolean lookupDeleted) {
        DekRegistryResource.checkName(kekName);
        DekRegistryResource.checkSubject(subject);
        KeyEncryptionKey kek = this.dekRegistry.getKek(kekName, lookupDeleted);
        if (kek == null) {
            throw DekRegistryErrors.keyNotFoundException(kekName);
        }
        return this.dekRegistry.getDekVersions(kekName, subject, algorithm, lookupDeleted);
    }

    @GET
    @Path(value="/{name}/deks/{subject}/versions/{version}")
    @Operation(summary="Get a dek by subject and version.", responses={@ApiResponse(responseCode="200", description="The dek info", content={@Content(schema=@Schema(implementation=Dek.class))}), @ApiResponse(responseCode="404", description="Error code 40470 -- Key not found"), @ApiResponse(responseCode="422", description="Unprocessable entity. Error code 42202 -- Invalid version. Error code 42271 -- Invalid key."), @ApiResponse(responseCode="500", description="Error code 50070 -- Dek generation error")})
    @PerformanceMetric(value="deks.versions.get")
    @DocumentedName(value="getDekByVersion")
    public Dek getDekByVersion(@Parameter(description="Name of the kek", required=true) @PathParam(value="name") String kekName, @Parameter(description="Subject of the dek", required=true) @PathParam(value="subject") String subject, @Parameter(description="Version of the dek", required=true) @PathParam(value="version") String version, @Parameter(description="Algorithm of the dek") @QueryParam(value="algorithm") DekFormat algorithm, @Parameter(description="Whether to include deleted keys") @QueryParam(value="deleted") boolean lookupDeleted) {
        VersionId versionId;
        DekRegistryResource.checkName(kekName);
        DekRegistryResource.checkSubject(subject);
        try {
            versionId = new VersionId(version);
        }
        catch (InvalidVersionException e) {
            throw Errors.invalidVersionException((String)e.getMessage());
        }
        try {
            KeyEncryptionKey kek = this.dekRegistry.getKek(kekName, lookupDeleted);
            if (kek == null) {
                throw DekRegistryErrors.keyNotFoundException(kekName);
            }
            DataEncryptionKey key = this.dekRegistry.getDek(kekName, subject, versionId.getVersionId(), algorithm, lookupDeleted);
            if (key == null) {
                throw DekRegistryErrors.keyNotFoundException(subject);
            }
            return key.toDekEntity();
        }
        catch (DekGenerationException e) {
            throw DekRegistryErrors.dekGenerationException(e.getMessage());
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException((String)"Error while retrieving key", (Throwable)e);
        }
    }

    @POST
    @Operation(summary="Create a kek.", responses={@ApiResponse(responseCode="200", description="The create response", content={@Content(schema=@Schema(implementation=Kek.class))}), @ApiResponse(responseCode="409", description="Conflict. Error code 40971 -- Key already exists. Error code 40972 -- Too many keys."), @ApiResponse(responseCode="422", description="Error code 42271 -- Invalid key")})
    @PerformanceMetric(value="keks.create")
    @DocumentedName(value="registerKek")
    public void createKek(@Suspended AsyncResponse asyncResponse, @Context HttpHeaders headers, @Parameter(description="Whether to test kek sharing") @QueryParam(value="testSharing") boolean testSharing, @Parameter(description="The create request", required=true) @NotNull CreateKekRequest request) {
        log.debug("Creating kek {}", (Object)request.getName());
        DekRegistryResource.checkName(request.getName());
        if (request.getKmsKeyId() == null || request.getKmsKeyId().isEmpty()) {
            throw DekRegistryErrors.invalidOrMissingKeyInfo("kmsKeyId");
        }
        if (request.getKmsType() == null) {
            throw DekRegistryErrors.invalidOrMissingKeyInfo("kmsType");
        }
        try {
            request.validate();
        }
        catch (Exception e) {
            throw DekRegistryErrors.invalidOrMissingKeyInfo("kmsKeyId");
        }
        Map headerProperties = this.requestHeaderBuilder.buildRequestHeaders(headers, this.getSchemaRegistry().config().whitelistHeaders());
        try {
            Object kek;
            if (request.isShared() && testSharing) {
                kek = new KeyEncryptionKey(request.getName(), request.getKmsType(), request.getKmsKeyId(), new TreeMap<String, String>(request.getKmsProps()), null, true, false);
                this.dekRegistry.testKek((KeyEncryptionKey)kek);
            }
            kek = this.dekRegistry.createKekOrForward(request, headerProperties);
            asyncResponse.resume(kek);
        }
        catch (AlreadyExistsException e) {
            throw DekRegistryErrors.alreadyExistsException(e.getMessage());
        }
        catch (TooManyKeysException e) {
            throw DekRegistryErrors.tooManyKeysException(this.dekRegistry.config().maxKeys());
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException((String)("Error while creating key: " + e.getMessage()), (Throwable)e);
        }
    }

    @POST
    @Path(value="/{name}/test")
    @Operation(summary="Test a kek.", responses={@ApiResponse(responseCode="200", description="The test response", content={@Content(schema=@Schema(implementation=Kek.class))}), @ApiResponse(responseCode="422", description="Error code 42271 -- Invalid key"), @ApiResponse(responseCode="500", description="Error code 50070 -- Dek generation error")})
    @PerformanceMetric(value="keks.test")
    @DocumentedName(value="testKek")
    public void testKek(@Suspended AsyncResponse asyncResponse, @Parameter(description="Name of the kek", required=true) @PathParam(value="name") String kekName) {
        log.debug("Testing kek {}", (Object)kekName);
        DekRegistryResource.checkName(kekName);
        KeyEncryptionKey kek = this.dekRegistry.getKek(kekName, false);
        if (kek == null) {
            throw DekRegistryErrors.keyNotFoundException(kekName);
        }
        try {
            this.dekRegistry.testKek(kek);
            asyncResponse.resume((Object)kek);
        }
        catch (DekGenerationException e) {
            throw DekRegistryErrors.dekGenerationException(e.getMessage());
        }
        catch (InvalidKeyException e) {
            throw DekRegistryErrors.invalidOrMissingKeyInfo(e.getMessage());
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException((String)"Error while testing key", (Throwable)e);
        }
    }

    @Deprecated
    @POST
    @Path(value="/{name}/deks")
    @Operation(summary="Create a dek.", responses={@ApiResponse(responseCode="200", description="The create response", content={@Content(schema=@Schema(implementation=Dek.class))}), @ApiResponse(responseCode="409", description="Conflict. Error code 40971 -- Key already exists. Error code 40972 -- Too many keys."), @ApiResponse(responseCode="422", description="Error code 42271 -- Invalid key"), @ApiResponse(responseCode="500", description="Error code 50070 -- Dek generation error")})
    @PerformanceMetric(value="deks.create")
    @DocumentedName(value="registerDek")
    public void createDek(@Suspended AsyncResponse asyncResponse, @Context HttpHeaders headers, @Parameter(description="Name of the kek", required=true) @PathParam(value="name") String kekName, @Parameter(description="The create request", required=true) @NotNull CreateDekRequest request) {
        this.createDekWithSubject(asyncResponse, headers, kekName, request.getSubject(), request);
    }

    @POST
    @Path(value="/{name}/deks/{subject}")
    @Operation(summary="Create a dek.", responses={@ApiResponse(responseCode="200", description="The create response", content={@Content(schema=@Schema(implementation=Dek.class))}), @ApiResponse(responseCode="409", description="Conflict. Error code 40971 -- Key already exists. Error code 40972 -- Too many keys."), @ApiResponse(responseCode="422", description="Error code 42271 -- Invalid key"), @ApiResponse(responseCode="500", description="Error code 50070 -- Dek generation error")})
    @PerformanceMetric(value="deks.create")
    @DocumentedName(value="registerDekWithSubject")
    public void createDekWithSubject(@Suspended AsyncResponse asyncResponse, @Context HttpHeaders headers, @Parameter(description="Name of the kek", required=true) @PathParam(value="name") String kekName, @Parameter(description="Subject of the dek", required=true) @PathParam(value="subject") String subject, @Parameter(description="The create request", required=true) @NotNull CreateDekRequest request) {
        log.debug("Creating dek {} for kek {}", (Object)subject, (Object)kekName);
        request.setSubject(subject);
        DekRegistryResource.checkName(kekName);
        DekRegistryResource.checkSubject(subject);
        KeyEncryptionKey kek = this.dekRegistry.getKek(kekName, request.isDeleted());
        if (kek == null) {
            throw DekRegistryErrors.keyNotFoundException(kekName);
        }
        Map headerProperties = this.requestHeaderBuilder.buildRequestHeaders(headers, this.getSchemaRegistry().config().whitelistHeaders());
        try {
            Dek dek = this.dekRegistry.createDekOrForward(kekName, request, headerProperties);
            asyncResponse.resume((Object)dek);
        }
        catch (AlreadyExistsException e) {
            throw DekRegistryErrors.alreadyExistsException(e.getMessage());
        }
        catch (DekGenerationException e) {
            throw DekRegistryErrors.dekGenerationException(e.getMessage());
        }
        catch (InvalidKeyException e) {
            throw DekRegistryErrors.invalidOrMissingKeyInfo(e.getMessage());
        }
        catch (TooManyKeysException e) {
            throw DekRegistryErrors.tooManyKeysException(this.dekRegistry.config().maxKeys());
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException((String)("Error while creating key: " + e.getMessage()), (Throwable)e);
        }
    }

    @PUT
    @Path(value="/{name}")
    @Operation(summary="Alters a kek.", responses={@ApiResponse(responseCode="200", description="The update response", content={@Content(schema=@Schema(implementation=Kek.class))}), @ApiResponse(responseCode="404", description="Error code 40470 -- Key not found"), @ApiResponse(responseCode="409", description="Error code 40971 -- Key already exists"), @ApiResponse(responseCode="422", description="Error code 42271 -- Invalid key")})
    @PerformanceMetric(value="keks.put")
    @DocumentedName(value="updateKek")
    public void putKek(@Suspended AsyncResponse asyncResponse, @Context HttpHeaders headers, @Parameter(description="Name of the kek", required=true) @PathParam(value="name") String name, @Parameter(description="Whether to test kek sharing") @QueryParam(value="testSharing") boolean testSharing, @Parameter(description="The update request", required=true) @NotNull UpdateKekRequest request) {
        log.debug("Updating kek {}", (Object)name);
        DekRegistryResource.checkName(name);
        KeyEncryptionKey oldKek = this.dekRegistry.getKek(name, false);
        if (oldKek == null) {
            throw DekRegistryErrors.keyNotFoundException(name);
        }
        Map headerProperties = this.requestHeaderBuilder.buildRequestHeaders(headers, this.getSchemaRegistry().config().whitelistHeaders());
        try {
            Kek kek;
            boolean shared;
            boolean bl = shared = request.isShared() != null ? request.isShared().booleanValue() : oldKek.isShared();
            if (shared && testSharing) {
                TreeMap<String, String> kmsProps = request.getKmsProps() != null ? new TreeMap(request.getKmsProps()) : oldKek.getKmsProps();
                KeyEncryptionKey newKek = new KeyEncryptionKey(name, oldKek.getKmsType(), oldKek.getKmsKeyId(), kmsProps, null, true, false);
                this.dekRegistry.testKek(newKek);
            }
            if ((kek = this.dekRegistry.putKekOrForward(name, request, headerProperties)) == null) {
                throw DekRegistryErrors.keyNotFoundException(name);
            }
            asyncResponse.resume((Object)kek);
        }
        catch (AlreadyExistsException e) {
            throw DekRegistryErrors.alreadyExistsException(e.getMessage());
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException((String)("Error while creating key: " + e.getMessage()), (Throwable)e);
        }
    }

    @DELETE
    @Path(value="/{name}")
    @Operation(summary="Delete a kek.", responses={@ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="404", description="Not found. Error code 40470 -- Key not found. Error code 40471 -- Key not soft-deleted."), @ApiResponse(responseCode="422", description="Unprocessable entity. Error code 42271 -- Invalid key. Error code 42272 -- References to key exist.")})
    @PerformanceMetric(value="keks.delete")
    @DocumentedName(value="deregisterKek")
    public void deleteKek(@Suspended AsyncResponse asyncResponse, @Context HttpHeaders headers, @Parameter(description="Name of the kek", required=true) @PathParam(value="name") String name, @Parameter(description="Whether to perform a permanent delete") @QueryParam(value="permanent") boolean permanentDelete) {
        log.debug("Deleting kek {}", (Object)name);
        DekRegistryResource.checkName(name);
        Map headerProperties = this.requestHeaderBuilder.buildRequestHeaders(headers, this.getSchemaRegistry().config().whitelistHeaders());
        try {
            KeyEncryptionKey kek = this.dekRegistry.getKek(name, true);
            if (kek == null) {
                throw DekRegistryErrors.keyNotFoundException(name);
            }
            this.dekRegistry.deleteKekOrForward(name, permanentDelete, headerProperties);
            asyncResponse.resume((Object)Response.status((int)204).build());
        }
        catch (KeyNotSoftDeletedException e) {
            throw DekRegistryErrors.keyNotSoftDeletedException(e.getName());
        }
        catch (KeyReferenceExistsException e) {
            throw DekRegistryErrors.referenceExistsException(e.getMessage());
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException((String)"Error while deleting key", (Throwable)e);
        }
    }

    @DELETE
    @Path(value="/{name}/deks/{subject}")
    @Operation(summary="Delete all versions of a dek.", responses={@ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="404", description="Not found. Error code 40470 -- Key not found. Error code 40471 -- Key not soft-deleted."), @ApiResponse(responseCode="422", description="Error code 42271 -- Invalid key")})
    @PerformanceMetric(value="deks.delete")
    @DocumentedName(value="deregisterDekVersions")
    public void deleteDekVersions(@Suspended AsyncResponse asyncResponse, @Context HttpHeaders headers, @Parameter(description="Name of the kek", required=true) @PathParam(value="name") String kekName, @Parameter(description="Subject of the dek", required=true) @PathParam(value="subject") String subject, @Parameter(description="Algorithm of the dek") @QueryParam(value="algorithm") DekFormat algorithm, @Parameter(description="Whether to perform a permanent delete") @QueryParam(value="permanent") boolean permanentDelete) {
        log.debug("Deleting dek {} for kek {}", (Object)subject, (Object)kekName);
        DekRegistryResource.checkName(kekName);
        DekRegistryResource.checkSubject(subject);
        Map headerProperties = this.requestHeaderBuilder.buildRequestHeaders(headers, this.getSchemaRegistry().config().whitelistHeaders());
        try {
            KeyEncryptionKey kek = this.dekRegistry.getKek(kekName, true);
            if (kek == null) {
                throw DekRegistryErrors.keyNotFoundException(kekName);
            }
            DataEncryptionKey key = this.dekRegistry.getLatestDek(kekName, subject, algorithm, true);
            if (key == null) {
                throw DekRegistryErrors.keyNotFoundException(subject);
            }
            this.dekRegistry.deleteDekOrForward(kekName, subject, algorithm, permanentDelete, headerProperties);
            asyncResponse.resume((Object)Response.status((int)204).build());
        }
        catch (KeyNotSoftDeletedException e) {
            throw DekRegistryErrors.keyNotSoftDeletedException(e.getName());
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException((String)"Error while deleting key", (Throwable)e);
        }
    }

    @DELETE
    @Path(value="/{name}/deks/{subject}/versions/{version}")
    @Operation(summary="Delete a dek version.", responses={@ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="404", description="Not found. Error code 40470 -- Key not found. Error code 40471 -- Key not soft-deleted."), @ApiResponse(responseCode="422", description="Unprocessable entity. Error code 42202 -- Invalid version. Error code 42271 -- Invalid key.")})
    @PerformanceMetric(value="deks.versions.delete")
    @DocumentedName(value="deregisterDekVersion")
    public void deleteDekVersion(@Suspended AsyncResponse asyncResponse, @Context HttpHeaders headers, @Parameter(description="Name of the kek", required=true) @PathParam(value="name") String kekName, @Parameter(description="Subject of the dek", required=true) @PathParam(value="subject") String subject, @Parameter(description="Version of the dek", required=true) @PathParam(value="version") String version, @Parameter(description="Algorithm of the dek") @QueryParam(value="algorithm") DekFormat algorithm, @Parameter(description="Whether to perform a permanent delete") @QueryParam(value="permanent") boolean permanentDelete) {
        VersionId versionId;
        log.debug("Deleting dek {} for kek {}", (Object)subject, (Object)kekName);
        DekRegistryResource.checkName(kekName);
        DekRegistryResource.checkSubject(subject);
        try {
            versionId = new VersionId(version);
        }
        catch (InvalidVersionException e) {
            throw Errors.invalidVersionException((String)e.getMessage());
        }
        Map headerProperties = this.requestHeaderBuilder.buildRequestHeaders(headers, this.getSchemaRegistry().config().whitelistHeaders());
        try {
            KeyEncryptionKey kek = this.dekRegistry.getKek(kekName, true);
            if (kek == null) {
                throw DekRegistryErrors.keyNotFoundException(kekName);
            }
            DataEncryptionKey key = this.dekRegistry.getDek(kekName, subject, versionId.getVersionId(), algorithm, true);
            if (key == null) {
                throw DekRegistryErrors.keyNotFoundException(subject);
            }
            this.dekRegistry.deleteDekVersionOrForward(kekName, subject, versionId.getVersionId(), algorithm, permanentDelete, headerProperties);
            asyncResponse.resume((Object)Response.status((int)204).build());
        }
        catch (KeyNotSoftDeletedException e) {
            throw DekRegistryErrors.keyNotSoftDeletedException(e.getName());
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException((String)"Error while deleting key", (Throwable)e);
        }
    }

    @POST
    @Path(value="/{name}/undelete")
    @Operation(summary="Undelete a kek.", responses={@ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="404", description="Error code 40470 -- Key not found"), @ApiResponse(responseCode="422", description="Unprocessable entity. Error code 42271 -- Invalid key. Error code 42272 -- References to key exist.")})
    @PerformanceMetric(value="keks.undelete")
    @DocumentedName(value="undeleteKek")
    public void undeleteKek(@Suspended AsyncResponse asyncResponse, @Context HttpHeaders headers, @Parameter(description="Name of the kek", required=true) @PathParam(value="name") String name) {
        log.debug("Undeleting kek {}", (Object)name);
        DekRegistryResource.checkName(name);
        Map headerProperties = this.requestHeaderBuilder.buildRequestHeaders(headers, this.getSchemaRegistry().config().whitelistHeaders());
        try {
            KeyEncryptionKey kek = this.dekRegistry.getKek(name, true);
            if (kek == null) {
                throw DekRegistryErrors.keyNotFoundException(name);
            }
            this.dekRegistry.undeleteKekOrForward(name, headerProperties);
            asyncResponse.resume((Object)Response.status((int)204).build());
        }
        catch (KeyReferenceExistsException e) {
            throw DekRegistryErrors.referenceExistsException(e.getMessage());
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException((String)"Error while undeleting key", (Throwable)e);
        }
    }

    @POST
    @Path(value="/{name}/deks/{subject}/undelete")
    @Operation(summary="Undelete all versions of a dek.", responses={@ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="404", description="Not found. Error code 40470 -- Key not found. Error code 40472 -- Key must be undeleted."), @ApiResponse(responseCode="422", description="Error code 42271 -- Invalid key")})
    @PerformanceMetric(value="deks.undelete")
    @DocumentedName(value="undeleteDekVersions")
    public void undeleteDekVersions(@Suspended AsyncResponse asyncResponse, @Context HttpHeaders headers, @Parameter(description="Name of the kek", required=true) @PathParam(value="name") String kekName, @Parameter(description="Subject of the dek", required=true) @PathParam(value="subject") String subject, @Parameter(description="Algorithm of the dek") @QueryParam(value="algorithm") DekFormat algorithm) {
        log.debug("Undeleting dek {} for kek {}", (Object)subject, (Object)kekName);
        DekRegistryResource.checkName(kekName);
        DekRegistryResource.checkSubject(subject);
        Map headerProperties = this.requestHeaderBuilder.buildRequestHeaders(headers, this.getSchemaRegistry().config().whitelistHeaders());
        try {
            KeyEncryptionKey kek = this.dekRegistry.getKek(kekName, true);
            if (kek == null) {
                throw DekRegistryErrors.keyNotFoundException(kekName);
            }
            DataEncryptionKey key = this.dekRegistry.getLatestDek(kekName, subject, algorithm, true);
            if (key == null) {
                throw DekRegistryErrors.keyNotFoundException(subject);
            }
            this.dekRegistry.undeleteDekOrForward(kekName, subject, algorithm, headerProperties);
            asyncResponse.resume((Object)Response.status((int)204).build());
        }
        catch (KeySoftDeletedException e) {
            throw DekRegistryErrors.keySoftDeletedException(e.getName());
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException((String)"Error while undeleting key", (Throwable)e);
        }
    }

    @POST
    @Path(value="/{name}/deks/{subject}/versions/{version}/undelete")
    @Operation(summary="Undelete a dek version.", responses={@ApiResponse(responseCode="204", description="No Content"), @ApiResponse(responseCode="404", description="Not found. Error code 40470 -- Key not found. Error code 40472 -- Key must be undeleted."), @ApiResponse(responseCode="422", description="Unprocessable entity. Error code 42202 -- Invalid version. Error code 42271 -- Invalid key.")})
    @PerformanceMetric(value="deks.versions.undelete")
    @DocumentedName(value="undeleteDekVersion")
    public void undeleteDekVersion(@Suspended AsyncResponse asyncResponse, @Context HttpHeaders headers, @Parameter(description="Name of the kek", required=true) @PathParam(value="name") String kekName, @Parameter(description="Subject of the dek", required=true) @PathParam(value="subject") String subject, @Parameter(description="Version of the dek", required=true) @PathParam(value="version") String version, @Parameter(description="Algorithm of the dek") @QueryParam(value="algorithm") DekFormat algorithm) {
        VersionId versionId;
        log.debug("Undeleting dek {} for kek {}", (Object)subject, (Object)kekName);
        DekRegistryResource.checkName(kekName);
        DekRegistryResource.checkSubject(subject);
        try {
            versionId = new VersionId(version);
        }
        catch (InvalidVersionException e) {
            throw Errors.invalidVersionException((String)e.getMessage());
        }
        Map headerProperties = this.requestHeaderBuilder.buildRequestHeaders(headers, this.getSchemaRegistry().config().whitelistHeaders());
        try {
            KeyEncryptionKey kek = this.dekRegistry.getKek(kekName, true);
            if (kek == null) {
                throw DekRegistryErrors.keyNotFoundException(kekName);
            }
            DataEncryptionKey key = this.dekRegistry.getDek(kekName, subject, versionId.getVersionId(), algorithm, true);
            if (key == null) {
                throw DekRegistryErrors.keyNotFoundException(subject);
            }
            this.dekRegistry.undeleteDekVersionOrForward(kekName, subject, versionId.getVersionId(), algorithm, headerProperties);
            asyncResponse.resume((Object)Response.status((int)204).build());
        }
        catch (KeySoftDeletedException e) {
            throw DekRegistryErrors.keySoftDeletedException(e.getName());
        }
        catch (SchemaRegistryException e) {
            throw Errors.schemaRegistryException((String)"Error while undeleting key", (Throwable)e);
        }
    }

    private static void checkName(String name) {
        if (name == null || name.isEmpty()) {
            throw DekRegistryErrors.invalidOrMissingKeyInfo("name");
        }
        if (name.length() > 256) {
            throw DekRegistryErrors.invalidOrMissingKeyInfo("name");
        }
        char first = name.charAt(0);
        if (!Character.isLetter(first) && first != '_') {
            throw DekRegistryErrors.invalidOrMissingKeyInfo("name");
        }
        for (int i = 1; i < name.length(); ++i) {
            char c = name.charAt(i);
            if (Character.isLetterOrDigit(c) || c == '_' || c == '-') continue;
            throw DekRegistryErrors.invalidOrMissingKeyInfo("name");
        }
    }

    private static void checkSubject(String subject) {
        if (subject == null || subject.isEmpty() || CharMatcher.javaIsoControl().matchesAnyOf((CharSequence)subject)) {
            throw DekRegistryErrors.invalidOrMissingKeyInfo("subject");
        }
    }
}

