/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.crypto.asymmetric;

import org.bouncycastle.asn1.ASN1OctetString;
import org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import org.bouncycastle.asn1.x9.X962Parameters;
import org.bouncycastle.asn1.x9.X9ECPoint;
import org.bouncycastle.asn1.x9.X9ObjectIdentifiers;
import org.bouncycastle.crypto.Algorithm;
import org.bouncycastle.crypto.AsymmetricPublicKey;
import org.bouncycastle.crypto.asymmetric.AsymmetricECKey;
import org.bouncycastle.crypto.asymmetric.ECDomainParameters;
import org.bouncycastle.crypto.asymmetric.ECDomainParametersID;
import org.bouncycastle.crypto.asymmetric.KeyUtils;
import org.bouncycastle.math.ec.ECPoint;
import org.bouncycastle.util.Properties;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public final class AsymmetricECPublicKey
extends AsymmetricECKey
implements AsymmetricPublicKey {
    private final ECPoint q;

    public AsymmetricECPublicKey(Algorithm algorithm, ECDomainParametersID eCDomainParametersID, byte[] byArray) {
        super(algorithm, eCDomainParametersID);
        this.q = KeyUtils.validated(this.getDomainParameters().getCurve(), byArray);
    }

    public AsymmetricECPublicKey(Algorithm algorithm, ECDomainParameters eCDomainParameters, byte[] byArray) {
        super(algorithm, eCDomainParameters);
        this.q = KeyUtils.validated(this.getDomainParameters().getCurve(), byArray);
    }

    public AsymmetricECPublicKey(Algorithm algorithm, ECDomainParametersID eCDomainParametersID, ECPoint eCPoint) {
        super(algorithm, eCDomainParametersID);
        this.q = KeyUtils.validated(this.getDomainParameters().getCurve(), eCPoint);
    }

    public AsymmetricECPublicKey(Algorithm algorithm, ECDomainParameters eCDomainParameters, ECPoint eCPoint) {
        super(algorithm, eCDomainParameters);
        this.q = KeyUtils.validated(this.getDomainParameters().getCurve(), eCPoint);
    }

    public AsymmetricECPublicKey(Algorithm algorithm, byte[] byArray) {
        this(algorithm, SubjectPublicKeyInfo.getInstance(byArray));
    }

    public AsymmetricECPublicKey(Algorithm algorithm, SubjectPublicKeyInfo subjectPublicKeyInfo) {
        super(algorithm, subjectPublicKeyInfo.getAlgorithm());
        byte[] byArray = subjectPublicKeyInfo.getPublicKeyData().getBytes();
        this.q = KeyUtils.validated(this.getDomainParameters().getCurve(), byArray);
    }

    @Override
    public byte[] getEncoded() {
        return this.getEncoded(Properties.isOverrideSet("org.bouncycastle.ec.enable_pc"));
    }

    public byte[] getEncoded(boolean bl) {
        ECDomainParameters eCDomainParameters = this.getDomainParameters();
        X962Parameters x962Parameters = KeyUtils.buildCurveParameters(eCDomainParameters);
        ASN1OctetString aSN1OctetString = ASN1OctetString.getInstance(new X9ECPoint(this.getW(), bl).toASN1Primitive());
        SubjectPublicKeyInfo subjectPublicKeyInfo = new SubjectPublicKeyInfo(new AlgorithmIdentifier(X9ObjectIdentifiers.id_ecPublicKey, x962Parameters), aSN1OctetString.getOctets());
        return KeyUtils.getEncodedInfo(subjectPublicKeyInfo);
    }

    public ECPoint getW() {
        return this.q;
    }

    @Override
    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (!(object instanceof AsymmetricECPublicKey)) {
            return false;
        }
        AsymmetricECPublicKey asymmetricECPublicKey = (AsymmetricECPublicKey)object;
        if (!this.q.equals(asymmetricECPublicKey.q)) {
            return false;
        }
        return this.getDomainParameters().equals(asymmetricECPublicKey.getDomainParameters());
    }

    @Override
    public int hashCode() {
        int n = this.q.hashCode();
        n = 31 * n + this.getDomainParameters().hashCode();
        return n;
    }
}

