/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.storage.checksum;

import java.util.Collections;
import org.apache.kafka.common.MetricName;
import org.apache.kafka.common.metrics.Gauge;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.MetricConfig;
import org.apache.kafka.common.metrics.MetricValueProvider;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.CumulativeCount;

public class E2EChecksumMetrics {
    public static final String ENTRY_NOT_FOUND_PREFIX = "EntryNotFoundTotal";
    public static final String SIZE_IN_BYTES_VAL_IS_GREATER_PREFIX = "SizeInBytesValIsGreaterTotal";
    public static final String SIZE_IN_BYTES_VAL_IS_LESSER_PREFIX = "SizeInBytesValIsLesserTotal";
    public static final String STORE_FILE_SIZE_PREFIX = "StoreFileSize";
    public static final String METRIC_GROUP_NAME = "E2EChecksum";
    private final Metrics metrics;
    private Sensor entryNotFound;
    private Sensor sizeInBytesValIsGreater;
    private Sensor sizeInBytesValIsLesser;
    private final LongGauge storeFileSize = new LongGauge(0L);
    private MetricName storeFileSizeMetricName;

    public E2EChecksumMetrics(Metrics metrics) {
        this.metrics = metrics;
        this.register();
    }

    private void register() {
        this.addSensors();
        this.addGauges();
    }

    private void addSensors() {
        this.addEntryNotFoundSensor();
        this.addSizeInBytesIsGreaterSensor();
        this.addSizeInBytesIsLesserSensor();
    }

    private void addGauges() {
        this.addStoreFileSizeGauge();
    }

    public void deRegister() {
        this.metrics.removeSensor(ENTRY_NOT_FOUND_PREFIX);
        this.metrics.removeSensor(SIZE_IN_BYTES_VAL_IS_GREATER_PREFIX);
        this.metrics.removeSensor(SIZE_IN_BYTES_VAL_IS_LESSER_PREFIX);
        this.metrics.removeMetric(this.storeFileSizeMetricName);
    }

    private void addEntryNotFoundSensor() {
        this.entryNotFound = this.metrics.sensor(ENTRY_NOT_FOUND_PREFIX);
        MetricName entryNotFoundMetricName = this.metrics.metricName(ENTRY_NOT_FOUND_PREFIX, METRIC_GROUP_NAME, "The total number of entry not found cases");
        this.entryNotFound.add(entryNotFoundMetricName, (MeasurableStat)new CumulativeCount());
    }

    private void addSizeInBytesIsGreaterSensor() {
        this.sizeInBytesValIsGreater = this.metrics.sensor(SIZE_IN_BYTES_VAL_IS_GREATER_PREFIX);
        MetricName sizeInBytesValIsGreaterMetricName = this.metrics.metricName(SIZE_IN_BYTES_VAL_IS_GREATER_PREFIX, METRIC_GROUP_NAME, "The total number of sizeInBytes value greater than file size cases");
        this.sizeInBytesValIsGreater.add(sizeInBytesValIsGreaterMetricName, (MeasurableStat)new CumulativeCount());
    }

    private void addSizeInBytesIsLesserSensor() {
        this.sizeInBytesValIsLesser = this.metrics.sensor(SIZE_IN_BYTES_VAL_IS_LESSER_PREFIX);
        MetricName sizeInBytesValIsLesserMetricName = this.metrics.metricName(SIZE_IN_BYTES_VAL_IS_LESSER_PREFIX, METRIC_GROUP_NAME, "The total number of sizeInBytes value lesser than file size cases");
        this.sizeInBytesValIsLesser.add(sizeInBytesValIsLesserMetricName, (MeasurableStat)new CumulativeCount());
    }

    private void addStoreFileSizeGauge() {
        this.storeFileSizeMetricName = this.metrics.metricName(STORE_FILE_SIZE_PREFIX, METRIC_GROUP_NAME, "Long value indicating E2EChecksumStore file size in bytes", Collections.emptyMap());
        this.metrics.addMetricIfAbsent(this.storeFileSizeMetricName, null, (MetricValueProvider)this.storeFileSize);
    }

    public void recordEntryNotFound() {
        this.entryNotFound.record();
    }

    public void recordSizeInBytesValIsGreater() {
        this.sizeInBytesValIsGreater.record();
    }

    public void recordSizeInBytesValIsLesser() {
        this.sizeInBytesValIsLesser.record();
    }

    public void recordStoreFileSize(long size) {
        this.storeFileSize.record(size);
    }

    static class LongGauge
    implements Gauge<Long> {
        private volatile long value;

        LongGauge(Long initialValue) {
            this.value = initialValue;
        }

        public synchronized Long value(MetricConfig config, long now) {
            return this.value;
        }

        public synchronized long record(long value) {
            this.value = value;
            return this.value;
        }
    }
}

