/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kafka.storage.internals.log;

import java.util.List;
import java.util.Optional;
import org.apache.kafka.common.message.FetchResponseData;
import org.apache.kafka.common.record.MemoryRecords;
import org.apache.kafka.common.record.Records;
import org.apache.kafka.storage.internals.log.AbstractFetchDataInfo;
import org.apache.kafka.storage.internals.log.LogOffsetMetadata;
import org.apache.kafka.storage.internals.log.RemoteStorageFetchInfo;

public class FetchDataInfo
implements AbstractFetchDataInfo {
    public static final FetchDataInfo EMPTY = new FetchDataInfo(LogOffsetMetadata.UNKNOWN_OFFSET_METADATA, (Records)MemoryRecords.EMPTY);
    public final LogOffsetMetadata fetchOffsetMetadata;
    public final Records records;
    public final boolean firstEntryIncomplete;
    public final Optional<List<FetchResponseData.AbortedTransaction>> abortedTransactions;
    public final Optional<RemoteStorageFetchInfo> delayedRemoteStorageFetch;

    public FetchDataInfo(LogOffsetMetadata fetchOffsetMetadata, Records records) {
        this(fetchOffsetMetadata, records, false, Optional.empty());
    }

    public FetchDataInfo(LogOffsetMetadata fetchOffsetMetadata, Records records, boolean firstEntryIncomplete, Optional<List<FetchResponseData.AbortedTransaction>> abortedTransactions) {
        this(fetchOffsetMetadata, records, firstEntryIncomplete, abortedTransactions, Optional.empty());
    }

    public FetchDataInfo(LogOffsetMetadata fetchOffsetMetadata, Records records, boolean firstEntryIncomplete, Optional<List<FetchResponseData.AbortedTransaction>> abortedTransactions, Optional<RemoteStorageFetchInfo> delayedRemoteStorageFetch) {
        this.fetchOffsetMetadata = fetchOffsetMetadata;
        this.records = records;
        this.firstEntryIncomplete = firstEntryIncomplete;
        this.abortedTransactions = abortedTransactions;
        this.delayedRemoteStorageFetch = delayedRemoteStorageFetch;
    }

    @Override
    public Optional<List<FetchResponseData.AbortedTransaction>> abortedTransactions() {
        return this.abortedTransactions;
    }

    public static FetchDataInfo empty(long fetchOffset) {
        return new FetchDataInfo(new LogOffsetMetadata(fetchOffset), (Records)MemoryRecords.EMPTY);
    }
}

