/*
 * Decompiled with CFR 0.152.
 */
package org.bouncycastle.tls;

import java.io.IOException;
import org.bouncycastle.tls.AbstractTlsKeyExchangeFactory;
import org.bouncycastle.tls.TlsDHEKeyExchange;
import org.bouncycastle.tls.TlsDHGroupVerifier;
import org.bouncycastle.tls.TlsDHKeyExchange;
import org.bouncycastle.tls.TlsDHanonKeyExchange;
import org.bouncycastle.tls.TlsECDHEKeyExchange;
import org.bouncycastle.tls.TlsECDHKeyExchange;
import org.bouncycastle.tls.TlsECDHanonKeyExchange;
import org.bouncycastle.tls.TlsKeyExchange;
import org.bouncycastle.tls.TlsPSKIdentity;
import org.bouncycastle.tls.TlsPSKIdentityManager;
import org.bouncycastle.tls.TlsPSKKeyExchange;
import org.bouncycastle.tls.TlsRSAKeyExchange;
import org.bouncycastle.tls.TlsSRPConfigVerifier;
import org.bouncycastle.tls.TlsSRPIdentity;
import org.bouncycastle.tls.TlsSRPKeyExchange;
import org.bouncycastle.tls.TlsSRPLoginParameters;
import org.bouncycastle.tls.crypto.TlsDHConfig;
import org.bouncycastle.tls.crypto.TlsECConfig;

/*
 * Multiple versions of this class in jar - see https://www.benf.org/other/cfr/multi-version-jar.html
 */
public class DefaultTlsKeyExchangeFactory
extends AbstractTlsKeyExchangeFactory {
    @Override
    public TlsKeyExchange createDHKeyExchange(int keyExchange) throws IOException {
        return new TlsDHKeyExchange(keyExchange);
    }

    @Override
    public TlsKeyExchange createDHanonKeyExchangeClient(int keyExchange, TlsDHGroupVerifier dhGroupVerifier) throws IOException {
        return new TlsDHanonKeyExchange(keyExchange, dhGroupVerifier);
    }

    @Override
    public TlsKeyExchange createDHanonKeyExchangeServer(int keyExchange, TlsDHConfig dhConfig) throws IOException {
        return new TlsDHanonKeyExchange(keyExchange, dhConfig);
    }

    @Override
    public TlsKeyExchange createDHEKeyExchangeClient(int keyExchange, TlsDHGroupVerifier dhGroupVerifier) throws IOException {
        return new TlsDHEKeyExchange(keyExchange, dhGroupVerifier);
    }

    @Override
    public TlsKeyExchange createDHEKeyExchangeServer(int keyExchange, TlsDHConfig dhConfig) throws IOException {
        return new TlsDHEKeyExchange(keyExchange, dhConfig);
    }

    @Override
    public TlsKeyExchange createECDHKeyExchange(int keyExchange) throws IOException {
        return new TlsECDHKeyExchange(keyExchange);
    }

    @Override
    public TlsKeyExchange createECDHanonKeyExchangeClient(int keyExchange) throws IOException {
        return new TlsECDHanonKeyExchange(keyExchange);
    }

    @Override
    public TlsKeyExchange createECDHanonKeyExchangeServer(int keyExchange, TlsECConfig ecConfig) throws IOException {
        return new TlsECDHanonKeyExchange(keyExchange, ecConfig);
    }

    @Override
    public TlsKeyExchange createECDHEKeyExchangeClient(int keyExchange) throws IOException {
        return new TlsECDHEKeyExchange(keyExchange);
    }

    @Override
    public TlsKeyExchange createECDHEKeyExchangeServer(int keyExchange, TlsECConfig ecConfig) throws IOException {
        return new TlsECDHEKeyExchange(keyExchange, ecConfig);
    }

    @Override
    public TlsKeyExchange createPSKKeyExchangeClient(int keyExchange, TlsPSKIdentity pskIdentity, TlsDHGroupVerifier dhGroupVerifier) throws IOException {
        return new TlsPSKKeyExchange(keyExchange, pskIdentity, dhGroupVerifier);
    }

    @Override
    public TlsKeyExchange createPSKKeyExchangeServer(int keyExchange, TlsPSKIdentityManager pskIdentityManager, TlsDHConfig dhConfig, TlsECConfig ecConfig) throws IOException {
        return new TlsPSKKeyExchange(keyExchange, pskIdentityManager, dhConfig, ecConfig);
    }

    @Override
    public TlsKeyExchange createRSAKeyExchange(int keyExchange) throws IOException {
        return new TlsRSAKeyExchange(keyExchange);
    }

    @Override
    public TlsKeyExchange createSRPKeyExchangeClient(int keyExchange, TlsSRPIdentity srpIdentity, TlsSRPConfigVerifier srpConfigVerifier) throws IOException {
        return new TlsSRPKeyExchange(keyExchange, srpIdentity, srpConfigVerifier);
    }

    @Override
    public TlsKeyExchange createSRPKeyExchangeServer(int keyExchange, TlsSRPLoginParameters loginParameters) throws IOException {
        return new TlsSRPKeyExchange(keyExchange, loginParameters);
    }
}

