/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant;

import io.confluent.kafka.multitenant.InetAddressToTenantMapping;
import java.net.InetAddress;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.function.Supplier;

public class InetAddressToTenantContext
implements InetAddressToTenantMapping {
    private Map<InetAddress, String> inetAddressToTenant;
    private Map<InetAddress, String> inetAddressToAPIKey;
    private Supplier<Boolean> trackInetAddressToTenantEnabled;
    private Supplier<Boolean> trackInetAddressToAPIKeyEnabled;
    private Map<String, Integer> tenantIdToInetAddressCounts = new ConcurrentHashMap<String, Integer>();
    private Map<String, Integer> apiKeyToInetAddressCounts = new ConcurrentHashMap<String, Integer>();
    private AtomicInteger tenantRemappedCount;
    private AtomicInteger apiKeyRemappedCount;

    public InetAddressToTenantContext(Supplier<Boolean> trackInetAddressToTenant, Supplier<Boolean> trackInetAddressToAPIKey, Supplier<Integer> inetMappingSize) {
        this.inetAddressToTenant = InetAddressToTenantContext.lruLinkedHashMap(inetMappingSize, this.tenantIdToInetAddressCounts);
        this.inetAddressToAPIKey = InetAddressToTenantContext.lruLinkedHashMap(inetMappingSize, this.apiKeyToInetAddressCounts);
        this.tenantRemappedCount = new AtomicInteger();
        this.apiKeyRemappedCount = new AtomicInteger();
        this.trackInetAddressToTenantEnabled = trackInetAddressToTenant;
        this.trackInetAddressToAPIKeyEnabled = trackInetAddressToAPIKey;
    }

    public boolean isTrackInetAddressToTenantEnabled() {
        return this.trackInetAddressToTenantEnabled.get();
    }

    public boolean isTrackInetAddressToAPIKeyEnabled() {
        return this.trackInetAddressToAPIKeyEnabled.get();
    }

    @Override
    public Optional<String> tenant(InetAddress address) {
        return Optional.ofNullable(this.inetAddressToTenant.get(address));
    }

    @Override
    public Optional<String> apiKey(InetAddress address) {
        return Optional.ofNullable(this.inetAddressToAPIKey.get(address));
    }

    public Map<InetAddress, String> getInetAddressToTenant() {
        return this.inetAddressToTenant;
    }

    public Map<InetAddress, String> getInetAddressToAPIKey() {
        return this.inetAddressToAPIKey;
    }

    public int apiKeyMappedCount() {
        return this.inetAddressToAPIKey.size();
    }

    public int apiKeyRemappedCount() {
        return this.apiKeyRemappedCount.get();
    }

    public int tenantMappedCount() {
        return this.inetAddressToTenant.size();
    }

    public int tenantRemappedCount() {
        return this.tenantRemappedCount.get();
    }

    public int tenantCount() {
        return this.tenantIdToInetAddressCounts.size();
    }

    public int apiKeyCount() {
        return this.apiKeyToInetAddressCounts.size();
    }

    public void trackAPIKeyByInetAddress(InetAddress inetAddress, String apiKey) {
        this.trackEntityByInetAddress(this.inetAddressToAPIKey, inetAddress, apiKey, this.apiKeyRemappedCount, this.apiKeyToInetAddressCounts);
    }

    public void trackTenantIdByInetAddress(InetAddress inetAddress, String tenantId) {
        this.trackEntityByInetAddress(this.inetAddressToTenant, inetAddress, tenantId, this.tenantRemappedCount, this.tenantIdToInetAddressCounts);
    }

    private synchronized void trackEntityByInetAddress(Map<InetAddress, String> inetAddressToEntity, InetAddress inetAddress, String value, AtomicInteger remappedCounts, Map<String, Integer> entityToCounts) {
        if (inetAddressToEntity.containsKey(inetAddress) && !Objects.equals(value, inetAddressToEntity.get(inetAddress))) {
            remappedCounts.incrementAndGet();
        }
        if (inetAddressToEntity.containsKey(inetAddress)) {
            InetAddressToTenantContext.decrement(entityToCounts, inetAddressToEntity.get(inetAddress));
        }
        entityToCounts.put(value, 1 + entityToCounts.getOrDefault(value, 0));
        inetAddressToEntity.put(inetAddress, value);
    }

    private static Map<InetAddress, String> lruLinkedHashMap(final Supplier<Integer> inetMappingSize, final Map<String, Integer> entityToCounts) {
        return Collections.synchronizedMap(new LinkedHashMap<InetAddress, String>(16, 0.75f, true){

            @Override
            protected synchronized boolean removeEldestEntry(Map.Entry<InetAddress, String> eldest) {
                boolean evicted;
                boolean bl = evicted = this.size() > (Integer)inetMappingSize.get();
                if (evicted) {
                    InetAddressToTenantContext.decrement(entityToCounts, eldest.getValue());
                }
                return evicted;
            }
        });
    }

    private static void decrement(Map<String, Integer> counts, String key) {
        int count = counts.getOrDefault(key, 0);
        if (count <= 1) {
            counts.remove(key);
        } else {
            counts.put(key, count - 1);
        }
    }
}

