/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.audit.kafka;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.BooleanNode;
import com.fasterxml.jackson.databind.node.JsonNodeFactory;
import com.fasterxml.jackson.databind.node.ObjectNode;
import com.fasterxml.jackson.databind.node.ShortNode;
import com.fasterxml.jackson.databind.node.TextNode;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.Struct;
import com.google.protobuf.util.JsonFormat;
import io.confluent.protobuf.events.auditlog.v2.AuditLog;
import io.confluent.protobuf.events.auditlog.v2.Result;
import io.confluent.protobuf.events.auditlog.v2.TypedCloudResourceRef;
import io.confluent.security.audit.AuditLogUtils;
import io.confluent.security.audit.kafka.AuditExtractorOptions;
import io.confluent.security.authorizer.ResourcePattern;
import java.util.ArrayList;
import java.util.List;
import org.apache.kafka.common.message.CreateClusterLinksRequestData;
import org.apache.kafka.common.message.CreateClusterLinksRequestDataJsonConverter;
import org.apache.kafka.common.message.CreateClusterLinksResponseData;
import org.apache.kafka.common.message.CreateClusterLinksResponseDataJsonConverter;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.server.audit.KafkaRequestEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateClusterLinksAuditExtractor {
    private static final Logger log = LoggerFactory.getLogger(CreateClusterLinksAuditExtractor.class);

    public static List<AuditLog> extract(KafkaRequestEvent requestEvent, AuditExtractorOptions extractorOptions) throws Exception {
        ArrayList<AuditLog> extractedAuditLogs = new ArrayList<AuditLog>();
        CreateClusterLinksRequestData createClusterLinksRequestData = CreateClusterLinksRequestDataJsonConverter.read((JsonNode)requestEvent.requestPayload(), (short)((short)requestEvent.requestContext().requestVersion()));
        CreateClusterLinksResponseData createClusterLinksResponseData = CreateClusterLinksResponseDataJsonConverter.read((JsonNode)requestEvent.responsePayload(), (short)((short)requestEvent.requestContext().requestVersion()));
        boolean validateOnly = createClusterLinksRequestData.validateOnly();
        boolean validateLink = createClusterLinksRequestData.validateLink();
        for (CreateClusterLinksRequestData.EntryData entryData : createClusterLinksRequestData.entries()) {
            String linkName = "";
            linkName = entryData.linkName();
            CreateClusterLinksResponseData.EntryData clusterLinkResult = CreateClusterLinksAuditExtractor.extractClusterLinkResult(createClusterLinksResponseData, linkName);
            boolean hasAuthorizationFailure = AuditLogUtils.hasAuthorizationFailure(clusterLinkResult.errorCode());
            Struct requestData = CreateClusterLinksAuditExtractor.requestData(entryData, requestEvent, validateOnly, validateLink);
            Result.Status status = CreateClusterLinksAuditExtractor.status(clusterLinkResult);
            Struct resultData = CreateClusterLinksAuditExtractor.resultData(clusterLinkResult);
            List<TypedCloudResourceRef> typedCloudResourceRefList = CreateClusterLinksAuditExtractor.typedCloudResourceRefList(requestEvent, linkName);
            ResourcePattern resourcePattern = new ResourcePattern("link", linkName, PatternType.LITERAL);
            String resourceCrn = AuditLogUtils.requestResourceCrn(extractorOptions.crnAuthority(), requestEvent, resourcePattern);
            AuditLog auditLog = AuditLogUtils.auditLog(requestEvent, extractorOptions, hasAuthorizationFailure, validateOnly, requestData, status, resultData, typedCloudResourceRefList, resourceCrn);
            extractedAuditLogs.add(auditLog);
        }
        return extractedAuditLogs;
    }

    private static CreateClusterLinksResponseData.EntryData extractClusterLinkResult(CreateClusterLinksResponseData createClusterLinksResponseData, String linkName) {
        for (CreateClusterLinksResponseData.EntryData entryData : createClusterLinksResponseData.entries()) {
            if (!entryData.linkName().equals(linkName)) continue;
            return entryData;
        }
        throw new IllegalStateException("Missing extractClusterLinkResult result linkName " + linkName);
    }

    private static List<TypedCloudResourceRef> typedCloudResourceRefList(KafkaRequestEvent requestEvent, String linkName) {
        List<TypedCloudResourceRef> typedCloudResourceRefList = AuditLogUtils.typedCloudResourceRefList(requestEvent);
        typedCloudResourceRefList.add(TypedCloudResourceRef.newBuilder().setType(TypedCloudResourceRef.ResourceType.CLUSTER_LINK).setResourceId(linkName).build());
        return typedCloudResourceRefList;
    }

    private static Struct requestData(CreateClusterLinksRequestData.EntryData entryData, KafkaRequestEvent requestEvent, boolean validateOnly, boolean validateLink) throws Exception {
        Struct.Builder builder = Struct.newBuilder();
        ObjectNode jsonNode = (ObjectNode)CreateClusterLinksRequestDataJsonConverter.EntryDataJsonConverter.write((CreateClusterLinksRequestData.EntryData)entryData, (short)((short)requestEvent.requestContext().requestVersion()), (boolean)true);
        jsonNode.remove("tenantPrefix");
        jsonNode.set("validateOnly", (JsonNode)BooleanNode.valueOf((boolean)validateOnly));
        jsonNode.set("validateLink", (JsonNode)BooleanNode.valueOf((boolean)validateLink));
        JsonFormat.parser().merge(jsonNode.toString(), (Message.Builder)builder);
        return builder.build();
    }

    private static Result.Status status(CreateClusterLinksResponseData.EntryData entryData) {
        return entryData.errorCode() == Errors.NONE.code() ? Result.Status.SUCCESS : Result.Status.FAILURE;
    }

    private static Struct resultData(CreateClusterLinksResponseData.EntryData entryData) throws InvalidProtocolBufferException {
        Struct.Builder builder = Struct.newBuilder();
        ObjectNode jsonNode = new ObjectNode(JsonNodeFactory.instance);
        jsonNode.set("message", (JsonNode)new TextNode(entryData.errorMessage()));
        jsonNode.set("errorCode", (JsonNode)new ShortNode(entryData.errorCode()));
        jsonNode.set("errorType", (JsonNode)new TextNode(Errors.forCode((short)entryData.errorCode()).name()));
        jsonNode.set("linkName", (JsonNode)new TextNode(entryData.linkName()));
        jsonNode.set("linkId", (JsonNode)new TextNode(entryData.linkId().toString()));
        JsonFormat.parser().merge(jsonNode.toString(), (Message.Builder)builder);
        return builder.build();
    }
}

