/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest;

import com.fasterxml.jackson.databind.Module;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.datatype.guava.GuavaModule;
import com.fasterxml.jackson.datatype.jdk8.Jdk8Module;
import com.fasterxml.jackson.datatype.jsr310.JavaTimeModule;
import com.fasterxml.jackson.jaxrs.base.JsonMappingExceptionMapper;
import com.fasterxml.jackson.jaxrs.base.JsonParseExceptionMapper;
import io.confluent.kafkarest.KafkaRestConfig;
import io.confluent.kafkarest.backends.BackendsModule;
import io.confluent.kafkarest.config.ConfigModule;
import io.confluent.kafkarest.controllers.ControllersModule;
import io.confluent.kafkarest.exceptions.ExceptionsModule;
import io.confluent.kafkarest.exceptions.KafkaRestExceptionMapper;
import io.confluent.kafkarest.extension.EnumConverterProvider;
import io.confluent.kafkarest.extension.InstantConverterProvider;
import io.confluent.kafkarest.extension.ResourceAccesslistFeature;
import io.confluent.kafkarest.extension.RestResourceExtension;
import io.confluent.kafkarest.ratelimit.RateLimitFeature;
import io.confluent.kafkarest.requestlog.CustomLog;
import io.confluent.kafkarest.requestlog.GlobalDosFilterListener;
import io.confluent.kafkarest.requestlog.PerConnectionDosFilterListener;
import io.confluent.kafkarest.resources.ResourcesFeature;
import io.confluent.kafkarest.response.JsonStreamMessageBodyReader;
import io.confluent.kafkarest.response.ResponseModule;
import io.confluent.rest.Application;
import io.confluent.rest.RestConfig;
import io.confluent.rest.exceptions.ConstraintViolationExceptionMapper;
import io.confluent.rest.exceptions.WebApplicationExceptionMapper;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.List;
import java.util.Properties;
import java.util.TimeZone;
import javax.ws.rs.core.Configurable;
import org.eclipse.jetty.server.RequestLog;
import org.eclipse.jetty.server.Slf4jRequestLogWriter;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.util.StringUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaRestApplication
extends Application<KafkaRestConfig> {
    private static final Logger log = LoggerFactory.getLogger(KafkaRestApplication.class);
    List<RestResourceExtension> restResourceExtensions;

    public KafkaRestApplication() {
        this(new Properties());
    }

    public KafkaRestApplication(Properties props) {
        this(new KafkaRestConfig(props));
    }

    public KafkaRestApplication(KafkaRestConfig config) {
        this(config, "");
    }

    public KafkaRestApplication(KafkaRestConfig config, String path) {
        this(config, path, null);
    }

    public KafkaRestApplication(KafkaRestConfig config, String path, String listenerName) {
        this(config, path, listenerName, null, null);
    }

    public KafkaRestApplication(KafkaRestConfig config, String path, String listenerName, RequestLog.Writer requestLogWriter, String requestLogFormat) {
        super((RestConfig)config, path, listenerName, KafkaRestApplication.createRequestLog(config, requestLogWriter, requestLogFormat, listenerName));
        this.restResourceExtensions = config.getConfiguredInstances("kafka.rest.resource.extension.class", RestResourceExtension.class);
        config.setMetrics(this.metrics);
        this.addNonGlobalDosfilterListener(new PerConnectionDosFilterListener());
        this.addGlobalDosfilterListener(new GlobalDosFilterListener());
    }

    private static RequestLog createRequestLog(KafkaRestConfig config, RequestLog.Writer requestLogWriter, String requestLogFormat, String listenerName) {
        if (config.getBoolean("use.custom.request.logging").booleanValue()) {
            log.info("For rest-app with listener {}, configuring custom request logging", (Object)listenerName);
            if (requestLogWriter == null) {
                Slf4jRequestLogWriter logWriter = new Slf4jRequestLogWriter();
                logWriter.setLoggerName(config.getString("request.logger.name"));
                requestLogWriter = logWriter;
            }
            if (requestLogFormat == null) {
                requestLogFormat = "%{client}a - %u %t \"%r\" %s %O \"%{Referer}i\" \"%{User-Agent}i\" %{ms}T";
            }
            return new CustomLog(requestLogWriter, requestLogFormat, new String[]{"REST_ERROR_CODE"});
        }
        return null;
    }

    public void configurePreResourceHandling(ServletContextHandler context) {
    }

    public void configurePostResourceHandling(ServletContextHandler context) {
    }

    public void setupResources(Configurable<?> config, KafkaRestConfig appConfig) {
        if (StringUtil.isBlank((String)appConfig.getString("bootstrap.servers")) && StringUtil.isBlank((String)appConfig.getString("zookeeper.connect"))) {
            throw new RuntimeException("At least one of bootstrap.servers or zookeeper.connect needs to be configured");
        }
        config.property("jersey.config.server.contentLength.buffer", (Object)0);
        config.register((Object)new JsonStreamMessageBodyReader(this.getJsonMapper(), appConfig));
        config.register((Object)new BackendsModule());
        config.register((Object)new ConfigModule(appConfig));
        config.register((Object)new ControllersModule());
        config.register((Object)new ExceptionsModule());
        config.register(RateLimitFeature.class);
        config.register((Object)new ResourcesFeature(appConfig));
        config.register((Object)new ResponseModule());
        config.register(ResourceAccesslistFeature.class);
        config.register(EnumConverterProvider.class);
        config.register(InstantConverterProvider.class);
        for (RestResourceExtension restResourceExtension : this.restResourceExtensions) {
            restResourceExtension.register(config, appConfig);
        }
    }

    public ObjectMapper getJsonMapper() {
        return super.getJsonMapper().registerModule((Module)new GuavaModule()).registerModule((Module)new Jdk8Module()).registerModule((Module)new JavaTimeModule()).configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false).setDateFormat((DateFormat)new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'")).setTimeZone(TimeZone.getTimeZone("UTC"));
    }

    protected void registerExceptionMappers(Configurable<?> config, KafkaRestConfig restConfig) {
        config.register(JsonParseExceptionMapper.class);
        config.register(JsonMappingExceptionMapper.class);
        config.register(ConstraintViolationExceptionMapper.class);
        config.register((Object)new WebApplicationExceptionMapper((RestConfig)restConfig));
        config.register((Object)new KafkaRestExceptionMapper(restConfig));
    }

    public void onShutdown() {
        for (RestResourceExtension restResourceExtension : this.restResourceExtensions) {
            restResourceExtension.clean();
        }
    }
}

