/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities;

import com.google.common.collect.ImmutableList;
import io.confluent.kafkarest.entities.Partition;
import io.confluent.kafkarest.entities.PartitionReplica;
import javax.annotation.Nullable;

final class AutoValue_Partition
extends Partition {
    private final String clusterId;
    private final String topicName;
    private final int partitionId;
    private final ImmutableList<PartitionReplica> replicas;
    private final Long earliestOffset;
    private final Long latestOffset;

    AutoValue_Partition(String clusterId, String topicName, int partitionId, ImmutableList<PartitionReplica> replicas, @Nullable Long earliestOffset, @Nullable Long latestOffset) {
        if (clusterId == null) {
            throw new NullPointerException("Null clusterId");
        }
        this.clusterId = clusterId;
        if (topicName == null) {
            throw new NullPointerException("Null topicName");
        }
        this.topicName = topicName;
        this.partitionId = partitionId;
        if (replicas == null) {
            throw new NullPointerException("Null replicas");
        }
        this.replicas = replicas;
        this.earliestOffset = earliestOffset;
        this.latestOffset = latestOffset;
    }

    @Override
    public String getClusterId() {
        return this.clusterId;
    }

    @Override
    public String getTopicName() {
        return this.topicName;
    }

    @Override
    public int getPartitionId() {
        return this.partitionId;
    }

    @Override
    public ImmutableList<PartitionReplica> getReplicas() {
        return this.replicas;
    }

    @Override
    @Nullable
    public Long getEarliestOffset() {
        return this.earliestOffset;
    }

    @Override
    @Nullable
    public Long getLatestOffset() {
        return this.latestOffset;
    }

    public String toString() {
        return "Partition{clusterId=" + this.clusterId + ", topicName=" + this.topicName + ", partitionId=" + this.partitionId + ", replicas=" + this.replicas + ", earliestOffset=" + this.earliestOffset + ", latestOffset=" + this.latestOffset + "}";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof Partition) {
            Partition that = (Partition)o;
            return this.clusterId.equals(that.getClusterId()) && this.topicName.equals(that.getTopicName()) && this.partitionId == that.getPartitionId() && this.replicas.equals(that.getReplicas()) && (this.earliestOffset == null ? that.getEarliestOffset() == null : this.earliestOffset.equals(that.getEarliestOffset())) && (this.latestOffset == null ? that.getLatestOffset() == null : this.latestOffset.equals(that.getLatestOffset()));
        }
        return false;
    }

    public int hashCode() {
        int h$ = 1;
        h$ *= 1000003;
        h$ ^= this.clusterId.hashCode();
        h$ *= 1000003;
        h$ ^= this.topicName.hashCode();
        h$ *= 1000003;
        h$ ^= this.partitionId;
        h$ *= 1000003;
        h$ ^= this.replicas.hashCode();
        h$ *= 1000003;
        h$ ^= this.earliestOffset == null ? 0 : this.earliestOffset.hashCode();
        h$ *= 1000003;
        return h$ ^= this.latestOffset == null ? 0 : this.latestOffset.hashCode();
    }
}

