/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.entities;

import io.confluent.kafka.schemaregistry.SchemaProvider;
import io.confluent.kafka.schemaregistry.avro.AvroSchemaProvider;
import io.confluent.kafka.schemaregistry.json.JsonSchemaProvider;
import io.confluent.kafka.schemaregistry.protobuf.ProtobufSchemaProvider;

public enum EmbeddedFormat {
    BINARY{

        @Override
        public boolean requiresSchema() {
            return false;
        }

        @Override
        public SchemaProvider getSchemaProvider() {
            throw new UnsupportedOperationException();
        }
    }
    ,
    JSON{

        @Override
        public boolean requiresSchema() {
            return false;
        }

        @Override
        public SchemaProvider getSchemaProvider() {
            throw new UnsupportedOperationException();
        }
    }
    ,
    STRING{

        @Override
        public boolean requiresSchema() {
            return false;
        }

        @Override
        public SchemaProvider getSchemaProvider() {
            throw new UnsupportedOperationException();
        }
    }
    ,
    AVRO{
        private final SchemaProvider schemaProvider = new AvroSchemaProvider();

        @Override
        public boolean requiresSchema() {
            return true;
        }

        @Override
        public SchemaProvider getSchemaProvider() {
            return this.schemaProvider;
        }
    }
    ,
    JSONSCHEMA{
        private final SchemaProvider schemaProvider = new JsonSchemaProvider();

        @Override
        public boolean requiresSchema() {
            return true;
        }

        @Override
        public SchemaProvider getSchemaProvider() {
            return this.schemaProvider;
        }
    }
    ,
    PROTOBUF{
        private final SchemaProvider schemaProvider = new ProtobufSchemaProvider();

        @Override
        public boolean requiresSchema() {
            return true;
        }

        @Override
        public SchemaProvider getSchemaProvider() {
            return this.schemaProvider;
        }
    };


    public abstract boolean requiresSchema();

    public abstract SchemaProvider getSchemaProvider();

    public static EmbeddedFormat forSchemaType(String schemaType) {
        if (schemaType.equals(AVRO.getSchemaProvider().schemaType())) {
            return AVRO;
        }
        if (schemaType.equals(JSONSCHEMA.getSchemaProvider().schemaType())) {
            return JSONSCHEMA;
        }
        if (schemaType.equals(PROTOBUF.getSchemaProvider().schemaType())) {
            return PROTOBUF;
        }
        throw new IllegalArgumentException(String.format("Illegal schema type: %s", schemaType));
    }
}

