/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.exceptions;

import io.confluent.kafkarest.exceptions.StatusCodeException;
import io.confluent.kafkarest.exceptions.v2.V2ExceptionMapper;
import io.confluent.kafkarest.exceptions.v3.V3ExceptionMapper;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.inject.Inject;
import javax.ws.rs.core.Context;
import javax.ws.rs.core.Feature;
import javax.ws.rs.core.FeatureContext;
import javax.ws.rs.core.Response;
import javax.ws.rs.core.UriInfo;
import javax.ws.rs.ext.ExceptionMapper;

public final class ExceptionsModule
implements Feature {
    private static final LinkedHashMap<String, ExceptionMapper<StatusCodeException>> mappers = new LinkedHashMap();

    public boolean configure(FeatureContext configurable) {
        configurable.register(DelegatingExceptionHandler.class);
        return false;
    }

    static {
        mappers.put("v3", new V3ExceptionMapper());
        mappers.put("", new V2ExceptionMapper());
    }

    static final class DelegatingExceptionHandler
    implements ExceptionMapper<StatusCodeException> {
        private final UriInfo uriInfo;

        @Inject
        DelegatingExceptionHandler(@Context UriInfo uriInfo) {
            this.uriInfo = Objects.requireNonNull(uriInfo);
        }

        public Response toResponse(StatusCodeException exception) {
            for (Map.Entry mapper : mappers.entrySet()) {
                if (!this.uriInfo.getPath().startsWith((String)mapper.getKey())) continue;
                return ((ExceptionMapper)mapper.getValue()).toResponse((Throwable)exception);
            }
            throw exception;
        }
    }
}

