/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.resources.v3;

import io.confluent.kafkarest.Errors;
import io.confluent.kafkarest.controllers.AclManager;
import io.confluent.kafkarest.entities.Acl;
import io.confluent.kafkarest.entities.v3.AclData;
import io.confluent.kafkarest.entities.v3.AclDataList;
import io.confluent.kafkarest.entities.v3.CreateAclRequest;
import io.confluent.kafkarest.entities.v3.DeleteAclsResponse;
import io.confluent.kafkarest.entities.v3.Resource;
import io.confluent.kafkarest.entities.v3.ResourceCollection;
import io.confluent.kafkarest.entities.v3.SearchAclsResponse;
import io.confluent.kafkarest.extension.ResourceAccesslistFeature;
import io.confluent.kafkarest.resources.AsyncResponses;
import io.confluent.kafkarest.response.UrlFactory;
import io.confluent.rest.annotations.PerformanceMetric;
import java.net.URI;
import java.util.Collections;
import java.util.Comparator;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.validation.Valid;
import javax.ws.rs.BadRequestException;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.DefaultValue;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.QueryParam;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Response;

@Path(value="/v3/clusters/{clusterId}/acls")
@ResourceAccesslistFeature.ResourceName(value="api.v3.acls.*")
public final class AclsResource {
    private final Provider<AclManager> aclManager;
    private final UrlFactory urlFactory;

    @Inject
    public AclsResource(Provider<AclManager> aclManager, UrlFactory urlFactory) {
        this.aclManager = Objects.requireNonNull(aclManager);
        this.urlFactory = Objects.requireNonNull(urlFactory);
    }

    @GET
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v3.acls.list")
    @ResourceAccesslistFeature.ResourceName(value="api.v3.acls.list")
    public void searchAcls(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId, @QueryParam(value="resource_type") @DefaultValue(value="any") Acl.ResourceType resourceType, @QueryParam(value="resource_name") @DefaultValue(value="") String resourceName, @QueryParam(value="pattern_type") @DefaultValue(value="any") Acl.PatternType patternType, @QueryParam(value="principal") @DefaultValue(value="") String principal, @QueryParam(value="host") @DefaultValue(value="") String host, @QueryParam(value="operation") @DefaultValue(value="any") Acl.Operation operation, @QueryParam(value="permission") @DefaultValue(value="any") Acl.Permission permission) {
        if (resourceType == Acl.ResourceType.UNKNOWN) {
            throw new BadRequestException("resource_type cannot be UNKNOWN");
        }
        if (patternType == Acl.PatternType.UNKNOWN) {
            throw new BadRequestException("pattern_type cannot be UNKNOWN");
        }
        if (operation == Acl.Operation.UNKNOWN) {
            throw new BadRequestException("operation cannot be UNKNOWN");
        }
        if (permission == Acl.Permission.UNKNOWN) {
            throw new BadRequestException("permission cannot be UNKNOWN");
        }
        CompletionStage response = ((AclManager)this.aclManager.get()).searchAcls(clusterId, resourceType, resourceName.isEmpty() ? null : resourceName, patternType, principal.isEmpty() ? null : principal, host.isEmpty() ? null : host, operation, permission).thenApply(acls -> SearchAclsResponse.create((AclDataList)((AclDataList.Builder)((AclDataList.Builder)AclDataList.builder().setMetadata(ResourceCollection.Metadata.builder().setSelf(this.urlFactory.newUrlBuilder().appendPathSegment("v3").appendPathSegment("clusters").appendPathSegment(clusterId).appendPathSegment("acls").putQueryParameter("resource_type", resourceType.name()).putQueryParameter("resource_name", resourceName).putQueryParameter("pattern_type", patternType.name()).putQueryParameter("principal", principal).putQueryParameter("host", host).putQueryParameter("operation", operation.name()).putQueryParameter("permission", permission.name()).build()).build())).setData(acls.stream().map(this::toAclData).sorted(Comparator.comparing(AclData::getResourceType).thenComparing(AclData::getResourceName).thenComparing(AclData::getPatternType).thenComparing(AclData::getPrincipal).thenComparing(AclData::getHost).thenComparing(AclData::getOperation).thenComparing(AclData::getPermission)).collect(Collectors.toList()))).build()));
        AsyncResponses.asyncResume(asyncResponse, response);
    }

    @POST
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v3.acls.create")
    @ResourceAccesslistFeature.ResourceName(value="api.v3.acls.create")
    public void createAcl(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId, @Valid CreateAclRequest request) {
        if (request == null) {
            throw Errors.invalidPayloadException("Null input provided. Data is required.");
        }
        CompletableFuture<Void> response = ((AclManager)this.aclManager.get()).validateAclCreateParameters(Collections.singletonList(request)).createAcl(clusterId, request.getResourceType(), request.getResourceName(), request.getPatternType(), request.getPrincipal(), request.getHost(), request.getOperation(), request.getPermission());
        AsyncResponses.AsyncResponseBuilder.from(Response.status((Response.Status)Response.Status.CREATED).location(URI.create(this.urlFactory.newUrlBuilder().appendPathSegment("v3").appendPathSegment("clusters").appendPathSegment(clusterId).appendPathSegment("acls").putQueryParameter("resource_type", request.getResourceType().name()).putQueryParameter("resource_name", request.getResourceName()).putQueryParameter("pattern_type", request.getPatternType().name()).putQueryParameter("principal", request.getPrincipal()).putQueryParameter("host", request.getHost()).putQueryParameter("operation", request.getOperation().name()).putQueryParameter("permission", request.getPermission().name()).build()))).entity(response).asyncResume(asyncResponse);
    }

    @DELETE
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v3.acls.delete")
    @ResourceAccesslistFeature.ResourceName(value="api.v3.acls.delete")
    public void deleteAcls(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId, @QueryParam(value="resource_type") @DefaultValue(value="unknown") Acl.ResourceType resourceType, @QueryParam(value="resource_name") @DefaultValue(value="") String resourceName, @QueryParam(value="pattern_type") @DefaultValue(value="unknown") Acl.PatternType patternType, @QueryParam(value="principal") @DefaultValue(value="") String principal, @QueryParam(value="host") @DefaultValue(value="") String host, @QueryParam(value="operation") @DefaultValue(value="unknown") Acl.Operation operation, @QueryParam(value="permission") @DefaultValue(value="unknown") Acl.Permission permission) {
        if (resourceType == Acl.ResourceType.UNKNOWN) {
            throw new BadRequestException("resource_type cannot be unspecified or UNKNOWN");
        }
        if (patternType == Acl.PatternType.UNKNOWN) {
            throw new BadRequestException("pattern_type cannot be unspecified or UNKNOWN");
        }
        if (operation == Acl.Operation.UNKNOWN) {
            throw new BadRequestException("operation cannot be unspecified or UNKNOWN");
        }
        if (permission == Acl.Permission.UNKNOWN) {
            throw new BadRequestException("permission cannot be unspecified or UNKNOWN");
        }
        CompletionStage response = ((AclManager)this.aclManager.get()).deleteAcls(clusterId, resourceType, resourceName.isEmpty() ? null : resourceName, patternType, principal.isEmpty() ? null : principal, host.isEmpty() ? null : host, operation, permission).thenApply(acls -> DeleteAclsResponse.create(acls.stream().map(this::toAclData).sorted(Comparator.comparing(AclData::getResourceType).thenComparing(AclData::getResourceName).thenComparing(AclData::getPatternType).thenComparing(AclData::getPrincipal).thenComparing(AclData::getHost).thenComparing(AclData::getOperation).thenComparing(AclData::getPermission)).collect(Collectors.toList())));
        AsyncResponses.asyncResume(asyncResponse, response);
    }

    public AclData toAclData(Acl acl) {
        return ((AclData.Builder)AclData.fromAcl(acl).setMetadata(Resource.Metadata.builder().setSelf(this.urlFactory.newUrlBuilder().appendPathSegment("v3").appendPathSegment("clusters").appendPathSegment(acl.getClusterId()).appendPathSegment("acls").putQueryParameter("resource_type", acl.getResourceType().name()).putQueryParameter("resource_name", acl.getResourceName()).putQueryParameter("pattern_type", acl.getPatternType().name()).putQueryParameter("principal", acl.getPrincipal()).putQueryParameter("host", acl.getHost()).putQueryParameter("operation", acl.getOperation().name()).putQueryParameter("permission", acl.getPermission().name()).build()).build())).build();
    }
}

