/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafkarest.resources.v3;

import io.confluent.kafkarest.controllers.BrokerConfigManager;
import io.confluent.kafkarest.entities.AbstractConfig;
import io.confluent.kafkarest.entities.BrokerConfig;
import io.confluent.kafkarest.entities.v3.BrokerConfigData;
import io.confluent.kafkarest.entities.v3.BrokerConfigDataList;
import io.confluent.kafkarest.entities.v3.GetBrokerConfigResponse;
import io.confluent.kafkarest.entities.v3.ListBrokerConfigsResponse;
import io.confluent.kafkarest.entities.v3.Resource;
import io.confluent.kafkarest.entities.v3.ResourceCollection;
import io.confluent.kafkarest.entities.v3.UpdateBrokerConfigRequest;
import io.confluent.kafkarest.extension.ResourceAccesslistFeature;
import io.confluent.kafkarest.resources.AsyncResponses;
import io.confluent.kafkarest.response.CrnFactory;
import io.confluent.kafkarest.response.UrlFactory;
import io.confluent.rest.annotations.PerformanceMetric;
import java.util.Comparator;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.validation.Valid;
import javax.ws.rs.Consumes;
import javax.ws.rs.DELETE;
import javax.ws.rs.GET;
import javax.ws.rs.NotFoundException;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.container.AsyncResponse;
import javax.ws.rs.container.Suspended;
import javax.ws.rs.core.Response;

@Path(value="/v3/clusters/{clusterId}/brokers/{brokerId}/configs")
@ResourceAccesslistFeature.ResourceName(value="api.v3.broker-configs.*")
public final class BrokerConfigsResource {
    private final Provider<BrokerConfigManager> brokerConfigManager;
    private final CrnFactory crnFactory;
    private final UrlFactory urlFactory;

    @Inject
    public BrokerConfigsResource(Provider<BrokerConfigManager> brokerConfigManager, CrnFactory crnFactory, UrlFactory urlFactory) {
        this.brokerConfigManager = Objects.requireNonNull(brokerConfigManager);
        this.crnFactory = Objects.requireNonNull(crnFactory);
        this.urlFactory = Objects.requireNonNull(urlFactory);
    }

    @GET
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v3.brokers.configs.list")
    @ResourceAccesslistFeature.ResourceName(value="api.v3.broker-configs.list")
    public void listBrokerConfigs(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId, @PathParam(value="brokerId") int brokerId) {
        CompletionStage response = ((BrokerConfigManager)this.brokerConfigManager.get()).listBrokerConfigs(clusterId, brokerId).thenApply(configs -> ListBrokerConfigsResponse.create((BrokerConfigDataList)((BrokerConfigDataList.Builder)((BrokerConfigDataList.Builder)BrokerConfigDataList.builder().setMetadata(ResourceCollection.Metadata.builder().setSelf(this.urlFactory.create("v3", "clusters", clusterId, "brokers", String.valueOf(brokerId), "configs")).build())).setData(configs.stream().sorted(Comparator.comparing(AbstractConfig::getName)).map(brokerConfig -> BrokerConfigsResource.toBrokerConfigData(brokerConfig, this.crnFactory, this.urlFactory)).collect(Collectors.toList()))).build()));
        AsyncResponses.asyncResume(asyncResponse, response);
    }

    @GET
    @Path(value="/{name}")
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v3.brokers.configs.get")
    @ResourceAccesslistFeature.ResourceName(value="api.v3.broker-configs.get")
    public void getBrokerConfig(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId, @PathParam(value="brokerId") int brokerId, @PathParam(value="name") String name) {
        CompletionStage response = ((CompletableFuture)((BrokerConfigManager)this.brokerConfigManager.get()).getBrokerConfig(clusterId, brokerId, name).thenApply(broker -> (BrokerConfig)broker.orElseThrow(NotFoundException::new))).thenApply(broker -> GetBrokerConfigResponse.create(BrokerConfigsResource.toBrokerConfigData(broker, this.crnFactory, this.urlFactory)));
        AsyncResponses.asyncResume(asyncResponse, response);
    }

    @PUT
    @Path(value="/{name}")
    @Consumes(value={"application/json"})
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v3.brokers.configs.update")
    @ResourceAccesslistFeature.ResourceName(value="api.v3.broker-configs.update")
    public void updateBrokerConfig(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId, @PathParam(value="brokerId") int brokerId, @PathParam(value="name") String name, @Valid UpdateBrokerConfigRequest request) {
        String newValue = request.getValue().orElse(null);
        CompletableFuture<Void> response = ((BrokerConfigManager)this.brokerConfigManager.get()).updateBrokerConfig(clusterId, brokerId, name, newValue);
        AsyncResponses.AsyncResponseBuilder.from(Response.status((Response.Status)Response.Status.NO_CONTENT)).entity(response).asyncResume(asyncResponse);
    }

    @DELETE
    @Path(value="/{name}")
    @Produces(value={"application/json"})
    @PerformanceMetric(value="v3.brokers.configs.delete")
    @ResourceAccesslistFeature.ResourceName(value="api.v3.broker-configs.delete")
    public void resetBrokerConfig(@Suspended AsyncResponse asyncResponse, @PathParam(value="clusterId") String clusterId, @PathParam(value="brokerId") int brokerId, @PathParam(value="name") String name) {
        CompletableFuture<Void> response = ((BrokerConfigManager)this.brokerConfigManager.get()).resetBrokerConfig(clusterId, brokerId, name);
        AsyncResponses.AsyncResponseBuilder.from(Response.status((Response.Status)Response.Status.NO_CONTENT)).entity(response).asyncResume(asyncResponse);
    }

    public static BrokerConfigData toBrokerConfigData(BrokerConfig brokerConfig, CrnFactory crnFactory, UrlFactory urlFactory) {
        return ((BrokerConfigData.Builder)BrokerConfigData.fromBrokerConfig(brokerConfig).setMetadata(Resource.Metadata.builder().setSelf(urlFactory.create("v3", "clusters", brokerConfig.getClusterId(), "brokers", String.valueOf(brokerConfig.getBrokerId()), "configs", brokerConfig.getName())).setResourceName(crnFactory.create("kafka", brokerConfig.getClusterId(), "broker", String.valueOf(brokerConfig.getBrokerId()), "config", brokerConfig.getName())).build())).build();
    }
}

