/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.security.authorizer.schemaregistryacl;

import io.confluent.kafka.schemaregistry.security.authorizer.SchemaRegistryResourceOperation;
import io.confluent.kafka.schemaregistry.security.authorizer.schemaregistryacl.ValidSchemaRegistryOperation;
import java.util.Set;
import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;

public class SchemaRegistryOperationValidator
implements ConstraintValidator<ValidSchemaRegistryOperation, Set<SchemaRegistryResourceOperation>> {
    private ValidSchemaRegistryOperation.SchemaRegistryOperationType operationType;

    public void initialize(ValidSchemaRegistryOperation validSchemaRegistryOperation) {
        this.operationType = validSchemaRegistryOperation.value();
    }

    public boolean isValid(Set<SchemaRegistryResourceOperation> schemaRegistryResourceOperations, ConstraintValidatorContext constraintValidatorContext) {
        if (schemaRegistryResourceOperations == null || schemaRegistryResourceOperations.isEmpty()) {
            return true;
        }
        if (this.operationType.equals((Object)ValidSchemaRegistryOperation.SchemaRegistryOperationType.SUBJECT)) {
            return SchemaRegistryResourceOperation.SUBJECT_RESOURCE_OPERATIONS.containsAll(schemaRegistryResourceOperations);
        }
        if (this.operationType.equals((Object)ValidSchemaRegistryOperation.SchemaRegistryOperationType.GLOBAL)) {
            return SchemaRegistryResourceOperation.GLOBAL_RESOURCE_OPERATIONS.containsAll(schemaRegistryResourceOperations);
        }
        return false;
    }
}

