/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.security.config;

import io.confluent.common.security.auth.RestAuthType;
import io.confluent.kafka.schemaregistry.rest.SchemaRegistryConfig;
import io.confluent.rest.RestConfigException;
import java.util.Map;
import java.util.Properties;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.security.auth.KafkaPrincipal;

public final class SecureSchemaRegistryConfig
extends SchemaRegistryConfig {
    public static final String KAFKASTORE_PREFIX = "kafkastore.";
    public static final String CONFLUENT_SSL_PRINCIPAL_MAPPING_RULES_CONFIG = "confluent.schema.registry.auth.ssl.principal.mapping.rules";
    private static final String CONFLUENT_SSL_PRINCIPAL_MAPPING_RULES_DOC = "A list of rules to map from the distinguished name (DN) in the client certificate to a short name principal for authentication with the Kafka broker. Rules are tested from left to right. The first rule that matches will be applied.";
    public static final String CONFLUENT_AUTH_MECHANISM_CONFIG = "confluent.schema.registry.auth.mechanism";
    private static final String CONFLUENT_AUTH_MECHANISM_DOC = "The mechanism used to authenticate SchemaRegistry requests.The principal from the authentication mechanism is then used to optionally authorize using a configured authorizer.";
    private static final String CONFLUENT_AUTH_MECHANISM_DEFAULT = "SSL";
    public static final String CONFLUENT_SCHEMA_REGISTRY_AUTHORIZER_CONFIG = "confluent.schema.registry.authorizer.class";
    private static final String CONFLUENT_SCHEMA_REGISTRY_AUTHORIZER_DOC = "The implementation used to authorize Schema Registry requests. Needs to be an implementation of the interface SchemaRegistryAuthorizer.";
    public static final String SCHEMA_LINKING_RBAC_ENABLE = "schema.linking.rbac.enable";
    private static final String SCHEMA_LINKING_RBAC_ENABLE_DOC = "This will enable rbac for schema linking";
    public static final String DEK_REGISTRY_RBAC_ENABLE = "dek.registry.rbac.enable";
    private static final String DEK_REGISTRY_RBAC_ENABLE_DOC = "This will enable rbac for dek registry";
    public static final String CONFLUENT_SCHEMA_REGISTRY_ACL_TOPIC_CONFIG = "confluent.schema.registry.acl.topic";
    private static final String CONFLUENT_SCHEMA_REGISTRY_ACL_TOPIC_DOC = "The topic used to store the ACL for the Schema Registry operations. This is optional and when not supplied the topic name is derived as ``kafkastore.topic`` suffixed with ``_acl`` ";
    public static final String CONFLUENT_TOPIC_ACL_PREFIX = "confluent.topic.acl.";
    public static final String CONFLUENT_TOPIC_ACL_SUPER_USERS_CONFIG = "confluent.topic.acl.super.users";
    public static final String CONFLUENT_TOPIC_ACL_SUPER_USERS_DOC = "Semicolon separated list of users who can be super users. One needs to be a super user to perform all global operations that doesn't involve a subject like read or write compatibility. For example ``admin1;admin2`` would make both admin1 and admin2 as super users.";
    public static final String CONFLUENT_TOPIC_ACL_SUPER_USERS_DEFAULT = "";
    public static final String CONFLUENT_LICENSE_CONFIG = "confluent.license";
    public static final String CONFLUENT_LICENSE_DEFAULT = "";
    protected static final String CONFLUENT_LICENSE_DOC = "Confluent will issue a license key to each subscriber. The license key will be a short snippet of text that you can copy and paste. Without the license key, you can use Confluent Security Plugins for a 30-day trial period. If you are a subscriber and don't have a license key, please contact Confluent Support at support@confluent.io.";
    public static final String CONFLUENT_TOPIC_CONFIG = "confluent.license.topic";
    public static final String CONFLUENT_TOPIC_DEFAULT = "_confluent-license";
    public static final String CONFLUENT_TOPIC_DOC = "Topic used for storing Confluent license";
    public static final String LICENSE_CONFIG_PREFIX = "confluent.license.";
    public static final String CONFLUENT_TOPIC_PRODUCER_PREFIX = "confluent.license.producer.";
    public static final String CONFLUENT_TOPIC_CONSUMER_PREFIX = "confluent.license.consumer.";
    public static final String CONFLUENT_TOPIC_ADMIN_PREFIX = "confluent.license.admin.";
    public static final String CONFLUENT_ANONYMOUS_PRINCIPAL_CONFIG = "confluent.schema.registry.anonymous.principal";
    private static final String CONFLUENT_ANONYMOUS_PRINCIPAL_DOC = "Whether to provide an anonymous principal for requests that lack authentication. The name of the anonymous principal is '" + KafkaPrincipal.ANONYMOUS.getName() + "'";
    private static final ConfigDef confluentConfigDef = SecureSchemaRegistryConfig.initConfigDef();

    public String licenseString() {
        return this.getPassword(CONFLUENT_LICENSE_CONFIG).value();
    }

    public String licenseTopic() {
        return this.getString(CONFLUENT_TOPIC_CONFIG);
    }

    private Map<String, Object> getKafkaConnectionProps() {
        Map props = this.originals();
        props.putAll(this.originalsWithPrefix(KAFKASTORE_PREFIX));
        props.putAll(this.originalsWithPrefix(LICENSE_CONFIG_PREFIX));
        props.putIfAbsent("bootstrap.servers", this.bootstrapBrokers());
        return props;
    }

    public Map<String, Object> licenseProducerConfigs() {
        Map<String, Object> producerProperties = this.getKafkaConnectionProps();
        producerProperties.putAll(this.originalsWithPrefix(CONFLUENT_TOPIC_PRODUCER_PREFIX));
        producerProperties.put("client.id", "confluent-license-producer");
        return producerProperties;
    }

    public Map<String, Object> licenseConsumerConfigs() {
        Map<String, Object> consumerProperties = this.getKafkaConnectionProps();
        consumerProperties.putAll(this.originalsWithPrefix(CONFLUENT_TOPIC_CONSUMER_PREFIX));
        consumerProperties.put("client.id", "confluent-license-consumer");
        return consumerProperties;
    }

    public Map<String, Object> licenseAdminConfigs() {
        Map<String, Object> adminProperties = this.getKafkaConnectionProps();
        adminProperties.putAll(this.originalsWithPrefix(CONFLUENT_TOPIC_ADMIN_PREFIX));
        adminProperties.put("client.id", "confluent-license-admin");
        return adminProperties;
    }

    public SecureSchemaRegistryConfig(Properties props) throws RestConfigException {
        super(confluentConfigDef, props);
    }

    private static ConfigDef initConfigDef() {
        return SecureSchemaRegistryConfig.baseSchemaRegistryConfigDef().define(CONFLUENT_AUTH_MECHANISM_CONFIG, ConfigDef.Type.STRING, (Object)CONFLUENT_AUTH_MECHANISM_DEFAULT, (ConfigDef.Validator)ConfigDef.ValidString.in((String[])RestAuthType.NAMES.toArray(new String[RestAuthType.NAMES.size()])), ConfigDef.Importance.LOW, CONFLUENT_AUTH_MECHANISM_DOC).define(CONFLUENT_SCHEMA_REGISTRY_AUTHORIZER_CONFIG, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.HIGH, CONFLUENT_SCHEMA_REGISTRY_AUTHORIZER_DOC).define(CONFLUENT_SCHEMA_REGISTRY_ACL_TOPIC_CONFIG, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.MEDIUM, CONFLUENT_SCHEMA_REGISTRY_ACL_TOPIC_DOC).define(CONFLUENT_TOPIC_ACL_SUPER_USERS_CONFIG, ConfigDef.Type.STRING, (Object)"", ConfigDef.Importance.MEDIUM, CONFLUENT_TOPIC_ACL_SUPER_USERS_DOC).define(CONFLUENT_LICENSE_CONFIG, ConfigDef.Type.PASSWORD, (Object)"", ConfigDef.Importance.HIGH, CONFLUENT_LICENSE_DOC).define(CONFLUENT_TOPIC_CONFIG, ConfigDef.Type.STRING, (Object)CONFLUENT_TOPIC_DEFAULT, ConfigDef.Importance.HIGH, CONFLUENT_TOPIC_DOC).define(CONFLUENT_SSL_PRINCIPAL_MAPPING_RULES_CONFIG, ConfigDef.Type.STRING, (Object)"DEFAULT", ConfigDef.Importance.LOW, CONFLUENT_SSL_PRINCIPAL_MAPPING_RULES_DOC).define(CONFLUENT_ANONYMOUS_PRINCIPAL_CONFIG, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.LOW, CONFLUENT_ANONYMOUS_PRINCIPAL_DOC).define(SCHEMA_LINKING_RBAC_ENABLE, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.HIGH, SCHEMA_LINKING_RBAC_ENABLE_DOC).define(DEK_REGISTRY_RBAC_ENABLE, ConfigDef.Type.BOOLEAN, (Object)false, ConfigDef.Importance.HIGH, DEK_REGISTRY_RBAC_ENABLE_DOC).define("security.providers", ConfigDef.Type.LIST, (Object)"", ConfigDef.Importance.LOW, "A list of configurable creator classes each returning a provider implementing security algorithms. These classes should implement the <code>org.apache.kafka.common.security.auth.SecurityProviderCreator</code> interface.");
    }

    public String aclTopic() {
        return this.getString(CONFLUENT_SCHEMA_REGISTRY_ACL_TOPIC_CONFIG).isEmpty() ? this.getString("kafkastore.topic").concat("_acl") : this.getString(CONFLUENT_SCHEMA_REGISTRY_ACL_TOPIC_CONFIG);
    }
}

