/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.protobuf.InvalidProtocolBufferException;
import com.google.protobuf.Message;
import com.google.protobuf.Timestamp;
import com.google.protobuf.util.JsonFormat;
import com.google.protobuf.util.Timestamps;
import io.confluent.kafka.multitenant.KafkaLogicalClusterMetadata;
import io.confluent.kafka.multitenant.MultiTenantPrincipal;
import io.confluent.kafka.multitenant.PhysicalClusterMetadata;
import io.confluent.kafka.multitenant.SslCertificateSpecification;
import io.confluent.protobuf.cloud.events.v1.LogicalCluster;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.nio.file.attribute.PosixFilePermissions;
import java.time.Instant;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Map;
import java.util.stream.Stream;
import kafka.server.ConfigEntityName;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.server.quota.ClientQuotaEntity;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.Assertions;

public class Utils {
    public static final Date CREATION_DATE_1 = new Date(System.currentTimeMillis() - 124356L);
    public static final Date CREATION_DATE_2 = new Date(System.currentTimeMillis() - 654321L);
    public static final KafkaLogicalClusterMetadata LC_META_XYZ = new KafkaLogicalClusterMetadata("lkc-xyz", "pkc-xyz", "xyz", "my-account", "k8s-abc", "kafka", Long.valueOf(0x6400000L), Long.valueOf(10240000L), Long.valueOf(2048L), null, null, Long.valueOf(KafkaLogicalClusterMetadata.DEFAULT_REQUEST_PERCENTAGE_PER_BROKER.longValue()), KafkaLogicalClusterMetadata.DEFAULT_NETWORK_QUOTA_OVERHEAD_PERCENTAGE, new KafkaLogicalClusterMetadata.LifecycleMetadata("lkc-xyz", "pkc-xyz", CREATION_DATE_2, null), Integer.valueOf(6000), null, null, Long.valueOf(KafkaLogicalClusterMetadata.DEFAULT_LINK_REQUEST_PERCENTAGE_PER_BROKER.longValue()));
    public static final KafkaLogicalClusterMetadata LC_META_1 = new KafkaLogicalClusterMetadata("lkc-tenant1", "pkc-xyz", "lkc-tenant1", "my-account", "k8s-abc", "kafka", Long.valueOf(0x6400000L), Long.valueOf(512000L), Long.valueOf(1024000L), null, null, Long.valueOf(1600L), KafkaLogicalClusterMetadata.DEFAULT_NETWORK_QUOTA_OVERHEAD_PERCENTAGE, new KafkaLogicalClusterMetadata.LifecycleMetadata("lkc-tenant1", "pkc-xyz", CREATION_DATE_2, null), Integer.valueOf(6000), null, null, Long.valueOf(KafkaLogicalClusterMetadata.DEFAULT_LINK_REQUEST_PERCENTAGE_PER_BROKER.longValue()));
    public static final KafkaLogicalClusterMetadata LC_META_ABC = new KafkaLogicalClusterMetadata("lkc-abc", "pkc-abc", "abc", "my-account", "k8s-abc", "kafka", Long.valueOf(0xA00000L), Long.valueOf(102000000L), Long.valueOf(204800L), null, null, Long.valueOf(KafkaLogicalClusterMetadata.DEFAULT_REQUEST_PERCENTAGE_PER_BROKER.longValue()), KafkaLogicalClusterMetadata.DEFAULT_NETWORK_QUOTA_OVERHEAD_PERCENTAGE, new KafkaLogicalClusterMetadata.LifecycleMetadata("lkc-abc", "pkc-abc", CREATION_DATE_1, null), Integer.valueOf(12000), "my-org2", "my-env2", Long.valueOf(KafkaLogicalClusterMetadata.DEFAULT_LINK_REQUEST_PERCENTAGE_PER_BROKER.longValue()));
    public static final String SPIFFE_ID_1 = "spiffe://dummy.trust.domain/test-workload";
    public static final KafkaLogicalClusterMetadata LC_META_DED = new KafkaLogicalClusterMetadata("lkc-ded", "pkc-ded", "ded", "my-account", "k8s-abc", "kafka", Long.valueOf(0xA00000L), Long.valueOf(10240000L), Long.valueOf(20480000L), null, null, Long.valueOf(KafkaLogicalClusterMetadata.DEFAULT_REQUEST_PERCENTAGE_PER_BROKER.longValue()), KafkaLogicalClusterMetadata.DEFAULT_NETWORK_QUOTA_OVERHEAD_PERCENTAGE, new KafkaLogicalClusterMetadata.LifecycleMetadata("lkc-ded", "pkc-ded", new Date(), new Date(System.currentTimeMillis() - 1000L)), Integer.valueOf(12000), "my-org3", "my-env3", Long.valueOf(KafkaLogicalClusterMetadata.DEFAULT_LINK_REQUEST_PERCENTAGE_PER_BROKER.longValue()));
    public static final KafkaLogicalClusterMetadata LC_META_MEH = new KafkaLogicalClusterMetadata("lkc-meh", "pkc-meh", "meh", "my-account", "k8s-abc", "kafka", Long.valueOf(0xA00000L), Long.valueOf(10240000L), Long.valueOf(204800L), null, null, Long.valueOf(KafkaLogicalClusterMetadata.DEFAULT_REQUEST_PERCENTAGE_PER_BROKER.longValue()), KafkaLogicalClusterMetadata.DEFAULT_NETWORK_QUOTA_OVERHEAD_PERCENTAGE, new KafkaLogicalClusterMetadata.LifecycleMetadata("lkc-meh", "pkc-meh", new Date(), new Date(System.currentTimeMillis() - (ConfluentConfigs.MULTITENANT_TENANT_DELETE_DELAY_MS_DEFAULT + 1000L))), null, "my-org4", "my-env4", Long.valueOf(KafkaLogicalClusterMetadata.DEFAULT_LINK_REQUEST_PERCENTAGE_PER_BROKER.longValue()));
    public static final KafkaLogicalClusterMetadata LC_META_HEALTHCHECK = new KafkaLogicalClusterMetadata("lkc-htc", "pkc-xyz", "external-healthcheck-pkc-xyz", "my-account", "k8s-abc", "healthcheck", null, null, null, null, null, null, null, new KafkaLogicalClusterMetadata.LifecycleMetadata("lkc-htc", "pkc-xyz", new Date(), null), null, "my-org5", "my-env5", Long.valueOf(KafkaLogicalClusterMetadata.DEFAULT_LINK_REQUEST_PERCENTAGE_PER_BROKER.longValue()));
    public static final KafkaLogicalClusterMetadata LC_META_LINK_HEALTHCHECK = new KafkaLogicalClusterMetadata("lkc-lhtc", "pkc-xyz", "external-link-healthcheck-pkc-xyz", "my-account", "k8s-abc", "link-healthcheck", null, null, null, null, null, null, null, new KafkaLogicalClusterMetadata.LifecycleMetadata("lkc-lhtc", "pkc-xyz", new Date(), null), null, "my-org6", "my-env6", Long.valueOf(KafkaLogicalClusterMetadata.DEFAULT_LINK_REQUEST_PERCENTAGE_PER_BROKER.longValue()));
    public static final KafkaLogicalClusterMetadata LC_META_ZERO_DEACTIVATION_DATE = new KafkaLogicalClusterMetadata("lkc-lhtc", "pkc-xyz", "external-link-healthcheck-pkc-xyz", "my-account", "k8s-abc", "link-healthcheck", null, null, null, null, null, null, null, new KafkaLogicalClusterMetadata.LifecycleMetadata("lkc-lhtc", "pkc-xyz", new Date(), new Date(0L)), null, "my-org6", "my-env6", Long.valueOf(KafkaLogicalClusterMetadata.DEFAULT_LINK_REQUEST_PERCENTAGE_PER_BROKER.longValue()));
    public static final KafkaLogicalClusterMetadata LC_NOT_KAFKA = new KafkaLogicalClusterMetadata("not-kafka", "pkc-xyz", "not-kafka", "my-account", "k8s-abc", "NOT_A_KAFKA_TYPE", Long.valueOf(0x6400000L), Long.valueOf(512000L), Long.valueOf(1024000L), null, null, Long.valueOf(1600L), KafkaLogicalClusterMetadata.DEFAULT_NETWORK_QUOTA_OVERHEAD_PERCENTAGE, new KafkaLogicalClusterMetadata.LifecycleMetadata("not-kafka", "pkc-xyz", CREATION_DATE_2, null), Integer.valueOf(6000), null, null, Long.valueOf(KafkaLogicalClusterMetadata.DEFAULT_LINK_REQUEST_PERCENTAGE_PER_BROKER.longValue()));
    static final SslCertificateSpecification SSL_CERT_SPEC_NO_TYPE = new SslCertificateSpecification(null, "mystorepassword", "pkcs.p12", Integer.valueOf(1), "fullchain.pem", "privkey.pem");
    static final SslCertificateSpecification SSL_CERT_SPEC_NO_PKCSFILE = new SslCertificateSpecification("PKCS12", "mystorepassword", null, Integer.valueOf(1), "fullchain.pem", "privkey.pem");
    static final SslCertificateSpecification SSL_CERT_SPEC_NO_PEMFILES = new SslCertificateSpecification("PKCS12", "mystorepassword", "pkcs.p12", Integer.valueOf(1), null, null);

    public static PhysicalClusterMetadata initiatePhysicalClusterMetadata(Map<String, Object> configs) throws IOException {
        return Utils.initiatePhysicalClusterMetadata(configs, ConfluentConfigs.MULTITENANT_METADATA_RELOAD_DELAY_MS_DEFAULT);
    }

    public static PhysicalClusterMetadata initiatePhysicalClusterMetadata(Map<String, Object> configs, long reloadDelay) throws IOException {
        configs.put("multitenant.metadata.reload.delay.ms", reloadDelay);
        PhysicalClusterMetadata metadata = new PhysicalClusterMetadata(new Metrics(), Time.SYSTEM);
        metadata.configure(configs);
        return metadata;
    }

    public static void createLogicalClusterFile(KafkaLogicalClusterMetadata lcMeta, Path dir) throws IOException {
        Utils.updateLogicalClusterFile(lcMeta, false, true, dir, null);
    }

    public static void createInvalidLogicalClusterFile(KafkaLogicalClusterMetadata lcMeta, Path dir) throws IOException {
        Utils.updateLogicalClusterFile(lcMeta, false, false, dir, null);
    }

    public static void updateLogicalClusterFile(KafkaLogicalClusterMetadata lcMeta, Path dir) throws IOException {
        Utils.updateLogicalClusterFile(lcMeta, false, true, dir, null);
    }

    public static void updateInvalidLogicalClusterFile(KafkaLogicalClusterMetadata lcMeta, Path dir) throws IOException {
        Utils.updateLogicalClusterFile(lcMeta, false, false, dir, null);
    }

    public static void deleteLogicalClusterFile(KafkaLogicalClusterMetadata lcMeta, Path dir) throws IOException {
        Utils.updateLogicalClusterFile(lcMeta, true, true, dir, null);
    }

    public static void setPosixFilePermissions(KafkaLogicalClusterMetadata lcMeta, String posixFilePermissionsStr, Path dir) throws IOException {
        String lcFilename = lcMeta.logicalClusterId() + ".json";
        Path metaPath = Paths.get(dir.toString(), "..data", lcFilename);
        Files.setPosixFilePermissions(metaPath, PosixFilePermissions.fromString(posixFilePermissionsStr));
    }

    public static KafkaLogicalClusterMetadata updateQuotas(KafkaLogicalClusterMetadata lcMeta, Long producerByteRate, Long consumerByteRate, Long brokerRequestPercentage, Long brokerLinkRequestPercentage) {
        return new KafkaLogicalClusterMetadata(lcMeta.logicalClusterId(), lcMeta.physicalClusterId(), lcMeta.logicalClusterName(), lcMeta.accountId(), lcMeta.k8sClusterId(), "kafka", lcMeta.storageBytes(), producerByteRate, consumerByteRate, null, null, brokerRequestPercentage, lcMeta.networkQuotaOverhead(), lcMeta.lifecycleMetadata(), lcMeta.maxPartitions(), lcMeta.organizationId(), lcMeta.environmentId(), brokerLinkRequestPercentage);
    }

    public static void createOrUpdateLogicalClusterFile(KafkaLogicalClusterMetadata lcMeta, Path dir, long lastModified) throws IOException {
        String lcFilename = lcMeta.logicalClusterId() + ".json";
        Utils.updateJsonFile(lcFilename, Utils.logicalClusterJsonString(lcMeta, true), false, dir, lastModified);
    }

    private static void updateLogicalClusterFile(KafkaLogicalClusterMetadata lcMeta, boolean remove, boolean valid, Path dir, Long lastModified) throws IOException {
        String lcFilename = lcMeta.logicalClusterId() + ".json";
        Utils.updateJsonFile(lcFilename, Utils.logicalClusterJsonString(lcMeta, valid), remove, dir, lastModified);
    }

    public static Path updateJsonFile(String jsonFilename, String jsonString, boolean remove, Path dir) throws IOException {
        return Utils.updateJsonFile(jsonFilename, jsonString, remove, dir, null);
    }

    public static Path updateJsonFile(String jsonFilename, String jsonString, boolean remove, Path dir, Long lastModified) throws IOException {
        Path dataDir;
        Path newDir = TestUtils.tempDirectory((Path)dir, null).toPath();
        Path lcFile = null;
        if (!remove) {
            lcFile = newDir.resolve(jsonFilename);
            Files.write(lcFile, jsonString.getBytes(), new OpenOption[0]);
            if (lastModified != null) {
                lcFile.toFile().setLastModified(lastModified);
            }
        }
        if (Files.exists(dataDir = dir.resolve("..data"), new LinkOption[0])) {
            Path oldDir = Files.readSymbolicLink(dataDir);
            try (Stream<Path> fileStream = Files.list(oldDir);){
                fileStream.forEach(filePath -> {
                    try {
                        if (!filePath.getFileName().toString().equals(jsonFilename)) {
                            Files.move(filePath, Paths.get(newDir.toString(), filePath.getFileName().toString()), new CopyOption[0]);
                        } else {
                            Files.delete(filePath);
                        }
                    }
                    catch (IOException ioe) {
                        throw new RuntimeException("Test failed to simulate logical cluster file creation.", ioe);
                    }
                });
            }
            Files.delete(dataDir);
            Files.delete(oldDir);
        }
        Files.createSymbolicLink(dataDir, newDir, new FileAttribute[0]);
        return lcFile;
    }

    static String logicalClusterJsonString(KafkaLogicalClusterMetadata lcMeta) {
        String json = Utils.baseLogicalClusterJsonString(lcMeta);
        json = json + ", \"network_quota_overhead\": " + lcMeta.networkQuotaOverhead();
        json = json + "}";
        return json;
    }

    static String logicalClusterJsonString(KafkaLogicalClusterMetadata lcMeta, boolean valid) {
        String json = Utils.baseLogicalClusterJsonString(lcMeta);
        if (valid) {
            json = json + "}";
        }
        return json;
    }

    private static String baseLogicalClusterJsonString(KafkaLogicalClusterMetadata lcMeta) {
        String json = "{\"logical_cluster_id\": \"" + lcMeta.logicalClusterId() + "\",\"physical_cluster_id\": \"" + lcMeta.physicalClusterId() + "\",\"logical_cluster_name\": \"" + lcMeta.logicalClusterName() + "\",\"account_id\": \"" + lcMeta.accountId() + "\",\"k8s_cluster_id\": \"" + lcMeta.k8sClusterId() + "\",\"logical_cluster_type\": \"" + lcMeta.logicalClusterType() + "\",\"max_partitions\": " + lcMeta.maxPartitions();
        if (lcMeta.organizationId() != null) {
            json = json + ", \"org_resource_id\": \"" + lcMeta.organizationId() + "\"";
        }
        if (lcMeta.environmentId() != null) {
            json = json + ", \"environment_id\": \"" + lcMeta.environmentId() + "\"";
        }
        try {
            json = json + ", \"metadata\": " + Utils.lifecycleJsonString(lcMeta);
        }
        catch (JsonProcessingException jsonProcessingException) {
            // empty catch block
        }
        if (lcMeta.storageBytes() != null) {
            json = json + ", \"storage_bytes\": " + lcMeta.storageBytes();
        }
        if (lcMeta.producerByteRate() != null) {
            json = json + ", \"network_ingress_byte_rate\": " + lcMeta.producerByteRate();
        }
        if (lcMeta.consumerByteRate() != null) {
            json = json + ", \"network_egress_byte_rate\": " + lcMeta.consumerByteRate();
        }
        if (lcMeta.brokerRequestPercentage() != null) {
            json = json + ", \"broker_request_percentage\": " + lcMeta.brokerRequestPercentage();
        }
        if (lcMeta.brokerLinkRequestPercentage() != null) {
            json = json + ", \"broker_link_request_percentage\": " + lcMeta.brokerLinkRequestPercentage();
        }
        return json;
    }

    private static String lifecycleJsonString(KafkaLogicalClusterMetadata lcMeta) throws JsonProcessingException {
        ObjectMapper mapper = new ObjectMapper();
        return mapper.writeValueAsString((Object)lcMeta.lifecycleMetadata());
    }

    static String sslCertSpecJsonString(SslCertificateSpecification sslSpec) {
        String json = "{\"ssl_certificate_encoding\": \"" + sslSpec.sslKeystoreType() + "\",\"ssl_keystore_filename\": \"" + sslSpec.pkcsCertFilename() + "\",\"ssl_pem_fullchain_filename\": \"" + sslSpec.sslPemFullchainFilename() + "\",\"ssl_pem_privkey_filename\": \"" + sslSpec.sslPemPrivkeyFilename() + "\"}";
        return json;
    }

    public static Path createSpecFile(Path dir, SslCertificateSpecification sslSpec) throws IOException {
        Path newDir = Files.createTempDirectory(dir, null, new FileAttribute[0]);
        Path sslSpecPath = Paths.get(newDir.toString(), "spec.json");
        String jsonString = Utils.sslCertSpecJsonString(sslSpec);
        Files.write(sslSpecPath, jsonString.getBytes(), new OpenOption[0]);
        return sslSpecPath;
    }

    public static void syncCerts(Path dir, URL url, String dirPath) throws IOException {
        String[] certFiles;
        String certs = url.getPath();
        Path tmpDataPath = Paths.get(dir.toRealPath(new LinkOption[0]).toString(), dirPath + "..data-tmp");
        Files.createDirectories(tmpDataPath, new FileAttribute[0]);
        String symlinkPath = dir.toRealPath(new LinkOption[0]) + "/" + dirPath;
        String certDirPath = symlinkPath + "..data";
        String tmpCertDirPath = certDirPath + "-tmp";
        File syncCertFile = new File(certs);
        for (String certFile : certFiles = syncCertFile.list()) {
            Files.copy(Paths.get(syncCertFile.getCanonicalPath(), certFile), Paths.get(tmpCertDirPath, certFile), StandardCopyOption.REPLACE_EXISTING);
            Files.createSymbolicLink(Paths.get(symlinkPath, certFile), Paths.get(certDirPath, certFile), new FileAttribute[0]);
        }
        Files.move(tmpDataPath, Paths.get(dir.toRealPath(new LinkOption[0]).toString(), dirPath + "..data"), StandardCopyOption.REPLACE_EXISTING);
    }

    public static void deleteFiles(Path dir, String dirPath) throws Exception {
        String certDirPath = dir.toRealPath(new LinkOption[0]) + "/" + dirPath;
        String certDataDirPath = certDirPath + "..data";
        File certDataDir = new File(certDataDirPath);
        String[] files = certDataDir.list();
        if (files == null) {
            return;
        }
        for (String file : files) {
            Files.delete(Paths.get(certDataDirPath, file));
            Files.delete(Paths.get(certDirPath, file));
        }
        Files.delete(Paths.get(certDataDirPath, new String[0]));
    }

    public static void deleteDir(Path dir) throws IOException {
        Files.walk(dir, new FileVisitOption[0]).sorted(Comparator.reverseOrder()).map(Path::toFile).forEach(File::delete);
    }

    static void moveFile(String filename, URL sourceUrl, URL destUrl) throws IOException {
        Path sourceDir = Paths.get(sourceUrl.getPath(), new String[0]);
        Path source = Paths.get(sourceDir.toString(), filename);
        Path destDir = Paths.get(destUrl.getPath(), new String[0]);
        Files.move(source, destDir.resolve(source.getFileName()), StandardCopyOption.REPLACE_EXISTING);
    }

    private static Timestamp dateToTimestamp(Date javaDate) {
        Instant instant = javaDate.toInstant();
        return Timestamps.fromNanos((long)((long)instant.getNano() + instant.getEpochSecond() * 1000000000L));
    }

    public static LogicalCluster protoFromMetadata(KafkaLogicalClusterMetadata lcm) {
        LogicalCluster.Builder builder = LogicalCluster.newBuilder();
        try {
            JsonFormat.parser().ignoringUnknownFields().merge(Utils.logicalClusterJsonString(lcm), (Message.Builder)builder);
        }
        catch (InvalidProtocolBufferException ipbe) {
            Assertions.fail((String)"Unable to parse JSON to create LogicalCluster proto object");
        }
        if (lcm.lifecycleMetadata() != null) {
            if (lcm.lifecycleMetadata().creationDate() != null) {
                builder.setCreated(Utils.dateToTimestamp(lcm.lifecycleMetadata().creationDate()));
            }
            if (lcm.lifecycleMetadata().deletionDate() != null) {
                builder.setDeactivated(Utils.dateToTimestamp(lcm.lifecycleMetadata().deletionDate()));
            }
        }
        return builder.build();
    }

    public static ClientQuotaEntity quotaEntity(MultiTenantPrincipal principal, boolean wantDefaultQuotaEntity) {
        String tenant = principal.tenantMetadata().tenantName;
        String serviceAccount = principal.tenantMetadata().userResourceId;
        final String quotaEntityName = tenant + '_' + (wantDefaultQuotaEntity ? ConfigEntityName.Default() : serviceAccount);
        ClientQuotaEntity.ConfigEntity quotaConfigEntity = new ClientQuotaEntity.ConfigEntity(){

            public String name() {
                return quotaEntityName;
            }

            public ClientQuotaEntity.ConfigEntityType entityType() {
                return ClientQuotaEntity.ConfigEntityType.USER;
            }
        };
        return () -> Collections.singletonList(quotaConfigEntity);
    }
}

