/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.multitenant.integration.test;

import io.confluent.kafka.clients.plugins.auth.oauth.OAuthBearerLoginCallbackHandler;
import io.confluent.kafka.multitenant.PhysicalClusterMetadata;
import io.confluent.kafka.multitenant.Utils;
import io.confluent.kafka.multitenant.integration.cluster.LogicalCluster;
import io.confluent.kafka.multitenant.integration.cluster.LogicalClusterUser;
import io.confluent.kafka.multitenant.integration.cluster.PhysicalCluster;
import io.confluent.kafka.multitenant.integration.test.IntegrationTestHarness;
import io.confluent.kafka.multitenant.integration.test.SslEngineFactoryWithCorrectSni;
import io.confluent.kafka.multitenant.integration.test.SslEngineFactoryWithSniStartWithPKC;
import io.confluent.kafka.security.audit.event.ConfluentAuthenticationEvent;
import io.confluent.kafka.security.authorizer.MockAuditLogProvider;
import io.confluent.kafka.server.plugins.auth.SniValidationMode;
import io.confluent.kafka.server.plugins.auth.oauth.OAuthUtils;
import java.io.IOException;
import java.net.InetAddress;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ExecutionException;
import java.util.stream.Collectors;
import kafka.server.KafkaConfig;
import org.apache.kafka.clients.admin.AdminClient;
import org.apache.kafka.clients.admin.NewTopic;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.SaslAuthenticationException;
import org.apache.kafka.common.network.CertStores;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.security.auth.SaslAuthenticationContext;
import org.apache.kafka.server.audit.AuditEventStatus;
import org.apache.kafka.server.audit.AuthenticationErrorInfo;
import org.apache.kafka.test.TestUtils;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Tag;
import org.junit.jupiter.api.TestInfo;
import org.junit.jupiter.params.ParameterizedTest;
import org.junit.jupiter.params.provider.ValueSource;

@Tag(value="integration")
public class OAuthHostNameValidationIntegrationTest {
    private TestInfo testInfo;
    private final String logicalClusterId = Utils.LC_META_ABC.logicalClusterId();
    private final String testTopic = "abcd";
    private final String orgId = Utils.LC_META_ABC.organizationId();
    private final Properties adminProperties = new Properties();
    private final List<NewTopic> sampleTopics = Collections.singletonList(new NewTopic("abcd", 3, 1));
    private Path tempDir;
    private IntegrationTestHarness testHarness;
    private OAuthUtils.JwsContainer jwsContainer;
    private String brokerUUID;
    private PhysicalClusterMetadata metadata;
    private LogicalClusterUser testUser;
    private Map<String, Object> testCert;

    @BeforeEach
    public void setUpTempDir(TestInfo testInfo) {
        this.testInfo = testInfo;
        this.tempDir = TestUtils.tempDirectory().toPath();
    }

    private void setUp(String sniValidationMode) throws Exception {
        this.adminProperties.put("sasl.login.callback.handler.class", OAuthBearerLoginCallbackHandler.class.getName());
        MockAuditLogProvider.reset();
        this.testHarness = new IntegrationTestHarness(this.testInfo);
        boolean serviceUserId = true;
        String subject = "1";
        this.jwsContainer = new OAuthUtils.Builder(100000, "Confluent", subject, this.orgId).build();
        PhysicalCluster physicalCluster = this.testHarness.start(this.setUpMetadata(this.brokerProps(sniValidationMode)), IntegrationTestHarness.defaultOAuthBrokerProps());
        int adminUserId = 100;
        LogicalCluster logicalCluster = physicalCluster.createLogicalCluster(this.logicalClusterId, 100, 1);
        this.testUser = logicalCluster.user(1);
        this.addAdminAcls();
    }

    private void addAdminAcls() {
        this.testHarness.newAclCommand().addTopicAclArgs(this.testUser.prefixedKafkaPrincipal(), this.testUser.withPrefix("abcd"), AclOperation.ALL, PatternType.LITERAL).execute();
    }

    @AfterEach
    public void tearDown() throws Exception {
        this.testHarness.shutdown();
        this.metadata.close(this.brokerUUID);
    }

    private Properties setUpMetadata(Properties brokerProps) throws IOException, InterruptedException {
        this.brokerUUID = "uuid";
        HashMap<String, Object> configs = new HashMap<String, Object>();
        configs.put(KafkaConfig.BrokerSessionUuidProp(), this.brokerUUID);
        brokerProps.put(KafkaConfig.BrokerSessionUuidProp(), this.brokerUUID);
        brokerProps.put("ce.broker.plugins.test.audit.provider.config", "TEST");
        configs.put("multitenant.metadata.dir", this.tempDir.toRealPath(new LinkOption[0]).toString());
        this.metadata = Utils.initiatePhysicalClusterMetadata(configs);
        Utils.createLogicalClusterFile(Utils.LC_META_ABC, this.tempDir);
        TestUtils.waitForCondition(() -> this.metadata.metadata(Utils.LC_META_ABC.logicalClusterId()) != null, (String)"Expected metadata of new logical cluster to be present in metadata cache");
        return brokerProps;
    }

    private Properties brokerProps(String sniValidationMode) throws Exception {
        Properties props = IntegrationTestHarness.defaultOAuthBrokerProps();
        props.put("listener.name.external.oauthbearer.sasl.jaas.config", "org.apache.kafka.common.security.oauthbearer.OAuthBearerLoginModule required publicKeyPath=\"" + this.jwsContainer.getPublicKeyFile().toPath() + "\"" + this.getModeConfigString(sniValidationMode) + ";");
        props.put("confluent.multitenant.parse.sni.host.name.enable", (Object)true);
        props.put("listener.security.protocol.map", "INTERNAL:PLAINTEXT,REPLICATION:PLAINTEXT,EXTERNAL:SASL_SSL");
        CertStores certStores = new CertStores.Builder(true).cn("127.0.0.1").hostAddress(InetAddress.getByName("127.0.0.1")).build();
        this.testCert = certStores.keyStoreProps();
        this.testCert.putAll(certStores.trustStoreProps());
        props.put(KafkaConfig.ListenersProp(), "INTERNAL://127.0.0.1:0,REPLICATION://127.0.0.1:0,EXTERNAL://127.0.0.1:0");
        props.put(KafkaConfig.InterBrokerListenerNameProp(), "REPLICATION");
        this.testCert.values().removeIf(Objects::isNull);
        props.putAll(this.testCert);
        return props;
    }

    private String getModeConfigString(String sniValidationMode) {
        return sniValidationMode == null ? "" : "sni_host_name_validation_mode=\"" + sniValidationMode + "\"";
    }

    private String clientJaasConfig(String jwsToken, String allowedCluster) {
        return "org.apache.kafka.common.security.oauthbearer.OAuthBearerLoginModule Required token=\"" + jwsToken + "\" cluster=\"" + allowedCluster + "\";";
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testNoSniHostNameSetSuccessfulAuthenticationNoModeSpecified(String quorum) throws Exception {
        this.setUp(null);
        AdminClient client = this.adminClientWithoutSni();
        KafkaFuture future = client.createTopics(this.sampleTopics).all();
        this.verifySuccessfulAuthentication(client, (KafkaFuture<Void>)future);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testNoSniHostNameSetSuccessfulAuthenticationInOptionalMode(String quorum) throws Exception {
        this.setUp(SniValidationMode.OPTIONAL_VALIDATION.getText());
        AdminClient client = this.adminClientWithoutSni();
        KafkaFuture future = client.createTopics(this.sampleTopics).all();
        this.verifySuccessfulAuthentication(client, (KafkaFuture<Void>)future);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testPkcSniHostNameSetSuccessfulAuthenticationInOptionalMode(String quorum) throws Exception {
        this.setUp(SniValidationMode.OPTIONAL_VALIDATION.getText());
        AdminClient client = this.adminClientWithPkcSni();
        KafkaFuture future = client.createTopics(this.sampleTopics).all();
        this.verifySuccessfulAuthentication(client, (KafkaFuture<Void>)future);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testNoSniHostNameSetFailedAuthenticationInLegacyMode(String quorum) throws Exception {
        this.setUp(SniValidationMode.ALLOW_LEGACY_BOOTSTRAP.getText());
        AdminClient client = this.adminClientWithoutSni();
        KafkaFuture future = client.createTopics(this.sampleTopics).all();
        this.verifyFailedAuthentication((KafkaFuture<Void>)future, null);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testPkcHostNameSuccessfulAuthenticationInLegacyMode(String quorum) throws Exception {
        this.setUp(SniValidationMode.ALLOW_LEGACY_BOOTSTRAP.getText());
        AdminClient client = this.adminClientWithPkcSni();
        KafkaFuture future = client.createTopics(this.sampleTopics).all();
        this.verifySuccessfulAuthentication(client, (KafkaFuture<Void>)future);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCorrectHostNameSuccessfulAuthenticationInLegacyMode(String quorum) throws Exception {
        this.setUp(SniValidationMode.ALLOW_LEGACY_BOOTSTRAP.getText());
        AdminClient client = this.adminClientWithMatchingSni();
        KafkaFuture future = client.createTopics(this.sampleTopics).all();
        this.verifySuccessfulAuthentication(client, (KafkaFuture<Void>)future);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testNoHostNameFailedAuthenticationInStrictMode(String quorum) throws Exception {
        this.setUp(SniValidationMode.STRICT.getText());
        AdminClient client = this.adminClientWithoutSni();
        KafkaFuture future = client.createTopics(this.sampleTopics).all();
        this.verifyFailedAuthentication((KafkaFuture<Void>)future, null);
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testPkcHostNameFailedAuthenticationInStrictMode(String quorum) throws Exception {
        this.setUp(SniValidationMode.STRICT.getText());
        AdminClient client = this.adminClientWithPkcSni();
        KafkaFuture future = client.createTopics(this.sampleTopics).all();
        this.verifyFailedAuthentication((KafkaFuture<Void>)future, "pkc-wrong-00aa-usw2-az1-x092.us-west-2.aws.glb.confluent.cloud");
    }

    @ParameterizedTest(name="{displayName}.quorum={0}")
    @ValueSource(strings={"zk", "kraft"})
    public void testCorrectHostNameSuccessfulAuthenticationInStrictMode(String quorum) throws Exception {
        this.setUp(SniValidationMode.STRICT.getText());
        AdminClient client = this.adminClientWithMatchingSni();
        KafkaFuture future = client.createTopics(this.sampleTopics).all();
        this.verifySuccessfulAuthentication(client, (KafkaFuture<Void>)future);
    }

    private AdminClient adminClientWithoutSni() {
        return this.testHarness.createSSLOAuthAdminClient(this.clientJaasConfig(this.jwsContainer.getJwsToken(), this.logicalClusterId), this.adminProperties, this.testCert, null);
    }

    private AdminClient adminClientWithPkcSni() {
        return this.testHarness.createSSLOAuthAdminClient(this.clientJaasConfig(this.jwsContainer.getJwsToken(), this.logicalClusterId), this.adminProperties, this.testCert, SslEngineFactoryWithSniStartWithPKC.class.getCanonicalName());
    }

    private AdminClient adminClientWithMatchingSni() {
        return this.testHarness.createSSLOAuthAdminClient(this.clientJaasConfig(this.jwsContainer.getJwsToken(), this.logicalClusterId), this.adminProperties, this.testCert, SslEngineFactoryWithCorrectSni.class.getCanonicalName());
    }

    private void verifySuccessfulAuthentication(AdminClient client, KafkaFuture<Void> future) throws InterruptedException, ExecutionException {
        future.get();
        this.verifyExpectedTopicsPresent(client);
        ConfluentAuthenticationEvent authenticationEvent = this.getLastAuthenticationEvent();
        this.verifySuccessfulAuthenticationEvent(authenticationEvent);
    }

    private void verifyExpectedTopicsPresent(AdminClient client) throws InterruptedException, ExecutionException {
        List expectedTopics = this.sampleTopics.stream().map(NewTopic::name).collect(Collectors.toList());
        TestUtils.retryOnExceptionWithTimeout(() -> Assertions.assertTrue((boolean)((Set)client.listTopics().names().get()).containsAll(expectedTopics)));
    }

    private void verifySuccessfulAuthenticationEvent(ConfluentAuthenticationEvent authenticationEvent) {
        Assertions.assertEquals((Object)"User", (Object)((KafkaPrincipal)authenticationEvent.principal().get()).getPrincipalType());
        Assertions.assertEquals((Object)"1", (Object)((KafkaPrincipal)authenticationEvent.principal().get()).getName());
        Assertions.assertEquals((Object)AuditEventStatus.SUCCESS, (Object)authenticationEvent.status());
        Assertions.assertTrue((boolean)authenticationEvent.principal().isPresent(), (String)"Authentication event should contain principal");
        Assertions.assertFalse((boolean)((KafkaPrincipal)authenticationEvent.principal().get()).toString().contains("tenantMetadata"), (String)"Authentication event shouldn't contain tenant metadata");
        Assertions.assertTrue((boolean)authenticationEvent.getScope().toString().contains("kafka-cluster=lkc-abc"), (String)"Authentication event should contain expected logical cluster.");
        SaslAuthenticationContext authenticationContext = (SaslAuthenticationContext)authenticationEvent.authenticationContext();
        Assertions.assertEquals((Object)"1", (Object)authenticationContext.server().getAuthorizationID());
    }

    private void verifyFailedAuthentication(KafkaFuture<Void> future, String expectedSNIHostName) throws InterruptedException {
        TestUtils.assertFutureError(future, SaslAuthenticationException.class);
        ConfluentAuthenticationEvent authenticationEvent = this.getLastAuthenticationEvent();
        this.verifyUnauthenticatedEvent(authenticationEvent, expectedSNIHostName);
    }

    private ConfluentAuthenticationEvent getLastAuthenticationEvent() {
        MockAuditLogProvider auditLogProvider = MockAuditLogProvider.getInstance(this.brokerUUID);
        return (ConfluentAuthenticationEvent)auditLogProvider.lastAuthenticationEntry();
    }

    private void verifyUnauthenticatedEvent(ConfluentAuthenticationEvent authenticationEvent, String expectedSNIHostName) {
        Assertions.assertEquals((Object)AuditEventStatus.UNAUTHENTICATED, (Object)authenticationEvent.status());
        Assertions.assertTrue((boolean)authenticationEvent.getScope().toString().contains("kafka-cluster=lkc-abc"), (String)"Authentication event should contain expected logical cluster");
        Assertions.assertTrue((boolean)authenticationEvent.authenticationException().isPresent(), (String)"Authentication event should contain exception");
        Assertions.assertFalse((boolean)authenticationEvent.principal().isPresent(), (String)"Authentication event shouldn't contain principal");
        AuthenticationException authenticationException = (AuthenticationException)authenticationEvent.authenticationException().get();
        AuthenticationErrorInfo errorInfo = authenticationException.errorInfo();
        Assertions.assertTrue((errorInfo.errorMessage().contains("The SNI cluster Id") && errorInfo.errorMessage().contains("doesn't match with logical cluster extension") ? 1 : 0) != 0, (String)"Error message should say the SNI cluster Id doesn't match");
        Assertions.assertEquals((Object)"1", (Object)errorInfo.identifier());
        Assertions.assertEquals((Object)expectedSNIHostName, errorInfo.saslExtensions().get("__confluent_sni_broker_host_name"));
    }
}

