/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.server.plugins.policy;

import io.confluent.kafka.server.plugins.policy.ClusterLinkPolicyConfig;
import java.util.Collections;
import java.util.HashMap;
import kafka.server.link.ClusterLinkConfig;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.PolicyViolationException;
import org.apache.kafka.common.security.auth.SecurityProtocol;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ClusterLinkPolicyConfigTest {
    @Test
    public void testValidateSecurityProtocol() {
        this.testValidateSecurityProtocol(null, null, null);
        this.testValidateSecurityProtocol("localhost:9071", null, null);
        this.testValidateSecurityProtocol("localhost:9071", "OUTBOUND", null);
        this.testValidateSecurityProtocol("localhost:9071", "INBOUND", SecurityProtocol.PLAINTEXT.name);
        this.testValidateSecurityProtocol("localhost:9071", "OUTBOUND", SecurityProtocol.PLAINTEXT.name);
        this.testValidateSecurityProtocol("test.confluent.cloud:9071", "OUTBOUND", SecurityProtocol.SASL_SSL.name);
    }

    @Test
    public void testValidateJaasConfig() {
        HashMap<String, String> configs = new HashMap<String, String>();
        configs.put("bootstrap.servers", "test.confluent.cloud:9071");
        configs.put(ClusterLinkConfig.ConnectionModeProp(), "OUTBOUND");
        configs.put("security.protocol", SecurityProtocol.SASL_SSL.name);
        configs.put("sasl.mechanism", "PLAIN");
        configs.put("sasl.jaas.config", "org.apache.kafka.common.security.plain.PlainLoginModule required username=\"xxxxx\" password=\"\"xxxxx\"\"");
        ClusterLinkPolicyConfig policyConfig = new ClusterLinkPolicyConfig(configs);
        InvalidConfigurationException ex = (InvalidConfigurationException)Assertions.assertThrows(InvalidConfigurationException.class, () -> policyConfig.validateSecurityConfigs(configs));
        Assertions.assertEquals((Object)"sasl.jaas.config could not be loaded.", (Object)ex.getMessage());
    }

    @Test
    public void testValidateSecurityProtocolFailure() {
        String errMsg = "Invalid security protocol";
        PolicyViolationException ex = (PolicyViolationException)Assertions.assertThrows(PolicyViolationException.class, () -> this.testValidateSecurityProtocol("test.confluent.cloud:9071", "OUTBOUND", SecurityProtocol.PLAINTEXT.name));
        Assertions.assertTrue((boolean)ex.getMessage().contains(errMsg), (String)ex.getMessage());
        ex = (PolicyViolationException)Assertions.assertThrows(PolicyViolationException.class, () -> this.testValidateSecurityProtocol("test.confluent.cloud:9071", "OUTBOUND", SecurityProtocol.SASL_PLAINTEXT.name));
        Assertions.assertTrue((boolean)ex.getMessage().contains(errMsg), (String)ex.getMessage());
        ex = (PolicyViolationException)Assertions.assertThrows(PolicyViolationException.class, () -> this.testValidateSecurityProtocol("test.confluent.cloud:9071", "OUTBOUND", SecurityProtocol.SSL.name));
        Assertions.assertTrue((boolean)ex.getMessage().contains(errMsg), (String)ex.getMessage());
    }

    private void testValidateSecurityProtocol(String bootstrapServers, String connectionMode, String securityProtocol) {
        HashMap<String, String> configs = new HashMap<String, String>();
        if (bootstrapServers != null) {
            configs.put("bootstrap.servers", bootstrapServers);
        }
        if (connectionMode != null) {
            configs.put(ClusterLinkConfig.ConnectionModeProp(), connectionMode);
        }
        if (securityProtocol != null) {
            configs.put("security.protocol", securityProtocol);
        }
        HashMap brokerConfigs = new HashMap();
        ClusterLinkPolicyConfig policyConfig = new ClusterLinkPolicyConfig(brokerConfigs);
        policyConfig.validateSecurityConfigs(configs);
    }

    @Test
    public void testMirrorTopicSyncConfigs() {
        HashMap<String, String> linkConfigs = new HashMap<String, String>();
        linkConfigs.put("bootstrap.servers", "localhost:1234");
        ClusterLinkPolicyConfig policyConfig = new ClusterLinkPolicyConfig(Collections.emptyMap());
        policyConfig.validateClusterLinkConfigs(linkConfigs);
        linkConfigs.put(ClusterLinkConfig.TopicConfigSyncIncludeProp(), "flush.ms");
        Assertions.assertThrows(PolicyViolationException.class, () -> policyConfig.validateClusterLinkConfigs(linkConfigs));
        linkConfigs.put(ClusterLinkConfig.TopicConfigSyncIncludeProp(), "retention.ms,retention.bytes,delete.retention.ms");
        policyConfig.validateClusterLinkConfigs(linkConfigs);
        linkConfigs.put(ClusterLinkConfig.TopicConfigSyncIncludeProp(), "retention.ms,flush.ms");
        Assertions.assertThrows(PolicyViolationException.class, () -> policyConfig.validateClusterLinkConfigs(linkConfigs));
    }
}

