/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.rbac;

import io.confluent.security.authorizer.AccessRule;
import io.confluent.security.authorizer.AuthorizePolicy;
import io.confluent.security.authorizer.Operation;
import io.confluent.security.authorizer.PermissionType;
import io.confluent.security.authorizer.ResourcePattern;
import io.confluent.security.authorizer.Scope;
import io.confluent.security.rbac.RoleBinding;
import java.util.Objects;
import org.apache.kafka.common.security.auth.KafkaPrincipal;

public class RbacAccessRule
extends AccessRule {
    private final String role;
    private final Scope scope;

    public RbacAccessRule(ResourcePattern resourcePattern, KafkaPrincipal principal, PermissionType permissionType, String host, Operation operation, AuthorizePolicy.PolicyType policyType, RoleBinding roleBinding) {
        super(resourcePattern, principal, permissionType, host, operation, policyType);
        this.role = Objects.requireNonNull(roleBinding.role());
        this.scope = Objects.requireNonNull(roleBinding.scope());
    }

    public String role() {
        return this.role;
    }

    public Scope scope() {
        return this.scope;
    }

    public String toString() {
        return String.format("%s has %s permission for operation %s on %s from host %s, (policyType: %s, role: %s, scope: %s)", this.principal(), this.permissionType(), this.operation(), this.resourcePattern(), this.host(), this.policyType(), this.role, this.scope);
    }
}

