/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.collections;

import java.util.AbstractCollection;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.function.Consumer;
import java.util.function.IntFunction;
import org.agrona.collections.CollectionUtil;
import org.agrona.collections.Hashing;

public class Int2ObjectCache<V>
implements Map<Integer, V> {
    private long cachePuts = 0L;
    private long cacheHits = 0L;
    private long cacheMisses = 0L;
    private int size;
    private final int capacity;
    private final int setSize;
    private final int setSizeShift;
    private final int mask;
    private final int[] keys;
    private final Object[] values;
    private final Consumer<V> evictionConsumer;
    private ValueCollection valueCollection;
    private KeySet keySet;
    private EntrySet entrySet;

    public Int2ObjectCache(int numSets, int setSize, Consumer<V> evictionConsumer) {
        CollectionUtil.validatePositivePowerOfTwo(numSets);
        CollectionUtil.validatePositivePowerOfTwo(setSize);
        Objects.requireNonNull(evictionConsumer, "null values are not permitted");
        if ((long)numSets * (long)setSize > 0x7FFFFFF7L) {
            throw new IllegalArgumentException("total capacity must be <= max array size: numSets=" + numSets + " setSize=" + setSize);
        }
        this.setSize = setSize;
        this.setSizeShift = Integer.numberOfTrailingZeros(setSize);
        this.capacity = numSets << this.setSizeShift;
        this.mask = numSets - 1;
        this.keys = new int[this.capacity];
        this.values = new Object[this.capacity];
        this.evictionConsumer = evictionConsumer;
    }

    public long cacheHits() {
        return this.cacheHits;
    }

    public long cacheMisses() {
        return this.cacheMisses;
    }

    public long cachePuts() {
        return this.cachePuts;
    }

    public void resetCounters() {
        this.cacheHits = 0L;
        this.cacheMisses = 0L;
        this.cachePuts = 0L;
    }

    public int capacity() {
        return this.capacity;
    }

    @Override
    public int size() {
        return this.size;
    }

    @Override
    public boolean isEmpty() {
        return 0 == this.size;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.containsKey((Integer)key);
    }

    public boolean containsKey(int key) {
        boolean found = false;
        int setNumber = Hashing.hash(key, this.mask);
        int setBeginIndex = setNumber << this.setSizeShift;
        int[] keys = this.keys;
        Object[] values = this.values;
        int setEndIndex = setBeginIndex + this.setSize;
        for (int i = setBeginIndex; i < setEndIndex && null != values[i]; ++i) {
            if (key != keys[i]) continue;
            found = true;
            break;
        }
        return found;
    }

    @Override
    public boolean containsValue(Object value) {
        boolean found = false;
        if (null != value) {
            Object[] values;
            for (Object v : values = this.values) {
                if (!Objects.equals(v, value)) continue;
                found = true;
                break;
            }
        }
        return found;
    }

    @Override
    public V get(Object key) {
        return this.get((Integer)key);
    }

    public V get(int key) {
        int setNumber = Hashing.hash(key, this.mask);
        int setBeginIndex = setNumber << this.setSizeShift;
        int[] keys = this.keys;
        Object[] values = this.values;
        Object value = null;
        int setEndIndex = setBeginIndex + this.setSize;
        for (int i = setBeginIndex; i < setEndIndex && null != (value = values[i]) && key != keys[i]; ++i) {
        }
        if (null == value) {
            ++this.cacheMisses;
        } else {
            ++this.cacheHits;
        }
        return (V)value;
    }

    public V computeIfAbsent(int key, IntFunction<? extends V> mappingFunction) {
        V value = this.get(key);
        if (null == value && null != (value = mappingFunction.apply(key))) {
            this.put(key, value);
        }
        return value;
    }

    @Override
    public V put(Integer key, V value) {
        return this.put((int)key, value);
    }

    @Override
    public V put(int key, V value) {
        int setBeginIndex;
        Objects.requireNonNull(value, "null values are not supported");
        int setNumber = Hashing.hash(key, this.mask);
        Object[] values = this.values;
        int[] keys = this.keys;
        Object evictedValue = null;
        int nextSetIndex = setBeginIndex + this.setSize;
        for (int i = setBeginIndex = setNumber << this.setSizeShift; i < nextSetIndex && null != (evictedValue = values[i]); ++i) {
            if (key != keys[i]) continue;
            this.shuffleUp(i, nextSetIndex - 1);
            break;
        }
        if (null == evictedValue) {
            evictedValue = values[setBeginIndex + (this.setSize - 1)];
        }
        this.shuffleDown(setBeginIndex);
        keys[setBeginIndex] = key;
        values[setBeginIndex] = value;
        ++this.cachePuts;
        if (null != evictedValue) {
            this.evictionConsumer.accept(evictedValue);
        } else {
            ++this.size;
        }
        return null;
    }

    @Override
    public V remove(Object key) {
        return this.remove((Integer)key);
    }

    public V remove(int key) {
        int setNumber = Hashing.hash(key, this.mask);
        int setBeginIndex = setNumber << this.setSizeShift;
        int[] keys = this.keys;
        Object[] values = this.values;
        Object value = null;
        int nextSetIndex = setBeginIndex + this.setSize;
        for (int i = setBeginIndex; i < nextSetIndex && null != (value = values[i]); ++i) {
            if (key != keys[i]) continue;
            this.shuffleUp(i, nextSetIndex - 1);
            --this.size;
            this.evictionConsumer.accept(value);
            break;
        }
        return (V)value;
    }

    private void shuffleUp(int fromIndex, int toIndex) {
        int[] keys = this.keys;
        Object[] values = this.values;
        values[toIndex] = null;
        for (int i = fromIndex; i < toIndex; ++i) {
            values[i] = values[i + 1];
            keys[i] = keys[i + 1];
        }
    }

    private void shuffleDown(int setBeginIndex) {
        int[] keys = this.keys;
        Object[] values = this.values;
        for (int i = setBeginIndex + (this.setSize - 1); i > setBeginIndex; --i) {
            values[i] = values[i - 1];
            keys[i] = keys[i - 1];
        }
        values[setBeginIndex] = null;
    }

    @Override
    public void clear() {
        for (Object value : this.values) {
            if (null == value) continue;
            values[i] = null;
            --this.size;
            this.evictionConsumer.accept(value);
        }
    }

    @Override
    public void putAll(Map<? extends Integer, ? extends V> map) {
        for (Map.Entry<Integer, V> entry : map.entrySet()) {
            this.put(entry.getKey(), entry.getValue());
        }
    }

    public KeySet keySet() {
        if (null == this.keySet) {
            this.keySet = new KeySet();
        }
        return this.keySet;
    }

    public ValueCollection values() {
        if (null == this.valueCollection) {
            this.valueCollection = new ValueCollection();
        }
        return this.valueCollection;
    }

    public EntrySet entrySet() {
        if (null == this.entrySet) {
            this.entrySet = new EntrySet();
        }
        return this.entrySet;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append('{');
        int[] keys = this.keys;
        Object[] values = this.values;
        int length = values.length;
        for (int i = 0; i < length; ++i) {
            Object value = values[i];
            if (null == value) continue;
            sb.append(keys[i]).append('=').append(value).append(", ");
        }
        if (sb.length() > 1) {
            sb.setLength(sb.length() - 2);
        }
        sb.append('}');
        return sb.toString();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Map)) {
            return false;
        }
        Map that = (Map)o;
        if (this.size != that.size()) {
            return false;
        }
        int[] keys = this.keys;
        Object[] values = this.values;
        int length = values.length;
        for (int i = 0; i < length; ++i) {
            Object thatValue;
            Object thisValue = values[i];
            if (null == thisValue || thisValue.equals(thatValue = that.get(keys[i]))) continue;
            return false;
        }
        return true;
    }

    @Override
    public int hashCode() {
        int result = 0;
        int[] keys = this.keys;
        Object[] values = this.values;
        int length = values.length;
        for (int i = 0; i < length; ++i) {
            Object value = values[i];
            if (null == value) continue;
            result += Integer.hashCode(keys[i]) ^ value.hashCode();
        }
        return result;
    }

    public final class EntryIterator
    extends AbstractIterator<Map.Entry<Integer, V>>
    implements Map.Entry<Integer, V> {
        @Override
        public Map.Entry<Integer, V> next() {
            this.findNext();
            return this;
        }

        @Override
        public Integer getKey() {
            return this.getIntKey();
        }

        public int getIntKey() {
            return Int2ObjectCache.this.keys[this.position()];
        }

        @Override
        public V getValue() {
            return Int2ObjectCache.this.values[this.position()];
        }

        @Override
        public V setValue(V value) {
            throw new UnsupportedOperationException("no set on this iterator");
        }
    }

    public final class KeyIterator
    extends AbstractIterator<Integer> {
        @Override
        public Integer next() {
            return this.nextInt();
        }

        public int nextInt() {
            this.findNext();
            return Int2ObjectCache.this.keys[this.position()];
        }
    }

    public final class ValueIterator
    extends AbstractIterator<V> {
        @Override
        public V next() {
            this.findNext();
            return Int2ObjectCache.this.values[this.position()];
        }
    }

    abstract class AbstractIterator<T>
    implements Iterator<T> {
        private int remaining;
        private int position = -1;

        AbstractIterator() {
        }

        protected final int position() {
            return this.position;
        }

        @Override
        public boolean hasNext() {
            return this.remaining > 0;
        }

        protected final void findNext() {
            boolean found = false;
            Object[] values = Int2ObjectCache.this.values;
            int size = Int2ObjectCache.this.capacity;
            for (int i = this.position + 1; i < size; ++i) {
                if (null == values[i]) continue;
                found = true;
                this.position = i;
                --this.remaining;
                break;
            }
            if (!found) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public abstract T next();

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Remove not supported on Iterator");
        }

        void reset() {
            this.remaining = Int2ObjectCache.this.size;
            this.position = -1;
        }
    }

    public final class EntrySet
    extends AbstractSet<Map.Entry<Integer, V>> {
        private final EntryIterator iterator;

        public EntrySet() {
            this.iterator = new EntryIterator();
        }

        @Override
        public int size() {
            return Int2ObjectCache.this.size();
        }

        public EntryIterator iterator() {
            this.iterator.reset();
            return this.iterator;
        }

        @Override
        public void clear() {
            Int2ObjectCache.this.clear();
        }
    }

    public final class ValueCollection
    extends AbstractCollection<V> {
        private final ValueIterator iterator;

        public ValueCollection() {
            this.iterator = new ValueIterator();
        }

        @Override
        public int size() {
            return Int2ObjectCache.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return Int2ObjectCache.this.containsValue(o);
        }

        public ValueIterator iterator() {
            this.iterator.reset();
            return this.iterator;
        }

        @Override
        public void clear() {
            Int2ObjectCache.this.clear();
        }
    }

    public final class KeySet
    extends AbstractSet<Integer> {
        private final KeyIterator iterator;

        public KeySet() {
            this.iterator = new KeyIterator();
        }

        @Override
        public int size() {
            return Int2ObjectCache.this.size();
        }

        @Override
        public boolean contains(Object o) {
            return Int2ObjectCache.this.containsKey(o);
        }

        public boolean contains(int key) {
            return Int2ObjectCache.this.containsKey(key);
        }

        public KeyIterator iterator() {
            this.iterator.reset();
            return this.iterator;
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException("Cannot remove on iterator");
        }

        @Override
        public void clear() {
            Int2ObjectCache.this.clear();
        }
    }
}

