/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.dataplane;

import com.google.protobuf.InvalidProtocolBufferException;
import io.confluent.kafka.multitenant.CommonTopicBasedPhysicalClusterMetadata;
import io.confluent.kafka.multitenant.NonKafkaLogicalClusterMetadata;
import io.confluent.protobuf.cloud.events.v1.LogicalCluster;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.TimeUnit;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.metrics.MeasurableStat;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.metrics.Sensor;
import org.apache.kafka.common.metrics.stats.Avg;
import org.apache.kafka.common.metrics.stats.Max;
import org.apache.kafka.common.metrics.stats.Min;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.connect.util.KafkaBasedLog;

public class AuthnzTopicBasedPhysicalClusterMetadata
extends CommonTopicBasedPhysicalClusterMetadata<NonKafkaLogicalClusterMetadata> {
    private static final String LC_LOAD_METRICS_GROUP_NAME = "confluent-lc-load-metrics";
    private static final String LC_METADATA_END_TO_END_LOAD_TIME_SENSOR_NAME = "lc-metadata-end-to-end-load-time";
    private static final String LC_METADATA_STARTUP_LOAD_TIME_SENSOR_NAME = "lc-metadata-startup-load-time";
    private static final String LC_METADATA_END_TO_END_LOAD_TIME_MIN_METRIC_NAME = "lc-metadata-end-to-end-load-time-min";
    private static final String LC_METADATA_END_TO_END_LOAD_TIME_MAX_METRIC_NAME = "lc-metadata-end-to-end-load-time-max";
    private static final String LC_METADATA_END_TO_END_LOAD_TIME_AVG_METRIC_NAME = "lc-metadata-end-to-end-load-time-avg";
    private static final String LC_METADATA_STARTUP_LOAD_TIME_METRIC_NAME = "lc-metadata-startup-load-time-max";
    private final Sensor lcTimeToLoadEndToEndSensor;
    private final Sensor lcStartupLoadSensor;

    public AuthnzTopicBasedPhysicalClusterMetadata(Metrics metrics) {
        this(metrics, Time.SYSTEM);
    }

    public AuthnzTopicBasedPhysicalClusterMetadata(Metrics metrics, Time time) {
        super(metrics, time);
        this.lcTimeToLoadEndToEndSensor = metrics.sensor(LC_METADATA_END_TO_END_LOAD_TIME_SENSOR_NAME);
        this.lcTimeToLoadEndToEndSensor.add(metrics.metricName(LC_METADATA_END_TO_END_LOAD_TIME_MIN_METRIC_NAME, LC_LOAD_METRICS_GROUP_NAME, "The minimum end to end load time of logical cluster metadata in ms"), (MeasurableStat)new Min());
        this.lcTimeToLoadEndToEndSensor.add(metrics.metricName(LC_METADATA_END_TO_END_LOAD_TIME_MAX_METRIC_NAME, LC_LOAD_METRICS_GROUP_NAME, "The maximum end to end load time of logical cluster metadata in ms"), (MeasurableStat)new Max());
        this.lcTimeToLoadEndToEndSensor.add(metrics.metricName(LC_METADATA_END_TO_END_LOAD_TIME_AVG_METRIC_NAME, LC_LOAD_METRICS_GROUP_NAME, "The mean end to end load time of logical cluster metadata in ms"), (MeasurableStat)new Avg());
        this.lcStartupLoadSensor = metrics.sensor(LC_METADATA_STARTUP_LOAD_TIME_SENSOR_NAME);
        this.lcStartupLoadSensor.add(metrics.metricName(LC_METADATA_STARTUP_LOAD_TIME_METRIC_NAME, LC_LOAD_METRICS_GROUP_NAME, "The time it took for the first load of all logical cluster metadata from the topic in ms"), (MeasurableStat)new Max());
    }

    protected String getSessionUuid(Map<String, ?> configs) {
        String sessionUuid = (String)configs.get("confluent.authnz.session.uuid");
        if (sessionUuid == null) {
            throw new ConfigException("Config confluent.authnz.session.uuid can not be empty when using TopicBasedPhysicalClusterMetadata");
        }
        return sessionUuid;
    }

    protected Sensor getStartSensor() {
        return this.lcStartupLoadSensor;
    }

    protected Sensor getEndToEndSensor() {
        return this.lcTimeToLoadEndToEndSensor;
    }

    protected String getTopicConfig() {
        return "confluent.cdc.lc.metadata.topic";
    }

    protected String getTopicClientId(Map<String, ?> configs) {
        return String.format("%s-%s-%s", this.topicName, ConfluentConfigs.ClientType.CONSUMER, "confluent.authnz.session.uuid");
    }

    protected void shutdown() {
        LOG.info("Shutting down");
        try {
            if (this.logConsumerState.getAndSet(CommonTopicBasedPhysicalClusterMetadata.State.CLOSED) != CommonTopicBasedPhysicalClusterMetadata.State.CLOSED) {
                this.lcLog.stop();
            } else {
                LOG.info("Trying to close already closed lkcLog");
            }
        }
        catch (Exception e) {
            LOG.error("Error when shutting down lkcLog", (Throwable)e);
        }
        this.backgroundUpdatesExecutorService.shutdownNow();
        try {
            this.backgroundUpdatesExecutorService.awaitTermination(CLOSE_TIMEOUT_MS, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            LOG.debug("Shutting down was interrupted", (Throwable)e);
        }
        LOG.info("Closed topic-based tenant cluster metadata store");
    }

    protected void ensureOpen() {
        if (!CommonTopicBasedPhysicalClusterMetadata.State.RUNNING.equals(this.logConsumerState.get())) {
            throw new IllegalStateException("KafkaBasedLog for the consumer topic not started.");
        }
    }

    public Set<String> logicalClusterIds() {
        this.ensureOpen();
        return this.logicalClusterIds;
    }

    public void handleSocketServerInitialized() {
    }

    public void updateClientConfigs(Map<String, Object> interBrokerClientConfigs) {
    }

    public Map<Endpoint, CompletableFuture<Void>> start(Map<String, Object> interBrokerClientConfigs, Collection<Endpoint> endpoints) {
        return null;
    }

    public String dedicatedLogicalClusterId() {
        return null;
    }

    public Set<String> kafkaLogicalClusterIds() {
        return null;
    }

    protected NonKafkaLogicalClusterMetadata parseLCM(ConsumerRecord<String, byte[]> record) {
        NonKafkaLogicalClusterMetadata lcm = null;
        try {
            LogicalCluster asProto = LogicalCluster.parseFrom((byte[])((byte[])record.value()));
            lcm = NonKafkaLogicalClusterMetadata.fromProtobuf(asProto);
        }
        catch (InvalidProtocolBufferException e) {
            throw new IllegalArgumentException(e);
        }
        return lcm;
    }

    protected void recordEndToEndSensor(NonKafkaLogicalClusterMetadata newLcm) {
        Date creationDate;
        if (newLcm.creationDate() != null && (creationDate = newLcm.creationDate()) != null) {
            long endToEndLoadTime = this.time.milliseconds() - creationDate.getTime();
            this.getEndToEndSensor().record((double)endToEndLoadTime);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void startLog() {
        CommonTopicBasedPhysicalClusterMetadata.State currentState = (CommonTopicBasedPhysicalClusterMetadata.State)this.logConsumerState.get();
        if (currentState != CommonTopicBasedPhysicalClusterMetadata.State.STARTING) {
            throw new IllegalStateException("Trying to start a log which is in a non-starting state: " + currentState);
        }
        try {
            long startNano = this.time.nanoseconds();
            this.lcLog.start();
            Map map = this.logicalClusterMap;
            synchronized (map) {
                this.postUpdateBookkeeping();
                this.logConsumerState.set(CommonTopicBasedPhysicalClusterMetadata.State.RUNNING);
            }
            long loadTimeNano = this.time.nanoseconds() - startNano;
            this.getStartSensor().record((double)TimeUnit.NANOSECONDS.toMillis(loadTimeNano));
            LOG.info("Consumed initial set of {} lcs metadata from topic {} in {} ns", new Object[]{this.logicalClusterMap.size(), this.topicName, loadTimeNano});
        }
        catch (Exception e) {
            this.logConsumerState.set(CommonTopicBasedPhysicalClusterMetadata.State.FAILED_TO_START);
            throw new IllegalStateException("Unable to start consuming lkc metadata from topic", e);
        }
    }

    void configure() {
        this.multitenantListenerNames = Collections.emptyList();
    }

    void start(KafkaBasedLog<String, byte[]> kafkaBasedLog) {
        LOG.warn("configure(KafkaBasedLog<>) called, shouldn't happen outside tests (Ignore if this is a unittest.)");
        if (!this.logConsumerState.compareAndSet(CommonTopicBasedPhysicalClusterMetadata.State.NOT_READY, CommonTopicBasedPhysicalClusterMetadata.State.STARTING)) {
            throw new IllegalStateException("start() called twice from the same unit test. Shouldn't happen!");
        }
        this.lcLog = kafkaBasedLog;
        this.startLog();
    }
}

