/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.security.auth.provider;

import io.confluent.kafka.http.server.KafkaHttpServerBinder;
import io.confluent.security.auth.client.acl.MdsAclMigration;
import io.confluent.security.auth.metadata.AuthCache;
import io.confluent.security.auth.metadata.AuthStore;
import io.confluent.security.auth.metadata.AuthWriter;
import io.confluent.security.auth.provider.ldap.LdapAuthenticateCallbackHandler;
import io.confluent.security.auth.provider.ldap.LdapConfig;
import io.confluent.security.auth.store.kafka.KafkaAuthStore;
import io.confluent.security.authorizer.AclMigrationAware;
import io.confluent.security.authorizer.Authorizer;
import io.confluent.security.authorizer.ConfluentAuthorizerConfig;
import io.confluent.security.authorizer.EmbeddedAuthorizer;
import io.confluent.security.authorizer.Operation;
import io.confluent.security.authorizer.ResourceType;
import io.confluent.security.authorizer.Scope;
import io.confluent.security.authorizer.provider.AccessRuleProvider;
import io.confluent.security.authorizer.provider.Auditable;
import io.confluent.security.authorizer.provider.AuthorizeRule;
import io.confluent.security.authorizer.provider.ConfluentBuiltInProviders;
import io.confluent.security.authorizer.provider.GroupProvider;
import io.confluent.security.authorizer.provider.MetadataProvider;
import io.confluent.security.authorizer.provider.ResourceAuthorizeRules;
import io.confluent.security.authorizer.provider.SharedProvider;
import io.confluent.security.store.NotMasterWriterException;
import io.confluent.security.store.kafka.KafkaStoreConfig;
import java.net.URL;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.kafka.clients.admin.Admin;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.CreateAclsOptions;
import org.apache.kafka.clients.admin.DeleteAclsOptions;
import org.apache.kafka.common.ClusterResource;
import org.apache.kafka.common.ClusterResourceListener;
import org.apache.kafka.common.Endpoint;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.KafkaFuture;
import org.apache.kafka.common.acl.AclBinding;
import org.apache.kafka.common.acl.AclBindingFilter;
import org.apache.kafka.common.acl.AclState;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.RebalanceInProgressException;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.security.auth.AuthenticateCallbackHandler;
import org.apache.kafka.common.security.auth.KafkaPrincipal;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.audit.AuditLogProvider;
import org.apache.kafka.server.authorizer.AclCreateResult;
import org.apache.kafka.server.authorizer.AclDeleteResult;
import org.apache.kafka.server.authorizer.Action;
import org.apache.kafka.server.authorizer.AuthorizableRequestContext;
import org.apache.kafka.server.authorizer.AuthorizationResult;
import org.apache.kafka.server.authorizer.AuthorizerServerInfo;
import org.apache.kafka.server.authorizer.internals.ConfluentAuthorizerServerInfo;
import org.apache.kafka.server.http.MetadataServerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfluentProvider
implements AccessRuleProvider,
GroupProvider,
MetadataProvider,
org.apache.kafka.server.authorizer.Authorizer,
ClusterResourceListener,
Auditable,
AclMigrationAware,
SharedProvider {
    private static final Logger log = LoggerFactory.getLogger(ConfluentProvider.class);
    static final ResourceType SECURITY_METADATA = new ResourceType("SecurityMetadata");
    private static final Set<ResourceType> METADATA_RESOURCE_TYPES = Utils.mkSet((Object[])new ResourceType[]{SECURITY_METADATA});
    private static final Set<Operation> METADATA_OPS = Utils.mkSet((Object[])new Operation[]{new Operation("DescribeAccess"), new Operation("AlterAccess")});
    static final ResourceType CLUSTER_REGISTRY = new ResourceType("ClusterRegistry");
    private static final Set<ResourceType> CLUSTER_REGISTRY_TYPES = Utils.mkSet((Object[])new ResourceType[]{CLUSTER_REGISTRY});
    private static final Set<Operation> CLUSTER_REGISTRY_OPS = Utils.mkSet((Object[])new Operation[]{new Operation("Describe"), new Operation("Alter")});
    private Map<String, ?> configs;
    private LdapAuthenticateCallbackHandler authenticateCallbackHandler;
    private AuditLogProvider auditLogProvider;
    private Scope authScope;
    private Scope authStoreScope;
    private AuthStore authStore;
    private AuthCache authCache;
    private Optional<ConfluentAdmin> aclClient = Optional.empty();
    private ConfluentAdmin mdsAdminClient;
    private String clusterId;
    private Set<KafkaPrincipal> configuredSuperUsers;
    private Metrics kafkaMetrics = null;
    protected boolean isConfluentCloud = false;
    private volatile boolean isStarted = false;
    private CompletionStage<Void> future = null;

    public ConfluentProvider() {
        this.authScope = Scope.ROOT_SCOPE;
    }

    public void onUpdate(ClusterResource clusterResource) {
        this.clusterId = clusterResource.clusterId();
        this.authScope = Scope.kafkaClusterScope((String)this.clusterId);
        this.authScope.validate();
    }

    public synchronized void configure(Map<String, ?> configs) {
        log.info(String.format("Configuring %s in %s mode.", this.getClass().getName(), ConfluentProvider.getMode(configs)));
        if (this.isStarted) {
            log.info(String.format("%s already configured. Returning.", this.getClass().getName()));
            return;
        }
        this.configs = configs;
        if (this.clusterId == null) {
            throw new IllegalStateException("Kafka cluster id not known");
        }
        this.authStoreScope = this.authStoreScope();
        if (this.isBrokerInMdsCluster() || this.isCCRbac()) {
            Scope metadataScope = Scope.ROOT_SCOPE;
            if (!metadataScope.containsScope(this.authScope) && !Scope.ROOT_SCOPE.equals((Object)this.authScope)) {
                throw new ConfigException(String.format("Metadata service scope %s does not contain broker scope %s", metadataScope, this.authScope));
            }
            this.authStoreScope = metadataScope;
        }
        this.configuredSuperUsers = ConfluentAuthorizerConfig.parseUsers((String)((String)configs.get("super.users")));
        this.isConfluentCloud = "io.confluent.kafka.multitenant.authorizer.MultiTenantAuthorizer".equals(configs.get("authorizer.class.name"));
    }

    public Scope authStoreScope() {
        return Objects.requireNonNull(this.authScope, "authScope");
    }

    public String providerName() {
        return ConfluentBuiltInProviders.AccessRuleProviders.CONFLUENT.name();
    }

    public boolean providerConfigured(Map<String, ?> configs) {
        return this.usesMetadataFromThisKafkaCluster() || configs.containsKey("confluent.metadata.bootstrap.servers");
    }

    public synchronized CompletionStage<Void> start(ConfluentAuthorizerServerInfo serverInfo) {
        log.info(String.format("Starting %s in %s mode.", this.getClass().getName(), ConfluentProvider.getMode(this.configs)));
        if (this.isStarted) {
            log.info(String.format("%s already started. Returning existing future.", this.getClass().getName()));
            return this.future;
        }
        if (!this.providerConfigured(serverInfo.interBrokerClientConfig())) {
            throw new ConfigException("You must specify confluent.metadata.bootstrap.servers to configure the RBAC provider.");
        }
        HashMap mergedConfigs = new HashMap(this.configs);
        mergedConfigs.putAll(serverInfo.interBrokerClientConfig());
        this.authStore = this.createAuthStore(this.authStoreScope, serverInfo, mergedConfigs);
        this.authCache = this.authStore.authCache();
        this.kafkaMetrics = serverInfo.metrics();
        if (LdapConfig.ldapEnabled(this.configs)) {
            this.authenticateCallbackHandler = new LdapAuthenticateCallbackHandler();
            this.authenticateCallbackHandler.configure(this.configs, "PLAIN", Collections.emptyList());
        }
        CompletionStage serviceFuture = null;
        if (this.isBrokerInMdsCluster() || this.isCCRbac()) {
            serviceFuture = this.authStore.startService(this.metadataServerAdvertisedListeners());
        }
        CompletableFuture<?> readerFuture = this.authStore.startReader();
        CompletableFuture<?> future = serviceFuture == null ? readerFuture : this.allOrFail(Arrays.asList(readerFuture.toCompletableFuture(), serviceFuture.toCompletableFuture()));
        this.future = future.thenApply(unused -> {
            Set accessProviders;
            KafkaHttpServerBinder httpServerBinder;
            if ((this.isBrokerInMdsCluster() || this.isCCRbac()) && (httpServerBinder = serverInfo.httpServerBinder()) != null) {
                this.mdsAdminClient = this.createMdsAdminClient((AuthorizerServerInfo)serverInfo, mergedConfigs);
                EmbeddedAuthorizer authorizer = this.createRbacAuthorizer();
                httpServerBinder.bindInstance(Authorizer.class, (Object)authorizer);
                httpServerBinder.bindInstance(AuthStore.class, (Object)this.authStore);
                httpServerBinder.bindInstance(ConfluentAdmin.class, (Object)this.mdsAdminClient);
                httpServerBinder.bindInstance(AuthenticateCallbackHandler.class, (Object)this.authenticateCallbackHandler);
            }
            if ((accessProviders = ConfluentAuthorizerConfig.accessRuleProviders(this.configs)).contains(ConfluentBuiltInProviders.AccessRuleProviders.ZK_ACL.name()) || accessProviders.contains(ConfluentBuiltInProviders.AccessRuleProviders.CONFLUENT.name())) {
                this.aclClient = Optional.of(this.createMdsAdminClient((AuthorizerServerInfo)serverInfo, mergedConfigs));
            }
            return null;
        });
        this.isStarted = true;
        return this.future;
    }

    protected List<URL> metadataServerAdvertisedListeners() {
        return new MetadataServerConfig(this.configs).metadataServerAdvertisedListeners();
    }

    public boolean mayDeny() {
        return true;
    }

    public boolean usesMetadataFromThisKafkaCluster() {
        return this.isBrokerInMdsCluster() || this.isMdsKraftController();
    }

    private boolean isMdsKraftController() {
        return new MetadataServerConfig(this.configs).isMdsKraftController();
    }

    private boolean isBrokerInMdsCluster() {
        MetadataServerConfig config = new MetadataServerConfig(this.configs);
        Object processRoles = this.configs.get("process.roles");
        return (processRoles == null || processRoles.toString().isEmpty() || processRoles.toString().contains("broker")) && config.isConfluentMetadataServerEnabled();
    }

    private static String getMode(Map<String, ?> configs) {
        Object processRoles = configs.get("process.roles");
        if (processRoles == null || processRoles.toString().isEmpty()) {
            return "ZK";
        }
        if (processRoles.toString().equalsIgnoreCase("broker")) {
            return "KRaft Isolated Controller";
        }
        if (processRoles.toString().equalsIgnoreCase("controller")) {
            return "KRaft Isolated Broker";
        }
        if (processRoles.toString().contains("broker") && processRoles.toString().contains("controller")) {
            return "KRaft Combined";
        }
        return "Unknown";
    }

    private boolean isCCRbac() {
        Object accessRuleProviders = this.configs.get("confluent.authorizer.access.rule.providers");
        if (accessRuleProviders == null) {
            return false;
        }
        String accessRuleProvidersString = accessRuleProviders.toString();
        List<String> accessRuleProvidersList = Arrays.asList(accessRuleProvidersString.split(","));
        return accessRuleProvidersList.contains("NO_KAFKA_MDS_DB");
    }

    public boolean isSuperUser(KafkaPrincipal principal, Scope scope) {
        return false;
    }

    public AuthorizeRule findRule(KafkaPrincipal sessionPrincipal, Set<KafkaPrincipal> groupPrincipals, String host, io.confluent.security.authorizer.Action action) {
        return this.authCache.findRule(sessionPrincipal, groupPrincipals, host, action);
    }

    public void addMatchingRules(ResourceAuthorizeRules matchingRules, KafkaPrincipal sessionPrincipal, Set<KafkaPrincipal> groupPrincipals, String host, Operation operation, Scope scope, ResourceType resourceType) {
        this.authCache.addMatchingRules(matchingRules, sessionPrincipal, groupPrincipals, host, operation, scope, resourceType);
    }

    public Set<KafkaPrincipal> groups(KafkaPrincipal sessionPrincipal) {
        HashSet<KafkaPrincipal> groups = new HashSet<KafkaPrincipal>();
        groups.addAll(this.authCache.groups(sessionPrincipal));
        return groups;
    }

    public void close() {
        log.debug("Closing RBAC provider");
        AtomicReference<Throwable> firstException = new AtomicReference<Throwable>();
        Utils.closeQuietly((AutoCloseable)this.authStore, (String)"authStore", firstException);
        if (this.authenticateCallbackHandler != null) {
            Utils.closeQuietly((AutoCloseable)this.authenticateCallbackHandler, (String)"authenticateCallbackHandler", firstException);
        }
        Utils.closeQuietly((AutoCloseable)this.aclClient.orElse(null), (String)"aclClient", firstException);
        ConfluentProvider.closeAdminClientImmediately((Admin)this.mdsAdminClient, "mdsAdminClient", firstException);
        Throwable exception = firstException.getAndSet(null);
        if (exception != null) {
            throw new KafkaException("ConfluentProvider could not be closed cleanly", exception);
        }
    }

    private static void closeAdminClientImmediately(Admin adminClient, String name, AtomicReference<Throwable> firstException) {
        if (adminClient != null) {
            try {
                adminClient.close(Duration.ZERO);
            }
            catch (Throwable t) {
                firstException.compareAndSet(null, t);
                log.error("Failed to close {} with type {}", new Object[]{name, adminClient.getClass().getName(), t});
            }
        }
    }

    public void auditLogProvider(AuditLogProvider auditLogProvider) {
        this.auditLogProvider = auditLogProvider;
    }

    public AuthStore authStore() {
        return this.authStore;
    }

    public EmbeddedAuthorizer createRbacAuthorizer() {
        return new RbacAuthorizer();
    }

    protected ConfluentAdmin createMdsAdminClient(AuthorizerServerInfo serverInfo, Map<String, ?> clientConfigs) {
        Map<String, Object> adminClientConfigs = new KafkaStoreConfig(serverInfo, clientConfigs).adminClientConfigs();
        return (ConfluentAdmin)Admin.create(adminClientConfigs);
    }

    protected boolean isConfluentCloud() {
        return this.isConfluentCloud;
    }

    protected AuthStore createAuthStore(Scope scope, ConfluentAuthorizerServerInfo serverInfo, Map<String, ?> configs) {
        log.info("Creating auth store");
        KafkaAuthStore authStore = new KafkaAuthStore(this.isConfluentCloud, scope, serverInfo, this.isBrokerInMdsCluster() || this.isCCRbac());
        authStore.configure(configs);
        return authStore;
    }

    public Map<Endpoint, ? extends CompletionStage<Void>> start(AuthorizerServerInfo serverInfo) {
        return Collections.emptyMap();
    }

    public List<AuthorizationResult> authorize(AuthorizableRequestContext requestContext, List<Action> actions) {
        throw new IllegalStateException("This provider should be used for authorization only using the AccessRuleProvider interface");
    }

    public List<? extends CompletionStage<AclCreateResult>> createAcls(AuthorizableRequestContext requestContext, List<AclBinding> aclBindings) {
        return this.createAcls(requestContext, aclBindings, Optional.empty());
    }

    public List<? extends CompletionStage<AclCreateResult>> createAcls(AuthorizableRequestContext requestContext, List<AclBinding> aclBindings, Optional<String> aclClusterId) {
        if (!this.aclClient.isPresent()) {
            throw new IllegalStateException("Acl operations are not supported by this provider");
        }
        ConfluentAdmin adminClient = this.aclClient.get();
        AuthWriter writer = this.authStore.writer();
        ArrayList results = new ArrayList(aclBindings.size());
        if (aclClusterId.isPresent()) {
            if (writer == null || !this.authStore.isMasterWriter()) {
                CompletableFuture<AclCreateResult> result2 = CompletableFuture.completedFuture(new AclCreateResult((ApiException)new NotMasterWriterException("Current master writer is " + this.authStore.masterWriterId())));
                for (int i = 0; i < aclBindings.size(); ++i) {
                    results.add(result2);
                }
            } else {
                for (int i = 0; i < aclBindings.size(); ++i) {
                    results.add(null);
                }
                writer.createAcls(Scope.kafkaClusterScope((String)aclClusterId.get()), aclBindings).forEach((binding, result) -> results.set(aclBindings.indexOf(binding), result.toCompletableFuture()));
            }
        } else {
            Integer writerId = this.authStore.masterWriterId();
            if (writerId == null) {
                CompletableFuture<AclCreateResult> result3 = CompletableFuture.completedFuture(new AclCreateResult((ApiException)new RebalanceInProgressException("Writer election is in progress")));
                for (int i = 0; i < aclBindings.size(); ++i) {
                    results.add(result3);
                }
            } else {
                Map futures = adminClient.createCentralizedAcls(aclBindings, new CreateAclsOptions(), this.clusterId, writerId.intValue()).values();
                for (AclBinding aclBinding : aclBindings) {
                    CompletableFuture result4 = new CompletableFuture();
                    results.add(result4);
                    ((KafkaFuture)futures.get(aclBinding)).whenComplete((unused, throwable) -> {
                        if (throwable == null) {
                            result4.complete(new AclCreateResult(null));
                        } else {
                            result4.complete(new AclCreateResult(this.toApiException((Throwable)throwable)));
                        }
                    });
                }
            }
        }
        return results;
    }

    public List<? extends CompletionStage<AclDeleteResult>> deleteAcls(AuthorizableRequestContext requestContext, List<AclBindingFilter> aclBindingFilters) {
        return this.deleteAcls(requestContext, aclBindingFilters, Optional.empty(), AclState.ANY);
    }

    public List<? extends CompletionStage<AclDeleteResult>> deleteAcls(AuthorizableRequestContext requestContext, List<AclBindingFilter> aclBindingFilters, Optional<String> aclClusterId, AclState aclState) {
        if (!this.aclClient.isPresent()) {
            throw new IllegalStateException("Acl operations are not supported by this provider");
        }
        ConfluentAdmin adminClient = this.aclClient.get();
        AuthWriter writer = this.authStore.writer();
        ArrayList results = new ArrayList(aclBindingFilters.size());
        if (aclClusterId.isPresent()) {
            if (writer == null || !this.authStore.isMasterWriter()) {
                CompletableFuture<AclDeleteResult> result2 = CompletableFuture.completedFuture(new AclDeleteResult((ApiException)new NotMasterWriterException("Current master writer is " + this.authStore.masterWriterId())));
                for (int i = 0; i < aclBindingFilters.size(); ++i) {
                    results.add(result2);
                }
            } else {
                for (int i = 0; i < aclBindingFilters.size(); ++i) {
                    results.add(null);
                }
                writer.deleteAcls(Scope.kafkaClusterScope((String)aclClusterId.get()), aclBindingFilters, r -> true).forEach((filter, result) -> results.set(aclBindingFilters.indexOf(filter), result.toCompletableFuture()));
            }
        } else {
            Integer writerId = this.authStore.masterWriterId();
            if (writerId == null) {
                CompletableFuture<AclDeleteResult> result3 = CompletableFuture.completedFuture(new AclDeleteResult((ApiException)new RebalanceInProgressException("Writer election is in progress")));
                for (int i = 0; i < aclBindingFilters.size(); ++i) {
                    results.add(result3);
                }
            } else {
                Map futures = adminClient.deleteCentralizedAcls(aclBindingFilters, new DeleteAclsOptions(), this.clusterId, writerId.intValue()).values();
                for (AclBindingFilter aclBindingFilter : aclBindingFilters) {
                    CompletableFuture result4 = new CompletableFuture();
                    results.add(result4);
                    ((KafkaFuture)futures.get(aclBindingFilter)).whenComplete((deleteResult, throwable) -> {
                        if (throwable == null) {
                            result4.complete(new AclDeleteResult((Collection)deleteResult.values().stream().map(acl -> new AclDeleteResult.AclBindingDeleteResult(acl.binding())).collect(Collectors.toList())));
                        } else {
                            result4.complete(new AclDeleteResult(this.toApiException((Throwable)throwable)));
                        }
                    });
                }
            }
        }
        return results;
    }

    public Iterable<AclBinding> acls(AclBindingFilter filter) {
        if (!this.aclClient.isPresent()) {
            throw new IllegalStateException("Acl operations are not supported by this provider");
        }
        return this.authCache.aclBindings(this.authScope, filter, r -> true);
    }

    public Runnable migrationTask(org.apache.kafka.server.authorizer.Authorizer sourceAuthorizer) {
        return () -> {
            MdsAclMigration aclMigration = new MdsAclMigration(this.clusterId, () -> this.authStore.masterWriterId());
            if (!this.aclClient.isPresent()) {
                throw new IllegalStateException("ACL provider is not enabled");
            }
            try {
                aclMigration.migrate(this.configs, sourceAuthorizer, this.aclClient.get());
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        };
    }

    public void setKafkaMetrics(Metrics metrics) {
        this.kafkaMetrics = metrics;
    }

    private ApiException toApiException(Throwable throwable) {
        return throwable instanceof ApiException ? (ApiException)throwable : new ApiException(throwable);
    }

    private CompletableFuture<?> allOrFail(List<CompletableFuture<Void>> futures) {
        CompletableFuture failFuture = new CompletableFuture();
        futures.forEach(future -> future.exceptionally(e -> {
            failFuture.completeExceptionally((Throwable)e);
            return null;
        }));
        CompletableFuture[] futureArray = futures.toArray(new CompletableFuture[futures.size()]);
        return CompletableFuture.anyOf(CompletableFuture.allOf(futureArray), failFuture);
    }

    public Optional<org.apache.kafka.server.authorizer.Authorizer> asAuthorizer() {
        return Optional.of(this);
    }

    private class RbacAuthorizer
    extends EmbeddedAuthorizer {
        RbacAuthorizer() {
            this.setupAuthorizerMetrics(ConfluentProvider.this.kafkaMetrics);
            this.configureProviders(Collections.singletonList(ConfluentProvider.this), ConfluentProvider.this, null, ConfluentProvider.this.auditLogProvider);
        }

        protected boolean isSuperUser(KafkaPrincipal sessionPrincipal, KafkaPrincipal userOrGroupPrincipal, io.confluent.security.authorizer.Action action) {
            return ConfluentProvider.this.configuredSuperUsers.contains(userOrGroupPrincipal) && (this.isRoleBindingRelated(action) || this.isClusterRegistryRelated(action));
        }

        private boolean isRoleBindingRelated(io.confluent.security.authorizer.Action action) {
            return METADATA_RESOURCE_TYPES.contains(action.resourceType()) || METADATA_OPS.contains(action.operation());
        }

        private boolean isClusterRegistryRelated(io.confluent.security.authorizer.Action action) {
            return CLUSTER_REGISTRY_TYPES.contains(action.resourceType()) && CLUSTER_REGISTRY_OPS.contains(action.operation());
        }
    }
}

