/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import com.yammer.metrics.core.Gauge;
import java.io.Serializable;
import java.lang.invoke.LambdaMetafactory;
import kafka.cluster.BrokerEndPoint;
import kafka.server.AbstractFetcherThread;
import kafka.server.BrokerAndFetcherId;
import kafka.server.FailedPartitions;
import kafka.server.FetchConnectionsMode;
import kafka.server.FetchConnectionsMode$Isolated$;
import kafka.server.FetcherLagMetrics;
import kafka.server.FetcherPool;
import kafka.server.FetcherPool$;
import kafka.server.FetcherPool$Default$;
import kafka.server.FetcherPool$InSync$;
import kafka.server.FetcherTag;
import kafka.server.InitialFetchState;
import kafka.server.PartitionFetchState;
import kafka.server.PausedPartitions;
import kafka.utils.Implicits$MapExtensionMethods$;
import kafka.utils.Logging;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.metrics.KafkaMetricsGroup;
import org.apache.kafka.server.util.Scheduler;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Map;
import scala.collection.MapOps;
import scala.collection.Set;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.mutable.HashMap;
import scala.collection.mutable.HashSet;
import scala.collection.mutable.Map$;
import scala.jdk.CollectionConverters$;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t5f!\u0002\u001a4\u0003\u0003A\u0004\u0002\u0003$\u0001\u0005\u000b\u0007I\u0011A$\t\u0011M\u0003!\u0011!Q\u0001\n!C\u0001\u0002\u0016\u0001\u0003\u0002\u0003\u0006I\u0001\u0013\u0005\t+\u0002\u0011\t\u0011)A\u0005-\"A\u0011\f\u0001B\u0001B\u0003%!\f\u0003\u0005_\u0001\t\u0005\t\u0015!\u0003`\u0011!q\u0007A!A!\u0002\u0013y\u0007\"B;\u0001\t\u00031\b\"CA\n\u0001\t\u0007I\u0011BA\u000b\u0011!\t\u0019\u0003\u0001Q\u0001\n\u0005]\u0001BCA\u0013\u0001\t\u0007I\u0011A\u001a\u0002(!A\u00111\b\u0001!\u0002\u0013\tI\u0003C\u0005\u0002>\u0001\u0011\r\u0011\"\u0005\u0002@!A\u0011\u0011\u000b\u0001!\u0002\u0013\t\t\u0005C\u0005\u0002T\u0001\u0001\r\u0011\"\u0003\u0002V!I\u0011q\u000b\u0001A\u0002\u0013%\u0011\u0011\f\u0005\b\u0003K\u0002\u0001\u0015)\u0003W\u0011%\t9\u0007\u0001b\u0001\n#\tI\u0007C\u0004\u0002l\u0001\u0001\u000b\u0011\u0002.\t\u0013\u00055\u0004A1A\u0005\u0002\u0005=\u0004\u0002CA<\u0001\u0001\u0006I!!\u001d\t\u0013\u0005e\u0004A1A\u0005\u0002\u0005m\u0004\u0002CAB\u0001\u0001\u0006I!! \t\u0013\u0005\u0015\u0005A1A\u0005\n\u0005\u001d\u0005\u0002CAH\u0001\u0001\u0006I!!#\t\u0011\u0005E\u0005\u0001\"\u00014\u0003'Cq!!&\u0001\t\u0013\t9\n\u0003\u0005\u0002&\u0002!\taMA+\u0011\u001d\t9\u000b\u0001C\u0001\u0003SC\u0001\"a,\u0001\t\u0003\u0019\u0014\u0011\u0017\u0005\t\u0003\u000b\u0004A\u0011A\u001a\u0002H\"9\u00111\u001a\u0001\u0005\u0002\u00055\u0007bBAp\u0001\u0019\u0005\u0011\u0011\u001d\u0005\b\u0005\u0003\u0001A\u0011\u0001B\u0002\u0011%\u0011i\u0002AI\u0001\n\u0003\u0011y\u0002C\u0004\u00036\u0001!\tAa\u000e\t\u000f\tm\u0002\u0001\"\u0005\u0003>!9!q\t\u0001\u0005\u0002\t%\u0003\"\u0003B'\u0001E\u0005I\u0011\u0001B\u0010\u0011\u001d\u0011y\u0005\u0001C\t\u0005#BqAa\u0019\u0001\t\u0003\u0011)\u0007C\u0004\u0003\u0000\u0001!\tA!!\t\u000f\t5\u0005\u0001\"\u0001\u0002\u0014\"9!q\u0012\u0001\u0005\u0002\u0005Mu!\u0003BIg\u0005\u0005\t\u0012\u0001BJ\r!\u00114'!A\t\u0002\tU\u0005BB;/\t\u0003\u00119\nC\u0005\u0003\u001a:\n\n\u0011\"\u0001\u0003\u001c\"I!1\u0015\u0018\u0012\u0002\u0013\u0005!Q\u0015\u0002\u0017\u0003\n\u001cHO]1di\u001a+Go\u00195fe6\u000bg.Y4fe*\u0011A'N\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003Y\nQa[1gW\u0006\u001c\u0001!\u0006\u0002:uN\u0019\u0001A\u000f!\u0011\u0005mrT\"\u0001\u001f\u000b\u0003u\nQa]2bY\u0006L!a\u0010\u001f\u0003\r\u0005s\u0017PU3g!\t\tE)D\u0001C\u0015\t\u0019U'A\u0003vi&d7/\u0003\u0002F\u0005\n9Aj\\4hS:<\u0017\u0001\u00028b[\u0016,\u0012\u0001\u0013\t\u0003\u0013Bs!A\u0013(\u0011\u0005-cT\"\u0001'\u000b\u00055;\u0014A\u0002\u001fs_>$h(\u0003\u0002Py\u00051\u0001K]3eK\u001aL!!\u0015*\u0003\rM#(/\u001b8h\u0015\tyE(A\u0003oC6,\u0007%\u0001\u0005dY&,g\u000e^%e\u0003-qW/\u001c$fi\u000eDWM]:\u0011\u0005m:\u0016B\u0001-=\u0005\rIe\u000e^\u0001\nM\u0016$8\r['pI\u0016\u0004\"a\u0017/\u000e\u0003MJ!!X\u001a\u0003)\u0019+Go\u00195D_:tWm\u0019;j_:\u001cXj\u001c3f\u0003%\u00198\r[3ek2,'\u000fE\u0002<A\nL!!\u0019\u001f\u0003\r=\u0003H/[8o!\t\u0019G.D\u0001e\u0015\t)g-\u0001\u0003vi&d'B\u0001\u001bh\u0015\t1\u0004N\u0003\u0002jU\u00061\u0011\r]1dQ\u0016T\u0011a[\u0001\u0004_J<\u0017BA7e\u0005%\u00196\r[3ek2,'/A\bfqR\u0014\u0018-T3ue&\u001cG+Y4t!\u0011\u00018\u000f\u0013%\u000e\u0003ET!A\u001d\u001f\u0002\u0015\r|G\u000e\\3di&|g.\u0003\u0002uc\n\u0019Q*\u00199\u0002\rqJg.\u001b;?)59\u0018qAA\u0005\u0003\u0017\ti!a\u0004\u0002\u0012A\u00191\f\u0001=\u0011\u0005eTH\u0002\u0001\u0003\u0006w\u0002\u0011\r\u0001 \u0002\u0002)F\u0019Q0!\u0001\u0011\u0005mr\u0018BA@=\u0005\u001dqu\u000e\u001e5j]\u001e\u00042aWA\u0002\u0013\r\t)a\r\u0002\u0016\u0003\n\u001cHO]1di\u001a+Go\u00195feRC'/Z1e\u0011\u00151\u0005\u00021\u0001I\u0011\u0015!\u0006\u00021\u0001I\u0011\u0015)\u0006\u00021\u0001W\u0011\u0015I\u0006\u00021\u0001[\u0011\u001dq\u0006\u0002%AA\u0002}CqA\u001c\u0005\u0011\u0002\u0003\u0007q.\u0001\u0007nKR\u0014\u0018nY:He>,\b/\u0006\u0002\u0002\u0018A!\u0011\u0011DA\u0010\u001b\t\tYBC\u0002\u0002\u001e\u0019\fq!\\3ue&\u001c7/\u0003\u0003\u0002\"\u0005m!!E&bM.\fW*\u001a;sS\u000e\u001cxI]8va\u0006iQ.\u001a;sS\u000e\u001cxI]8va\u0002\n\u0001CZ3uG\",'\u000f\u00165sK\u0006$W*\u00199\u0016\u0005\u0005%\u0002cBA\u0016\u0003c\t)\u0004_\u0007\u0003\u0003[Q1!a\fr\u0003\u001diW\u000f^1cY\u0016LA!a\r\u0002.\t9\u0001*Y:i\u001b\u0006\u0004\bcA.\u00028%\u0019\u0011\u0011H\u001a\u0003\u0015\u0019+Go\u00195feR\u000bw-A\tgKR\u001c\u0007.\u001a:UQJ,\u0017\rZ'ba\u0002\nA\u0001\\8dWV\u0011\u0011\u0011\t\t\u0005\u0003\u0007\ni%\u0004\u0002\u0002F)!\u0011qIA%\u0003\u0011a\u0017M\\4\u000b\u0005\u0005-\u0013\u0001\u00026bm\u0006LA!a\u0014\u0002F\t1qJ\u00196fGR\fQ\u0001\\8dW\u0002\nAC\\;n\r\u0016$8\r[3sgB+'O\u0011:pW\u0016\u0014X#\u0001,\u000219,XNR3uG\",'o\u001d)fe\n\u0013xn[3s?\u0012*\u0017\u000f\u0006\u0003\u0002\\\u0005\u0005\u0004cA\u001e\u0002^%\u0019\u0011q\f\u001f\u0003\tUs\u0017\u000e\u001e\u0005\t\u0003G\u0002\u0012\u0011!a\u0001-\u0006\u0019\u0001\u0010J\u0019\u0002+9,XNR3uG\",'o\u001d)fe\n\u0013xn[3sA\u0005Y\"/\u001a9mS\u000e\fg)\u001a;dQ\u000e{gN\\3di&|gn]'pI\u0016,\u0012AW\u0001\u001de\u0016\u0004H.[2b\r\u0016$8\r[\"p]:,7\r^5p]Nlu\u000eZ3!\u0003A1\u0017-\u001b7fIB\u000b'\u000f^5uS>t7/\u0006\u0002\u0002rA\u00191,a\u001d\n\u0007\u0005U4G\u0001\tGC&dW\r\u001a)beRLG/[8og\u0006\tb-Y5mK\u0012\u0004\u0016M\u001d;ji&|gn\u001d\u0011\u0002!A\fWo]3e!\u0006\u0014H/\u001b;j_:\u001cXCAA?!\rY\u0016qP\u0005\u0004\u0003\u0003\u001b$\u0001\u0005)bkN,G\rU1si&$\u0018n\u001c8t\u0003E\u0001\u0018-^:fIB\u000b'\u000f^5uS>t7\u000fI\u0001\u0005i\u0006<7/\u0006\u0002\u0002\nB)\u0001o]AF\u0011B!\u00111IAG\u0013\r\t\u0016QI\u0001\u0006i\u0006<7\u000fI\u0001\u001dGJ,\u0017\r^3TKB\f'/\u0019;f\r\u0016$8\r[3s\u001b\u0016$(/[2t)\t\tY&\u0001\u0007nS:4U\r^2i%\u0006$X\r\u0006\u0003\u0002\u001a\u0006}\u0005cA\u001e\u0002\u001c&\u0019\u0011Q\u0014\u001f\u0003\r\u0011{WO\u00197f\u0011\u001d\t\tk\u0007a\u0001\u0003G\u000b!BZ3uG\",'/T1q!\u0015\u00018/!\u000ey\u0003=!W-\u00193UQJ,\u0017\rZ\"pk:$\u0018\u0001\u0005:fg&TX\r\u00165sK\u0006$\u0007k\\8m)\u0011\tY&a+\t\r\u00055V\u00041\u0001W\u0003\u001dqWm^*ju\u0016\f!bZ3u\r\u0016$8\r[3s)\u0011\t\u0019,!.\u0011\u0007m\u0002\u0007\u0010C\u0004\u00028z\u0001\r!!/\u0002\u001dQ|\u0007/[2QCJ$\u0018\u000e^5p]B!\u00111XAa\u001b\t\tiLC\u0002\u0002@\u001e\faaY8n[>t\u0017\u0002BAb\u0003{\u0013a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.\u0001\u0007hKR4U\r^2iKJLE\rF\u0002W\u0003\u0013Dq!a. \u0001\u0004\tI,A\u000enCJ\\\u0007+\u0019:uSRLwN\\:G_J$&/\u001e8dCRLwN\u001c\u000b\t\u00037\ny-a5\u0002V\"1\u0011\u0011\u001b\u0011A\u0002Y\u000b\u0001B\u0019:pW\u0016\u0014\u0018\n\u001a\u0005\b\u0003o\u0003\u0003\u0019AA]\u0011\u001d\t9\u000e\ta\u0001\u00033\f\u0001\u0003\u001e:v]\u000e\fG/[8o\u001f\u001a47/\u001a;\u0011\u0007m\nY.C\u0002\u0002^r\u0012A\u0001T8oO\u0006\u00192M]3bi\u00164U\r^2iKJ$\u0006N]3bIR9\u00010a9\u0002h\u0006]\bBBAsC\u0001\u0007a+A\u0005gKR\u001c\u0007.\u001a:JI\"9\u0011\u0011^\u0011A\u0002\u0005-\u0018\u0001D:pkJ\u001cWM\u0011:pW\u0016\u0014\b\u0003BAw\u0003gl!!a<\u000b\u0007\u0005EX'A\u0004dYV\u001cH/\u001a:\n\t\u0005U\u0018q\u001e\u0002\u000f\u0005J|7.\u001a:F]\u0012\u0004v.\u001b8u\u0011\u001d\tI0\ta\u0001\u0003w\f1BZ3uG\",'\u000fU8pYB\u00191,!@\n\u0007\u0005}8GA\u0006GKR\u001c\u0007.\u001a:Q_>d\u0017aF1eI\u001a+Go\u00195fe\u001a{'\u000fU1si&$\u0018n\u001c8t)!\tYF!\u0002\u0003\u0012\tM\u0001b\u0002B\u0004E\u0001\u0007!\u0011B\u0001\u0014a\u0006\u0014H/\u001b;j_:\fe\u000eZ(gMN,Go\u001d\t\u0007aN\fILa\u0003\u0011\u0007m\u0013i!C\u0002\u0003\u0010M\u0012\u0011#\u00138ji&\fGNR3uG\"\u001cF/\u0019;f\u0011\u001d\tIP\ta\u0001\u0003wD\u0011B!\u0006#!\u0003\u0005\rAa\u0006\u0002\u0011\r\fG\u000e\u001c2bG.\u0004\u0002b\u000fB\r\u0003sC\u00181L\u0005\u0004\u00057a$!\u0003$v]\u000e$\u0018n\u001c83\u0003\u0005\nG\r\u001a$fi\u000eDWM\u001d$peB\u000b'\u000f^5uS>t7\u000f\n3fM\u0006,H\u000e\u001e\u00134+\t\u0011\tC\u000b\u0003\u0003\u0018\t\r2F\u0001B\u0013!\u0011\u00119C!\r\u000e\u0005\t%\"\u0002\u0002B\u0016\u0005[\t\u0011\"\u001e8dQ\u0016\u001c7.\u001a3\u000b\u0007\t=B(\u0001\u0006b]:|G/\u0019;j_:LAAa\r\u0003*\t\tRO\\2iK\u000e\\W\r\u001a,be&\fgnY3\u0002%\u0005$GMR1jY\u0016$\u0007+\u0019:uSRLwN\u001c\u000b\u0005\u00037\u0012I\u0004C\u0004\u00028\u0012\u0002\r!!/\u00029\u0005$G\rU1si&$\u0018n\u001c8t)>4U\r^2iKJ$\u0006N]3bIR1\u00111\fB \u0005\u0007BaA!\u0011&\u0001\u0004A\u0018!\u00044fi\u000eDWM\u001d+ie\u0016\fG\rC\u0004\u0003F\u0015\u0002\rA!\u0003\u0002-%t\u0017\u000e^5bY>3gm]3u\u0003:$W\t]8dQN\fA$\\1zE\u0016l\u0015n\u001a:bi\u0016LenU=oGB\u000b'\u000f^5uS>t7\u000f\u0006\u0003\u0002\\\t-\u0003\"\u0003B\u000bMA\u0005\t\u0019\u0001B\f\u0003\u0019j\u0017-\u001f2f\u001b&<'/\u0019;f\u0013:\u001c\u0016P\\2QCJ$\u0018\u000e^5p]N$C-\u001a4bk2$H%M\u0001\u0014i>Le.\u001b;jC24U\r^2i'R\fG/\u001a\u000b\u0007\u0005\u0013\u0011\u0019Fa\u0016\t\u000f\tU\u0003\u00061\u0001\u0002\u0002\u00059a-\u001a;dQ\u0016\u0014\bb\u0002B-Q\u0001\u0007!1L\u0001\u0010a\u0006\u0014H/\u001b;j_:\u001cF/\u0019;fgB1\u0001o]A]\u0005;\u00022a\u0017B0\u0013\r\u0011\tg\r\u0002\u0014!\u0006\u0014H/\u001b;j_:4U\r^2i'R\fG/Z\u0001\u0014[\u0006L(-Z+qI\u0006$X\rV8qS\u000eLEm\u001d\u000b\u0007\u00037\u00129G!\u001c\t\u000f\t%\u0014\u00061\u0001\u0003l\u0005\u0011\u0002/\u0019:uSRLwN\\:U_V\u0003H-\u0019;f!\u0015\u00018/!/W\u0011\u001d\u0011y'\u000ba\u0001\u0005c\n\u0001\u0002^8qS\u000eLEm\u001d\t\u0007w\tM\u0004Ja\u001e\n\u0007\tUDHA\u0005Gk:\u001cG/[8ocA!1\b\u0019B=!\u0011\tYLa\u001f\n\t\tu\u0014Q\u0018\u0002\u0005+VLG-\u0001\u000esK6|g/\u001a$fi\u000eDWM\u001d$peB\u000b'\u000f^5uS>t7\u000f\u0006\u0003\u0003\\\t\r\u0005b\u0002BCU\u0001\u0007!qQ\u0001\u000ba\u0006\u0014H/\u001b;j_:\u001c\b#\u00029\u0003\n\u0006e\u0016b\u0001BFc\n\u00191+\u001a;\u00025MDW\u000f\u001e3po:LE\r\\3GKR\u001c\u0007.\u001a:UQJ,\u0017\rZ:\u0002!\rdwn]3BY24U\r^2iKJ\u001c\u0018AF!cgR\u0014\u0018m\u0019;GKR\u001c\u0007.\u001a:NC:\fw-\u001a:\u0011\u0005ms3C\u0001\u0018;)\t\u0011\u0019*A\u000e%Y\u0016\u001c8/\u001b8ji\u0012:'/Z1uKJ$C-\u001a4bk2$H%N\u000b\u0005\u0005;\u0013\t+\u0006\u0002\u0003 *\u001aqLa\t\u0005\u000bm\u0004$\u0019\u0001?\u00027\u0011bWm]:j]&$He\u001a:fCR,'\u000f\n3fM\u0006,H\u000e\u001e\u00137+\u0011\u00119Ka+\u0016\u0005\t%&fA8\u0003$\u0011)10\rb\u0001y\u0002")
public abstract class AbstractFetcherManager<T extends AbstractFetcherThread>
implements Logging {
    private final String name;
    private final KafkaMetricsGroup metricsGroup;
    private final HashMap<FetcherTag, T> fetcherThreadMap;
    private final Object lock;
    private int numFetchersPerBroker;
    private final FetchConnectionsMode replicaFetchConnectionsMode;
    private final FailedPartitions failedPartitions;
    private final PausedPartitions pausedPartitions;
    private final Map<String, String> tags;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static <T extends AbstractFetcherThread> Map<String, String> $lessinit$greater$default$6() {
        return (Map)scala.collection.Map$.MODULE$.empty();
    }

    public static <T extends AbstractFetcherThread> Option<Scheduler> $lessinit$greater$default$5() {
        return None$.MODULE$;
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public String name() {
        return this.name;
    }

    private KafkaMetricsGroup metricsGroup() {
        return this.metricsGroup;
    }

    public HashMap<FetcherTag, T> fetcherThreadMap() {
        return this.fetcherThreadMap;
    }

    public Object lock() {
        return this.lock;
    }

    private int numFetchersPerBroker() {
        return this.numFetchersPerBroker;
    }

    private void numFetchersPerBroker_$eq(int x$1) {
        this.numFetchersPerBroker = x$1;
    }

    public FetchConnectionsMode replicaFetchConnectionsMode() {
        return this.replicaFetchConnectionsMode;
    }

    public FailedPartitions failedPartitions() {
        return this.failedPartitions;
    }

    public PausedPartitions pausedPartitions() {
        return this.pausedPartitions;
    }

    private Map<String, String> tags() {
        return this.tags;
    }

    public void createSeparateFetcherMetrics() {
        FetcherPool$.MODULE$.values().foreach((Function1 & Serializable)fetcherPool -> this.metricsGroup().newGauge("MinFetchRate", (Gauge)new Gauge<Object>(this, fetcherPool){
            private final /* synthetic */ AbstractFetcherManager $outer;
            private final FetcherPool fetcherPool$1;

            public final double value() {
                return this.$outer.kafka$server$AbstractFetcherManager$$$anonfun$createSeparateFetcherMetrics$2(this.fetcherPool$1);
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.fetcherPool$1 = fetcherPool$1;
            }
        }, CollectionConverters$.MODULE$.MapHasAsJava((Map)this.tags().$plus$plus((IterableOnce)scala.collection.Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"FetcherPool"), (Object)fetcherPool.name())})))).asJava()));
    }

    private double minFetchRate(Map<FetcherTag, T> fetcherMap) {
        double headRate = BoxesRunTime.unboxToDouble((Object)fetcherMap.values().headOption().map((Function1 & Serializable)x$4 -> BoxesRunTime.boxToDouble((double)AbstractFetcherManager.$anonfun$minFetchRate$1(x$4))).getOrElse((Function0)(JFunction0.mcD.sp & Serializable)() -> 0.0));
        return BoxesRunTime.unboxToDouble((Object)fetcherMap.values().foldLeft((Object)BoxesRunTime.boxToDouble((double)headRate), (Function2 & Serializable)(curMinAll, fetcherThread) -> BoxesRunTime.boxToDouble((double)package$.MODULE$.min(BoxesRunTime.unboxToDouble((Object)curMinAll), fetcherThread.fetcherStats().requestRate().oneMinuteRate()))));
    }

    public int deadThreadCount() {
        Object object = this.lock();
        synchronized (object) {
            int n = this.fetcherThreadMap().values().count((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.isThreadFailed()));
            return n;
        }
    }

    public void resizeThreadPool(int newSize) {
        Object object = this.lock();
        synchronized (object) {
            int currentSize = this.numFetchersPerBroker();
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(43).append("Resizing fetcher thread pool size from ").append(currentSize).append(" to ").append(newSize).toString());
            this.numFetchersPerBroker_$eq(newSize);
            if (newSize != currentSize) {
                this.migratePartitions$1(newSize);
            }
            this.shutdownIdleFetcherThreads();
            return;
        }
    }

    public Option<T> getFetcher(TopicPartition topicPartition) {
        Object object = this.lock();
        synchronized (object) {
            Option option = this.fetcherThreadMap().values().find((Function1 & Serializable)fetcherThread -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$getFetcher$1(topicPartition, fetcherThread)));
            return option;
        }
    }

    public int getFetcherId(TopicPartition topicPartition) {
        Object object = this.lock();
        synchronized (object) {
            int n = Utils.abs((int)(31 * topicPartition.topic().hashCode() + topicPartition.partition())) % this.numFetchersPerBroker();
            return n;
        }
    }

    public void markPartitionsForTruncation(int brokerId, TopicPartition topicPartition, long truncationOffset) {
        Object object = this.lock();
        synchronized (object) {
            int fetcherId = this.getFetcherId(topicPartition);
            FetcherPool$.MODULE$.values().foreach((Function1 & Serializable)fetcherPool -> {
                AbstractFetcherManager.$anonfun$markPartitionsForTruncation$1(this, brokerId, fetcherId, topicPartition, truncationOffset, fetcherPool);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public abstract T createFetcherThread(int var1, BrokerEndPoint var2, FetcherPool var3);

    public void addFetcherForPartitions(Map<TopicPartition, InitialFetchState> partitionAndOffsets, FetcherPool fetcherPool, Function2<TopicPartition, T, BoxedUnit> callback) {
        Object object = this.lock();
        synchronized (object) {
            partitionAndOffsets.groupBy((Function1 & Serializable)x0$1 -> {
                if (x0$1 != null) {
                    TopicPartition topicPartition = (TopicPartition)x0$1._1();
                    InitialFetchState brokerAndInitialFetchOffset = (InitialFetchState)x0$1._2();
                    return new BrokerAndFetcherId(brokerAndInitialFetchOffset.leader(), this.getFetcherId(topicPartition));
                }
                throw new MatchError(null);
            }).withFilter((Function1 & Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$addFetcherForPartitions$2(check$ifrefutable$1))).foreach((Function1 & Serializable)x$8 -> {
                AbstractFetcherManager.$anonfun$addFetcherForPartitions$3(this, fetcherPool, callback, x$8);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public Function2<TopicPartition, T, BoxedUnit> addFetcherForPartitions$default$3() {
        return (Function2 & Serializable)(x$6, x$7) -> {
            AbstractFetcherManager.$anonfun$addFetcherForPartitions$default$3$1(x$6, x$7);
            return BoxedUnit.UNIT;
        };
    }

    public void addFailedPartition(TopicPartition topicPartition) {
        Object object = this.lock();
        synchronized (object) {
            this.failedPartitions().add(topicPartition);
            return;
        }
    }

    public void addPartitionsToFetcherThread(T fetcherThread, Map<TopicPartition, InitialFetchState> initialOffsetAndEpochs) {
        ((AbstractFetcherThread)fetcherThread).addPartitions(initialOffsetAndEpochs);
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(41).append("Added fetcher ").append(fetcherThread.getName()).append(" to broker ").append(fetcherThread.leader().brokerEndPoint().id()).append(" for partitions ").append(initialOffsetAndEpochs).toString());
    }

    public void maybeMigrateInSyncPartitions(Function2<TopicPartition, T, BoxedUnit> callback) {
        Object object = this.lock();
        synchronized (object) {
            this.fetcherThreadMap().withFilter((Function1 & Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$maybeMigrateInSyncPartitions$1(check$ifrefutable$2))).foreach((Function1 & Serializable)x$11 -> {
                AbstractFetcherManager.$anonfun$maybeMigrateInSyncPartitions$2(this, callback, x$11);
                return BoxedUnit.UNIT;
            });
            this.shutdownIdleFetcherThreads();
            return;
        }
    }

    public Function2<TopicPartition, T, BoxedUnit> maybeMigrateInSyncPartitions$default$1() {
        return (Function2 & Serializable)(x$9, x$10) -> {
            AbstractFetcherManager.$anonfun$maybeMigrateInSyncPartitions$default$1$1(x$9, x$10);
            return BoxedUnit.UNIT;
        };
    }

    public Map<TopicPartition, InitialFetchState> toInitialFetchState(AbstractFetcherThread fetcher, Map<TopicPartition, PartitionFetchState> partitionStates) {
        return (Map)partitionStates.map((Function1 & Serializable)x0$1 -> {
            if (x0$1 != null) {
                TopicPartition topicPartition = (TopicPartition)x0$1._1();
                PartitionFetchState fetchState = (PartitionFetchState)x0$1._2();
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)topicPartition), (Object)new InitialFetchState(fetchState.topicId(), fetcher.leader().brokerEndPoint(), fetchState.currentLeaderEpoch(), fetchState.fetchOffset(), fetchState.replicationSessionId()));
            }
            throw new MatchError(null);
        });
    }

    public void maybeUpdateTopicIds(Map<TopicPartition, Object> partitionsToUpdate, Function1<String, Option<Uuid>> topicIds) {
        Object object = this.lock();
        synchronized (object) {
            ((scala.collection.immutable.Map)partitionsToUpdate.groupBy((Function1 & Serializable)x0$1 -> {
                if (x0$1 != null) {
                    TopicPartition topicPartition = (TopicPartition)x0$1._1();
                    int leaderId = x0$1._2$mcI$sp();
                    return FetcherPool$.MODULE$.values().map((Function1 & Serializable)poolType -> new FetcherTag(leaderId, this.getFetcherId(topicPartition), (FetcherPool)poolType));
                }
                throw new MatchError(null);
            }).map((Function1 & Serializable)x0$2 -> {
                if (x0$2 != null) {
                    List brokerAndFetcherId = (List)x0$2._1();
                    Map partitionsToUpdate = (Map)x0$2._2();
                    return new Tuple2((Object)brokerAndFetcherId, (Object)partitionsToUpdate.keySet());
                }
                throw new MatchError(null);
            })).withFilter((Function1 & Serializable)check$ifrefutable$3 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$maybeUpdateTopicIds$4(check$ifrefutable$3))).foreach((Function1 & Serializable)x$13 -> {
                AbstractFetcherManager.$anonfun$maybeUpdateTopicIds$5(this, topicIds, x$13);
                return BoxedUnit.UNIT;
            });
            return;
        }
    }

    public Map<TopicPartition, PartitionFetchState> removeFetcherForPartitions(Set<TopicPartition> partitions) {
        scala.collection.mutable.Map fetchStates = (scala.collection.mutable.Map)Map$.MODULE$.empty();
        Object object = this.lock();
        synchronized (object) {
            this.fetcherThreadMap().values().foreach((Function1 & Serializable)fetcher -> (scala.collection.mutable.Map)fetchStates.$plus$plus$eq(fetcher.removePartitions(partitions)));
            this.failedPartitions().removeAll(partitions);
            this.pausedPartitions().removeAll(partitions);
        }
        if (partitions.nonEmpty()) {
            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(31).append("Removed fetcher for partitions ").append(partitions).toString());
        }
        return fetchStates;
    }

    public void shutdownIdleFetcherThreads() {
        Object object = this.lock();
        synchronized (object) {
            HashSet keysToBeRemoved = new HashSet();
            this.fetcherThreadMap().withFilter((Function1 & Serializable)check$ifrefutable$4 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$shutdownIdleFetcherThreads$1(check$ifrefutable$4))).foreach((Function1 & Serializable)x$14 -> {
                if (x$14 != null) {
                    FetcherTag key = (FetcherTag)x$14._1();
                    AbstractFetcherThread fetcher = (AbstractFetcherThread)x$14._2();
                    if (fetcher.partitionCount() <= 0) {
                        fetcher.shutdown();
                        return keysToBeRemoved.$plus$eq((Object)key);
                    }
                    return BoxedUnit.UNIT;
                }
                throw new MatchError(null);
            });
            HashMap cfr_ignored_0 = (HashMap)this.fetcherThreadMap().$minus$minus$eq((IterableOnce)keysToBeRemoved);
            return;
        }
    }

    public void closeAllFetchers() {
        Object object = this.lock();
        synchronized (object) {
            this.fetcherThreadMap().withFilter((Function1 & Serializable)check$ifrefutable$5 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$closeAllFetchers$1(check$ifrefutable$5))).foreach((Function1 & Serializable)x$15 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$closeAllFetchers$2(x$15)));
            this.fetcherThreadMap().withFilter((Function1 & Serializable)check$ifrefutable$6 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$closeAllFetchers$3(check$ifrefutable$6))).foreach((Function1 & Serializable)x$16 -> {
                AbstractFetcherManager.$anonfun$closeAllFetchers$4(x$16);
                return BoxedUnit.UNIT;
            });
            this.fetcherThreadMap().clear();
            return;
        }
    }

    public static final /* synthetic */ long $anonfun$new$2(long curMaxLagAll, AbstractFetcherThread fetcherThread) {
        long maxLagThread = BoxesRunTime.unboxToLong((Object)fetcherThread.fetcherLagStats().stats().values().foldLeft((Object)BoxesRunTime.boxToLong((long)0L), (Function2 & Serializable)(curMaxLagThread, lagMetrics) -> BoxesRunTime.boxToLong((long)package$.MODULE$.max(BoxesRunTime.unboxToLong((Object)curMaxLagThread), lagMetrics.lag()))));
        return package$.MODULE$.max(curMaxLagAll, maxLagThread);
    }

    public final /* synthetic */ long kafka$server$AbstractFetcherManager$$$anonfun$new$1() {
        return BoxesRunTime.unboxToLong((Object)this.fetcherThreadMap().values().foldLeft((Object)BoxesRunTime.boxToLong((long)0L), (Function2 & Serializable)(curMaxLagAll, fetcherThread) -> BoxesRunTime.boxToLong((long)AbstractFetcherManager.$anonfun$new$2(BoxesRunTime.unboxToLong((Object)curMaxLagAll), fetcherThread))));
    }

    public static final /* synthetic */ long $anonfun$new$5(AbstractFetcherThread x$1) {
        return BoxesRunTime.unboxToLong((Object)x$1.fetcherLagStats().stats().values().iterator().map((Function1 & Serializable)x$2 -> BoxesRunTime.boxToLong((long)x$2.lag())).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public final /* synthetic */ long kafka$server$AbstractFetcherManager$$$anonfun$new$4() {
        return BoxesRunTime.unboxToLong((Object)this.fetcherThreadMap().valuesIterator().map((Function1 & Serializable)x$1 -> BoxesRunTime.boxToLong((long)AbstractFetcherManager.$anonfun$new$5(x$1))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
    }

    public final /* synthetic */ double kafka$server$AbstractFetcherManager$$$anonfun$new$7() {
        return this.minFetchRate((Map<FetcherTag, T>)this.fetcherThreadMap());
    }

    public static final /* synthetic */ double $anonfun$new$9(AbstractFetcherThread x$3) {
        return x$3.fetcherStats().requestRate().oneMinuteRate();
    }

    public final /* synthetic */ double kafka$server$AbstractFetcherManager$$$anonfun$new$8() {
        return BoxesRunTime.unboxToDouble((Object)this.fetcherThreadMap().valuesIterator().map((Function1 & Serializable)x$3 -> BoxesRunTime.boxToDouble((double)AbstractFetcherManager.$anonfun$new$9(x$3))).sum((Numeric)Numeric.DoubleIsFractional$.MODULE$));
    }

    public final /* synthetic */ int kafka$server$AbstractFetcherManager$$$anonfun$new$10() {
        return this.failedPartitions().size();
    }

    public final /* synthetic */ int kafka$server$AbstractFetcherManager$$$anonfun$new$11() {
        return this.pausedPartitions().size();
    }

    public final /* synthetic */ int kafka$server$AbstractFetcherManager$$$anonfun$new$12() {
        return this.deadThreadCount();
    }

    public static final /* synthetic */ void $anonfun$new$13(AbstractFetcherManager $this, Scheduler s) {
        s.schedule("migrate-in-sync-partitions-thread", () -> $this.maybeMigrateInSyncPartitions($this.maybeMigrateInSyncPartitions$default$1()), 0L, 1000L);
        $this.createSeparateFetcherMetrics();
    }

    public static final /* synthetic */ boolean $anonfun$createSeparateFetcherMetrics$3(FetcherPool fetcherPool$1, Tuple2 x0$1) {
        if (x0$1 != null) {
            FetcherPool fetcherPool = ((FetcherTag)x0$1._1()).fetcherPool();
            return !(fetcherPool != null ? !fetcherPool.equals(fetcherPool$1) : fetcherPool$1 != null);
        }
        throw new MatchError(null);
    }

    public final /* synthetic */ double kafka$server$AbstractFetcherManager$$$anonfun$createSeparateFetcherMetrics$2(FetcherPool fetcherPool$1) {
        return this.minFetchRate((Map)this.fetcherThreadMap().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$createSeparateFetcherMetrics$3(fetcherPool$1, x0$1))));
    }

    public static final /* synthetic */ double $anonfun$minFetchRate$1(AbstractFetcherThread x$4) {
        return x$4.fetcherStats().requestRate().oneMinuteRate();
    }

    public static final /* synthetic */ void $anonfun$resizeThreadPool$2(AbstractFetcherThread thread$1, scala.collection.mutable.Map allRemovedPartitionsMapByFetcherPool$1, FetcherTag id$1, TopicPartition topicPartition, PartitionFetchState currentFetchState) {
        InitialFetchState initialFetchState = new InitialFetchState(currentFetchState.topicId(), thread$1.leader().brokerEndPoint(), currentFetchState.currentLeaderEpoch(), currentFetchState.fetchOffset(), currentFetchState.replicationSessionId());
        ((scala.collection.mutable.Map)allRemovedPartitionsMapByFetcherPool$1.getOrElseUpdate((Object)id$1.fetcherPool(), (Function0 & Serializable)() -> (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$))).update((Object)topicPartition, (Object)initialFetchState);
    }

    public static final /* synthetic */ void $anonfun$resizeThreadPool$1(int newSize$1, scala.collection.mutable.Map allRemovedPartitionsMapByFetcherPool$1, FetcherTag id, AbstractFetcherThread thread) {
        Map<TopicPartition, PartitionFetchState> partitionStates = thread.removeAllPartitions();
        if (id.fetcherId() >= newSize$1) {
            thread.shutdown();
        }
        Function2 & Serializable forKeyValue$extension_f = (Function2 & Serializable)(topicPartition, currentFetchState) -> {
            AbstractFetcherManager.$anonfun$resizeThreadPool$2(thread, allRemovedPartitionsMapByFetcherPool$1, id, topicPartition, currentFetchState);
            return BoxedUnit.UNIT;
        };
        partitionStates.foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1(forKeyValue$extension_f, arg_0, arg_1));
    }

    private final void migratePartitions$1(int newSize) {
        scala.collection.mutable.Map allRemovedPartitionsMapByFetcherPool = (scala.collection.mutable.Map)Map$.MODULE$.apply((Seq)Nil$.MODULE$);
        this.fetcherThreadMap().foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1((Function2 & Serializable)(id, thread) -> {
            AbstractFetcherManager.$anonfun$resizeThreadPool$1(newSize, allRemovedPartitionsMapByFetcherPool, id, thread);
            return BoxedUnit.UNIT;
        }, arg_0, arg_1));
        Function2 & Serializable forKeyValue$extension_f = (Function2 & Serializable)(fetcherPool, allRemovedPartitionsMap) -> {
            this.addFetcherForPartitions((Map<TopicPartition, InitialFetchState>)allRemovedPartitionsMap, fetcherPool, this.addFetcherForPartitions$default$3());
            return BoxedUnit.UNIT;
        };
        allRemovedPartitionsMapByFetcherPool.foreachEntry((arg_0, arg_1) -> Implicits$MapExtensionMethods$.$anonfun$forKeyValue$1(forKeyValue$extension_f, arg_0, arg_1));
    }

    public static final /* synthetic */ boolean $anonfun$getFetcher$1(TopicPartition topicPartition$1, AbstractFetcherThread fetcherThread) {
        return fetcherThread.fetchState(topicPartition$1).isDefined();
    }

    public static final /* synthetic */ void $anonfun$markPartitionsForTruncation$1(AbstractFetcherManager $this, int brokerId$1, int fetcherId$1, TopicPartition topicPartition$2, long truncationOffset$1, FetcherPool fetcherPool) {
        FetcherTag fetcherTag = new FetcherTag(brokerId$1, fetcherId$1, fetcherPool);
        $this.fetcherThreadMap().get((Object)fetcherTag).foreach((Function1 & Serializable)thread -> {
            thread.markPartitionsForTruncation(topicPartition$2, truncationOffset$1);
            return BoxedUnit.UNIT;
        });
    }

    private final AbstractFetcherThread addAndStartFetcherThread$1(BrokerAndFetcherId brokerAndFetcherId, FetcherTag fetcherTag) {
        T fetcherThread = this.createFetcherThread(brokerAndFetcherId.fetcherId(), brokerAndFetcherId.broker(), fetcherTag.fetcherPool());
        this.fetcherThreadMap().put((Object)fetcherTag, fetcherThread);
        ((AbstractFetcherThread)fetcherThread).start();
        return fetcherThread;
    }

    public static final /* synthetic */ boolean $anonfun$addFetcherForPartitions$2(Tuple2 check$ifrefutable$1) {
        return check$ifrefutable$1 != null;
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ void $anonfun$addFetcherForPartitions$3(AbstractFetcherManager $this, FetcherPool fetcherPool$2, Function2 callback$1, Tuple2 x$8) {
        block6: {
            if (x$8 == null) break block6;
            brokerAndFetcherId = (BrokerAndFetcherId)x$8._1();
            initialFetchOffsets = (Map)x$8._2();
            fetcherTag = new FetcherTag(brokerAndFetcherId.broker().id(), brokerAndFetcherId.fetcherId(), fetcherPool$2);
            var8_7 = false;
            var9_8 = null;
            var10_9 = $this.fetcherThreadMap().get((Object)fetcherTag);
            if (!(var10_9 instanceof Some)) ** GOTO lbl-1000
            var8_7 = true;
            var9_8 = (Some)var10_9;
            currentFetcherThread = (AbstractFetcherThread)var9_8.value();
            v0 = currentFetcherThread.leader().brokerEndPoint();
            var12_11 = brokerAndFetcherId.broker();
            if (!(v0 != null ? v0.equals(var12_11) == false : var12_11 != null)) {
                v1 = currentFetcherThread;
            } else if (var8_7) {
                ((AbstractFetcherThread)var9_8.value()).shutdown();
                v1 = $this.addAndStartFetcherThread$1(brokerAndFetcherId, fetcherTag);
            } else if (None$.MODULE$.equals(var10_9)) {
                v1 = $this.addAndStartFetcherThread$1(brokerAndFetcherId, fetcherTag);
            } else {
                throw new MatchError((Object)var10_9);
            }
            fetcherThread = v1;
            $this.addPartitionsToFetcherThread(fetcherThread, (Map<TopicPartition, InitialFetchState>)initialFetchOffsets);
            initialFetchOffsets.keys().foreach((Function1)(Function1 & Serializable)LambdaMetafactory.altMetafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, $anonfun$addFetcherForPartitions$4$adapted(scala.Function2 kafka.server.AbstractFetcherThread org.apache.kafka.common.TopicPartition ), (Lorg/apache/kafka/common/TopicPartition;)Ljava/lang/Object;)((Function2)callback$1, (AbstractFetcherThread)fetcherThread));
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$addFetcherForPartitions$default$3$1(TopicPartition x$6, AbstractFetcherThread x$7) {
    }

    public static final /* synthetic */ boolean $anonfun$maybeMigrateInSyncPartitions$1(Tuple2 check$ifrefutable$2) {
        return check$ifrefutable$2 != null;
    }

    public static final /* synthetic */ boolean $anonfun$maybeMigrateInSyncPartitions$3(Tuple2 x0$1) {
        FetcherLagMetrics lagMetrics;
        if (x0$1 != null && (lagMetrics = (FetcherLagMetrics)x0$1._2()) != null) {
            return lagMetrics.lag() == 0L;
        }
        throw new MatchError((Object)x0$1);
    }

    public static final /* synthetic */ void $anonfun$maybeMigrateInSyncPartitions$2(AbstractFetcherManager $this, Function2 callback$2, Tuple2 x$11) {
        if (x$11 != null) {
            FetcherTag tag = (FetcherTag)x$11._1();
            AbstractFetcherThread fetcher = (AbstractFetcherThread)x$11._2();
            FetcherPool fetcherPool = tag.fetcherPool();
            FetcherPool$Default$ fetcherPool$Default$ = FetcherPool$Default$.MODULE$;
            if (fetcherPool == null) {
                return;
            }
            if (fetcherPool.equals(fetcherPool$Default$)) {
                scala.collection.immutable.Set inSyncPartitions = ((IterableOnceOps)((IterableOps)fetcher.fetcherLagStats().stats().filter((Function1 & Serializable)x0$1 -> BoxesRunTime.boxToBoolean((boolean)AbstractFetcherManager.$anonfun$maybeMigrateInSyncPartitions$3(x0$1)))).map((Function1 & Serializable)x0$2 -> {
                    if (x0$2 != null) {
                        return (TopicPartition)x0$2._1();
                    }
                    throw new MatchError(null);
                })).toSet();
                Map<TopicPartition, PartitionFetchState> partitionStates = fetcher.removePartitions((Set<TopicPartition>)inSyncPartitions);
                Map<TopicPartition, InitialFetchState> fetchStates = $this.toInitialFetchState(fetcher, partitionStates);
                $this.addFetcherForPartitions(fetchStates, FetcherPool$InSync$.MODULE$, callback$2);
                if (partitionStates.nonEmpty()) {
                    $this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(32).append("Moved ").append(partitionStates.keys()).append(" partitions from ").append(FetcherPool$Default$.MODULE$).append(" to ").append(FetcherPool$InSync$.MODULE$).append(" for ").append(tag).toString());
                    return;
                }
                return;
            }
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ void $anonfun$maybeMigrateInSyncPartitions$default$1$1(TopicPartition x$9, AbstractFetcherThread x$10) {
    }

    public static final /* synthetic */ boolean $anonfun$maybeUpdateTopicIds$4(Tuple2 check$ifrefutable$3) {
        return check$ifrefutable$3 != null;
    }

    public static final /* synthetic */ void $anonfun$maybeUpdateTopicIds$6(AbstractFetcherManager $this, Set partitions$1, Function1 topicIds$1, FetcherTag fetcherTag) {
        $this.fetcherThreadMap().get((Object)fetcherTag).foreach((Function1 & Serializable)x$12 -> {
            x$12.maybeUpdateTopicIds((Set<TopicPartition>)partitions$1, (Function1<String, Option<Uuid>>)topicIds$1);
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ void $anonfun$maybeUpdateTopicIds$5(AbstractFetcherManager $this, Function1 topicIds$1, Tuple2 x$13) {
        if (x$13 != null) {
            List fetcherTags = (List)x$13._1();
            Set partitions = (Set)x$13._2();
            fetcherTags.foreach((Function1 & Serializable)fetcherTag -> {
                AbstractFetcherManager.$anonfun$maybeUpdateTopicIds$6($this, partitions, topicIds$1, fetcherTag);
                return BoxedUnit.UNIT;
            });
            return;
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$shutdownIdleFetcherThreads$1(Tuple2 check$ifrefutable$4) {
        return check$ifrefutable$4 != null;
    }

    public static final /* synthetic */ boolean $anonfun$closeAllFetchers$1(Tuple2 check$ifrefutable$5) {
        return check$ifrefutable$5 != null;
    }

    public static final /* synthetic */ boolean $anonfun$closeAllFetchers$2(Tuple2 x$15) {
        if (x$15 != null) {
            return ((AbstractFetcherThread)x$15._2()).initiateShutdown();
        }
        throw new MatchError(null);
    }

    public static final /* synthetic */ boolean $anonfun$closeAllFetchers$3(Tuple2 check$ifrefutable$6) {
        return check$ifrefutable$6 != null;
    }

    public static final /* synthetic */ void $anonfun$closeAllFetchers$4(Tuple2 x$16) {
        if (x$16 != null) {
            ((AbstractFetcherThread)x$16._2()).shutdown();
            return;
        }
        throw new MatchError(null);
    }

    public AbstractFetcherManager(String name, String clientId, int numFetchers, FetchConnectionsMode fetchMode, Option<Scheduler> scheduler, Map<String, String> extraMetricTags) {
        BoxedUnit boxedUnit;
        this.name = name;
        this.metricsGroup = new KafkaMetricsGroup(this.getClass());
        this.fetcherThreadMap = new HashMap();
        this.lock = new Object();
        this.numFetchersPerBroker = numFetchers;
        this.replicaFetchConnectionsMode = fetchMode;
        this.failedPartitions = new FailedPartitions();
        this.pausedPartitions = new PausedPartitions();
        this.logIdent_$eq(new StringBuilder(3).append("[").append(name).append("] ").toString());
        this.tags = (Map)((MapOps)scala.collection.Map$.MODULE$.apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"clientId"), (Object)clientId)}))).$plus$plus(extraMetricTags);
        this.metricsGroup().newGauge("MaxLag", (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ AbstractFetcherManager $outer;

            public final long value() {
                return this.$outer.kafka$server$AbstractFetcherManager$$$anonfun$new$1();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, CollectionConverters$.MODULE$.MapHasAsJava(this.tags()).asJava());
        this.metricsGroup().newGauge("TotalLag", (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ AbstractFetcherManager $outer;

            public final long value() {
                return this.$outer.kafka$server$AbstractFetcherManager$$$anonfun$new$4();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, CollectionConverters$.MODULE$.MapHasAsJava(this.tags()).asJava());
        this.metricsGroup().newGauge("MinFetchRate", (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ AbstractFetcherManager $outer;

            public final double value() {
                return this.$outer.kafka$server$AbstractFetcherManager$$$anonfun$new$7();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, CollectionConverters$.MODULE$.MapHasAsJava(this.tags()).asJava());
        this.metricsGroup().newGauge("TotalFetchRate", (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ AbstractFetcherManager $outer;

            public final double value() {
                return this.$outer.kafka$server$AbstractFetcherManager$$$anonfun$new$8();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, CollectionConverters$.MODULE$.MapHasAsJava(this.tags()).asJava());
        this.metricsGroup().newGauge("FailedPartitionsCount", (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ AbstractFetcherManager $outer;

            public final int value() {
                return this.$outer.kafka$server$AbstractFetcherManager$$$anonfun$new$10();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, CollectionConverters$.MODULE$.MapHasAsJava(this.tags()).asJava());
        this.metricsGroup().newGauge("PausedPartitionsCount", (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ AbstractFetcherManager $outer;

            public final int value() {
                return this.$outer.kafka$server$AbstractFetcherManager$$$anonfun$new$11();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, CollectionConverters$.MODULE$.MapHasAsJava(this.tags()).asJava());
        this.metricsGroup().newGauge("DeadThreadCount", (Gauge)new Gauge<Object>(this){
            private final /* synthetic */ AbstractFetcherManager $outer;

            public final int value() {
                AbstractFetcherManager abstractFetcherManager = this.$outer;
                if (abstractFetcherManager == null) {
                    throw null;
                }
                return abstractFetcherManager.deadThreadCount();
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
            }
        }, CollectionConverters$.MODULE$.MapHasAsJava(this.tags()).asJava());
        FetchConnectionsMode fetchConnectionsMode = this.replicaFetchConnectionsMode();
        FetchConnectionsMode$Isolated$ fetchConnectionsMode$Isolated$ = FetchConnectionsMode$Isolated$.MODULE$;
        if (fetchConnectionsMode != null && fetchConnectionsMode.equals(fetchConnectionsMode$Isolated$)) {
            scheduler.foreach((Function1 & Serializable)s -> {
                AbstractFetcherManager.$anonfun$new$13(this, s);
                return BoxedUnit.UNIT;
            });
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Predef$.MODULE$.locally((Object)boxedUnit);
    }

    public static final /* synthetic */ Object $anonfun$addFetcherForPartitions$4$adapted(Function2 callback$1, AbstractFetcherThread fetcherThread$1, TopicPartition tp) {
        callback$1.apply((Object)tp, (Object)fetcherThread$1);
        return BoxedUnit.UNIT;
    }
}

