/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import kafka.server.ClusterLinkQuotas;
import kafka.server.ClusterLinkTenantContext;
import kafka.server.ReplicaQuota;
import org.apache.kafka.common.TopicPartition;
import scala.Option;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u0005]3A!\u0003\u0006\u0001\u001f!A!\u0004\u0001B\u0001B\u0003%1\u0004\u0003\u0005\u001f\u0001\t\u0005\t\u0015!\u0003 \u0011!i\u0003A!A!\u0002\u0013\u0011\u0003\"\u0002\u0018\u0001\t\u0003y\u0003\"\u0002\u001b\u0001\t\u0013)\u0004\"B\u001d\u0001\t\u0003R\u0004\"B\"\u0001\t\u0003\"\u0005\"B+\u0001\t\u00032&AH\"mkN$XM\u001d'j].\u0014V\r\u001d7jG\u0006\fVo\u001c;b\u0003\u0012\f\u0007\u000f^3s\u0015\tYA\"\u0001\u0004tKJ4XM\u001d\u0006\u0002\u001b\u0005)1.\u00194lC\u000e\u00011c\u0001\u0001\u0011-A\u0011\u0011\u0003F\u0007\u0002%)\t1#A\u0003tG\u0006d\u0017-\u0003\u0002\u0016%\t1\u0011I\\=SK\u001a\u0004\"a\u0006\r\u000e\u0003)I!!\u0007\u0006\u0003\u0019I+\u0007\u000f\\5dCF+x\u000e^1\u0002\rE,x\u000e^1t!\t9B$\u0003\u0002\u001e\u0015\t\t2\t\\;ti\u0016\u0014H*\u001b8l#V|G/Y:\u0002\rQ,g.\u00198u!\r\t\u0002EI\u0005\u0003CI\u0011aa\u00149uS>t\u0007CA\u0012+\u001d\t!\u0003\u0006\u0005\u0002&%5\taE\u0003\u0002(\u001d\u00051AH]8pizJ!!\u000b\n\u0002\rA\u0013X\rZ3g\u0013\tYCF\u0001\u0004TiJLgn\u001a\u0006\u0003SI\t\u0001\u0002\\5oW:\u000bW.Z\u0001\u0007y%t\u0017\u000e\u001e \u0015\tA\n$g\r\t\u0003/\u0001AQA\u0007\u0003A\u0002mAQA\b\u0003A\u0002}AQ!\f\u0003A\u0002\t\n\u0011d\u00197vgR,'\u000fT5oWJ+\u0007\u000f\\5dC\u000e{g\u000e^3yiR\ta\u0007\u0005\u0002\u0018o%\u0011\u0001H\u0003\u0002\u0019\u00072,8\u000f^3s\u0019&t7\u000eV3oC:$8i\u001c8uKb$\u0018A\u0002:fG>\u0014H\r\u0006\u0002<}A\u0011\u0011\u0003P\u0005\u0003{I\u0011A!\u00168ji\")qH\u0002a\u0001\u0001\u0006)a/\u00197vKB\u0011\u0011#Q\u0005\u0003\u0005J\u0011A\u0001T8oO\u0006Y\u0011n\u001d+ie>$H\u000f\\3e)\t)\u0005\n\u0005\u0002\u0012\r&\u0011qI\u0005\u0002\b\u0005>|G.Z1o\u0011\u0015Iu\u00011\u0001K\u00039!x\u000e]5d!\u0006\u0014H/\u001b;j_:\u0004\"aS*\u000e\u00031S!!\u0014(\u0002\r\r|W.\\8o\u0015\tiqJ\u0003\u0002Q#\u00061\u0011\r]1dQ\u0016T\u0011AU\u0001\u0004_J<\u0017B\u0001+M\u00059!v\u000e]5d!\u0006\u0014H/\u001b;j_:\fq\"[:Rk>$\u0018-\u0012=dK\u0016$W\rZ\u000b\u0002\u000b\u0002")
public class ClusterLinkReplicaQuotaAdapter
implements ReplicaQuota {
    private final ClusterLinkQuotas quotas;
    private final Option<String> tenant;
    private final String linkName;

    private ClusterLinkTenantContext clusterLinkReplicaContext() {
        return new ClusterLinkTenantContext(this.tenant, this.linkName);
    }

    @Override
    public void record(long value) {
        this.quotas.produce().record(this.clusterLinkReplicaContext(), value);
    }

    @Override
    public boolean isThrottled(TopicPartition topicPartition) {
        return this.quotas.produce().isThrottled(this.clusterLinkReplicaContext(), topicPartition);
    }

    @Override
    public boolean isQuotaExceeded() {
        return this.quotas.produce().isQuotaExceeded(this.clusterLinkReplicaContext()) || this.quotas.request().isQuotaExceeded(this.clusterLinkReplicaContext());
    }

    public ClusterLinkReplicaQuotaAdapter(ClusterLinkQuotas quotas, Option<String> tenant, String linkName) {
        this.quotas = quotas;
        this.tenant = tenant;
        this.linkName = linkName;
    }
}

