/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Properties;
import kafka.server.ConfigAdminManager$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaConfig$;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkConfig$;
import kafka.server.link.ClusterLinkDisabled$;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkUtils$;
import kafka.server.logger.RuntimeLoggerManager;
import kafka.server.metadata.ConfigRepository;
import kafka.server.metadata.KRaftMetadataCache;
import kafka.server.metadata.ZkConfigRepository;
import kafka.utils.Logging;
import kafka.zk.ClusterLinkData;
import org.apache.kafka.clients.admin.AlterConfigOp;
import org.apache.kafka.clients.admin.ConfigEntry;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.ConfigDef;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.ClusterAuthorizationException;
import org.apache.kafka.common.errors.ClusterLinkNotFoundException;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.message.AlterConfigsRequestData;
import org.apache.kafka.common.message.AlterConfigsResponseData;
import org.apache.kafka.common.message.IncrementalAlterConfigsRequestData;
import org.apache.kafka.common.message.IncrementalAlterConfigsResponseData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.resource.ResourceType;
import org.apache.kafka.common.utils.ImplicitLinkedHashCollection;
import org.apache.kafka.metadata.ClusterLink;
import org.slf4j.Logger;
import scala.;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.Iterable;
import scala.collection.IterableOnceOps;
import scala.collection.Map;
import scala.collection.Seq;
import scala.collection.StringOps$;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\t=e\u0001\u0002\u000f\u001e\u0001\tB\u0001b\f\u0001\u0003\u0002\u0003\u0006I\u0001\r\u0005\tg\u0001\u0011\t\u0011)A\u0005i!A\u0001\b\u0001B\u0001B\u0003%\u0011\b\u0003\u0005@\u0001\t\u0015\r\u0011\"\u0001A\u0011!Y\u0005A!A!\u0002\u0013\t\u0005\"\u0002'\u0001\t\u0003i\u0005bB*\u0001\u0005\u0004%\t\u0001\u0016\u0005\u00077\u0002\u0001\u000b\u0011B+\t\u000bq\u0003A\u0011A/\t\u0013\u0005U\u0003!%A\u0005\u0002\u0005]\u0003bBA7\u0001\u0011\u0005\u0011q\u000e\u0005\b\u0003[\u0002A\u0011AAE\u0011\u0019a\u0006\u0001\"\u0001\u0002\u0018\"9\u0011Q\u000e\u0001\u0005\u0002\u0005=\u0006bBA[\u0001\u0011\u0005\u0011q\u0017\u0005\b\u0003{\u0003A\u0011AA`\u0011\u001d\t9\r\u0001C\u0001\u0003\u0013<q!!8\u001e\u0011\u0003\tyN\u0002\u0004\u001d;!\u0005\u0011\u0011\u001d\u0005\u0007\u0019N!\t!a9\t\u0013\u0005\u00158C1A\u0005\u0002\u0005\u001d\b\u0002CA{'\u0001\u0006I!!;\t\u000f\u0005]8\u0003\"\u0001\u0002z\"9\u0011q`\n\u0005\u0002\t\u0005\u0001b\u0002B\b'\u0011\u0005!\u0011\u0003\u0005\b\u0005\u0003\u001aB\u0011\u0001B\"\u0011\u001d\u00119f\u0005C\u0001\u00053\u0012!cQ8oM&<\u0017\tZ7j]6\u000bg.Y4fe*\u0011adH\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\u0001\nQa[1gW\u0006\u001c\u0001aE\u0002\u0001G%\u0002\"\u0001J\u0014\u000e\u0003\u0015R\u0011AJ\u0001\u0006g\u000e\fG.Y\u0005\u0003Q\u0015\u0012a!\u00118z%\u00164\u0007C\u0001\u0016.\u001b\u0005Y#B\u0001\u0017 \u0003\u0015)H/\u001b7t\u0013\tq3FA\u0004M_\u001e<\u0017N\\4\u0002\r9|G-Z%e!\t!\u0013'\u0003\u00023K\t\u0019\u0011J\u001c;\u0002\t\r|gN\u001a\t\u0003kYj\u0011!H\u0005\u0003ou\u00111bS1gW\u0006\u001cuN\u001c4jO\u0006\u00012m\u001c8gS\u001e\u0014V\r]8tSR|'/\u001f\t\u0003uuj\u0011a\u000f\u0006\u0003yu\t\u0001\"\\3uC\u0012\fG/Y\u0005\u0003}m\u0012\u0001cQ8oM&<'+\u001a9pg&$xN]=\u0002%\rdWo\u001d;fe2Kgn['b]\u0006<WM]\u000b\u0002\u0003B\u0011!\t\u0013\b\u0003\u0007\u001ak\u0011\u0001\u0012\u0006\u0003\u000bv\tA\u0001\\5oW&\u0011q\tR\u0001\u0013\u00072,8\u000f^3s\u0019&t7NR1di>\u0014\u00180\u0003\u0002J\u0015\nYA*\u001b8l\u001b\u0006t\u0017mZ3s\u0015\t9E)A\ndYV\u001cH/\u001a:MS:\\W*\u00198bO\u0016\u0014\b%\u0001\u0004=S:LGO\u0010\u000b\u0006\u001d>\u0003\u0016K\u0015\t\u0003k\u0001AQa\f\u0004A\u0002ABQa\r\u0004A\u0002QBQ\u0001\u000f\u0004A\u0002eBQa\u0010\u0004A\u0002\u0005\u000bAC];oi&lW\rT8hO\u0016\u0014X*\u00198bO\u0016\u0014X#A+\u0011\u0005YKV\"A,\u000b\u0005ak\u0012A\u00027pO\u001e,'/\u0003\u0002[/\n!\"+\u001e8uS6,Gj\\4hKJl\u0015M\\1hKJ\fQC];oi&lW\rT8hO\u0016\u0014X*\u00198bO\u0016\u0014\b%\u0001\u0006qe\u0016\u0004(o\\2fgN$rAXA\n\u0003?\tY\u0005E\u0003`I\u001a\f9!D\u0001a\u0015\t\t'-\u0001\u0003vi&d'\"A2\u0002\t)\fg/Y\u0005\u0003K\u0002\u0014q\"\u00133f]RLG/\u001f%bg\"l\u0015\r\u001d\t\u0004O\u0006\u0005aB\u00015~\u001d\tI'P\u0004\u0002ko:\u00111.\u001e\b\u0003YJt!!\u001c9\u000e\u00039T!a\\\u0011\u0002\rq\u0012xn\u001c;?\u0013\u0005\t\u0018aA8sO&\u00111\u000f^\u0001\u0007CB\f7\r[3\u000b\u0003EL!\u0001\t<\u000b\u0005M$\u0018B\u0001=z\u0003\u0019\u0019w.\\7p]*\u0011\u0001E^\u0005\u0003wr\fq!\\3tg\u0006<WM\u0003\u0002ys&\u0011ap`\u0001#\u0013:\u001c'/Z7f]R\fG.\u00117uKJ\u001cuN\u001c4jON\u0014V-];fgR$\u0015\r^1\u000b\u0005md\u0018\u0002BA\u0002\u0003\u000b\u0011A#\u00117uKJ\u001cuN\u001c4jON\u0014Vm]8ve\u000e,'B\u0001@\u0000!\u0011\tI!a\u0004\u000e\u0005\u0005-!bAA\u0007y\u0006A!/Z9vKN$8/\u0003\u0003\u0002\u0012\u0005-!\u0001C!qS\u0016\u0013(o\u001c:\t\u000f\u0005U\u0011\u00021\u0001\u0002\u0018\u00059!/Z9vKN$\b\u0003BA\r\u00037i\u0011a`\u0005\u0004\u0003;y(AI%oGJ,W.\u001a8uC2\fE\u000e^3s\u0007>tg-[4t%\u0016\fX/Z:u\t\u0006$\u0018\rC\u0004\u0002\"%\u0001\r!a\t\u0002\u0013\u0005,H\u000f[8sSj,\u0007#\u0003\u0013\u0002&\u0005%\u0012QGA#\u0013\r\t9#\n\u0002\n\rVt7\r^5p]J\u0002B!a\u000b\u000225\u0011\u0011Q\u0006\u0006\u0004\u0003_a\u0018\u0001\u0003:fg>,(oY3\n\t\u0005M\u0012Q\u0006\u0002\r%\u0016\u001cx.\u001e:dKRK\b/\u001a\t\u0005\u0003o\tyD\u0004\u0003\u0002:\u0005m\u0002CA7&\u0013\r\ti$J\u0001\u0007!J,G-\u001a4\n\t\u0005\u0005\u00131\t\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005uR\u0005E\u0002%\u0003\u000fJ1!!\u0013&\u0005\u001d\u0011un\u001c7fC:D\u0011\"!\u0014\n!\u0003\u0005\r!a\u0014\u0002I\u0005,H\u000f[8sSj,W*\u001b:s_J$v\u000e]5d\u0007>tg-[4WC2LG-\u0019;j_:\u0004R\u0001JA)\u0003\u000bJ1!a\u0015&\u0005%1UO\\2uS>t\u0007'\u0001\u000bqe\u0016\u0004(o\\2fgN$C-\u001a4bk2$HeM\u000b\u0003\u00033RC!a\u0014\u0002\\-\u0012\u0011Q\f\t\u0005\u0003?\nI'\u0004\u0002\u0002b)!\u00111MA3\u0003%)hn\u00195fG.,GMC\u0002\u0002h\u0015\n!\"\u00198o_R\fG/[8o\u0013\u0011\tY'!\u0019\u0003#Ut7\r[3dW\u0016$g+\u0019:jC:\u001cW-\u0001\u000ewC2LG-\u0019;f\u0005J|7.\u001a:D_:4\u0017nZ\"iC:<W\r\u0006\u0004\u0002r\u0005]\u0014\u0011\u0010\t\u0004I\u0005M\u0014bAA;K\t!QK\\5u\u0011\u0019\tyc\u0003a\u0001M\"9\u00111P\u0006A\u0002\u0005u\u0014AD2p]\u001aLwMU3t_V\u00148-\u001a\t\u0005\u0003\u007f\n))\u0004\u0002\u0002\u0002*\u0019\u00111\u0011?\u0002\r\r|gNZ5h\u0013\u0011\t9)!!\u0003\u001d\r{gNZ5h%\u0016\u001cx.\u001e:dKR1\u0011\u0011OAF\u0003+Cq!!$\r\u0001\u0004\ty)A\u0003qe>\u00048\u000fE\u0002`\u0003#K1!a%a\u0005)\u0001&o\u001c9feRLWm\u001d\u0005\b\u0003wb\u0001\u0019AA?)\u0011\tI*a*\u0011\r}#\u00171TA\u0004!\u0011\ti*a)\u000f\u0007!\fy*C\u0002\u0002\"~\fq#\u00117uKJ\u001cuN\u001c4jON\u0014V-];fgR$\u0015\r^1\n\t\u0005\r\u0011Q\u0015\u0006\u0004\u0003C{\bbBA\u000b\u001b\u0001\u0007\u0011\u0011\u0016\t\u0005\u00033\tY+C\u0002\u0002.~\u0014q#\u00117uKJ\u001cuN\u001c4jON\u0014V-];fgR$\u0015\r^1\u0015\r\u0005E\u0014\u0011WAZ\u0011\u001d\tyC\u0004a\u0001\u00037Cq!a\u001f\u000f\u0001\u0004\ti(A\u0012wC2LG-\u0019;f%\u0016\u001cx.\u001e:dK:\u000bW.Z%t\u0007V\u0014(/\u001a8u\u001d>$W-\u00133\u0015\t\u0005E\u0014\u0011\u0018\u0005\b\u0003w{\u0001\u0019AA\u001b\u0003\u0011q\u0017-\\3\u0002Q5\f\u0017PY3N_\u0012Lg-_%oGJ,W.\u001a8uC2\fE\u000e^3s\u0007>tg-[4SKF,Xm\u001d;\u0015\r\u0005]\u0011\u0011YAb\u0011\u001d\t)\u0002\u0005a\u0001\u0003/Aa!!2\u0011\u0001\u0004q\u0016!\u00039s_\u000e,7o]3e\u0003u\u0011X-Y:tK6\u0014G.Z%oGJ,W.\u001a8uC2\u0014Vm\u001d9p]N,G\u0003CAf\u0003#\f).!7\u0011\t\u0005e\u0011QZ\u0005\u0004\u0003\u001f|(aI%oGJ,W.\u001a8uC2\fE\u000e^3s\u0007>tg-[4t%\u0016\u001c\bo\u001c8tK\u0012\u000bG/\u0019\u0005\b\u0003'\f\u0002\u0019AA\f\u0003!y'/[4j]\u0006d\u0007BBAl#\u0001\u0007a,\u0001\fqe\u0016\u0004(o\\2fgNLgn\u001a*fgB|gn]3t\u0011\u001d\tY.\u0005a\u0001\u0003\u0017\f1\u0003]3sg&\u001cH/\u001a8u%\u0016\u001c\bo\u001c8tKN\f!cQ8oM&<\u0017\tZ7j]6\u000bg.Y4feB\u0011QgE\n\u0003'\r\"\"!a8\u0002\u00071|w-\u0006\u0002\u0002jB!\u00111^Ay\u001b\t\tiOC\u0002\u0002pR\fQa\u001d7gi)LA!a=\u0002n\n1Aj\\4hKJ\fA\u0001\\8hA\u000592m\u001c9z/&$\bn\\;u!J,\u0007O]8dKN\u001cX\r\u001a\u000b\u0007\u0003S\u000bY0!@\t\u000f\u0005Uq\u00031\u0001\u0002*\"9\u0011QY\fA\u0002\u0005e\u0015\u0001\u0007:fCN\u001cX-\u001c2mK2+w-Y2z%\u0016\u001c\bo\u001c8tKRA!1\u0001B\u0005\u0005\u0017\u0011i\u0001\u0005\u0003\u0002\u001a\t\u0015\u0011b\u0001B\u0004\u007f\nA\u0012\t\u001c;fe\u000e{gNZ5hgJ+7\u000f]8og\u0016$\u0015\r^1\t\u000f\u0005M\u0007\u00041\u0001\u0002*\"9\u0011q\u001b\rA\u0002\u0005e\u0005bBAn1\u0001\u0007!1A\u0001\u0013G>tG/Y5og\u0012+\b\u000f\\5dCR,7/\u0006\u0003\u0003\u0014\t=B\u0003BA#\u0005+AqAa\u0006\u001a\u0001\u0004\u0011I\"\u0001\u0005ji\u0016\u0014\u0018M\u00197f!\u0019\u0011YB!\n\u0003,9!!Q\u0004B\u0011\u001d\ri'qD\u0005\u0002M%\u0019!1E\u0013\u0002\u000fA\f7m[1hK&!!q\u0005B\u0015\u0005!IE/\u001a:bE2,'b\u0001B\u0012KA!!Q\u0006B\u0018\u0019\u0001!qA!\r\u001a\u0005\u0004\u0011\u0019DA\u0001U#\u0011\u0011)Da\u000f\u0011\u0007\u0011\u00129$C\u0002\u0003:\u0015\u0012qAT8uQ&tw\rE\u0002%\u0005{I1Aa\u0010&\u0005\r\te._\u0001\u0010i>dunZ4bE2,\u0007K]8qgR1!Q\tB)\u0005'\u0002\u0002Ba\u0012\u0003N\u0005U\u0012QG\u0007\u0003\u0005\u0013R1Aa\u0013&\u0003)\u0019w\u000e\u001c7fGRLwN\\\u0005\u0005\u0005\u001f\u0012IEA\u0002NCBDq!a\f\u001b\u0001\u0004\ti\bC\u0004\u0003Vi\u0001\r!a$\u0002\u0017\r|gNZ5h!J|\u0007o]\u0001\u001aaJ,\u0007/\u0019:f\u0013:\u001c'/Z7f]R\fGnQ8oM&<7\u000f\u0006\u0005\u0002r\tm#Q\u000fB<\u0011\u001d\u0011if\u0007a\u0001\u0005?\na\"\u00197uKJ\u001cuN\u001c4jO>\u00038\u000f\u0005\u0004\u0003H\t\u0005$QM\u0005\u0005\u0005G\u0012IEA\u0002TKF\u0004BAa\u001a\u0003r5\u0011!\u0011\u000e\u0006\u0005\u0005W\u0012i'A\u0003bI6LgNC\u0002\u0003pe\fqa\u00197jK:$8/\u0003\u0003\u0003t\t%$!D!mi\u0016\u00148i\u001c8gS\u001e|\u0005\u000fC\u0004\u0003Vm\u0001\r!a$\t\u000f\te4\u00041\u0001\u0003|\u0005Q1m\u001c8gS\u001e\\U-_:\u0011\u0011\t\u001d#QJA\u001b\u0005{\u0002BAa \u0003\n:!!\u0011\u0011BC\u001d\rI'1Q\u0005\u0004\u0003\u0007c\u0018\u0002\u0002BD\u0003\u0003\u000b\u0011bQ8oM&<G)\u001a4\n\t\t-%Q\u0012\u0002\n\u0007>tg-[4LKfTAAa\"\u0002\u0002\u0002")
public class ConfigAdminManager
implements Logging {
    private final int nodeId;
    private final KafkaConfig conf;
    private final ConfigRepository configRepository;
    private final ClusterLinkFactory.LinkManager clusterLinkManager;
    private final RuntimeLoggerManager runtimeLoggerManager;
    private com.typesafe.scalalogging.Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static void prepareIncrementalConfigs(Seq<AlterConfigOp> alterConfigOps, Properties configProps, Map<String, ConfigDef.ConfigKey> configKeys) {
        ConfigAdminManager$.MODULE$.prepareIncrementalConfigs(alterConfigOps, configProps, configKeys);
    }

    public static Map<String, String> toLoggableProps(ConfigResource resource, Properties configProps) {
        return ConfigAdminManager$.MODULE$.toLoggableProps(resource, configProps);
    }

    public static <T> boolean containsDuplicates(Iterable<T> iterable) {
        return ConfigAdminManager$.MODULE$.containsDuplicates(iterable);
    }

    public static AlterConfigsResponseData reassembleLegacyResponse(AlterConfigsRequestData original, IdentityHashMap<AlterConfigsRequestData.AlterConfigsResource, ApiError> preprocessingResponses, AlterConfigsResponseData persistentResponses) {
        return ConfigAdminManager$.MODULE$.reassembleLegacyResponse(original, preprocessingResponses, persistentResponses);
    }

    public static AlterConfigsRequestData copyWithoutPreprocessed(AlterConfigsRequestData request, IdentityHashMap<AlterConfigsRequestData.AlterConfigsResource, ApiError> processed) {
        return ConfigAdminManager$.MODULE$.copyWithoutPreprocessed(request, processed);
    }

    public static Logger log() {
        return ConfigAdminManager$.MODULE$.log();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private com.typesafe.scalalogging.Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public com.typesafe.scalalogging.Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    public ClusterLinkFactory.LinkManager clusterLinkManager() {
        return this.clusterLinkManager;
    }

    public RuntimeLoggerManager runtimeLoggerManager() {
        return this.runtimeLoggerManager;
    }

    public IdentityHashMap<IncrementalAlterConfigsRequestData.AlterConfigsResource, ApiError> preprocess(IncrementalAlterConfigsRequestData request, Function2<ResourceType, String, Object> authorize, Function0<Object> authorizeMirrorTopicConfigValidation) {
        IdentityHashMap<IncrementalAlterConfigsRequestData.AlterConfigsResource, ApiError> results = new IdentityHashMap<IncrementalAlterConfigsRequestData.AlterConfigsResource, ApiError>();
        HashMap resourceIds = new HashMap();
        request.resources().forEach(resource -> {
            IncrementalAlterConfigsRequestData.AlterConfigsResource preexisting = resourceIds.put(new Tuple2((Object)BoxesRunTime.boxToByte((byte)resource.resourceType()), (Object)resource.resourceName()), resource);
            if (preexisting != null) {
                new .colon.colon((Object)preexisting, (List)new .colon.colon(resource, (List)Nil$.MODULE$)).foreach((Function1 & Serializable)r -> results.put((IncrementalAlterConfigsRequestData.AlterConfigsResource)r, new ApiError(Errors.INVALID_REQUEST, "Each resource must appear at most once.")));
                return;
            }
        });
        request.resources().forEach(resource -> {
            if (!results.containsKey(resource)) {
                block20: {
                    ConfigResource.Type resourceType = ConfigResource.Type.forId((byte)resource.resourceType());
                    ConfigResource configResource = new ConfigResource(resourceType, resource.resourceName());
                    try {
                        if (ConfigAdminManager$.MODULE$.containsDuplicates((Iterable)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)resource.configs()).asScala().map((Function1 & Serializable)x$1 -> x$1.name()))) {
                            throw new InvalidRequestException("Error due to duplicate config keys");
                        }
                        ArrayList nullUpdates = new ArrayList();
                        resource.configs().forEach(config -> {
                            if (config.configOperation() != AlterConfigOp.OpType.DELETE.id() && config.value() == null) {
                                nullUpdates.add(config.name());
                                return;
                            }
                        });
                        if (!nullUpdates.isEmpty()) {
                            throw new InvalidRequestException(new StringBuilder(31).append("Null value not supported for : ").append(String.join((CharSequence)", ", nullUpdates)).toString());
                        }
                        if (ConfigResource.Type.BROKER_LOGGER.equals(resourceType)) {
                            this.runtimeLoggerManager().applyChangesForResource(BoxesRunTime.unboxToBoolean((Object)authorize.apply((Object)ResourceType.CLUSTER, (Object)"kafka-cluster")), request.validateOnly(), (IncrementalAlterConfigsRequestData.AlterConfigsResource)resource);
                            results.put((IncrementalAlterConfigsRequestData.AlterConfigsResource)resource, ApiError.NONE);
                            break block20;
                        }
                        if (ConfigResource.Type.BROKER.equals(resourceType)) {
                            if (!configResource.name().isEmpty()) {
                                this.validateResourceNameIsCurrentNodeId(resource.resourceName());
                            }
                            this.validateBrokerConfigChange((IncrementalAlterConfigsRequestData.AlterConfigsResource)resource, configResource);
                            break block20;
                        }
                        if (ConfigResource.Type.TOPIC.equals(resourceType)) {
                            if (!request.skipMirrorTopicConfigValidation()) {
                                ClusterLinkUtils$.MODULE$.validateMirrorTopicConfig(resource.resourceName(), (Set<String>)((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)resource.configs()).asScala().map((Function1 & Serializable)cfg -> cfg.name())).toSet(), this.clusterLinkManager(), true);
                            } else if (request.skipMirrorTopicConfigValidation() && !authorizeMirrorTopicConfigValidation.apply$mcZ$sp()) {
                                throw new ClusterAuthorizationException(Errors.CLUSTER_AUTHORIZATION_FAILED.message());
                            }
                            break block20;
                        }
                        if (ConfigResource.Type.CLUSTER_LINK.equals(resourceType)) {
                            if (!$this.conf.usesSelfManagedQuorum() && !$this.conf.migrationEnabled()) break block20;
                            Option<ClusterLinkMetadataManager> option = this.clusterLinkManager().clusterLinkMetadataManager();
                            if (option instanceof Some) {
                                String linkName;
                                ClusterLinkMetadataManager metadataManager = (ClusterLinkMetadataManager)((Some)option).value();
                                Option<ClusterLinkData> linkData = metadataManager.getClusterLinkData(linkName = resource.resourceName());
                                if (linkData instanceof Some) {
                                    ClusterLinkData cld = (ClusterLinkData)((Some)linkData).value();
                                    Properties configProps = metadataManager.getClusterLinkConfigProps(cld.linkId());
                                    Option<ClusterLinkConfig> currentConfig = this.clusterLinkManager().linkConfigFromPersistentProps(linkName, configProps, this.clusterLinkManager().linkConfigFromPersistentProps$default$3());
                                    scala.collection.immutable.Seq alterConfigOps = ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)resource.configs()).asScala().map((Function1 & Serializable)config -> {
                                        AlterConfigOp.OpType opType = AlterConfigOp.OpType.forId((byte)config.configOperation());
                                        if (opType == null) {
                                            throw new InvalidRequestException(new StringBuilder(24).append("Unknown operations type ").append(config.configOperation()).toString());
                                        }
                                        return new AlterConfigOp(new ConfigEntry(config.name(), config.value()), opType);
                                    })).toSeq();
                                    ConfigAdminManager$.MODULE$.prepareIncrementalConfigs((Seq<AlterConfigOp>)alterConfigOps, configProps, (Map<String, ConfigDef.ConfigKey>)ClusterLinkConfig$.MODULE$.configKeys());
                                    ClusterLinkConfig newConfig = ClusterLinkConfig$.MODULE$.create(configProps, (Option<KafkaConfig>)new Some((Object)$this.conf), true);
                                    currentConfig.foreach((Function1 & Serializable)x$2 -> {
                                        x$2.validateReconfiguration(newConfig);
                                        return BoxedUnit.UNIT;
                                    });
                                    if (newConfig.autoMirroringEnable()) {
                                        this.clusterLinkManager().maybeCheckForOverlappingTopicFilters(newConfig, cld.linkName(), cld.tenantPrefix());
                                    }
                                    break block20;
                                }
                                if (None$.MODULE$.equals(linkData)) {
                                    throw new ClusterLinkNotFoundException(new StringBuilder(37).append("Cluster link with name ").append(linkName).append(" wasn't found.").toString());
                                }
                                throw new MatchError(linkData);
                            }
                            if (None$.MODULE$.equals(option)) {
                                throw ClusterLinkDisabled$.MODULE$.exception(false);
                            }
                            throw new MatchError(option);
                        }
                        throw new InvalidRequestException(new StringBuilder(22).append("Unknown resource type ").append(resource.resourceType()).toString());
                    }
                    catch (Throwable throwable) {
                        if (throwable instanceof ConfigException ? true : throwable instanceof IllegalArgumentException) {
                            String message = new StringBuilder(36).append("Invalid config value for resource ").append(resource).append(": ").append(throwable.getMessage()).toString();
                            this.info((Function0<String>)(Function0 & Serializable)() -> message);
                            ApiError err = ApiError.fromThrowable((Throwable)new InvalidConfigurationException(message, throwable));
                            results.put((IncrementalAlterConfigsRequestData.AlterConfigsResource)resource, err);
                            return;
                        }
                        if (throwable != null) {
                            ApiError err = ApiError.fromThrowable((Throwable)throwable);
                            this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(55).append("Error preprocessing incrementalAlterConfigs request on ").append(configResource).toString(), (Function0<Throwable>)(Function0 & Serializable)() -> throwable);
                            results.put((IncrementalAlterConfigsRequestData.AlterConfigsResource)resource, err);
                            return;
                        }
                        throw null;
                    }
                }
                return;
            }
        });
        return results;
    }

    public void validateBrokerConfigChange(IncrementalAlterConfigsRequestData.AlterConfigsResource resource, ConfigResource configResource) {
        boolean perBrokerConfig = !configResource.name().isEmpty();
        Properties persistentProps = this.configRepository.config(configResource);
        Properties configProps = this.conf.dynamicConfig().fromPersistentProps(persistentProps, perBrokerConfig);
        scala.collection.immutable.Seq alterConfigOps = ((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)resource.configs()).asScala().map((Function1 & Serializable)x0$1 -> {
            AlterConfigOp.OpType opType = AlterConfigOp.OpType.forId((byte)x0$1.configOperation());
            if (opType == null) {
                throw new InvalidRequestException(new StringBuilder(24).append("Unknown operations type ").append(x0$1.configOperation()).toString());
            }
            return new AlterConfigOp(new ConfigEntry(x0$1.name(), x0$1.value()), opType);
        })).toSeq();
        ConfigAdminManager$.MODULE$.prepareIncrementalConfigs((Seq<AlterConfigOp>)alterConfigOps, configProps, KafkaConfig$.MODULE$.configKeys());
        try {
            this.validateBrokerConfigChange(configProps, configResource);
            return;
        }
        catch (Throwable t) {
            this.error((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(53).append("validation of configProps ").append(configProps).append(" for ").append(configResource).append(" failed with exception").toString(), (Function0<Throwable>)(Function0 & Serializable)() -> t);
            throw t;
        }
    }

    public void validateBrokerConfigChange(Properties props, ConfigResource configResource) {
        try {
            this.conf.dynamicConfig().validate(props, !configResource.name().isEmpty());
            return;
        }
        catch (ApiException apiException) {
            throw apiException;
        }
        catch (Throwable e) {
            throw new InvalidRequestException(e.getMessage());
        }
    }

    public IdentityHashMap<AlterConfigsRequestData.AlterConfigsResource, ApiError> preprocess(AlterConfigsRequestData request) {
        IdentityHashMap<AlterConfigsRequestData.AlterConfigsResource, ApiError> results = new IdentityHashMap<AlterConfigsRequestData.AlterConfigsResource, ApiError>();
        HashMap resourceIds = new HashMap();
        request.resources().forEach(resource -> {
            AlterConfigsRequestData.AlterConfigsResource preexisting = resourceIds.put(new Tuple2((Object)BoxesRunTime.boxToByte((byte)resource.resourceType()), (Object)resource.resourceName()), resource);
            if (preexisting != null) {
                new .colon.colon((Object)preexisting, (List)new .colon.colon(resource, (List)Nil$.MODULE$)).foreach((Function1 & Serializable)r -> results.put((AlterConfigsRequestData.AlterConfigsResource)r, new ApiError(Errors.INVALID_REQUEST, "Each resource must appear at most once.")));
                return;
            }
        });
        request.resources().forEach(resource -> {
            if (!results.containsKey(resource)) {
                block8: {
                    ConfigResource.Type resourceType = ConfigResource.Type.forId((byte)resource.resourceType());
                    ConfigResource configResource = new ConfigResource(resourceType, resource.resourceName());
                    try {
                        if (ConfigAdminManager$.MODULE$.containsDuplicates((Iterable)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)resource.configs()).asScala().map((Function1 & Serializable)x$3 -> x$3.name()))) {
                            throw new InvalidRequestException("Error due to duplicate config keys");
                        }
                        ArrayList nullUpdates = new ArrayList();
                        resource.configs().forEach(config -> {
                            if (config.value() == null) {
                                nullUpdates.add(config.name());
                                return;
                            }
                        });
                        if (!nullUpdates.isEmpty()) {
                            throw new InvalidRequestException(new StringBuilder(31).append("Null value not supported for : ").append(String.join((CharSequence)", ", nullUpdates)).toString());
                        }
                        if (ConfigResource.Type.BROKER.equals(resourceType)) {
                            if (!configResource.name().isEmpty()) {
                                this.validateResourceNameIsCurrentNodeId(resource.resourceName());
                            }
                            this.validateBrokerConfigChange((AlterConfigsRequestData.AlterConfigsResource)resource, configResource);
                            break block8;
                        }
                        if (ConfigResource.Type.TOPIC.equals(resourceType)) {
                            ClusterLinkUtils$.MODULE$.validateMirrorTopicConfig(resource.resourceName(), (Set<String>)((IterableOnceOps)CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)resource.configs()).asScala().map((Function1 & Serializable)cfg -> cfg.name())).toSet(), this.clusterLinkManager(), false);
                            break block8;
                        }
                        throw new InvalidRequestException(new StringBuilder(22).append("Unknown resource type ").append(resource.resourceType()).toString());
                    }
                    catch (Throwable throwable) {
                        ApiError err = ApiError.fromThrowable((Throwable)throwable);
                        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(46).append("Error preprocessing alterConfigs request on ").append(configResource).append(": ").append(err).toString());
                        results.put((AlterConfigsRequestData.AlterConfigsResource)resource, err);
                    }
                }
                return;
            }
        });
        return results;
    }

    public Function0<Object> preprocess$default$3() {
        return (JFunction0.mcZ.sp & Serializable)() -> false;
    }

    public void validateBrokerConfigChange(AlterConfigsRequestData.AlterConfigsResource resource, ConfigResource configResource) {
        Properties props = new Properties();
        resource.configs().forEach(config -> props.setProperty(config.name(), config.value()));
        this.validateBrokerConfigChange(props, configResource);
    }

    public void validateResourceNameIsCurrentNodeId(String name) {
        int n;
        try {
            n = StringOps$.MODULE$.toInt$extension(Predef$.MODULE$.augmentString(name));
        }
        catch (NumberFormatException numberFormatException) {
            throw new InvalidRequestException(new StringBuilder(39).append("Node id must be an integer, but it is: ").append(name).toString());
        }
        if (n != this.nodeId) {
            throw new InvalidRequestException(new StringBuilder(46).append("Unexpected broker id, expected ").append(this.nodeId).append(", but received ").append(name).toString());
        }
    }

    public IncrementalAlterConfigsRequestData maybeModifyIncrementalAlterConfigRequest(IncrementalAlterConfigsRequestData request, IdentityHashMap<IncrementalAlterConfigsRequestData.AlterConfigsResource, ApiError> processed) {
        IncrementalAlterConfigsRequestData copy = new IncrementalAlterConfigsRequestData().setValidateOnly(request.validateOnly()).setSkipMirrorTopicConfigValidation(request.skipMirrorTopicConfigValidation());
        request.resources().forEach(resource -> {
            ConfigResource.Type type = ConfigResource.Type.forId((byte)resource.resourceType());
            if (ConfigResource.Type.CLUSTER_LINK.equals(type)) {
                if (!processed.containsKey(resource)) {
                    try {
                        void var7_8;
                        void var6_7;
                        String string;
                        String string2;
                        ArrayList newConfigs = new ArrayList();
                        CollectionConverters$.MODULE$.CollectionHasAsScala((Collection)resource.configs()).asScala().foreach((Function1 & Serializable)cfg -> BoxesRunTime.boxToBoolean((boolean)newConfigs.add(new IncrementalAlterConfigsRequestData.AlterableConfig().setName(cfg.name()).setValue(cfg.value()).setConfigOperation(cfg.configOperation()))));
                        if ($this.conf.requiresZookeeper() && !$this.conf.migrationEnabled()) {
                            string2 = resource.resourceName();
                            string = null;
                        } else if ($this.conf.requiresZookeeper() && $this.conf.migrationEnabled()) {
                            string2 = resource.resourceName();
                            string = this.linkIdAsString$1((IncrementalAlterConfigsRequestData.AlterConfigsResource)resource);
                        } else {
                            string2 = this.linkIdAsString$1((IncrementalAlterConfigsRequestData.AlterConfigsResource)resource);
                            string = null;
                        }
                        String string3 = string;
                        String resourceName = string2;
                        String resourceId = string3;
                        copy.resources().mustAdd((ImplicitLinkedHashCollection.Element)new IncrementalAlterConfigsRequestData.AlterConfigsResource().setResourceName((String)var6_7).setClusterLinkResourceId((String)var7_8).setResourceType(resource.resourceType()).setConfigs(new IncrementalAlterConfigsRequestData.AlterableConfigCollection(newConfigs.iterator())));
                        return;
                    }
                    catch (Throwable ex) {
                        ConfigAdminManager$.MODULE$.log().debug(new StringBuilder(96).append("Encountered an error when processing cluster link resource ").append(resource).append(" in IncrementalAlterConfigs request. ").append(ex.getMessage()).toString());
                        processed.put((IncrementalAlterConfigsRequestData.AlterConfigsResource)resource, ApiError.fromThrowable((Throwable)ex));
                        return;
                    }
                }
                return;
            }
            if (!processed.containsKey(resource)) {
                copy.resources().mustAdd((ImplicitLinkedHashCollection.Element)resource.duplicate());
                return;
            }
        });
        return copy;
    }

    public IncrementalAlterConfigsResponseData reassembleIncrementalResponse(IncrementalAlterConfigsRequestData original, IdentityHashMap<IncrementalAlterConfigsRequestData.AlterConfigsResource, ApiError> preprocessingResponses, IncrementalAlterConfigsResponseData persistentResponses) {
        IncrementalAlterConfigsResponseData response = new IncrementalAlterConfigsResponseData();
        scala.collection.immutable.Map responsesByResource = CollectionConverters$.MODULE$.IteratorHasAsScala(persistentResponses.responses().iterator()).asScala().map((Function1 & Serializable)x0$1 -> {
            ConfigResource.Type type = ConfigResource.Type.forId((byte)x0$1.resourceType());
            ConfigResource.Type type2 = ConfigResource.Type.CLUSTER_LINK;
            if (!(type != null ? !type.equals(type2) : type2 != null)) {
                String string;
                ConfigRepository configRepository = $this.configRepository;
                if (configRepository instanceof ZkConfigRepository) {
                    string = x0$1.resourceName();
                } else if (configRepository instanceof KRaftMetadataCache) {
                    KRaftMetadataCache kRaftMetadataCache = (KRaftMetadataCache)configRepository;
                    String linkId = x0$1.resourceName();
                    try {
                        string = ((ClusterLink)kRaftMetadataCache.currentImage().clusterLinks().linksById().get(Uuid.fromString((String)linkId))).linkName();
                    }
                    catch (IllegalArgumentException illegalArgumentException) {
                        throw new IllegalStateException("Found non Kafka link id in KRaft mode.");
                    }
                } else {
                    throw new IllegalStateException("Unsupported config repository type");
                }
                String resourceName = string;
                return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)resourceName, (Object)BoxesRunTime.boxToByte((byte)x0$1.resourceType()))), (Object)new ApiError(x0$1.errorCode(), x0$1.errorMessage()));
            }
            return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)new Tuple2((Object)x0$1.resourceName(), (Object)BoxesRunTime.boxToByte((byte)x0$1.resourceType()))), (Object)new ApiError(x0$1.errorCode(), x0$1.errorMessage()));
        }).toMap((.less.colon.less)$less$colon$less$.MODULE$.refl());
        original.resources().forEach(r -> {
            ApiError apiError;
            Option option = Option$.MODULE$.apply(preprocessingResponses.get(r));
            if (None$.MODULE$.equals(option)) {
                Option option2 = responsesByResource.get((Object)new Tuple2((Object)r.resourceName(), (Object)BoxesRunTime.boxToByte((byte)r.resourceType())));
                if (None$.MODULE$.equals(option2)) {
                    ConfigAdminManager$.MODULE$.log().error(new StringBuilder(79).append("The controller returned fewer results than we ").append("expected. No response found for ").append(r).append(".").toString());
                    apiError = new ApiError(Errors.UNKNOWN_SERVER_ERROR);
                } else {
                    if (!(option2 instanceof Some)) throw new MatchError((Object)option2);
                    apiError = (ApiError)((Some)option2).value();
                }
            } else {
                if (!(option instanceof Some)) throw new MatchError((Object)option);
                apiError = (ApiError)((Some)option).value();
            }
            ApiError err = apiError;
            response.responses().add(new IncrementalAlterConfigsResponseData.AlterConfigsResourceResponse().setResourceName(r.resourceName()).setResourceType(r.resourceType()).setErrorCode(err.error().code()).setErrorMessage(err.message()));
        });
        return response;
    }

    public static final /* synthetic */ boolean $anonfun$maybeModifyIncrementalAlterConfigRequest$3(IncrementalAlterConfigsRequestData.AlterConfigsResource resource$1, ClusterLinkData x$4) {
        String string = x$4.linkName();
        String string2 = resource$1.resourceName();
        return !(string != null ? !string.equals(string2) : string2 != null);
    }

    private final String linkIdAsString$1(IncrementalAlterConfigsRequestData.AlterConfigsResource resource$1) {
        return ((Uuid)this.clusterLinkManager().listClusterLinks().find((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)ConfigAdminManager.$anonfun$maybeModifyIncrementalAlterConfigRequest$3(resource$1, x$4))).map((Function1 & Serializable)x$5 -> x$5.linkId()).getOrElse((Function0 & Serializable)() -> {
            throw new InvalidRequestException(new StringBuilder(37).append("Unable to find cluster link resource ").append(resource$1.resourceName()).toString());
        })).toString();
    }

    public ConfigAdminManager(int nodeId, KafkaConfig conf, ConfigRepository configRepository, ClusterLinkFactory.LinkManager clusterLinkManager) {
        this.nodeId = nodeId;
        this.conf = conf;
        this.configRepository = configRepository;
        this.clusterLinkManager = clusterLinkManager;
        this.logIdent_$eq(new StringBuilder(30).append("[ConfigAdminManager[nodeId=").append(nodeId).append("]: ").toString());
        this.runtimeLoggerManager = new RuntimeLoggerManager(nodeId, this.logger().underlying());
    }
}

