/*
 * Decompiled with CFR 0.152.
 */
package kafka.server;

import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import kafka.cluster.EndPoint;
import kafka.metrics.KafkaMetricsReporter$;
import kafka.server.BrokerServer;
import kafka.server.ControllerServer;
import kafka.server.KafkaBroker$;
import kafka.server.KafkaConfig;
import kafka.server.KafkaRaftServer$;
import kafka.server.KafkaRaftServer$BrokerRole$;
import kafka.server.KafkaRaftServer$ControllerRole$;
import kafka.server.MetaProperties;
import kafka.server.Server;
import kafka.server.Server$;
import kafka.server.SharedServer;
import kafka.server.StandardFaultHandlerFactory;
import kafka.utils.CoreUtils$;
import kafka.utils.Logging;
import kafka.utils.Mx4jLoader$;
import kafka.utils.VerifiableProperties$;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.config.internals.ConfluentConfigs;
import org.apache.kafka.common.metrics.Metrics;
import org.apache.kafka.common.utils.AppInfoParser;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.KafkaConfigSchema;
import org.apache.kafka.metadata.bootstrap.BootstrapMetadata;
import org.apache.kafka.raft.RaftConfig;
import org.apache.kafka.server.metrics.KafkaYammerMetrics;
import org.apache.kafka.server.multitenant.MultiTenantMetadata;
import org.slf4j.event.Level;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Some;
import scala.Tuple3;
import scala.collection.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

@ScalaSignature(bytes="\u0006\u0005\tUe\u0001B A\u0001\u0015C\u0001B\u0016\u0001\u0003\u0002\u0003\u0006Ia\u0016\u0005\t5\u0002\u0011\t\u0011)A\u00057\")q\r\u0001C\u0001Q\"QA\u000e\u0001I\u0001\u0002\u0007\u0005\u000b\u0011B7\t\u0013\u0005e\u0001A1A\u0005\n\u0005m\u0001bBA\u000f\u0001\u0001\u0006I\u0001\u001d\u0005\n\u0003?\u0001!\u0019!C\u0005\u0003CAq!a\t\u0001A\u0003%1\u000fC\u0005\u0002&\u0001\u0011\r\u0011\"\u0003\u0002(!9\u0011\u0011\u0006\u0001!\u0002\u0013Y\b\"CA\u0016\u0001\t\u0007I\u0011BA\u0017\u0011!\tI\u0004\u0001Q\u0001\n\u0005=\u0002\"CA\u001e\u0001\t\u0007I\u0011AA\u001f\u0011!\t\u0019\u0006\u0001Q\u0001\n\u0005}\u0002\"CA+\u0001\t\u0007I\u0011BA,\u0011!\t)\n\u0001Q\u0001\n\u0005e\u0003\"CAL\u0001\t\u0007I\u0011AAM\u0011!\ty\n\u0001Q\u0001\n\u0005m\u0005\"CAQ\u0001\t\u0007I\u0011BAR\u0011!\tY\u000b\u0001Q\u0001\n\u0005\u0015\u0006\"CAW\u0001\t\u0007I\u0011BAX\u0011!\tI\f\u0001Q\u0001\n\u0005E\u0006\"CA^\u0001\t\u0007I\u0011BA_\u0011!\t9\r\u0001Q\u0001\n\u0005}\u0006bBAe\u0001\u0011\u0005\u00131\u001a\u0005\b\u0003'\u0004A\u0011IAf\u0011\u001d\t)\u000e\u0001C!\u0003\u0017<q!a6A\u0011\u0003\tIN\u0002\u0004@\u0001\"\u0005\u00111\u001c\u0005\u0007Ov!\t!!8\t\u0013\u0005}WD1A\u0005\u0002\u0005\u0005\b\u0002CAt;\u0001\u0006I!a9\t\u0013\u0005%XD1A\u0005\u0002\u0005-\b\u0002CA{;\u0001\u0006I!!<\t\u0013\u0005]XD1A\u0005\u0002\u0005e\b\u0002\u0003B\u0001;\u0001\u0006I!a?\u0007\u0013\t\rQ\u0004%A\u0012\"\t\u0015qa\u0002B?;!\u0005%1\u0006\u0004\b\u0005\u0013i\u0002\u0012\u0011B\u0006\u0011\u00199w\u0005\"\u0001\u0003*!9!QF\u0014\u0005B\t=\u0002\"\u0003B\u0019O\u0005\u0005I\u0011IAq\u0011%\u0011\u0019dJA\u0001\n\u0003\u0011)\u0004C\u0005\u0003>\u001d\n\t\u0011\"\u0001\u0003@!I!\u0011J\u0014\u0002\u0002\u0013\u0005#1\n\u0005\n\u0005':\u0013\u0011!C\u0001\u0005+B\u0011Ba\u0018(\u0003\u0003%\tE!\u0019\t\u0013\t\rt%!A\u0005\n\t\u0015ta\u0002B@;!\u0005%1\u000f\u0004\b\u0005[j\u0002\u0012\u0011B8\u0011\u00199'\u0007\"\u0001\u0003r!9!Q\u0006\u001a\u0005B\t=\u0002\"\u0003B\u0019e\u0005\u0005I\u0011IAq\u0011%\u0011\u0019DMA\u0001\n\u0003\u0011)\u0004C\u0005\u0003>I\n\t\u0011\"\u0001\u0003v!I!\u0011\n\u001a\u0002\u0002\u0013\u0005#1\n\u0005\n\u0005'\u0012\u0014\u0011!C\u0001\u0005sB\u0011Ba\u00183\u0003\u0003%\tE!\u0019\t\u0013\t\r$'!A\u0005\n\t\u0015\u0004b\u0002BA;\u0011\u0005!1\u0011\u0005\n\u0005\u000fk\"\u0019!C\u0001\u0005\u0013C\u0001Ba%\u001eA\u0003%!1\u0012\u0002\u0010\u0017\u000647.\u0019*bMR\u001cVM\u001d<fe*\u0011\u0011IQ\u0001\u0007g\u0016\u0014h/\u001a:\u000b\u0003\r\u000bQa[1gW\u0006\u001c\u0001a\u0005\u0003\u0001\r2\u0003\u0006CA$K\u001b\u0005A%\"A%\u0002\u000bM\u001c\u0017\r\\1\n\u0005-C%AB!osJ+g\r\u0005\u0002N\u001d6\t\u0001)\u0003\u0002P\u0001\n11+\u001a:wKJ\u0004\"!\u0015+\u000e\u0003IS!a\u0015\"\u0002\u000bU$\u0018\u000e\\:\n\u0005U\u0013&a\u0002'pO\u001eLgnZ\u0001\u0007G>tg-[4\u0011\u00055C\u0016BA-A\u0005-Y\u0015MZ6b\u0007>tg-[4\u0002\tQLW.\u001a\t\u00039\u0016l\u0011!\u0018\u0006\u0003'zS!a\u00181\u0002\r\r|W.\\8o\u0015\t\u0019\u0015M\u0003\u0002cG\u00061\u0011\r]1dQ\u0016T\u0011\u0001Z\u0001\u0004_J<\u0017B\u00014^\u0005\u0011!\u0016.\\3\u0002\rqJg.\u001b;?)\rI'n\u001b\t\u0003\u001b\u0002AQAV\u0002A\u0002]CQAW\u0002A\u0002m\u000b1\u0001\u001f\u00132!\u00159e\u000e]:|\u0013\ty\u0007J\u0001\u0004UkBdWm\r\t\u0003\u001bFL!A\u001d!\u0003\u001d5+G/\u0019)s_B,'\u000f^5fgB\u0011A/_\u0007\u0002k*\u0011ao^\u0001\nE>|Go\u001d;sCBT!\u0001\u001f1\u0002\u00115,G/\u00193bi\u0006L!A_;\u0003#\t{w\u000e^:ue\u0006\u0004X*\u001a;bI\u0006$\u0018\r\u0005\u0003}\u007f\u0006\rQ\"A?\u000b\u0005yD\u0015AC2pY2,7\r^5p]&\u0019\u0011\u0011A?\u0003\u0007M+\u0017\u000f\u0005\u0003\u0002\u0006\u0005Ma\u0002BA\u0004\u0003\u001f\u00012!!\u0003I\u001b\t\tYAC\u0002\u0002\u000e\u0011\u000ba\u0001\u0010:p_Rt\u0014bAA\t\u0011\u00061\u0001K]3eK\u001aLA!!\u0006\u0002\u0018\t11\u000b\u001e:j]\u001eT1!!\u0005I\u0003%iW\r^1Qe>\u00048/F\u0001q\u0003)iW\r^1Qe>\u00048\u000fI\u0001\u0012E>|Go\u001d;sCBlU\r^1eCR\fW#A:\u0002%\t|w\u000e^:ue\u0006\u0004X*\u001a;bI\u0006$\u0018\rI\u0001\f_\u001a4G.\u001b8f\t&\u00148/F\u0001|\u00031ygM\u001a7j]\u0016$\u0015N]:!\u0003\u001diW\r\u001e:jGN,\"!a\f\u0011\t\u0005E\u0012QG\u0007\u0003\u0003gQ1!a\u000b_\u0013\u0011\t9$a\r\u0003\u000f5+GO]5dg\u0006AQ.\u001a;sS\u000e\u001c\b%A\nnk2$\u0018\u000eV3oC:$X*\u001a;bI\u0006$\u0018-\u0006\u0002\u0002@A)q)!\u0011\u0002F%\u0019\u00111\t%\u0003\r=\u0003H/[8o!\u0011\t9%a\u0014\u000e\u0005\u0005%#\u0002BA&\u0003\u001b\n1\"\\;mi&$XM\\1oi*\u0011\u0011\tY\u0005\u0005\u0003#\nIEA\nNk2$\u0018\u000eV3oC:$X*\u001a;bI\u0006$\u0018-\u0001\u000bnk2$\u0018\u000eV3oC:$X*\u001a;bI\u0006$\u0018\rI\u0001\u001dG>tGO]8mY\u0016\u0014\u0018+^8sk64v\u000e^3sg\u001a+H/\u001e:f+\t\tI\u0006\u0005\u0004\u0002\\\u0005%\u0014QN\u0007\u0003\u0003;RA!a\u0018\u0002b\u0005Q1m\u001c8dkJ\u0014XM\u001c;\u000b\t\u0005\r\u0014QM\u0001\u0005kRLGN\u0003\u0002\u0002h\u0005!!.\u0019<b\u0013\u0011\tY'!\u0018\u0003#\r{W\u000e\u001d7fi\u0006\u0014G.\u001a$viV\u0014X\r\u0005\u0005\u0002p\u0005E\u0014QOAA\u001b\t\t\t'\u0003\u0003\u0002t\u0005\u0005$aA'baB!\u0011qOA?\u001b\t\tIH\u0003\u0003\u0002|\u0005\u0015\u0014\u0001\u00027b]\u001eLA!a \u0002z\t9\u0011J\u001c;fO\u0016\u0014\b\u0003BAB\u0003\u001fsA!!\"\u0002\f6\u0011\u0011q\u0011\u0006\u0004\u0003\u0013\u0003\u0017\u0001\u0002:bMRLA!!$\u0002\b\u0006Q!+\u00194u\u0007>tg-[4\n\t\u0005E\u00151\u0013\u0002\f\u0003\u0012$'/Z:t'B,7M\u0003\u0003\u0002\u000e\u0006\u001d\u0015!H2p]R\u0014x\u000e\u001c7feF+xN];n->$XM]:GkR,(/\u001a\u0011\u0002+%tG/\u001a:Ce>\\WM\u001d)peR4U\u000f^;sKV\u0011\u00111\u0014\t\u0006\u000f\u0006\u0005\u0013Q\u0014\t\u0007\u00037\nI'!\u001e\u0002-%tG/\u001a:Ce>\\WM\u001d)peR4U\u000f^;sK\u0002\nAb\u001d5be\u0016$7+\u001a:wKJ,\"!!*\u0011\u00075\u000b9+C\u0002\u0002*\u0002\u0013Ab\u00155be\u0016$7+\u001a:wKJ\fQb\u001d5be\u0016$7+\u001a:wKJ\u0004\u0013A\u00022s_.,'/\u0006\u0002\u00022B)q)!\u0011\u00024B\u0019Q*!.\n\u0007\u0005]\u0006I\u0001\u0007Ce>\\WM]*feZ,'/A\u0004ce>\\WM\u001d\u0011\u0002\u0015\r|g\u000e\u001e:pY2,'/\u0006\u0002\u0002@B)q)!\u0011\u0002BB\u0019Q*a1\n\u0007\u0005\u0015\u0007I\u0001\tD_:$(o\u001c7mKJ\u001cVM\u001d<fe\u0006Y1m\u001c8ue>dG.\u001a:!\u0003\u001d\u0019H/\u0019:ukB$\"!!4\u0011\u0007\u001d\u000by-C\u0002\u0002R\"\u0013A!\u00168ji\u0006A1\u000f[;uI><h.A\u0007bo\u0006LGo\u00155vi\u0012|wO\\\u0001\u0010\u0017\u000647.\u0019*bMR\u001cVM\u001d<feB\u0011Q*H\n\u0003;\u0019#\"!!7\u0002\u001b5+G/\u00193bi\u0006$v\u000e]5d+\t\t\u0019\u000f\u0005\u0003\u0002x\u0005\u0015\u0018\u0002BA\u000b\u0003s\na\"T3uC\u0012\fG/\u0019+pa&\u001c\u0007%A\tNKR\fG-\u0019;b!\u0006\u0014H/\u001b;j_:,\"!!<\u0011\t\u0005=\u0018\u0011_\u0007\u0002=&\u0019\u00111\u001f0\u0003\u001dQ{\u0007/[2QCJ$\u0018\u000e^5p]\u0006\u0011R*\u001a;bI\u0006$\u0018\rU1si&$\u0018n\u001c8!\u0003=iU\r^1eCR\fGk\u001c9jG&#WCAA~!\u0011\ty/!@\n\u0007\u0005}hL\u0001\u0003Vk&$\u0017\u0001E'fi\u0006$\u0017\r^1U_BL7-\u00133!\u0005-\u0001&o\\2fgN\u0014v\u000e\\3\u0014\u0005\u00152\u0015fA\u0013(e\tQ!I]8lKJ\u0014v\u000e\\3\u0014\u0011\u001d2%Q\u0002B\t\u0005/\u00012Aa\u0004&\u001b\u0005i\u0002cA$\u0003\u0014%\u0019!Q\u0003%\u0003\u000fA\u0013x\u000eZ;diB!!\u0011\u0004B\u0012\u001d\u0011\u0011YBa\b\u000f\t\u0005%!QD\u0005\u0002\u0013&\u0019!\u0011\u0005%\u0002\u000fA\f7m[1hK&!!Q\u0005B\u0014\u00051\u0019VM]5bY&T\u0018M\u00197f\u0015\r\u0011\t\u0003\u0013\u000b\u0003\u0005W\u00012Aa\u0004(\u0003!!xn\u0015;sS:<GCAA\u0002\u00035\u0001(o\u001c3vGR\u0004&/\u001a4jq\u0006a\u0001O]8ek\u000e$\u0018I]5usV\u0011!q\u0007\t\u0004\u000f\ne\u0012b\u0001B\u001e\u0011\n\u0019\u0011J\u001c;\u0002\u001dA\u0014x\u000eZ;di\u0016cW-\\3oiR!!\u0011\tB$!\r9%1I\u0005\u0004\u0005\u000bB%aA!os\"AA\u000eLA\u0001\u0002\u0004\u00119$A\bqe>$Wo\u0019;Ji\u0016\u0014\u0018\r^8s+\t\u0011i\u0005E\u0003}\u0005\u001f\u0012\t%C\u0002\u0003Ru\u0014\u0001\"\u0013;fe\u0006$xN]\u0001\tG\u0006tW)];bYR!!q\u000bB/!\r9%\u0011L\u0005\u0004\u00057B%a\u0002\"p_2,\u0017M\u001c\u0005\tY:\n\t\u00111\u0001\u0003B\u0005A\u0001.Y:i\u0007>$W\r\u0006\u0002\u00038\u0005aqO]5uKJ+\u0007\u000f\\1dKR\u0011!q\r\t\u0005\u0003o\u0012I'\u0003\u0003\u0003l\u0005e$AB(cU\u0016\u001cGO\u0001\bD_:$(o\u001c7mKJ\u0014v\u000e\\3\u0014\u0011I2%Q\u0002B\t\u0005/!\"Aa\u001d\u0011\u0007\t=!\u0007\u0006\u0003\u0003B\t]\u0004\u0002\u000378\u0003\u0003\u0005\rAa\u000e\u0015\t\t]#1\u0010\u0005\tYf\n\t\u00111\u0001\u0003B\u0005Q!I]8lKJ\u0014v\u000e\\3\u0002\u001d\r{g\u000e\u001e:pY2,'OU8mK\u0006\t\u0012N\\5uS\u0006d\u0017N_3M_\u001e$\u0015N]:\u0015\u00075\u0014)\tC\u0003Wy\u0001\u0007q+\u0001\u0007d_:4\u0017nZ*dQ\u0016l\u0017-\u0006\u0002\u0003\fB!!Q\u0012BH\u001b\u00059\u0018b\u0001BIo\n\t2*\u00194lC\u000e{gNZ5h'\u000eDW-\\1\u0002\u001b\r|gNZ5h'\u000eDW-\\1!\u0001")
public class KafkaRaftServer
implements Server,
Logging {
    private final KafkaConfig config;
    private final Time time;
    private final /* synthetic */ Tuple3 x$1;
    private final MetaProperties metaProps;
    private final BootstrapMetadata bootstrapMetadata;
    private final Seq<String> offlineDirs;
    private final Metrics metrics;
    private final Option<MultiTenantMetadata> multiTenantMetadata;
    private final CompletableFuture<Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture;
    private final Option<CompletableFuture<Integer>> interBrokerPortFuture;
    private final SharedServer sharedServer;
    private final Option<BrokerServer> broker;
    private final Option<ControllerServer> controller;
    private Logger logger;
    private String logIdent;
    private volatile boolean bitmap$0;

    public static KafkaConfigSchema configSchema() {
        return KafkaRaftServer$.MODULE$.configSchema();
    }

    public static Tuple3<MetaProperties, BootstrapMetadata, Seq<String>> initializeLogDirs(KafkaConfig config) {
        return KafkaRaftServer$.MODULE$.initializeLogDirs(config);
    }

    public static Uuid MetadataTopicId() {
        return KafkaRaftServer$.MODULE$.MetadataTopicId();
    }

    public static TopicPartition MetadataPartition() {
        return KafkaRaftServer$.MODULE$.MetadataPartition();
    }

    public static String MetadataTopic() {
        return KafkaRaftServer$.MODULE$.MetadataTopic();
    }

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!this.bitmap$0) {
                this.logger = Logging.logger$(this);
                this.bitmap$0 = true;
            }
        }
        return this.logger;
    }

    @Override
    public Logger logger() {
        if (!this.bitmap$0) {
            return this.logger$lzycompute();
        }
        return this.logger;
    }

    @Override
    public String logIdent() {
        return this.logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        this.logIdent = x$1;
    }

    private MetaProperties metaProps() {
        return this.metaProps;
    }

    private BootstrapMetadata bootstrapMetadata() {
        return this.bootstrapMetadata;
    }

    private Seq<String> offlineDirs() {
        return this.offlineDirs;
    }

    private Metrics metrics() {
        return this.metrics;
    }

    public Option<MultiTenantMetadata> multiTenantMetadata() {
        return this.multiTenantMetadata;
    }

    private CompletableFuture<Map<Integer, RaftConfig.AddressSpec>> controllerQuorumVotersFuture() {
        return this.controllerQuorumVotersFuture;
    }

    public Option<CompletableFuture<Integer>> interBrokerPortFuture() {
        return this.interBrokerPortFuture;
    }

    private SharedServer sharedServer() {
        return this.sharedServer;
    }

    private Option<BrokerServer> broker() {
        return this.broker;
    }

    private Option<ControllerServer> controller() {
        return this.controller;
    }

    @Override
    public void startup() {
        Mx4jLoader$.MODULE$.maybeLoad();
        this.controller().foreach((Function1 & Serializable)x$2 -> {
            x$2.startup();
            return BoxedUnit.UNIT;
        });
        this.broker().foreach((Function1 & Serializable)x$3 -> {
            x$3.startup();
            return BoxedUnit.UNIT;
        });
        AppInfoParser.registerAppInfo((String)Server$.MODULE$.MetricsPrefix(), (String)Integer.toString(this.config.brokerId()), (Metrics)this.metrics(), (long)this.time.milliseconds());
        this.info((Function0<String>)(Function0 & Serializable)() -> KafkaBroker$.MODULE$.STARTED_MESSAGE());
    }

    @Override
    public void shutdown() {
        this.broker().foreach((Function1 & Serializable)x$4 -> {
            x$4.shutdown();
            return BoxedUnit.UNIT;
        });
        this.controller().foreach((Function1 & Serializable)x$5 -> {
            x$5.shutdown();
            return BoxedUnit.UNIT;
        });
        CoreUtils$.MODULE$.swallow((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable)() -> AppInfoParser.unregisterAppInfo((String)Server$.MODULE$.MetricsPrefix(), (String)Integer.toString($this.config.brokerId()), (Metrics)this.metrics()), this, Level.WARN);
        this.multiTenantMetadata().foreach((Function1 & Serializable)x$6 -> {
            x$6.close(this.config.brokerSessionUuid());
            return BoxedUnit.UNIT;
        });
    }

    @Override
    public void awaitShutdown() {
        this.broker().foreach((Function1 & Serializable)x$7 -> {
            x$7.awaitShutdown();
            return BoxedUnit.UNIT;
        });
        this.controller().foreach((Function1 & Serializable)x$8 -> {
            x$8.awaitShutdown();
            return BoxedUnit.UNIT;
        });
    }

    public static final /* synthetic */ boolean $anonfun$interBrokerPortFuture$1(KafkaRaftServer $this, EndPoint endpoint) {
        return endpoint.listenerName().equals((Object)$this.config.interBrokerListenerName());
    }

    public static final /* synthetic */ void $anonfun$interBrokerPortFuture$2(KafkaRaftServer $this, ObjectRef future$1, EndPoint listener) {
        if (listener.port() != 0) {
            future$1.elem = new Some(CompletableFuture.completedFuture($this.config.interBrokerPortFromEffectiveAdvertisedListeners()));
            return;
        }
    }

    public KafkaRaftServer(KafkaConfig config, Time time) {
        this.config = config;
        this.time = time;
        this.logIdent_$eq(new StringBuilder(26).append("[KafkaRaftServer nodeId=").append(config.nodeId()).append("] ").toString());
        KafkaMetricsReporter$.MODULE$.startReporters(VerifiableProperties$.MODULE$.apply(config.originals()));
        KafkaYammerMetrics.INSTANCE.configure(config.originals());
        Tuple3<MetaProperties, BootstrapMetadata, Seq<String>> tuple3 = KafkaRaftServer$.MODULE$.initializeLogDirs(config);
        if (tuple3 == null) {
            throw new MatchError(null);
        }
        MetaProperties metaProps = (MetaProperties)tuple3._1();
        BootstrapMetadata bootstrapMetadata = (BootstrapMetadata)tuple3._2();
        Seq offlineDirs = (Seq)tuple3._3();
        this.x$1 = new Tuple3((Object)metaProps, (Object)bootstrapMetadata, (Object)offlineDirs);
        this.metaProps = (MetaProperties)this.x$1._1();
        this.bootstrapMetadata = (BootstrapMetadata)this.x$1._2();
        this.offlineDirs = (Seq)this.x$1._3();
        this.metrics = Server$.MODULE$.initializeMetrics(config, time, this.metaProps().clusterId());
        this.multiTenantMetadata = Option$.MODULE$.apply((Object)ConfluentConfigs.buildMultitenantMetadata(config.values(), (Metrics)this.metrics()));
        this.controllerQuorumVotersFuture = CompletableFuture.completedFuture(RaftConfig.parseVoterConnections(config.quorumVoters()));
        ObjectRef future = ObjectRef.create((Object)None$.MODULE$);
        config.listeners().find((Function1 & Serializable)endpoint -> BoxesRunTime.boxToBoolean((boolean)KafkaRaftServer.$anonfun$interBrokerPortFuture$1(this, endpoint))).foreach((Function1 & Serializable)listener -> {
            KafkaRaftServer.$anonfun$interBrokerPortFuture$2(this, future, listener);
            return BoxedUnit.UNIT;
        });
        this.interBrokerPortFuture = (Option)future.elem;
        this.sharedServer = new SharedServer(config, this.metaProps(), time, this.metrics(), this.controllerQuorumVotersFuture(), new StandardFaultHandlerFactory(), this.multiTenantMetadata(), KafkaRaftServer$.MODULE$.configSchema(), this.interBrokerPortFuture());
        this.broker = config.processRoles().contains((Object)KafkaRaftServer$BrokerRole$.MODULE$) ? new Some((Object)new BrokerServer(this.sharedServer(), this.offlineDirs())) : None$.MODULE$;
        this.controller = config.processRoles().contains((Object)KafkaRaftServer$ControllerRole$.MODULE$) ? new Some((Object)new ControllerServer(this.sharedServer(), KafkaRaftServer$.MODULE$.configSchema(), this.bootstrapMetadata())) : None$.MODULE$;
    }

    public static interface ProcessRole {
    }
}

