/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import java.io.Serializable;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kafka.server.ClusterLinkRequestQuota;
import kafka.server.link.ClusterLinkAdminClient;
import kafka.server.link.ClusterLinkDestClientManager;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkPromoteAndSwapMirrorTopicType$;
import kafka.server.link.ClusterLinkScheduler;
import kafka.server.link.ClusterLinkTask$;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.InternalTaskErrorCode$;
import kafka.server.link.TaskDescription;
import kafka.server.link.TaskErrorCodeAndMsg;
import kafka.server.link.TopicLinkMirror$;
import kafka.server.link.TopicLinkPausedMirror$;
import kafka.server.link.TopicLinkState;
import org.apache.kafka.clients.admin.AlterMirrorOp;
import org.apache.kafka.clients.admin.AlterMirrorsOptions;
import org.apache.kafka.clients.admin.AlterMirrorsResult;
import org.apache.kafka.clients.admin.ConfluentAdmin;
import org.apache.kafka.clients.admin.PartitionResult;
import org.apache.kafka.clients.admin.ReplicaStatusOptions;
import org.apache.kafka.clients.admin.ReplicaStatusResult;
import org.apache.kafka.common.TopicPartition;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.replica.ReplicaStatus;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.metadata.MirrorTopic;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.compat.java8.OptionConverters;
import scala.compat.java8.OptionConverters$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\t}g\u0001\u0002\"D\u0001)C\u0001b\u0015\u0001\u0003\u0002\u0003\u0006I\u0001\u0016\u0005\tC\u0002\u0011\t\u0011)A\u0005E\"AQ\r\u0001B\u0001B\u0003%a\r\u0003\u0005x\u0001\t\u0005\t\u0015!\u0003y\u0011)a\bA!A!\u0002\u0013i\u00181\u0002\u0005\r\u0003\u001b\u0001!\u0011!Q\u0001\n\u0005=\u0011q\u0003\u0005\r\u00033\u0001!\u0011!Q\u0001\n\u0005m\u0011\u0011\u0005\u0005\b\u0003K\u0001A\u0011AA\u0014\u0011%\tI\u0004\u0001a\u0001\n\u0013\tY\u0004C\u0005\u0002D\u0001\u0001\r\u0011\"\u0003\u0002F!A\u0011\u0011\u000b\u0001!B\u0013\ti\u0004C\u0005\u0002T\u0001\u0011\r\u0011\"\u0003\u0002V!A\u0011Q\f\u0001!\u0002\u0013\t9\u0006C\u0005\u0002`\u0001\u0011\r\u0011\"\u0003\u0002b!9\u00111\r\u0001!\u0002\u0013Q\u0007\"CA3\u0001\t\u0007I\u0011BA1\u0011\u001d\t9\u0007\u0001Q\u0001\n)D1\"!\u001b\u0001\u0001\u0004\u0005\r\u0011\"\u0003\u0002l!Y\u00111\u0010\u0001A\u0002\u0003\u0007I\u0011BA?\u0011-\t\t\t\u0001a\u0001\u0002\u0003\u0006K!!\u001c\t\u0013\u0005\r\u0005A1A\u0005\n\u0005\u0015\u0005\u0002CAO\u0001\u0001\u0006I!a\"\t\u0013\u0005}\u0005\u00011A\u0005\n\u0005\u0005\u0006\"CAR\u0001\u0001\u0007I\u0011BAS\u0011!\tI\u000b\u0001Q!\n\u0005m\u0001\"CAV\u0001\u0001\u0007I\u0011BAQ\u0011%\ti\u000b\u0001a\u0001\n\u0013\ty\u000b\u0003\u0005\u00024\u0002\u0001\u000b\u0015BA\u000e\u0011%\t)\f\u0001a\u0001\n\u0013\t\t\u000bC\u0005\u00028\u0002\u0001\r\u0011\"\u0003\u0002:\"A\u0011Q\u0018\u0001!B\u0013\tY\u0002C\u0005\u0002@\u0002\u0001\r\u0011\"\u0003\u0002\"\"I\u0011\u0011\u0019\u0001A\u0002\u0013%\u00111\u0019\u0005\t\u0003\u000f\u0004\u0001\u0015)\u0003\u0002\u001c!I\u0011\u0011\u001a\u0001A\u0002\u0013%\u00111\b\u0005\n\u0003\u0017\u0004\u0001\u0019!C\u0005\u0003\u001bD\u0001\"!5\u0001A\u0003&\u0011Q\b\u0005\n\u0003'\u0004\u0001\u0019!C\u0005\u0003wA\u0011\"!6\u0001\u0001\u0004%I!a6\t\u0011\u0005m\u0007\u0001)Q\u0005\u0003{A\u0011\"!8\u0001\u0001\u0004%I!a8\t\u0013\u00055\b\u00011A\u0005\n\u0005=\b\u0002CAz\u0001\u0001\u0006K!!9\t\u000f\u0005u\b\u0001\"\u0015\u0002\u0000\"9!Q\u0003\u0001\u0005\n\t]\u0001b\u0002B\u0012\u0001\u0011%!Q\u0005\u0005\b\u0005S\u0001A\u0011\u0002B\u0016\u0011\u001d\u0011I\u0004\u0001C\u0005\u0005wAqA!\u0016\u0001\t\u0013\u00119\u0006C\u0004\u0003\\\u0001!IA!\u0018\t\u000f\t-\u0004\u0001\"\u0003\u0003n!9!1\u000f\u0001\u0005\n\tU\u0004b\u0002B=\u0001\u0011%!1\u0010\u0005\b\u0005\u0007\u0003A\u0011\u0002BC\u0011\u001d\u0011Y\t\u0001C\u0005\u0005\u001bCqA!%\u0001\t\u0013\u0011\u0019\nC\u0004\u0003\u001c\u0002!IA!(\t\u000f\t\r\u0006\u0001\"\u0001\u0003&\"9!q\u0015\u0001\u0005\n\t%\u0006b\u0002BT\u0001\u0011E#Q\u0016\u0005\u000f\u0005o\u0003\u0001\u0013aA\u0001\u0002\u0013%\u0011\u0011UA\u0011\u000f%\u0011IlQA\u0001\u0012\u0003\u0011YL\u0002\u0005C\u0007\u0006\u0005\t\u0012\u0001B_\u0011\u001d\t)c\u0010C\u0001\u0005\u000bD\u0011Ba2@#\u0003%\tA!3\u0003I\rcWo\u001d;fe2Kgn\u001b)s_6|G/Z!oIN;\u0018\r]'jeJ|'\u000fV8qS\u000eT!\u0001R#\u0002\t1Lgn\u001b\u0006\u0003\r\u001e\u000baa]3sm\u0016\u0014(\"\u0001%\u0002\u000b-\fgm[1\u0004\u0001M\u0011\u0001a\u0013\t\u0003\u0019Bs!!\u0014(\u000e\u0003\rK!aT\"\u0002)\rcWo\u001d;fe2Kgn[*dQ\u0016$W\u000f\\3s\u0013\t\t&K\u0001\u0007QKJLw\u000eZ5d)\u0006\u001c8N\u0003\u0002P\u0007\u0006)Ao\u001c9jGB\u0011QK\u0018\b\u0003-r\u0003\"a\u0016.\u000e\u0003aS!!W%\u0002\rq\u0012xn\u001c;?\u0015\u0005Y\u0016!B:dC2\f\u0017BA/[\u0003\u0019\u0001&/\u001a3fM&\u0011q\f\u0019\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005uS\u0016!D2mS\u0016tG/T1oC\u001e,'\u000f\u0005\u0002NG&\u0011Am\u0011\u0002\u001d\u00072,8\u000f^3s\u0019&t7\u000eR3ti\u000ec\u0017.\u001a8u\u001b\u0006t\u0017mZ3s\u0003EawnY1m\u0003\u0012l\u0017N\u001c$bGR|'/\u001f\t\u0004O\"TW\"\u0001.\n\u0005%T&!\u0003$v]\u000e$\u0018n\u001c81!\tYW/D\u0001m\u0015\tig.A\u0003bI6LgN\u0003\u0002pa\u000691\r\\5f]R\u001c(B\u0001%r\u0015\t\u00118/\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002i\u0006\u0019qN]4\n\u0005Yd'AD\"p]\u001adW/\u001a8u\u0003\u0012l\u0017N\\\u0001\u001de\u0016lw\u000e^3DYV\u001cH/\u001a:MS:\\\u0017\tZ7j]\u000ec\u0017.\u001a8u!\r9\u0007.\u001f\t\u0003\u001bjL!a_\"\u0003-\rcWo\u001d;fe2Kgn[!e[&t7\t\\5f]R\fA\u0001^5nKB\u0019a0a\u0002\u000e\u0003}TA!!\u0001\u0002\u0004\u0005)Q\u000f^5mg*\u0019\u0011Q\u00019\u0002\r\r|W.\\8o\u0013\r\tIa \u0002\u0005)&lW-\u0003\u0002}!\u0006)\u0011/^8uCB!\u0011\u0011CA\n\u001b\u0005)\u0015bAA\u000b\u000b\n92\t\\;ti\u0016\u0014H*\u001b8l%\u0016\fX/Z:u#V|G/Y\u0005\u0004\u0003\u001b\u0001\u0016AC5oi\u0016\u0014h/\u00197NgB\u0019q-!\b\n\u0007\u0005}!LA\u0002J]RL1!a\tQ\u0003E\u0011Xm]2iK\u0012,H.\u001a#fY\u0006LXj]\u0001\u0007y%t\u0017\u000e\u001e \u0015!\u0005%\u00121FA\u0017\u0003_\t\t$a\r\u00026\u0005]\u0002CA'\u0001\u0011\u0015\u0019\u0006\u00021\u0001U\u0011\u0015\t\u0007\u00021\u0001c\u0011\u0015)\u0007\u00021\u0001g\u0011\u00159\b\u00021\u0001y\u0011\u0015a\b\u00021\u0001~\u0011\u001d\ti\u0001\u0003a\u0001\u0003\u001fA\u0011\"!\u0007\t!\u0003\u0005\r!a\u0007\u00021MDw.\u001e7e'R\f'\u000f\u001e)f]\u0012LgnZ'jeJ|'/\u0006\u0002\u0002>A\u0019q-a\u0010\n\u0007\u0005\u0005#LA\u0004C_>dW-\u00198\u00029MDw.\u001e7e'R\f'\u000f\u001e)f]\u0012LgnZ'jeJ|'o\u0018\u0013fcR!\u0011qIA'!\r9\u0017\u0011J\u0005\u0004\u0003\u0017R&\u0001B+oSRD\u0011\"a\u0014\u000b\u0003\u0003\u0005\r!!\u0010\u0002\u0007a$\u0013'A\rtQ>,H\u000eZ*uCJ$\b+\u001a8eS:<W*\u001b:s_J\u0004\u0013aD7fi\u0006$\u0017\r^1NC:\fw-\u001a:\u0016\u0005\u0005]\u0003cA'\u0002Z%\u0019\u00111L\"\u00035\rcWo\u001d;fe2Kgn['fi\u0006$\u0017\r^1NC:\fw-\u001a:\u0002!5,G/\u00193bi\u0006l\u0015M\\1hKJ\u0004\u0013a\u0003:f[>$X-\u00113nS:,\u0012A[\u0001\re\u0016lw\u000e^3BI6Lg\u000eI\u0001\u000bY>\u001c\u0017\r\\!e[&t\u0017a\u00037pG\u0006d\u0017\tZ7j]\u0002\n!\u0002]1si&$\u0018n\u001c8t+\t\ti\u0007E\u0003V\u0003_\n\u0019(C\u0002\u0002r\u0001\u00141aU3u!\u0011\t)(a\u001e\u000e\u0005\u0005\r\u0011\u0002BA=\u0003\u0007\u0011a\u0002V8qS\u000e\u0004\u0016M\u001d;ji&|g.\u0001\bqCJ$\u0018\u000e^5p]N|F%Z9\u0015\t\u0005\u001d\u0013q\u0010\u0005\n\u0003\u001f\u001a\u0012\u0011!a\u0001\u0003[\n1\u0002]1si&$\u0018n\u001c8tA\u0005i\"/Z7pi\u0016\u0014V\r\u001d7jG\u0006\u001cF/\u0019;vgB\u000b'\u000f^5uS>t7/\u0006\u0002\u0002\bBA\u0011\u0011RAJ\u0003g\n9*\u0004\u0002\u0002\f*!\u0011QRAH\u0003\u0011)H/\u001b7\u000b\u0005\u0005E\u0015\u0001\u00026bm\u0006LA!!&\u0002\f\n\u0019Q*\u00199\u0011\u0007-\fI*C\u0002\u0002\u001c2\u0014q\u0002U1si&$\u0018n\u001c8SKN,H\u000e^\u0001\u001fe\u0016lw\u000e^3SKBd\u0017nY1Ti\u0006$Xo\u001d)beRLG/[8og\u0002\n!F\\;n'\u0016$(+Z7pi\u0016$v\u000e]5d)>\u0004VM\u001c3j]\u001el\u0015N\u001d:pe\u0016C8-\u001a9uS>t7/\u0006\u0002\u0002\u001c\u0005qc.^7TKR\u0014V-\\8uKR{\u0007/[2U_B+g\u000eZ5oO6K'O]8s\u000bb\u001cW\r\u001d;j_:\u001cx\fJ3r)\u0011\t9%a*\t\u0013\u0005=\u0003$!AA\u0002\u0005m\u0011a\u000b8v[N+GOU3n_R,Gk\u001c9jGR{\u0007+\u001a8eS:<W*\u001b:s_J,\u0005pY3qi&|gn\u001d\u0011\u0002A9,XNU3n_R,'+\u001a9mS\u000e\f7\u000b^1ukN,\u0005pY3qi&|gn]\u0001%]Vl'+Z7pi\u0016\u0014V\r\u001d7jG\u0006\u001cF/\u0019;vg\u0016C8-\u001a9uS>t7o\u0018\u0013fcR!\u0011qIAY\u0011%\tyeGA\u0001\u0002\u0004\tY\"A\u0011ok6\u0014V-\\8uKJ+\u0007\u000f\\5dCN#\u0018\r^;t\u000bb\u001cW\r\u001d;j_:\u001c\b%A\u0010ok6dunY1m%\u0016\u0004H.[2b'R\fG/^:Fq\u000e,\u0007\u000f^5p]N\f1E\\;n\u0019>\u001c\u0017\r\u001c*fa2L7-Y*uCR,8/\u0012=dKB$\u0018n\u001c8t?\u0012*\u0017\u000f\u0006\u0003\u0002H\u0005m\u0006\"CA(=\u0005\u0005\t\u0019AA\u000e\u0003\u0001rW/\u001c'pG\u0006d'+\u001a9mS\u000e\f7\u000b^1ukN,\u0005pY3qi&|gn\u001d\u0011\u0002M9,X\u000eT8dC2l\u0015N\u001d:peR{\u0007/[2Qe>lw\u000e^5p]\u0016C8-\u001a9uS>t7/\u0001\u0016ok6dunY1m\u001b&\u0014(o\u001c:U_BL7\r\u0015:p[>$\u0018n\u001c8Fq\u000e,\u0007\u000f^5p]N|F%Z9\u0015\t\u0005\u001d\u0013Q\u0019\u0005\n\u0003\u001f\n\u0013\u0011!a\u0001\u00037\tqE\\;n\u0019>\u001c\u0017\r\\'jeJ|'\u000fV8qS\u000e\u0004&o\\7pi&|g.\u0012=dKB$\u0018n\u001c8tA\u0005i\"/Z7pi\u0016$v\u000e]5d'\u0016$Hk\u001c)f]\u0012LgnZ'jeJ|'/A\u0011sK6|G/\u001a+pa&\u001c7+\u001a;U_B+g\u000eZ5oO6K'O]8s?\u0012*\u0017\u000f\u0006\u0003\u0002H\u0005=\u0007\"CA(I\u0005\u0005\t\u0019AA\u001f\u0003y\u0011X-\\8uKR{\u0007/[2TKR$v\u000eU3oI&tw-T5se>\u0014\b%A\u0013m_\u000e\fG.T5se>\u0014Hk\u001c9jG\u000e\u000bWo\u001a5u+B$vNU3n_R,Gk\u001c9jG\u0006ICn\\2bY6K'O]8s)>\u0004\u0018nY\"bk\u001eDG/\u00169U_J+Wn\u001c;f)>\u0004\u0018nY0%KF$B!a\u0012\u0002Z\"I\u0011qJ\u0014\u0002\u0002\u0003\u0007\u0011QH\u0001'Y>\u001c\u0017\r\\'jeJ|'\u000fV8qS\u000e\u001c\u0015-^4iiV\u0003Hk\u001c*f[>$X\rV8qS\u000e\u0004\u0013\u0001\u0003;bg.$Um]2\u0016\u0005\u0005\u0005\b#B4\u0002d\u0006\u001d\u0018bAAs5\n1q\n\u001d;j_:\u00042!TAu\u0013\r\tYo\u0011\u0002\u0010)\u0006\u001c8\u000eR3tGJL\u0007\u000f^5p]\u0006aA/Y:l\t\u0016\u001c8m\u0018\u0013fcR!\u0011qIAy\u0011%\tyEKA\u0001\u0002\u0004\t\t/A\u0005uCN\\G)Z:dA!\u001a1&a>\u0011\u0007\u001d\fI0C\u0002\u0002|j\u0013\u0001B^8mCRLG.Z\u0001\u0004eVtGC\u0001B\u0001!\u0011\u0011\u0019A!\u0005\u000f\u0007\t\u0015aJ\u0004\u0003\u0003\b\t=a\u0002\u0002B\u0005\u0005\u001bq1a\u0016B\u0006\u0013\u0005A\u0015B\u0001$H\u0013\t!U)C\u0002\u0003\u0014I\u0013!\u0002V1tWJ+7/\u001e7u\u0003)!(/\u00198tSRLwN\u001c\u000b\u0005\u0005\u0003\u0011I\u0002C\u0004\u0003\u001c5\u0002\rA!\b\u0002\u0017Q\f7o[\"p]R,\u0007\u0010\u001e\t\u0005\u0005\u0007\u0011y\"C\u0002\u0003\"I\u00131\u0002V1tW\u000e{g\u000e^3yi\u0006i2/\u001a;SK6|G/\u001a+pa&\u001cGk\u001c)f]\u0012LgnZ'jeJ|'\u000f\u0006\u0003\u0003\u0002\t\u001d\u0002b\u0002B\u000e]\u0001\u0007!QD\u0001$Q\u0006tG\r\\3TKR\u0014V-\\8uKR{\u0007/[2U_B+g\u000eZ5oO6K'O]8s)\u0019\u0011\tA!\f\u00030!9!1D\u0018A\u0002\tu\u0001b\u0002B\u0019_\u0001\u0007!1G\u0001\u0007e\u0016\u001cX\u000f\u001c;\u0011\u0007-\u0014)$C\u0002\u000381\u0014!#\u00117uKJl\u0015N\u001d:peN\u0014Vm];mi\u0006a\u0003.\u00198eY\u0016\u001cV\r\u001e*f[>$X\rV8qS\u000e$v\u000eU3oI&tw-T5se>\u0014X\t_2faRLwN\u001c\u000b\u0007\u0005\u0003\u0011iDa\u0010\t\u000f\tm\u0001\u00071\u0001\u0003\u001e!9!\u0011\t\u0019A\u0002\t\r\u0013!A3\u0011\t\t\u0015#q\n\b\u0005\u0005\u000f\u0012YED\u0002X\u0005\u0013J\u0011aW\u0005\u0004\u0005\u001bR\u0016a\u00029bG.\fw-Z\u0005\u0005\u0005#\u0012\u0019FA\u0005UQJ|w/\u00192mK*\u0019!Q\n.\u00021\r\f7\r[3SK6|G/\u001a*fa2L7-Y*uCR,8\u000f\u0006\u0003\u0003\u0002\te\u0003b\u0002B\u000ec\u0001\u0007!QD\u0001\u001aQ\u0006tG\r\\3SK6|G/\u001a*fa2L7-Y*uCR,8\u000f\u0006\u0004\u0003\u0002\t}#\u0011\r\u0005\b\u00057\u0011\u0004\u0019\u0001B\u000f\u0011\u001d\u0011\u0019G\ra\u0001\u0005K\n\u0011D]3n_R,'+\u001a9mS\u000e\f7\u000b^1ukN\u0014Vm];miB\u00191Na\u001a\n\u0007\t%DNA\nSKBd\u0017nY1Ti\u0006$Xo\u001d*fgVdG/\u0001\u0012iC:$G.\u001a*f[>$XMU3qY&\u001c\u0017m\u0015;biV\u001cX\t_2faRLwN\u001c\u000b\u0007\u0005\u0003\u0011yG!\u001d\t\u000f\tm1\u00071\u0001\u0003\u001e!9!\u0011I\u001aA\u0002\t\r\u0013aF2iK\u000e\\Gj\\2bYJ+\u0007\u000f\\5dCN#\u0018\r^;t)\u0011\u0011\tAa\u001e\t\u000f\tmA\u00071\u0001\u0003\u001e\u0005A\u0002.\u00198eY\u0016dunY1m%\u0016\u0004H.[2b'R\fG/^:\u0015\r\t\u0005!Q\u0010B@\u0011\u001d\u0011Y\"\u000ea\u0001\u0005;AqA!!6\u0001\u0004\u0011)'\u0001\rm_\u000e\fGNU3qY&\u001c\u0017m\u0015;biV\u001c(+Z:vYR\f\u0011\u0005[1oI2,Gj\\2bYJ+\u0007\u000f\\5dCN#\u0018\r^;t\u000bb\u001cW\r\u001d;j_:$bA!\u0001\u0003\b\n%\u0005b\u0002B\u000em\u0001\u0007!Q\u0004\u0005\b\u0005\u00032\u0004\u0019\u0001B\"\u0003]\u0001(o\\7pi\u0016dunY1m\u001b&\u0014(o\u001c:U_BL7\r\u0006\u0003\u0003\u0002\t=\u0005b\u0002B\u000eo\u0001\u0007!QD\u0001\u001eQ\u0006tG\r\\3Qe>lw\u000e^3M_\u000e\fG.T5se>\u0014Hk\u001c9jGR1!\u0011\u0001BK\u0005/CqAa\u00079\u0001\u0004\u0011i\u0002C\u0004\u0003\u001ab\u0002\rAa\r\u0002+M$x\u000e]'jeJ|'\u000fV8qS\u000e\u0014Vm];mi\u0006I\u0003.\u00198eY\u0016dunY1m\u001b&\u0014(o\u001c:U_BL7\r\u0015:p[>$\u0018n\u001c8Fq\u000e,\u0007\u000f^5p]N$bA!\u0001\u0003 \n\u0005\u0006b\u0002B\u000es\u0001\u0007!Q\u0004\u0005\b\u0005\u0003J\u0004\u0019\u0001B\"\u0003=!\u0018m]6EKN\u001c'/\u001b9uS>tGCAAq\u00031ygnQ8na2,G/[8o)\u0011\u0011\tAa+\t\u000f\tm1\b1\u0001\u0003\u001eQ!\u0011q\tBX\u0011\u001d\u0011\t\u0004\u0010a\u0001\u0005c\u00032\u0001\u0014BZ\u0013\r\u0011)L\u0015\u0002\u0014\u0007>l\u0007\u000f\\3uK\u0012$\u0016m]6SKN,H\u000e^\u0001\u0018gV\u0004XM\u001d\u0013sKN\u001c\u0007.\u001a3vY\u0016$U\r\\1z\u001bN\fAe\u00117vgR,'\u000fT5oWB\u0013x.\\8uK\u0006sGmU<ba6K'O]8s)>\u0004\u0018n\u0019\t\u0003\u001b~\u001a2a\u0010B`!\r9'\u0011Y\u0005\u0004\u0005\u0007T&AB!osJ+g\r\u0006\u0002\u0003<\u0006YB\u0005\\3tg&t\u0017\u000e\u001e\u0013he\u0016\fG/\u001a:%I\u00164\u0017-\u001e7uI]*\"Aa3+\t\u0005m!QZ\u0016\u0003\u0005\u001f\u0004BA!5\u0003\\6\u0011!1\u001b\u0006\u0005\u0005+\u00149.A\u0005v]\u000eDWmY6fI*\u0019!\u0011\u001c.\u0002\u0015\u0005tgn\u001c;bi&|g.\u0003\u0003\u0003^\nM'!E;oG\",7m[3e-\u0006\u0014\u0018.\u00198dK\u0002")
public class ClusterLinkPromoteAndSwapMirrorTopic
extends ClusterLinkScheduler.PeriodicTask {
    private final String topic;
    private final ClusterLinkDestClientManager clientManager;
    private final Function0<ClusterLinkAdminClient> remoteClusterLinkAdminClient;
    private boolean shouldStartPendingMirror;
    private final ClusterLinkMetadataManager metadataManager;
    private final ConfluentAdmin remoteAdmin;
    private final ConfluentAdmin localAdmin;
    private Set<TopicPartition> partitions;
    private final Map<TopicPartition, PartitionResult> remoteReplicaStatusPartitions;
    private int numSetRemoteTopicToPendingMirrorExceptions;
    private int numRemoteReplicaStatusExceptions;
    private int numLocalReplicaStatusExceptions;
    private int numLocalMirrorTopicPromotionExceptions;
    private boolean remoteTopicSetToPendingMirror;
    private boolean localMirrorTopicCaughtUpToRemoteTopic;
    private volatile Option<TaskDescription> taskDesc;

    public static int $lessinit$greater$default$7() {
        return 5000;
    }

    private /* synthetic */ int super$rescheduleDelayMs() {
        return super.rescheduleDelayMs();
    }

    private boolean shouldStartPendingMirror() {
        return this.shouldStartPendingMirror;
    }

    private void shouldStartPendingMirror_$eq(boolean x$1) {
        this.shouldStartPendingMirror = x$1;
    }

    private ClusterLinkMetadataManager metadataManager() {
        return this.metadataManager;
    }

    private ConfluentAdmin remoteAdmin() {
        return this.remoteAdmin;
    }

    private ConfluentAdmin localAdmin() {
        return this.localAdmin;
    }

    private Set<TopicPartition> partitions() {
        return this.partitions;
    }

    private void partitions_$eq(Set<TopicPartition> x$1) {
        this.partitions = x$1;
    }

    private Map<TopicPartition, PartitionResult> remoteReplicaStatusPartitions() {
        return this.remoteReplicaStatusPartitions;
    }

    private int numSetRemoteTopicToPendingMirrorExceptions() {
        return this.numSetRemoteTopicToPendingMirrorExceptions;
    }

    private void numSetRemoteTopicToPendingMirrorExceptions_$eq(int x$1) {
        this.numSetRemoteTopicToPendingMirrorExceptions = x$1;
    }

    private int numRemoteReplicaStatusExceptions() {
        return this.numRemoteReplicaStatusExceptions;
    }

    private void numRemoteReplicaStatusExceptions_$eq(int x$1) {
        this.numRemoteReplicaStatusExceptions = x$1;
    }

    private int numLocalReplicaStatusExceptions() {
        return this.numLocalReplicaStatusExceptions;
    }

    private void numLocalReplicaStatusExceptions_$eq(int x$1) {
        this.numLocalReplicaStatusExceptions = x$1;
    }

    private int numLocalMirrorTopicPromotionExceptions() {
        return this.numLocalMirrorTopicPromotionExceptions;
    }

    private void numLocalMirrorTopicPromotionExceptions_$eq(int x$1) {
        this.numLocalMirrorTopicPromotionExceptions = x$1;
    }

    private boolean remoteTopicSetToPendingMirror() {
        return this.remoteTopicSetToPendingMirror;
    }

    private void remoteTopicSetToPendingMirror_$eq(boolean x$1) {
        this.remoteTopicSetToPendingMirror = x$1;
    }

    private boolean localMirrorTopicCaughtUpToRemoteTopic() {
        return this.localMirrorTopicCaughtUpToRemoteTopic;
    }

    private void localMirrorTopicCaughtUpToRemoteTopic_$eq(boolean x$1) {
        this.localMirrorTopicCaughtUpToRemoteTopic = x$1;
    }

    private Option<TaskDescription> taskDesc() {
        return this.taskDesc;
    }

    private void taskDesc_$eq(Option<TaskDescription> x$1) {
        this.taskDesc = x$1;
    }

    @Override
    public ClusterLinkScheduler.TaskResult run() {
        ClusterLinkScheduler.TaskContext taskContext = new ClusterLinkScheduler.TaskContext((Seq<TaskErrorCodeAndMsg>)((Seq)package$.MODULE$.Seq().empty()));
        this.partitions_$eq(this.metadataManager().topicPartitions(this.topic));
        if (this.partitions().isEmpty()) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(115).append("Cannot promote and swap mirror topic for deleted topic '").append($this.topic).append("'. ").append("Shutting down ClusterLinkPromoteAndSwapMirrorTopic task.").toString());
            return this.onCompletion(taskContext);
        }
        Option mirrorState = this.metadataManager().mirrorTopicStatesFromMetadataStore((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic})))).get((Object)this.topic);
        boolean bl = false;
        Some some = null;
        if (mirrorState instanceof Some) {
            bl = true;
            some = (Some)mirrorState;
            ClusterLinkTopicState state = (ClusterLinkTopicState)some.value();
            if (state instanceof ClusterLinkTopicState.PendingSynchronizeMirror) {
                ClusterLinkTopicState.PendingSynchronizeMirror pendingSynchronizeMirror = (ClusterLinkTopicState.PendingSynchronizeMirror)state;
                TopicLinkState topicLinkState = pendingSynchronizeMirror.remoteMirrorNextState();
                if (TopicLinkMirror$.MODULE$.equals(topicLinkState)) {
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(70).append("Executing PromoteAndStartMirror since next state for remote mirror is ").append(MirrorTopic.State.MIRROR.stateName()).toString());
                    this.shouldStartPendingMirror_$eq(true);
                } else if (TopicLinkPausedMirror$.MODULE$.equals(topicLinkState)) {
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(70).append("Executing PromoteAndPauseMirror since next state for remote mirror is ").append(MirrorTopic.State.PAUSED.stateName()).toString());
                    this.shouldStartPendingMirror_$eq(false);
                } else {
                    this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(125).append("See unsupported mirror '").append(pendingSynchronizeMirror).append("' for the next state for remote mirror topic, shutting down ClusterLinkPromoteAndSwapMirrorTopic task").toString());
                    return this.onCompletion(taskContext);
                }
                this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(75).append("Attempting to promote and swap mirror topic ").append($this.topic).append(" with shouldStartPendingMirror=").append(this.shouldStartPendingMirror()).toString());
                if (this.remoteTopicSetToPendingMirror()) {
                    return this.transition(taskContext);
                }
                return this.setRemoteTopicToPendingMirror(taskContext);
            }
        }
        if (bl) {
            ClusterLinkTopicState state = (ClusterLinkTopicState)some.value();
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(95).append("See unsupported '").append(state).append("' for mirror topic '").append($this.topic).append("', shutting down ClusterLinkPromoteAndSwapMirrorTopic task").toString());
            return this.onCompletion(taskContext);
        }
        if (None$.MODULE$.equals(mirrorState)) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(92).append("No mirror state for mirror topic '").append($this.topic).append("', shutting down ClusterLinkPromoteAndSwapMirrorTopic task").toString());
            return this.onCompletion(taskContext);
        }
        throw new MatchError((Object)mirrorState);
    }

    private ClusterLinkScheduler.TaskResult transition(ClusterLinkScheduler.TaskContext taskContext) {
        if (!this.localMirrorTopicCaughtUpToRemoteTopic() && this.remoteReplicaStatusPartitions().isEmpty()) {
            return this.cacheRemoteReplicaStatus(taskContext);
        }
        if (!this.localMirrorTopicCaughtUpToRemoteTopic() && !this.remoteReplicaStatusPartitions().isEmpty()) {
            return this.checkLocalReplicaStatus(taskContext);
        }
        return this.promoteLocalMirrorTopic(taskContext);
    }

    private ClusterLinkScheduler.TaskResult setRemoteTopicToPendingMirror(ClusterLinkScheduler.TaskContext taskContext) {
        this.info((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(45).append("Setting remote topic ").append($this.topic).append(" to PendingMirror state.").toString());
        Uuid localTopicId = this.metadataManager().metadataCache().getTopicId(this.topic);
        Uuid expectedRemoteTopicId = ((ClusterLinkTopicState)((Tuple2)this.metadataManager().mirrorTopicStatesFromMetadataStore((Set<String>)((Set)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{this.topic})))).head())._2()).sourceTopicId();
        try {
            AlterMirrorsResult setRemoteTopicToPendingMirrorResult = this.shouldStartPendingMirror() ? ((ClusterLinkAdminClient)this.remoteClusterLinkAdminClient.apply()).convertToStartPendingMirror(this.topic, this.topic, localTopicId, expectedRemoteTopicId) : ((ClusterLinkAdminClient)this.remoteClusterLinkAdminClient.apply()).convertToPausePendingMirror(this.topic, this.topic, localTopicId, expectedRemoteTopicId);
            this.scheduleWhenComplete(setRemoteTopicToPendingMirrorResult.all(), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable)tc -> this.handleSetRemoteTopicToPendingMirror((ClusterLinkScheduler.TaskContext)tc, setRemoteTopicToPendingMirrorResult), taskContext));
            Seq<TaskErrorCodeAndMsg> inProgressTask_errs = taskContext.errs();
            return new ClusterLinkScheduler.TaskResult(false, inProgressTask_errs);
        }
        catch (Throwable e) {
            return this.handleSetRemoteTopicToPendingMirrorException(taskContext, e);
        }
    }

    private ClusterLinkScheduler.TaskResult handleSetRemoteTopicToPendingMirror(ClusterLinkScheduler.TaskContext taskContext, AlterMirrorsResult result) {
        Some errOpt;
        Some some;
        try {
            result.all().get();
            some = None$.MODULE$;
        }
        catch (Throwable e) {
            some = errOpt = new Some((Object)e);
        }
        if (None$.MODULE$.equals(errOpt)) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(130).append("Successfully set remote topic ").append($this.topic).append(" to PendingMirror state, will cache remote topic replica").append(" status before waiting for lag to come down.").toString());
            this.remoteTopicSetToPendingMirror_$eq(true);
            return this.transition(taskContext);
        }
        if (errOpt instanceof Some) {
            Throwable e = (Throwable)errOpt.value();
            return this.handleSetRemoteTopicToPendingMirrorException(taskContext, e);
        }
        throw new MatchError((Object)errOpt);
    }

    private ClusterLinkScheduler.TaskResult handleSetRemoteTopicToPendingMirrorException(ClusterLinkScheduler.TaskContext taskContext, Throwable e) {
        if (this.numSetRemoteTopicToPendingMirrorExceptions() == 0) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(80).append("Encountered exception while trying to set remote topic ").append($this.topic).append(" to PendingMirror state: ").append(e).toString());
        } else {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(114).append("Encountered exception while trying to set remote topic ").append($this.topic).append(" to PendingMirror state. This").append(" operation has failed ").append(this.numSetRemoteTopicToPendingMirrorExceptions()).append(" times: ").append(e).toString());
        }
        this.numSetRemoteTopicToPendingMirrorExceptions_$eq(this.numSetRemoteTopicToPendingMirrorExceptions() + 1);
        if (ClusterLinkTask$.MODULE$.isRetriableException(e)) {
            String errMsg = new StringBuilder(97).append("Encountered exception while trying to set remote topic ").append(this.topic).append(" to PendingMirror state: ").append(e).append(". Will retry in ").append(super.rescheduleDelayMs()).append(".").toString();
            this.debug((Function0<String>)(Function0 & Serializable)() -> errMsg);
            Seq completedTask_errs = (Seq)taskContext.errs().$plus$plus((IterableOnce)new .colon.colon((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg), (List)Nil$.MODULE$));
            return new ClusterLinkScheduler.TaskResult(true, (Seq<TaskErrorCodeAndMsg>)completedTask_errs);
        }
        throw e;
    }

    private ClusterLinkScheduler.TaskResult cacheRemoteReplicaStatus(ClusterLinkScheduler.TaskContext taskContext) {
        try {
            this.numRemoteReplicaStatusExceptions_$eq(0);
            ReplicaStatusResult remoteReplicaStatusResult = this.remoteAdmin().replicaStatus(CollectionConverters$.MODULE$.SetHasAsJava(this.partitions()).asJava(), new ReplicaStatusOptions());
            this.scheduleWhenComplete(remoteReplicaStatusResult.all(), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable)tc -> this.handleRemoteReplicaStatus((ClusterLinkScheduler.TaskContext)tc, remoteReplicaStatusResult), taskContext));
            Seq<TaskErrorCodeAndMsg> inProgressTask_errs = taskContext.errs();
            return new ClusterLinkScheduler.TaskResult(false, inProgressTask_errs);
        }
        catch (Throwable e) {
            return this.handleRemoteReplicaStatusException(taskContext, e);
        }
    }

    private ClusterLinkScheduler.TaskResult handleRemoteReplicaStatus(ClusterLinkScheduler.TaskContext taskContext, ReplicaStatusResult remoteReplicaStatusResult) {
        Some errOpt;
        Some some;
        try {
            Map allResults = (Map)remoteReplicaStatusResult.allResults().get();
            allResults.forEach((x0$1, x1$1) -> {
                if (OptionConverters.RichOptionalGeneric$.MODULE$.asScala$extension(OptionConverters$.MODULE$.RichOptionalGeneric(((ReplicaStatus)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(x1$1.replicas()).asScala().filter((Function1 & Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)x$2.isLeader()))).head()).mirrorInfo())).exists((Function1 & Serializable)x$3 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkPromoteAndSwapMirrorTopic.$anonfun$handleRemoteReplicaStatus$3(x$3)))) {
                    this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(95).append("Not all leaders on remote cluster have propagated PendingMirror state, will retry again in").append(" ").append(this.super$rescheduleDelayMs()).append(" ms.").toString());
                    Seq<TaskErrorCodeAndMsg> completedTask_errs = taskContext.errs();
                    new ClusterLinkScheduler.TaskResult(true, completedTask_errs);
                    return;
                }
            });
            this.remoteReplicaStatusPartitions().putAll(allResults);
            some = None$.MODULE$;
        }
        catch (Throwable e) {
            some = errOpt = new Some((Object)e);
        }
        if (None$.MODULE$.equals(errOpt)) {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(109).append("Cached remote replica status for topic ").append($this.topic).append(". Will wait for lag to get to zero before promoting").append(" local mirror topic").toString());
            return this.transition(taskContext);
        }
        if (errOpt instanceof Some) {
            Throwable e = (Throwable)errOpt.value();
            return this.handleRemoteReplicaStatusException(taskContext, e);
        }
        throw new MatchError((Object)errOpt);
    }

    private ClusterLinkScheduler.TaskResult handleRemoteReplicaStatusException(ClusterLinkScheduler.TaskContext taskContext, Throwable e) {
        if (this.numRemoteReplicaStatusExceptions() == 0) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(70).append("Encountered exception while getting remote replica status for topic ").append($this.topic).append(": ").append(e).toString());
        } else {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(104).append("Encountered exception while getting remote replica status for topic ").append($this.topic).append(".").append(" This operation has failed ").append(this.numRemoteReplicaStatusExceptions()).append(" times: ").append(e).toString());
        }
        this.numRemoteReplicaStatusExceptions_$eq(this.numRemoteReplicaStatusExceptions() + 1);
        if (ClusterLinkTask$.MODULE$.isRetriableException(e)) {
            String errMsg = new StringBuilder(87).append("Encountered exception while getting remote replica status for topic ").append(this.topic).append(": ").append(e).append(". Will retry in ").append(super.rescheduleDelayMs()).append(".").toString();
            this.debug((Function0<String>)(Function0 & Serializable)() -> errMsg);
            Seq completedTask_errs = (Seq)taskContext.errs().$plus$plus((IterableOnce)new .colon.colon((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg), (List)Nil$.MODULE$));
            return new ClusterLinkScheduler.TaskResult(true, (Seq<TaskErrorCodeAndMsg>)completedTask_errs);
        }
        throw e;
    }

    private ClusterLinkScheduler.TaskResult checkLocalReplicaStatus(ClusterLinkScheduler.TaskContext taskContext) {
        try {
            ReplicaStatusResult localReplicaStatusResult = this.localAdmin().replicaStatus(this.remoteReplicaStatusPartitions().keySet(), new ReplicaStatusOptions());
            this.scheduleWhenComplete(localReplicaStatusResult.all(), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable)tc -> this.handleLocalReplicaStatus((ClusterLinkScheduler.TaskContext)tc, localReplicaStatusResult), taskContext));
            Seq<TaskErrorCodeAndMsg> inProgressTask_errs = taskContext.errs();
            return new ClusterLinkScheduler.TaskResult(false, inProgressTask_errs);
        }
        catch (Throwable e) {
            return this.handleLocalReplicaStatusException(taskContext, e);
        }
    }

    private ClusterLinkScheduler.TaskResult handleLocalReplicaStatus(ClusterLinkScheduler.TaskContext taskContext, ReplicaStatusResult localReplicaStatusResult) {
        Some errOpt;
        Some some;
        try {
            this.numLocalReplicaStatusExceptions_$eq(0);
            Map localReplicaStatusPartitions = (Map)localReplicaStatusResult.allResults().get();
            Iterator<Map.Entry<TopicPartition, PartitionResult>> remoteReplicaStatusPartitionIterator = this.remoteReplicaStatusPartitions().entrySet().iterator();
            while (remoteReplicaStatusPartitionIterator.hasNext()) {
                Map.Entry<TopicPartition, PartitionResult> entry = remoteReplicaStatusPartitionIterator.next();
                TopicPartition tp = entry.getKey();
                ReplicaStatus localPartitionResultLeader = (ReplicaStatus)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(((PartitionResult)localReplicaStatusPartitions.get(tp)).replicas()).asScala().filter((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.isLeader()))).head();
                ReplicaStatus remotePartitionResultLeader = (ReplicaStatus)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(entry.getValue().replicas()).asScala().filter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.isLeader()))).head();
                if (!((Object)BoxesRunTime.boxToLong((long)localPartitionResultLeader.logEndOffset())).equals(BoxesRunTime.boxToLong((long)remotePartitionResultLeader.logEndOffset()))) continue;
                remoteReplicaStatusPartitionIterator.remove();
            }
            some = None$.MODULE$;
        }
        catch (Throwable e) {
            some = errOpt = new Some((Object)e);
        }
        if (None$.MODULE$.equals(errOpt)) {
            if (!this.remoteReplicaStatusPartitions().isEmpty()) {
                this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(99).append("Not all local mirror topic partitions are caught up with the remote topic. Will check again in ").append(this.super$rescheduleDelayMs()).append(" ms.").toString());
                Seq<TaskErrorCodeAndMsg> completedTask_errs = taskContext.errs();
                return new ClusterLinkScheduler.TaskResult(true, completedTask_errs);
            }
            this.debug((Function0<String>)(Function0 & Serializable)() -> "All local mirror topic partitions are caught up with the remote topic. Will proceed to promote local mirror topic.");
            this.localMirrorTopicCaughtUpToRemoteTopic_$eq(true);
            return this.transition(taskContext);
        }
        if (errOpt instanceof Some) {
            Throwable e = (Throwable)errOpt.value();
            return this.handleLocalReplicaStatusException(taskContext, e);
        }
        throw new MatchError((Object)errOpt);
    }

    private ClusterLinkScheduler.TaskResult handleLocalReplicaStatusException(ClusterLinkScheduler.TaskContext taskContext, Throwable e) {
        if (this.numLocalReplicaStatusExceptions() == 0) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(69).append("Encountered exception while getting local replica status for topic ").append($this.topic).append(": ").append(e).toString());
        } else {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(103).append("Encountered exception while getting local replica status for topic ").append($this.topic).append(".").append(" This operation has failed ").append(this.numLocalReplicaStatusExceptions()).append(" times: ").append(e).toString());
        }
        this.numLocalReplicaStatusExceptions_$eq(this.numLocalReplicaStatusExceptions() + 1);
        if (ClusterLinkTask$.MODULE$.isRetriableException(e)) {
            String errMsg = new StringBuilder(84).append("Encountered exception while getting local replica status for topic ").append(this.topic).append(": ").append(e).append(" Will retry in ").append(super.rescheduleDelayMs()).toString();
            this.debug((Function0<String>)(Function0 & Serializable)() -> errMsg);
            Seq completedTask_errs = (Seq)taskContext.errs().$plus$plus((IterableOnce)new .colon.colon((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg), (List)Nil$.MODULE$));
            return new ClusterLinkScheduler.TaskResult(true, (Seq<TaskErrorCodeAndMsg>)completedTask_errs);
        }
        throw e;
    }

    private ClusterLinkScheduler.TaskResult promoteLocalMirrorTopic(ClusterLinkScheduler.TaskContext taskContext) {
        try {
            this.numLocalMirrorTopicPromotionExceptions_$eq(0);
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(50).append("Executing promote operation on local mirror topic ").append($this.topic).toString());
            AlterMirrorsResult stopMirrorTopicResult = this.localAdmin().alterMirrors(Collections.singletonMap(this.topic, AlterMirrorOp.PROMOTE), new AlterMirrorsOptions());
            this.scheduleWhenComplete(stopMirrorTopicResult.all(), new ClusterLinkScheduler.TaskExecutionState((Function1<ClusterLinkScheduler.TaskContext, ClusterLinkScheduler.TaskResult>)(Function1 & Serializable)tc -> this.handlePromoteLocalMirrorTopic((ClusterLinkScheduler.TaskContext)tc, stopMirrorTopicResult), taskContext));
            Seq<TaskErrorCodeAndMsg> inProgressTask_errs = taskContext.errs();
            return new ClusterLinkScheduler.TaskResult(false, inProgressTask_errs);
        }
        catch (Throwable e) {
            return this.handleLocalMirrorTopicPromotionExceptions(taskContext, e);
        }
    }

    private ClusterLinkScheduler.TaskResult handlePromoteLocalMirrorTopic(ClusterLinkScheduler.TaskContext taskContext, AlterMirrorsResult stopMirrorTopicResult) {
        try {
            stopMirrorTopicResult.all().get();
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(63).append("Successfully completed promote operation on local mirror topic ").append($this.topic).toString());
            return this.onCompletion(taskContext);
        }
        catch (Throwable e) {
            return this.handleLocalMirrorTopicPromotionExceptions(taskContext, e);
        }
    }

    private ClusterLinkScheduler.TaskResult handleLocalMirrorTopicPromotionExceptions(ClusterLinkScheduler.TaskContext taskContext, Throwable e) {
        if (this.numLocalMirrorTopicPromotionExceptions() == 0) {
            this.warn((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(59).append("Encountered exception while promoting local mirror topic ").append($this.topic).append(": ").append(e).toString());
        } else {
            this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(93).append("Encountered exception while promoting local mirror topic ").append($this.topic).append(".").append(" This operation has failed ").append(this.numLocalMirrorTopicPromotionExceptions()).append(" times: ").append(e).toString());
        }
        this.numLocalMirrorTopicPromotionExceptions_$eq(this.numLocalMirrorTopicPromotionExceptions() + 1);
        if (ClusterLinkTask$.MODULE$.isRetriableException(e)) {
            String errMsg = new StringBuilder(75).append("Encountered exception while promoting local mirror topic ").append(this.topic).append(": ").append(e).append(". Will retry in ").append(super.rescheduleDelayMs()).toString();
            this.debug((Function0<String>)(Function0 & Serializable)() -> errMsg);
            Seq completedTask_errs = (Seq)taskContext.errs().$plus$plus((IterableOnce)new .colon.colon((Object)new TaskErrorCodeAndMsg(InternalTaskErrorCode$.MODULE$, errMsg), (List)Nil$.MODULE$));
            return new ClusterLinkScheduler.TaskResult(true, (Seq<TaskErrorCodeAndMsg>)completedTask_errs);
        }
        throw e;
    }

    public Option<TaskDescription> taskDescription() {
        return this.taskDesc();
    }

    private ClusterLinkScheduler.TaskResult onCompletion(ClusterLinkScheduler.TaskContext taskContext) {
        this.info((Function0<String>)(Function0 & Serializable)() -> "Shutting down ClusterLinkPromoteAndSwapMirrorTopic task.");
        this.shutdown();
        Seq<TaskErrorCodeAndMsg> completedTask_errs = taskContext.errs();
        return new ClusterLinkScheduler.TaskResult(true, completedTask_errs);
    }

    @Override
    public void onCompletion(ClusterLinkScheduler.CompletedTaskResult result) {
        this.debug((Function0<String>)(Function0 & Serializable)() -> new StringBuilder(27).append("Completed with task result ").append(result).toString());
        this.taskDesc_$eq(ClusterLinkTask$.MODULE$.handleResult(result, this.clientManager.metrics(), ClusterLinkPromoteAndSwapMirrorTopicType$.MODULE$, "promote and swap the mirror"));
    }

    public static final /* synthetic */ boolean $anonfun$handleRemoteReplicaStatus$3(ReplicaStatus.MirrorInfo x$3) {
        return !x$3.state().equals((Object)ReplicaStatus.MirrorInfo.State.PENDING_MIRROR);
    }

    public ClusterLinkPromoteAndSwapMirrorTopic(String topic, ClusterLinkDestClientManager clientManager, Function0<ConfluentAdmin> localAdminFactory, Function0<ClusterLinkAdminClient> remoteClusterLinkAdminClient, Time time, ClusterLinkRequestQuota quota, int intervalMs) {
        this.topic = topic;
        this.clientManager = clientManager;
        this.remoteClusterLinkAdminClient = remoteClusterLinkAdminClient;
        super(clientManager.scheduler(), new StringBuilder(38).append("PromoteAndSwapMirrorTopic-topic-").append(topic).append("-link-").append(clientManager.linkData().linkName()).toString(), intervalMs, time, quota);
        this.shouldStartPendingMirror = true;
        this.metadataManager = clientManager.metadataManager();
        this.remoteAdmin = clientManager.getAdmin();
        this.localAdmin = (ConfluentAdmin)localAdminFactory.apply();
        this.remoteReplicaStatusPartitions = new HashMap<TopicPartition, PartitionResult>();
        this.numSetRemoteTopicToPendingMirrorExceptions = 0;
        this.numRemoteReplicaStatusExceptions = 0;
        this.numLocalReplicaStatusExceptions = 0;
        this.numLocalMirrorTopicPromotionExceptions = 0;
        this.remoteTopicSetToPendingMirror = false;
        this.localMirrorTopicCaughtUpToRemoteTopic = false;
        this.taskDesc = None$.MODULE$;
    }
}

