/*
 * Decompiled with CFR 0.152.
 */
package kafka.server.link;

import com.typesafe.scalalogging.Logger;
import io.confluent.kafka.link.ClusterLinkConfig;
import io.confluent.kafka.link.ClusterLinkUtils;
import java.io.Serializable;
import java.net.InetSocketAddress;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionException;
import java.util.concurrent.ExecutionException;
import kafka.controller.KafkaController;
import kafka.server.KafkaConfig;
import kafka.server.MetadataSupport;
import kafka.server.RaftSupport;
import kafka.server.ZkSupport;
import kafka.server.link.ClusterLinkAlterConfigPolicy;
import kafka.server.link.ClusterLinkConfig;
import kafka.server.link.ClusterLinkFactory;
import kafka.server.link.ClusterLinkFilter;
import kafka.server.link.ClusterLinkFilterInfo;
import kafka.server.link.ClusterLinkMetadataManager;
import kafka.server.link.ClusterLinkTopicInfo;
import kafka.server.link.ClusterLinkTopicState;
import kafka.server.link.ClusterLinkUtils;
import kafka.server.link.ConnectionMode;
import kafka.server.link.ConnectionMode$Outbound$;
import kafka.server.link.GroupClusterLinkFilterInfo;
import kafka.server.link.GroupFilterJson;
import kafka.server.link.MatchedGroup;
import kafka.server.link.MirrorTopicConfigSyncRules;
import kafka.server.link.MirrorTopicConfigsDelegate;
import kafka.server.link.RetriableReconfigurationUnavailableLinkReason$;
import kafka.server.link.TopicFilterJson;
import kafka.server.link.UnavailableLinkReason;
import kafka.server.link.UnresolvableBootstrapUnavailableLinkReason$;
import kafka.utils.ConfluentUtils;
import kafka.utils.Logging;
import org.apache.kafka.clients.admin.OffsetSpec;
import org.apache.kafka.common.KafkaException;
import org.apache.kafka.common.Uuid;
import org.apache.kafka.common.acl.AclOperation;
import org.apache.kafka.common.config.ConfigException;
import org.apache.kafka.common.config.ConfigResource;
import org.apache.kafka.common.errors.ApiException;
import org.apache.kafka.common.errors.AuthenticationException;
import org.apache.kafka.common.errors.ClusterLinkNotFoundException;
import org.apache.kafka.common.errors.InvalidClusterLinkException;
import org.apache.kafka.common.errors.InvalidConfigurationException;
import org.apache.kafka.common.errors.InvalidPartitionsException;
import org.apache.kafka.common.errors.InvalidRequestException;
import org.apache.kafka.common.errors.RetriableException;
import org.apache.kafka.common.errors.TimeoutException;
import org.apache.kafka.common.errors.TopicAuthorizationException;
import org.apache.kafka.common.errors.UnsupportedVersionException;
import org.apache.kafka.common.message.CreateTopicsRequestData;
import org.apache.kafka.common.protocol.Errors;
import org.apache.kafka.common.requests.ApiError;
import org.apache.kafka.common.resource.PatternType;
import org.apache.kafka.common.utils.SecurityUtils;
import org.apache.kafka.common.utils.Time;
import org.apache.kafka.common.utils.Utils;
import org.apache.kafka.server.policy.AlterConfigPolicy;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableOnce;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.Seq;
import scala.collection.SeqOps;
import scala.collection.Set;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Set$;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.Buffer$;
import scala.jdk.CollectionConverters$;
import scala.package$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.runtime.ScalaRunTime$;

public final class ClusterLinkUtils$
implements Logging {
    public static final ClusterLinkUtils$ MODULE$ = new ClusterLinkUtils$();
    private static final scala.collection.immutable.Set<Object> ConfluentCloudInternalPorts = (scala.collection.immutable.Set)Predef$.MODULE$.Set().apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapIntArray(new int[]{9071, 9072, 9073, 9074, 9075, 9076, 9080, 8090}));
    private static final int MaxCreateClusterLinksTimeoutMs = 300000;
    private static Logger logger;
    private static String logIdent;
    private static volatile boolean bitmap$0;

    @Override
    public String loggerName() {
        return Logging.loggerName$(this);
    }

    @Override
    public String msgWithLogIdent(String msg) {
        return Logging.msgWithLogIdent$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg) {
        Logging.trace$(this, msg);
    }

    @Override
    public void trace(Function0<String> msg, Function0<Throwable> e) {
        Logging.trace$(this, msg, e);
    }

    @Override
    public boolean isDebugEnabled() {
        return Logging.isDebugEnabled$(this);
    }

    @Override
    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$(this);
    }

    @Override
    public void debug(Function0<String> msg) {
        Logging.debug$(this, msg);
    }

    @Override
    public void debug(Function0<String> msg, Function0<Throwable> e) {
        Logging.debug$(this, msg, e);
    }

    @Override
    public void info(Function0<String> msg) {
        Logging.info$(this, msg);
    }

    @Override
    public void info(Function0<String> msg, Function0<Throwable> e) {
        Logging.info$(this, msg, e);
    }

    @Override
    public void warn(Function0<String> msg) {
        Logging.warn$(this, msg);
    }

    @Override
    public void warn(Function0<String> msg, Function0<Throwable> e) {
        Logging.warn$(this, msg, e);
    }

    @Override
    public void error(Function0<String> msg) {
        Logging.error$(this, msg);
    }

    @Override
    public void error(Function0<String> msg, Function0<Throwable> e) {
        Logging.error$(this, msg, e);
    }

    @Override
    public void fatal(Function0<String> msg) {
        Logging.fatal$(this, msg);
    }

    @Override
    public void fatal(Function0<String> msg, Function0<Throwable> e) {
        Logging.fatal$(this, msg, e);
    }

    private Logger logger$lzycompute() {
        synchronized (this) {
            if (!bitmap$0) {
                logger = Logging.logger$(this);
                bitmap$0 = true;
            }
        }
        return logger;
    }

    @Override
    public Logger logger() {
        if (!bitmap$0) {
            return this.logger$lzycompute();
        }
        return logger;
    }

    @Override
    public String logIdent() {
        return logIdent;
    }

    @Override
    public void logIdent_$eq(String x$1) {
        logIdent = x$1;
    }

    public scala.collection.immutable.Set<Object> ConfluentCloudInternalPorts() {
        return ConfluentCloudInternalPorts;
    }

    private int MaxCreateClusterLinksTimeoutMs() {
        return MaxCreateClusterLinksTimeoutMs;
    }

    public void validateLinkName(String linkName) {
        ClusterLinkUtils.validateLinkNameOrThrow((String)linkName);
    }

    public Option<InvalidRequestException> checkTimeoutMs(int timeoutMs) {
        if (timeoutMs > this.MaxCreateClusterLinksTimeoutMs()) {
            return new Some((Object)new InvalidRequestException(String.format("Timeout of %d(ms) is above maximum allowed of %d(ms).", new Integer(timeoutMs), new Integer(this.MaxCreateClusterLinksTimeoutMs()))));
        }
        return None$.MODULE$;
    }

    public String logicalCluster(String tenantPrefix) {
        return tenantPrefix.substring(0, tenantPrefix.length() - 1);
    }

    public ClusterLinkUtils.ResolveCreateTopic resolveCreateTopic(CreateTopicsRequestData.CreatableTopic topic, Option<Uuid> linkId, Properties configs, boolean validateOnly, Option<ClusterLinkConfig> linkConfig, Option<CompletableFuture<ClusterLinkTopicInfo>> topicInfo, String tenantPrefix) {
        Option mirrorTopic = Option$.MODULE$.apply((Object)topic.mirrorTopic());
        Option option = Option$.MODULE$.apply((Object)topic.linkName());
        if (option instanceof Some) {
            String linkName = (String)((Some)option).value();
            ClusterLinkUtils.validateLinkNameOrThrow((String)linkName);
            if (mirrorTopic instanceof Some) {
                String unprefixedSourceTopicName;
                String mt = (String)((Some)mirrorTopic).value();
                String withoutTenantPrefixTopicName = topic.name().substring(tenantPrefix.length());
                Option clusterLinkPrefix = linkConfig.flatMap((Function1 & Serializable)x$1 -> x$1.clusterLinkPrefix());
                clusterLinkPrefix.foreach((Function1 & Serializable)linkPrefix -> {
                    ClusterLinkUtils$.$anonfun$resolveCreateTopic$2(withoutTenantPrefixTopicName, linkPrefix);
                    return BoxedUnit.UNIT;
                });
                int clusterLinkPrefixLength = ((String)clusterLinkPrefix.getOrElse((Function0 & Serializable)() -> "")).length();
                String unprefixedTopicName = withoutTenantPrefixTopicName.substring(clusterLinkPrefixLength);
                String string = unprefixedSourceTopicName = mt.substring(tenantPrefix.length());
                if (string == null ? unprefixedTopicName != null : !string.equals(unprefixedTopicName)) {
                    String expectedMirrorName = new StringBuilder(0).append((String)clusterLinkPrefix.getOrElse((Function0 & Serializable)() -> "")).append(unprefixedSourceTopicName).toString();
                    if (clusterLinkPrefix.isDefined()) {
                        throw new UnsupportedVersionException(new StringBuilder(100).append("Renaming the topic suffix, after the prefix, for mirroring not yet supported. Expected mirror name: ").append(expectedMirrorName).toString());
                    }
                    throw new UnsupportedVersionException(new StringBuilder(70).append("Topic renaming for mirroring not yet supported. Expected mirror name: ").append(expectedMirrorName).toString());
                }
            } else {
                if (None$.MODULE$.equals(mirrorTopic)) {
                    throw new InvalidRequestException("Mirror topic not set.");
                }
                throw new MatchError((Object)mirrorTopic);
            }
            if (topic.numPartitions() != -1) {
                throw new InvalidRequestException("Cannot specify both mirror topic and number of partitions.");
            }
            if (!topic.assignments().isEmpty()) {
                throw new InvalidRequestException("Cannot specify both mirror topic and partition assignments.");
            }
            if (linkId.isEmpty()) {
                throw new ClusterLinkNotFoundException(new StringBuilder(41).append("Cluster link with name '").append(topic.linkName()).append("' does not exist.").toString());
            }
            if (linkConfig instanceof Some) {
                MirrorTopicConfigSyncRules topicConfigSyncRules = ((ClusterLinkConfig)((Object)((Some)linkConfig).value())).topicConfigSyncRules();
                topicConfigSyncRules.validateMirrorPropsForTopicCreation(topic.name(), configs);
                if (topicInfo instanceof Some) {
                    ClusterLinkTopicInfo clusterLinkTopicInfo;
                    CompletableFuture ti = (CompletableFuture)((Some)topicInfo).value();
                    try {
                        if (!ti.isDone()) {
                            throw new IllegalStateException("Mirror information must have been resolved.");
                        }
                        clusterLinkTopicInfo = (ClusterLinkTopicInfo)ti.get();
                    }
                    catch (ExecutionException executionException) {
                        throw executionException.getCause();
                    }
                    catch (TimeoutException e) {
                        if (this.logger().underlying().isErrorEnabled()) {
                            String msgWithLogIdent_msg = "Received timeout exception while fetching topic information over cluster link";
                            Object var28_21 = null;
                            this.logger().underlying().error(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg), (Throwable)e);
                        }
                        throw new TimeoutException(new StringBuilder(64).append("Timed out while fetching topic information over cluster link '").append(linkName).append("'.").toString(), (Throwable)e);
                    }
                    ClusterLinkTopicInfo info = clusterLinkTopicInfo;
                    if (!info.description().authorizedOperations().contains(AclOperation.READ)) {
                        throw new TopicAuthorizationException("Mirror topic creation requires READ access on the source topic.");
                    }
                    Properties newConfigs = new MirrorTopicConfigsDelegate(configs, info.config(), topicConfigSyncRules).initMirrorProps(topic.name());
                    Uuid x$2 = (Uuid)linkId.get();
                    Uuid x$3 = info.description().topicId();
                    Seq<Object> x$4 = info.mirrorStartOffsets();
                    long x$5 = Time.SYSTEM.milliseconds();
                    return new ClusterLinkUtils.ResolveCreateTopic(newConfigs, (Option<ClusterLinkTopicState>)new Some((Object)new ClusterLinkTopicState.Mirror(linkName, x$2, x$3, x$5, x$4)), info.description().partitions().size());
                }
                if (None$.MODULE$.equals(topicInfo)) {
                    if (!validateOnly) {
                        throw new IllegalStateException("Mirror information must be provided if 'validateOnly' is not set.");
                    }
                    return new ClusterLinkUtils.ResolveCreateTopic(configs, (Option<ClusterLinkTopicState>)None$.MODULE$, -1);
                }
                throw new MatchError(topicInfo);
            }
            if (None$.MODULE$.equals(linkConfig)) {
                throw new InvalidRequestException(new StringBuilder(62).append("Cannot create mirror topic, cluster link ").append(linkName).append(" is in a FAILED state").toString());
            }
            throw new MatchError(linkConfig);
        }
        if (None$.MODULE$.equals(option)) {
            if (mirrorTopic.nonEmpty()) {
                throw new InvalidRequestException("Cannot create mirror topic, cluster link name not specified.");
            }
            return new ClusterLinkUtils.ResolveCreateTopic(configs, (Option<ClusterLinkTopicState>)None$.MODULE$, -1);
        }
        throw new MatchError((Object)option);
    }

    public String resolveCreateTopic$default$7() {
        return "";
    }

    public void validateCreatePartitions(String topic, int numPartitions, boolean validateOnly, Option<CompletableFuture<Object>> partitions) {
        if (partitions instanceof Some) {
            int n;
            CompletableFuture parts = (CompletableFuture)((Some)partitions).value();
            try {
                if (!parts.isDone()) {
                    throw new IllegalStateException("Mirror partitions must have been resolved.");
                }
                n = BoxesRunTime.unboxToInt(parts.get());
            }
            catch (ExecutionException executionException) {
                throw executionException.getCause();
            }
            catch (TimeoutException timeoutException) {
                throw new TimeoutException("Timed out while fetching topic partitions over cluster link.");
            }
            int mirrorNumPartitions = n;
            if (mirrorNumPartitions < numPartitions) {
                throw new InvalidPartitionsException(new StringBuilder(76).append("Cannot set '").append(numPartitions).append("' partitions for topic '").append(topic).append("', ").append("exceeds linked topic's '").append(mirrorNumPartitions).append("' partitions.").toString());
            }
            return;
        }
        if (None$.MODULE$.equals(partitions)) {
            if (!validateOnly) {
                throw new IllegalStateException("Mirror information must be provided if 'validateOnly' is not set.");
            }
            return;
        }
        throw new MatchError(partitions);
    }

    public scala.collection.immutable.Seq<ClusterLinkFilterInfo> clusterLinkTopicFilters(Option<TopicFilterJson> filters, Option<String> tenantPrefix, Option<String> clusterLinkPrefix) {
        return (scala.collection.immutable.Seq)((IterableOps)filters.map((Function1 & Serializable)x$2 -> x$2.filters()).getOrElse((Function0 & Serializable)() -> (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty())).map((Function1 & Serializable)filter -> MODULE$.clusterLinkFilter((ClusterLinkFilter)filter, MODULE$.tenantAndClusterLinkPrefix(tenantPrefix, clusterLinkPrefix)));
    }

    public scala.collection.immutable.Seq<GroupClusterLinkFilterInfo> clusterLinkGroupFilters(Option<GroupFilterJson> filters, Option<String> tenantPrefix, Option<String> clusterLinkPrefix, ClusterLinkConfig.LinkMode linkMode) {
        return (scala.collection.immutable.Seq)((IterableOps)filters.map((Function1 & Serializable)x$3 -> x$3.filters()).getOrElse((Function0 & Serializable)() -> (scala.collection.immutable.Seq)package$.MODULE$.Seq().empty())).map((Function1 & Serializable)filter -> {
            ClusterLinkFilterInfo clFilter = MODULE$.clusterLinkFilter((ClusterLinkFilter)filter, MODULE$.tenantAndClusterLinkPrefix(tenantPrefix, clusterLinkPrefix));
            return new GroupClusterLinkFilterInfo(clFilter, filter.effectiveTopicTypes(linkMode));
        });
    }

    private String tenantAndClusterLinkPrefix(Option<String> tenantPrefix, Option<String> clusterLinkPrefix) {
        return new StringBuilder(0).append((String)tenantPrefix.getOrElse((Function0 & Serializable)() -> "")).append(clusterLinkPrefix.getOrElse((Function0 & Serializable)() -> "")).toString();
    }

    private ClusterLinkFilterInfo clusterLinkFilter(ClusterLinkFilter filter, String prefix) {
        PatternType patternType = SecurityUtils.patternType((String)filter.patternType());
        if (StringOps$.MODULE$.nonEmpty$extension(Predef$.MODULE$.augmentString(prefix))) {
            if (PatternType.LITERAL.equals(patternType)) {
                String string = filter.name();
                String string2 = "*";
                if (string != null && string.equals(string2)) {
                    PatternType patternType2 = patternType;
                    PatternType patternType3 = PatternType.LITERAL;
                    if (!(patternType2 != null ? !patternType2.equals(patternType3) : patternType3 != null)) {
                        return new ClusterLinkFilterInfo(prefix, PatternType.PREFIXED, filter.filterType(), filter);
                    }
                }
                return new ClusterLinkFilterInfo(new StringBuilder(0).append(prefix).append(filter.name()).toString(), patternType, filter.filterType(), filter);
            }
            if (PatternType.PREFIXED.equals(patternType)) {
                return new ClusterLinkFilterInfo(new StringBuilder(0).append(prefix).append(filter.name()).toString(), patternType, filter.filterType(), filter);
            }
            throw new IllegalStateException(new StringBuilder(24).append("Unexpected pattern type ").append(filter.patternType()).toString());
        }
        return new ClusterLinkFilterInfo(filter.name(), patternType, filter.filterType(), filter);
    }

    public Properties restrictValidateTopicConfigPolicy(String topic, Properties props, Option<AlterConfigPolicy> policy) {
        if (policy instanceof Some) {
            AlterConfigPolicy pol = (AlterConfigPolicy)((Some)policy).value();
            Map configs = Utils.propsToStringMap((Properties)props);
            if (pol instanceof ClusterLinkAlterConfigPolicy) {
                ClusterLinkAlterConfigPolicy clusterLinkAlterConfigPolicy = (ClusterLinkAlterConfigPolicy)pol;
                Map<String, String> newConfigs = clusterLinkAlterConfigPolicy.clusterLinkRestrictTopicConfigs(configs);
                clusterLinkAlterConfigPolicy.clusterLinkValidateTopicConfigs(newConfigs);
                return Utils.mkProperties(newConfigs);
            }
            ConfigResource resource = new ConfigResource(ConfigResource.Type.TOPIC, topic);
            pol.validate(new AlterConfigPolicy.RequestMetadata(resource, configs));
            return props;
        }
        if (None$.MODULE$.equals(policy)) {
            return props;
        }
        throw new MatchError(policy);
    }

    public boolean canHandleClusterLinkRequests(MetadataSupport metadataSupport, KafkaConfig config) {
        if (metadataSupport instanceof ZkSupport) {
            KafkaController controller = ((ZkSupport)metadataSupport).controller();
            if (config.migrationEnabled()) {
                return true;
            }
            return controller.isActive();
        }
        if (metadataSupport instanceof RaftSupport) {
            return true;
        }
        throw new MatchError((Object)metadataSupport);
    }

    public void validateMirrorTopicConfig(String topic, scala.collection.immutable.Set<String> configKeys, ClusterLinkFactory.LinkManager clusterLinkManager, boolean isIncremental) {
        clusterLinkManager.clusterLinkMetadataManager().foreach((Function1 & Serializable)metadataManager -> {
            ClusterLinkUtils$.$anonfun$validateMirrorTopicConfig$1(topic, isIncremental, clusterLinkManager, configKeys, metadataManager);
            return BoxedUnit.UNIT;
        });
    }

    /*
     * Unable to fully structure code
     */
    public ApiException apiException(Throwable throwable, String message) {
        e = (throwable instanceof ExecutionException != false ? true : throwable instanceof CompletionException != false) != false ? throwable.getCause() : throwable;
        v0 = err = Errors.forException((Throwable)e);
        var6_5 = Errors.UNKNOWN_SERVER_ERROR;
        if (!(v0 == null ? var6_5 != null : v0.equals(var6_5) == false)) ** GOTO lbl-1000
        v1 = err.message();
        var7_6 = e.getMessage();
        if (!(v1 != null ? v1.equals(var7_6) == false : var7_6 != null)) lbl-1000:
        // 2 sources

        {
            v2 = null;
        } else {
            rootCause = e;
            while (rootCause.getCause() != null) {
                rootCause = rootCause.getCause();
            }
            v2 = rootCause == e ? e.getMessage() : new StringBuilder(14).append(e.getMessage()).append(", root cause: ").append(rootCause).toString();
        }
        errMessage = v2;
        var14_9 = new ApiError(err, errMessage);
        v3 = var14_9.error();
        var9_10 = Errors.UNKNOWN_SERVER_ERROR;
        if (!(v3 != null ? v3.equals(var9_10) == false : var9_10 != null) && e instanceof AuthenticationException) {
            var14_9 = new ApiError(Errors.INVALID_CONFIG, e.getMessage());
        }
        errorMessage = new StringBuilder(15).append(message).append(" due to error: ").append(var14_9.messageWithFallback()).toString();
        v4 = var14_9.error();
        var11_12 = Errors.UNKNOWN_SERVER_ERROR;
        if (!(v4 != null ? v4.equals(var11_12) == false : var11_12 != null)) {
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error(Logging.msgWithLogIdent$(this, errorMessage), e);
            }
        } else if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug(Logging.msgWithLogIdent$(this, errorMessage), e);
        }
        if (var14_9.exception() instanceof InvalidClusterLinkException) {
            if (e instanceof InvalidClusterLinkException) {
                var12_13 = (InvalidClusterLinkException)e;
                return new InvalidClusterLinkException(var12_13.clusterLinkError(), var12_13.linkErrorMessage(), errorMessage);
            }
            if (this.logger().underlying().isWarnEnabled()) {
                msgWithLogIdent_msg = new StringBuilder(88).append((Object)var14_9.exception()).append(" is an instance of ClusterLinkAvailabilityException but ").append(e).append(" is not which should not happen.").toString();
                var13_14 = null;
                this.logger().underlying().warn(Logging.msgWithLogIdent$(this, msgWithLogIdent_msg));
            }
            return var14_9.error().exception(errorMessage);
        }
        return var14_9.error().exception(errorMessage);
    }

    public Tuple2<scala.collection.immutable.Set<String>, scala.collection.immutable.Seq<ClusterLinkFilterInfo>> doFilterTopics(scala.collection.immutable.Set<String> toFilter, Option<TopicFilterJson> filterJsonObject, Option<String> tenantPrefix, Option<String> clusterLinkPrefix) {
        scala.collection.immutable.Seq<ClusterLinkFilterInfo> filters = this.clusterLinkTopicFilters(filterJsonObject, tenantPrefix, clusterLinkPrefix);
        return this.doFilterTopics(toFilter, filters);
    }

    public Tuple2<scala.collection.immutable.Set<MatchedGroup>, scala.collection.immutable.Seq<ClusterLinkFilterInfo>> doFilterGroups(scala.collection.immutable.Set<String> toFilter, Option<GroupFilterJson> filterJsonObject, Option<String> tenantPrefix, Option<String> clusterLinkPrefix, ClusterLinkConfig.LinkMode linkMode) {
        scala.collection.immutable.Seq<GroupClusterLinkFilterInfo> filters = this.clusterLinkGroupFilters(filterJsonObject, tenantPrefix, clusterLinkPrefix, linkMode);
        return this.doFilterGroups(toFilter, filters);
    }

    public Tuple2<scala.collection.immutable.Set<String>, scala.collection.immutable.Seq<ClusterLinkFilterInfo>> doFilterTopics(scala.collection.immutable.Set<String> toFilter, scala.collection.immutable.Seq<ClusterLinkFilterInfo> filters) {
        Buffer usedFilters = (Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        scala.collection.immutable.Set filtered = (scala.collection.immutable.Set)toFilter.filter((Function1 & Serializable)item -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkUtils$.$anonfun$doFilterTopics$1(filters, usedFilters, item)));
        return new Tuple2((Object)filtered, filters.diff((Seq)usedFilters));
    }

    public Tuple2<scala.collection.immutable.Set<MatchedGroup>, scala.collection.immutable.Seq<ClusterLinkFilterInfo>> doFilterGroups(scala.collection.immutable.Set<String> groups, scala.collection.immutable.Seq<GroupClusterLinkFilterInfo> filters) {
        Buffer usedFilters = (Buffer)Buffer$.MODULE$.apply((scala.collection.immutable.Seq)Nil$.MODULE$);
        scala.collection.immutable.Set filtered = (scala.collection.immutable.Set)groups.flatMap((Function1 & Serializable)group -> {
            scala.collection.immutable.Seq matchedFilters = (scala.collection.immutable.Seq)filters.filter((Function1 & Serializable)x$7 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkUtils$.$anonfun$doFilterGroups$2(group, x$7)));
            if (matchedFilters.isEmpty()) {
                return None$.MODULE$;
            }
            usedFilters.$plus$plus$eq((IterableOnce)matchedFilters.map((Function1 & Serializable)x$8 -> x$8.filterInfo()));
            scala.collection.immutable.Set includeTopicTypes = ((IterableOnceOps)((scala.collection.immutable.Seq)matchedFilters.filter((Function1 & Serializable)x$9 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkUtils$.$anonfun$doFilterGroups$4(x$9)))).flatMap((Function1 & Serializable)x$10 -> x$10.topicTypes())).toSet();
            scala.collection.immutable.Set excludeTopicTypes = ((IterableOnceOps)((scala.collection.immutable.Seq)matchedFilters.filter((Function1 & Serializable)x$11 -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkUtils$.$anonfun$doFilterGroups$6(x$11)))).flatMap((Function1 & Serializable)x$12 -> x$12.topicTypes())).toSet();
            scala.collection.immutable.Set topicTypes = (scala.collection.immutable.Set)includeTopicTypes.diff((Set)excludeTopicTypes);
            if (!topicTypes.isEmpty()) {
                return new Some((Object)new MatchedGroup((String)group, (scala.collection.immutable.Set<Enumeration.Value>)topicTypes));
            }
            return None$.MODULE$;
        });
        return new Tuple2((Object)filtered, ((SeqOps)filters.map((Function1 & Serializable)x$13 -> x$13.filterInfo())).diff((Seq)usedFilters));
    }

    public ClusterLinkConfig.LinkMode doFilterGroups$default$5() {
        return ClusterLinkConfig.LinkMode.DESTINATION;
    }

    public boolean isInternalNetworkOrPort(InetSocketAddress socketAddress) {
        return this.ConfluentCloudInternalPorts().contains((Object)BoxesRunTime.boxToInteger((int)socketAddress.getPort())) && (socketAddress.getAddress().isSiteLocalAddress() || socketAddress.getAddress().isLoopbackAddress());
    }

    public boolean isOutboundBootstrapCCloudHost(KafkaConfig brokerConfig, ClusterLinkConfig clusterLinkConfig) {
        return this.isOutboundBootstrapCCloudHost(brokerConfig.values(), clusterLinkConfig);
    }

    public boolean isOutboundBootstrapCCloudHost(Map<String, ?> brokerConfigs, ClusterLinkConfig clusterLinkConfig) {
        return this.isOutboundBootstrapCCloudHost(brokerConfigs, clusterLinkConfig.connectionMode(), clusterLinkConfig.bootstrapServers());
    }

    public boolean isOutboundBootstrapCCloudHost(Map<String, ?> brokerConfigs, ConnectionMode connectionMode, List<String> bootstrapServers) {
        Option firstHost = ((IterableOps)((IterableOps)CollectionConverters$.MODULE$.ListHasAsScala(bootstrapServers).asScala().filter((Function1 & Serializable)bootstrap -> BoxesRunTime.boxToBoolean((boolean)ClusterLinkUtils$.$anonfun$isOutboundBootstrapCCloudHost$1(bootstrap)))).map((Function1 & Serializable)bootstrap -> Utils.getHost((String)bootstrap))).headOption();
        if (firstHost instanceof Some) {
            String host = (String)((Some)firstHost).value();
            ConnectionMode connectionMode2 = connectionMode;
            ConnectionMode$Outbound$ connectionMode$Outbound$ = ConnectionMode$Outbound$.MODULE$;
            return connectionMode2 != null && connectionMode2.equals(connectionMode$Outbound$) && host != null && ConfluentUtils.hasCCloudHostPattern(brokerConfigs, host);
        }
        if (None$.MODULE$.equals(firstHost)) {
            return false;
        }
        throw new MatchError((Object)firstHost);
    }

    public boolean isRetriableFailure(Throwable cause) {
        if (cause instanceof RetriableException) {
            return true;
        }
        if (cause instanceof ConfigException) {
            String namingMessage = cause.getMessage();
            if (namingMessage == null) {
                return false;
            }
            return namingMessage.startsWith("No resolvable bootstrap urls");
        }
        return false;
    }

    public OffsetSpec toOffsetSpec(long timestamp, OffsetSpec defaultSpec) {
        if (Long.MIN_VALUE == timestamp) {
            return defaultSpec;
        }
        if (timestamp >= 0L) {
            return OffsetSpec.forTimestamp((long)timestamp);
        }
        if (-2L == timestamp) {
            return new OffsetSpec.EarliestSpec();
        }
        if (-1L == timestamp) {
            return new OffsetSpec.LatestSpec();
        }
        if (-3L == timestamp) {
            throw new InvalidConfigurationException("Mirroring from max timestamp is not supported.");
        }
        throw new InvalidConfigurationException(new StringBuilder(46).append("Unsupported start offset spec for mirroring: ").append(timestamp).append(".").toString());
    }

    public Option<UnavailableLinkReason> retriableExceptionToUnavailablereason(Throwable ex) {
        if (ex instanceof ConfigException) {
            return new Some((Object)UnresolvableBootstrapUnavailableLinkReason$.MODULE$);
        }
        if (ex instanceof RetriableException) {
            return new Some((Object)RetriableReconfigurationUnavailableLinkReason$.MODULE$);
        }
        return None$.MODULE$;
    }

    public boolean isAuthenticationException(KafkaException kafkaException) {
        return kafkaException instanceof AuthenticationException || kafkaException.getCause() != null && kafkaException.getCause() instanceof AuthenticationException;
    }

    public static final /* synthetic */ void $anonfun$resolveCreateTopic$2(String withoutTenantPrefixTopicName$1, String linkPrefix) {
        if (!withoutTenantPrefixTopicName$1.startsWith(linkPrefix)) {
            throw new InvalidConfigurationException(new StringBuilder(57).append("Mirror topic name should start with cluster link prefix ").append(linkPrefix).append(".").toString());
        }
    }

    public static final /* synthetic */ String $anonfun$resolveCreateTopic$5() {
        return "Received timeout exception while fetching topic information over cluster link";
    }

    public static final /* synthetic */ TimeoutException $anonfun$resolveCreateTopic$6(TimeoutException e$1) {
        return e$1;
    }

    public static final /* synthetic */ void $anonfun$validateMirrorTopicConfig$1(String topic$1, boolean isIncremental$1, ClusterLinkFactory.LinkManager clusterLinkManager$1, scala.collection.immutable.Set configKeys$1, ClusterLinkMetadataManager metadataManager) {
        if (metadataManager.hasTopic(topic$1)) {
            Option clusterLinkTopicState = metadataManager.mirrorTopicStatesFromMetadataStore((scala.collection.immutable.Set<String>)((scala.collection.immutable.Set)Set$.MODULE$.apply((scala.collection.immutable.Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new String[]{topic$1})))).get((Object)topic$1);
            if (clusterLinkTopicState.exists((Function1 & Serializable)x$4 -> BoxesRunTime.boxToBoolean((boolean)x$4.mirrorIsEstablished()))) {
                if (!isIncremental$1) {
                    throw new InvalidRequestException(new StringBuilder(72).append("Non-incremental configuration updates for mirror topic '").append(topic$1).append("' are disallowed").toString());
                }
                Uuid linkId = ((ClusterLinkTopicState)clusterLinkTopicState.get()).linkId();
                if (clusterLinkManager$1.linkConfig(linkId).isEmpty()) {
                    throw new ClusterLinkNotFoundException(new StringBuilder(71).append("The cluster link with ID ").append(linkId).append(" does not exist, or is temporarily unavailable").toString());
                }
                ((ClusterLinkConfig)((Object)clusterLinkManager$1.linkConfig(linkId).get())).topicConfigSyncRules().validateMirrorPropsForTopicAlteration(topic$1, (scala.collection.immutable.Set<String>)configKeys$1);
                return;
            }
            return;
        }
    }

    public static final /* synthetic */ String $anonfun$apiException$1(String errorMessage$1) {
        return errorMessage$1;
    }

    public static final /* synthetic */ Throwable $anonfun$apiException$2(Throwable e$2) {
        return e$2;
    }

    public static final /* synthetic */ String $anonfun$apiException$3(String errorMessage$1) {
        return errorMessage$1;
    }

    public static final /* synthetic */ Throwable $anonfun$apiException$4(Throwable e$2) {
        return e$2;
    }

    public static final /* synthetic */ String $anonfun$apiException$5(ObjectRef apiError$1, Throwable e$2) {
        return new StringBuilder(88).append((Object)((ApiError)apiError$1.elem).exception()).append(" is an instance of ClusterLinkAvailabilityException but ").append(e$2).append(" is not which should not happen.").toString();
    }

    public static final /* synthetic */ boolean $anonfun$doFilterTopics$1(scala.collection.immutable.Seq filters$1, Buffer usedFilters$1, String item) {
        scala.collection.immutable.Seq matchedFilters = (scala.collection.immutable.Seq)filters$1.filter((Function1 & Serializable)x$5 -> BoxesRunTime.boxToBoolean((boolean)x$5.matchesIncludeOrExclude(item)));
        if (matchedFilters.isEmpty()) {
            return false;
        }
        usedFilters$1.$plus$plus$eq((IterableOnce)matchedFilters);
        return matchedFilters.forall((Function1 & Serializable)x$6 -> BoxesRunTime.boxToBoolean((boolean)x$6.isInclude()));
    }

    public static final /* synthetic */ boolean $anonfun$doFilterGroups$2(String group$1, GroupClusterLinkFilterInfo x$7) {
        return x$7.filterInfo().matchesIncludeOrExclude(group$1);
    }

    public static final /* synthetic */ boolean $anonfun$doFilterGroups$4(GroupClusterLinkFilterInfo x$9) {
        return x$9.filterInfo().isInclude();
    }

    public static final /* synthetic */ boolean $anonfun$doFilterGroups$6(GroupClusterLinkFilterInfo x$11) {
        return !x$11.filterInfo().isInclude();
    }

    public static final /* synthetic */ boolean $anonfun$isOutboundBootstrapCCloudHost$1(String bootstrap) {
        return bootstrap != null && !bootstrap.isEmpty();
    }

    private ClusterLinkUtils$() {
    }
}

