/*
 * Decompiled with CFR 0.152.
 */
package kafka.tier.snapshot;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.time.Duration;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.function.Supplier;
import kafka.tier.exceptions.TierObjectStoreFatalException;
import kafka.tier.exceptions.TierObjectStoreRetriableException;
import kafka.tier.store.TierObjectStore;
import kafka.tier.store.TierObjectStoreResponse;
import kafka.tier.store.VersionInformation;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TierTopicSnapshotObjectStoreUtils {
    private static final Logger log = LoggerFactory.getLogger(TierTopicSnapshotObjectStoreUtils.class);
    static final int MAX_RETRIES = 50;
    static final long MAX_BACKOFF_MS = Duration.ofMinutes(10L).toMillis();

    public static void putBuffer(Supplier<Boolean> isShutdown, TierObjectStore objectStore, TierObjectStore.ObjectStoreMetadata metadata, ByteBuffer buffer, TierObjectStore.FileType fileType) throws IOException, InterruptedException {
        int retryCount = 0;
        while (true) {
            if (isShutdown.get().booleanValue()) {
                throw new InterruptedException("Object store put call interrupted");
            }
            try {
                objectStore.putBuffer(metadata, buffer.duplicate(), fileType);
                return;
            }
            catch (TierObjectStoreRetriableException e) {
                log.warn("Retry object store call after " + retryCount + " attempts", (Throwable)((Object)e));
                if (++retryCount >= 50) {
                    throw new TierObjectStoreFatalException("Failed to run object store call after 50 attempts", (Throwable)((Object)e));
                }
                Thread.sleep(TierTopicSnapshotObjectStoreUtils.backOffMs(retryCount));
                continue;
            }
            break;
        }
    }

    public static TierObjectStoreResponse getObject(Supplier<Boolean> isShutdown, TierObjectStore objectStore, TierObjectStore.ObjectStoreMetadata metadata, TierObjectStore.FileType fileType) throws IOException, InterruptedException {
        int retryCount = 0;
        while (true) {
            if (isShutdown.get().booleanValue()) {
                throw new InterruptedException("Object store call interrupted");
            }
            try {
                return objectStore.getObject(metadata, fileType);
            }
            catch (TierObjectStoreRetriableException e) {
                log.warn("Retry object store call get after " + retryCount + " attempts", (Throwable)((Object)e));
                if (++retryCount >= 50) {
                    throw new TierObjectStoreFatalException("Failed to run object store call after 50 attempts", (Throwable)((Object)e));
                }
                Thread.sleep(TierTopicSnapshotObjectStoreUtils.backOffMs(retryCount));
                continue;
            }
            break;
        }
    }

    public static Map<String, List<VersionInformation>> listObject(Supplier<Boolean> isShutdown, TierObjectStore objectStore, String keyPrefix, Boolean versionInfo) throws InterruptedException {
        int retryCount = 0;
        while (true) {
            if (isShutdown.get().booleanValue()) {
                throw new InterruptedException("Object store call interrupted");
            }
            try {
                return objectStore.listObject(keyPrefix, versionInfo);
            }
            catch (TierObjectStoreRetriableException e) {
                log.warn("Retry object store list call after " + retryCount + " attempts", (Throwable)((Object)e));
                if (++retryCount >= 50) {
                    throw new TierObjectStoreFatalException("Failed to run object store call after 50 attempts", (Throwable)((Object)e));
                }
                Thread.sleep(TierTopicSnapshotObjectStoreUtils.backOffMs(retryCount));
                continue;
            }
            break;
        }
    }

    static long backOffMs(int retryCount) {
        long randomSecond = 1000 + new Random().nextInt(1000);
        return Math.min(MAX_BACKOFF_MS, (long)Math.pow(2.0, retryCount) * randomSecond);
    }
}

