/*
 * Decompiled with CFR 0.152.
 */
package org.agrona.concurrent.status;

import java.nio.charset.Charset;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Consumer;
import org.agrona.DirectBuffer;
import org.agrona.MutableDirectBuffer;
import org.agrona.concurrent.AtomicBuffer;
import org.agrona.concurrent.EpochClock;
import org.agrona.concurrent.status.CountersManager;

public class ConcurrentCountersManager
extends CountersManager {
    private final ReentrantLock lock = new ReentrantLock();

    public ConcurrentCountersManager(AtomicBuffer metaDataBuffer, AtomicBuffer valuesBuffer) {
        super(metaDataBuffer, valuesBuffer);
    }

    public ConcurrentCountersManager(AtomicBuffer metaDataBuffer, AtomicBuffer valuesBuffer, Charset labelCharset) {
        super(metaDataBuffer, valuesBuffer, labelCharset);
    }

    public ConcurrentCountersManager(AtomicBuffer metaDataBuffer, AtomicBuffer valuesBuffer, Charset labelCharset, EpochClock epochClock, long freeToReuseTimeoutMs) {
        super(metaDataBuffer, valuesBuffer, labelCharset, epochClock, freeToReuseTimeoutMs);
    }

    @Override
    public int available() {
        this.lock.lock();
        try {
            int n = super.available();
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int allocate(String label, int typeId) {
        this.lock.lock();
        try {
            int n = super.allocate(label, typeId);
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int allocate(String label, int typeId, Consumer<MutableDirectBuffer> keyFunc) {
        this.lock.lock();
        try {
            int n = super.allocate(label, typeId, keyFunc);
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int allocate(int typeId, DirectBuffer keyBuffer, int keyOffset, int keyLength, DirectBuffer labelBuffer, int labelOffset, int labelLength) {
        this.lock.lock();
        try {
            int n = super.allocate(typeId, keyBuffer, keyOffset, keyLength, labelBuffer, labelOffset, labelLength);
            return n;
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void free(int counterId) {
        this.lock.lock();
        try {
            super.free(counterId);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCounterValue(int counterId, long value) {
        this.lock.lock();
        try {
            super.setCounterValue(counterId, value);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCounterRegistrationId(int counterId, long registrationId) {
        this.lock.lock();
        try {
            super.setCounterRegistrationId(counterId, registrationId);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCounterOwnerId(int counterId, long ownerId) {
        this.lock.lock();
        try {
            super.setCounterOwnerId(counterId, ownerId);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCounterReferenceId(int counterId, long referenceId) {
        this.lock.lock();
        try {
            super.setCounterReferenceId(counterId, referenceId);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void setCounterLabel(int counterId, String label) {
        this.lock.lock();
        try {
            super.setCounterLabel(counterId, label);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void setCounterKey(int counterId, Consumer<MutableDirectBuffer> keyFunc) {
        this.lock.lock();
        try {
            super.setCounterKey(counterId, keyFunc);
        }
        finally {
            this.lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setCounterKey(int counterId, DirectBuffer keyBuffer, int offset, int length) {
        this.lock.lock();
        try {
            super.setCounterKey(counterId, keyBuffer, offset, length);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public void appendToLabel(int counterId, String label) {
        this.lock.lock();
        try {
            super.appendToLabel(counterId, label);
        }
        finally {
            this.lock.unlock();
        }
    }

    @Override
    public String toString() {
        this.lock.lock();
        try {
            String string = super.toString();
            return string;
        }
        finally {
            this.lock.unlock();
        }
    }
}

