/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.kafka.schemaregistry.encryption.aws;

import com.google.common.base.Splitter;
import com.google.crypto.tink.KmsClient;
import io.confluent.kafka.schemaregistry.encryption.aws.AwsKmsClient;
import io.confluent.kafka.schemaregistry.encryption.tink.KmsDriver;
import java.lang.reflect.Field;
import java.security.GeneralSecurityException;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import software.amazon.awssdk.auth.credentials.AwsBasicCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentials;
import software.amazon.awssdk.auth.credentials.AwsCredentialsProvider;
import software.amazon.awssdk.auth.credentials.DefaultCredentialsProvider;
import software.amazon.awssdk.auth.credentials.ProfileCredentialsProvider;
import software.amazon.awssdk.auth.credentials.StaticCredentialsProvider;
import software.amazon.awssdk.regions.Region;
import software.amazon.awssdk.services.sts.StsClient;
import software.amazon.awssdk.services.sts.StsClientBuilder;
import software.amazon.awssdk.services.sts.auth.StsAssumeRoleCredentialsProvider;
import software.amazon.awssdk.services.sts.model.AssumeRoleRequest;

public class AwsKmsDriver
implements KmsDriver {
    public static final String ACCESS_KEY_ID = "access.key.id";
    public static final String SECRET_ACCESS_KEY = "secret.access.key";
    public static final String PROFILE = "profile";
    public static final String ROLE_ARN = "role.arn";
    public static final String ROLE_SESSION_NAME = "role.session.name";
    public static final String ROLE_EXTERNAL_ID = "role.external.id";
    public static final String AWS_ROLE_ARN = "AWS_ROLE_ARN";
    public static final String AWS_ROLE_SESSION_NAME = "AWS_ROLE_SESSION_NAME";
    public static final String AWS_ROLE_EXTERNAL_ID = "AWS_ROLE_EXTERNAL_ID";
    public static final String AWS_WEB_IDENTITY_TOKEN_FILE = "AWS_WEB_IDENTITY_TOKEN_FILE";

    public String getKeyUrlPrefix() {
        return "aws-kms://";
    }

    private AwsCredentialsProvider getCredentials(Map<String, ?> configs, Optional<String> kekUrl) throws GeneralSecurityException {
        try {
            String roleExternalId;
            String roleSessionName;
            String roleArn = (String)configs.get(ROLE_ARN);
            if (roleArn == null) {
                roleArn = System.getenv(AWS_ROLE_ARN);
            }
            if ((roleSessionName = (String)configs.get(ROLE_SESSION_NAME)) == null) {
                roleSessionName = System.getenv(AWS_ROLE_SESSION_NAME);
            }
            if ((roleExternalId = (String)configs.get(ROLE_EXTERNAL_ID)) == null) {
                roleExternalId = System.getenv(AWS_ROLE_EXTERNAL_ID);
            }
            String roleWebIdentityTokenFile = System.getenv(AWS_WEB_IDENTITY_TOKEN_FILE);
            String accessKey = (String)configs.get(ACCESS_KEY_ID);
            String secretKey = (String)configs.get(SECRET_ACCESS_KEY);
            String profile = (String)configs.get(PROFILE);
            Object provider = accessKey != null && secretKey != null ? StaticCredentialsProvider.create((AwsCredentials)AwsBasicCredentials.create((String)accessKey, (String)secretKey)) : (profile != null ? ProfileCredentialsProvider.create((String)profile) : DefaultCredentialsProvider.create());
            if (roleArn != null && roleWebIdentityTokenFile == null) {
                Region region = AwsKmsDriver.getRegionFromKeyId(AwsKmsClient.removePrefix("aws-kms://", kekUrl.get()));
                return this.buildRoleProvider((AwsCredentialsProvider)provider, region, roleArn, roleSessionName, roleExternalId);
            }
            return provider;
        }
        catch (Exception e) {
            throw new GeneralSecurityException("cannot load credentials", e);
        }
    }

    private AwsCredentialsProvider buildRoleProvider(AwsCredentialsProvider provider, Region region, String roleArn, String roleSessionName, String roleExternalId) {
        StsClient stsClient = (StsClient)((StsClientBuilder)((StsClientBuilder)StsClient.builder().credentialsProvider(provider)).region(region)).build();
        return ((StsAssumeRoleCredentialsProvider.Builder)StsAssumeRoleCredentialsProvider.builder().stsClient(stsClient)).refreshRequest(() -> this.buildRoleRequest(roleArn, roleSessionName, roleExternalId)).build();
    }

    private AssumeRoleRequest buildRoleRequest(String roleArn, String roleSessionName, String roleExternalId) {
        AssumeRoleRequest.Builder req = AssumeRoleRequest.builder().roleArn(roleArn).roleSessionName(roleSessionName != null ? roleSessionName : "confluent-encrypt");
        if (roleExternalId != null) {
            req = req.externalId(roleExternalId);
        }
        return (AssumeRoleRequest)req.build();
    }

    public static Region getRegionFromKeyId(String keyId) {
        List tokens = Splitter.on((char)':').splitToList((CharSequence)keyId);
        if (tokens.size() < 4) {
            throw new IllegalArgumentException("invalid key URI");
        }
        String regionName = (String)tokens.get(3);
        return Region.of((String)regionName);
    }

    public KmsClient newKmsClient(Map<String, ?> configs, Optional<String> kekUrl) throws GeneralSecurityException {
        software.amazon.awssdk.services.kms.KmsClient testClient = (software.amazon.awssdk.services.kms.KmsClient)this.getTestClient(configs);
        Optional<AwsCredentialsProvider> creds = testClient != null ? Optional.empty() : Optional.of(this.getCredentials(configs, kekUrl));
        return AwsKmsDriver.newKmsClientWithAwsKms(kekUrl, creds, testClient);
    }

    protected static KmsClient newKmsClientWithAwsKms(Optional<String> keyUri, Optional<AwsCredentialsProvider> credentials, software.amazon.awssdk.services.kms.KmsClient awsKms) throws GeneralSecurityException {
        AwsKmsClient client = keyUri.isPresent() ? new AwsKmsClient(keyUri.get()) : new AwsKmsClient();
        if (credentials.isPresent()) {
            client.withCredentialsProvider(credentials.get());
        } else {
            client.withDefaultCredentials();
        }
        if (awsKms != null) {
            AwsKmsDriver.setAwsKms(client, awsKms);
        }
        return client;
    }

    private static void setAwsKms(AwsKmsClient client, software.amazon.awssdk.services.kms.KmsClient awsKms) {
        try {
            Field field = AwsKmsClient.class.getDeclaredField("awsKms");
            field.setAccessible(true);
            field.set(client, awsKms);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

