/*
 * Decompiled with CFR 0.152.
 */
package io.confluent.connect.secretregistry;

import io.confluent.connect.secretregistry.ConnectSecretRegistryFilter;
import io.confluent.connect.secretregistry.util.Version;
import io.confluent.kafka.secretregistry.exceptions.SecretRegistryException;
import io.confluent.kafka.secretregistry.exceptions.SecretRegistryInitializationException;
import io.confluent.kafka.secretregistry.rest.SslFactory;
import io.confluent.kafka.secretregistry.rest.resources.PathKeyResource;
import io.confluent.kafka.secretregistry.rest.resources.PathKeyVersionResource;
import io.confluent.kafka.secretregistry.rest.resources.PathResource;
import io.confluent.kafka.secretregistry.storage.KafkaSecretRegistry;
import io.confluent.kafka.secretregistry.storage.UriInfo;
import io.confluent.security.auth.client.RestAuthorizer;
import io.confluent.security.authorizer.Scope;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.kafka.connect.errors.ConnectException;
import org.apache.kafka.connect.health.ConnectClusterState;
import org.apache.kafka.connect.rest.ConnectRestExtension;
import org.apache.kafka.connect.rest.ConnectRestExtensionContext;
import org.apache.kafka.connect.runtime.WorkerConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConnectSecretRegistryExtension
implements ConnectRestExtension {
    private static final Logger log = LoggerFactory.getLogger(ConnectSecretRegistryExtension.class);
    public static final String CONNECT_CLUSTER_TYPE = "connect-cluster";
    private static final String PROTOCOL_HTTP = "http";
    private static final String PROTOCOL_HTTPS = "https";
    private static final String STANDALONE_CLUSTER = "STANDALONE";
    private static ReentrantLock lock = new ReentrantLock();
    private static Condition isInit = lock.newCondition();
    private static KafkaSecretRegistry secretRegistry;
    private WorkerConfig workerConfig;
    private Map<String, ?> configs;
    private static final String USE_ADVERTISED_ENDPOINTS_CONFIG = "secret.registry.use.advertised.endpoints";
    private static final boolean USE_ADVERTISED_ENDPOINTS_DEFAULT = false;

    public void configure(Map<String, ?> configs) {
        this.configs = configs;
        this.workerConfig = new ConcreteWorkerConfig(configs);
    }

    private void initSecretRegistry(KafkaSecretRegistry secretRegistry) throws SecretRegistryException {
        String host = this.workerConfig.getString("rest.advertised.host.name");
        Integer port = this.workerConfig.getInt("rest.advertised.port");
        boolean useAdvertisedEndpoints = Boolean.parseBoolean(((Object)this.workerConfig.originals().getOrDefault(USE_ADVERTISED_ENDPOINTS_CONFIG, false)).toString());
        UriInfo uriInfo = KafkaSecretRegistry.getUriInfoForIdentity((String)host, (Integer)port, (List)this.workerConfig.getList("listeners"), (String)this.determineAdvertisedProtocol(), (boolean)useAdvertisedEndpoints);
        SslFactory sslFactory = new SslFactory(this.workerConfig.originalsStrings());
        secretRegistry.initRest(sslFactory, uriInfo);
    }

    private String determineAdvertisedProtocol() {
        String advertisedSecurityProtocol = this.workerConfig.getString("rest.advertised.listener");
        if (advertisedSecurityProtocol == null) {
            String listeners = (String)this.workerConfig.originals().get("listeners");
            if (listeners == null) {
                return PROTOCOL_HTTP;
            }
            listeners = listeners.toLowerCase(Locale.ENGLISH);
            if (listeners.contains(String.format("%s://", PROTOCOL_HTTP))) {
                return PROTOCOL_HTTP;
            }
            if (listeners.contains(String.format("%s://", PROTOCOL_HTTPS))) {
                return PROTOCOL_HTTPS;
            }
            return PROTOCOL_HTTP;
        }
        return advertisedSecurityProtocol.toLowerCase(Locale.ENGLISH);
    }

    public void register(ConnectRestExtensionContext restExtensionContext) {
        try {
            KafkaSecretRegistry secretRegistry = ConnectSecretRegistryExtension.secretRegistry();
            this.initSecretRegistry(secretRegistry);
            Scope scope = ConnectSecretRegistryExtension.determineScope(this.configs, restExtensionContext.clusterState());
            log.info("Registering RBAC authorizer on cluster with scope '{}'", (Object)scope);
            RestAuthorizer restAuthorizer = new RestAuthorizer();
            restAuthorizer.configure(this.workerConfig.originals());
            ConnectSecretRegistryFilter filter = new ConnectSecretRegistryFilter(scope, restAuthorizer, restExtensionContext.clusterState());
            restExtensionContext.configurable().register((Object)filter);
            restExtensionContext.configurable().register((Object)new PathResource(secretRegistry));
            restExtensionContext.configurable().register((Object)new PathKeyResource(secretRegistry));
            restExtensionContext.configurable().register((Object)new PathKeyVersionResource(secretRegistry));
        }
        catch (SecretRegistryException e) {
            log.error("Error initializing the secret registry", (Throwable)e);
            this.close();
            throw new ConnectException("Error initializing the secret registry", (Throwable)e);
        }
    }

    static Scope determineScope(Map<String, ?> configs, ConnectClusterState clusterState) {
        String kafkaClusterId = clusterState.clusterDetails().kafkaClusterId();
        Object groupId = configs.get("group.id");
        String clusterId = groupId != null ? groupId.toString() : STANDALONE_CLUSTER;
        return new Scope.Builder(new String[0]).withKafkaCluster(kafkaClusterId).withCluster(CONNECT_CLUSTER_TYPE, clusterId).build();
    }

    public String version() {
        return Version.getVersion();
    }

    public void close() {
        ConnectSecretRegistryExtension.closeSecretRegistry();
    }

    public static void configureSecretRegistry(KafkaSecretRegistry registry) {
        lock.lock();
        try {
            secretRegistry = registry;
            isInit.signal();
        }
        finally {
            lock.unlock();
        }
    }

    protected static KafkaSecretRegistry secretRegistry() throws SecretRegistryInitializationException {
        lock.lock();
        try {
            while (secretRegistry == null) {
                isInit.await();
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            String errMsg = "Interrupted waiting for initialization of InternalSecretConfigProvider";
            log.error(errMsg);
            throw new SecretRegistryInitializationException(errMsg);
        }
        finally {
            lock.unlock();
        }
        return secretRegistry;
    }

    private static void closeSecretRegistry() {
        lock.lock();
        try {
            if (secretRegistry != null) {
                secretRegistry.close();
                secretRegistry = null;
            }
        }
        finally {
            lock.unlock();
        }
    }

    private static class ConcreteWorkerConfig
    extends WorkerConfig {
        public ConcreteWorkerConfig(Map<String, String> props) {
            super(ConcreteWorkerConfig.baseConfigDef(), props);
        }
    }
}

